/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;

public class PharmacistInstructions
extends POCDMT000040SubstanceAdministration {
    public PharmacistInstructions() {
        super.getClassCode().add("ACT");
        super.setMoodCode(XDocumentSubstanceMood.INT);
        super.getTemplateId().add(PharmacistInstructions.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.43"));
        super.getTemplateId().add(PharmacistInstructions.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.3.1"));
        super.setCode((CD)PharmacistInstructions.createHl7CodeFixedValue("FINSTRUCT", "1.3.6.1.4.1.19376.1.5.3.2", null, null));
        super.setStatusCode(PharmacistInstructions.createHl7StatusCodeFixedValue("completed", null, null, null));
        super.getEntryRelationship().add(PharmacistInstructions.createHl7EntryRelationshipFixedValue("SUBJ", "true"));
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().add(value);
    }

    public void clearHl7EntryRelationship() {
        this.getEntryRelationship().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

