/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaAlcoholConsumption implements ValueSetEnumInterface
{
    ALCOHOL_CONSUMPTION_NOT_KNOWN("Alcohol_notknown", "1.2.40.0.34.5.179", "Alcohol consumption not known", "Alcohol consumption not known", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FOUR_OR_MORE_TIMES_A_WEEK("LA18929-2", "1.3.6.1.4.1.12009.10.1.1334", "4 or more times a week", "4 or more times a week", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MONTHLY_OR_LESS("LA18926-8", "1.3.6.1.4.1.12009.10.1.1334", "Monthly or less", "Monthly or less", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEVER("LA6270-8", "1.3.6.1.4.1.12009.10.1.1334", "Never", "Never", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TWO_3_TIMES_A_WEEK("LA18928-4", "1.3.6.1.4.1.12009.10.1.1334", "2-3 times a week", "2-3 times a week", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TWO_4_TIMES_A_MONTH("LA18927-6", "1.3.6.1.4.1.12009.10.1.1334", "2-4 times a month", "2-4 times a month", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ALCOHOL_CONSUMPTION_NOT_KNOWN_CODE = "Alcohol_notknown";
    public static final String FOUR_OR_MORE_TIMES_A_WEEK_CODE = "LA18929-2";
    public static final String MONTHLY_OR_LESS_CODE = "LA18926-8";
    public static final String NEVER_CODE = "LA6270-8";
    public static final String TWO_3_TIMES_A_WEEK_CODE = "LA18928-4";
    public static final String TWO_4_TIMES_A_MONTH_CODE = "LA18927-6";
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.30";
    public static final String VALUE_SET_NAME = "ELGA_AlcoholConsumption";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaAlcoholConsumption getEnum(@Nullable String code) {
        for (ElgaAlcoholConsumption x : ElgaAlcoholConsumption.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaAlcoholConsumption.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaAlcoholConsumption x : ElgaAlcoholConsumption.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaAlcoholConsumption(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

