/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaObservationInterpretation implements ValueSetEnumInterface
{
    ABNORMAL_ALERT_L2("AA", "2.16.840.1.113883.5.83", "Abnormal alert", "Abnormal alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ABNORMAL_L1("A", "2.16.840.1.113883.5.83", "Abnormal", "Abnormal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DECREASED_L1("D", "2.16.840.1.113883.5.83", "decreased", "decreased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FIVE__00_100_00_KU_L_ULTRA_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST5", "1.2.40.0.34.5.104", "50.00 \u2013 100.00 kU/l (ultra high level of allergen specific IgE)", "50.00 \u2013 100.00 kU/l (ultra high level of allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_ALERT_L2("HH", "2.16.840.1.113883.5.83", "High alert", "High alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_L1("H", "2.16.840.1.113883.5.83", "High", "High", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_OFF_SCALE_L1(">", "2.16.840.1.113883.5.83", "high off scale", "high off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INCREASED_L1("U", "2.16.840.1.113883.5.83", "increased", "increased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INDETERMINATE_L1("IND", "2.16.840.1.113883.5.83", "Indeterminate", "Indeterminate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INTERMEDIATE_L1("I", "2.16.840.1.113883.5.83", "intermediate", "intermediate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_ALERT_L2("LL", "2.16.840.1.113883.5.83", "Low alert", "Low alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_L1("L", "2.16.840.1.113883.5.83", "Low", "Low", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_OFF_SCALE_L1("<", "2.16.840.1.113883.5.83", "low off scale", "low off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEGATIVE_L1("NEG", "2.16.840.1.113883.5.83", "Negative", "Negative", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORMAL_L1("N", "2.16.840.1.113883.5.83", "Normal", "Normal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSERVATIONINTERPRETATIONDETECTION("_ObservationInterpretationDetection", "2.16.840.1.113883.5.83", "ObservationInterpretationDetection", "ObservationInterpretationDetection", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSERVATIONINTERPRETATIONEXCEPTIONS("_ObservationInterpretationExceptions", "2.16.840.1.113883.5.83", "ObservationInterpretationExceptions", "ObservationInterpretationExceptions", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSERVATIONINTERPRETATIONNORMALITY("_ObservationInterpretationNormality", "2.16.840.1.113883.5.83", "ObservationInterpretationNormality", "ObservationInterpretationNormality", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSERVATIONINTERPRETATIONSUSCEPTIBILITY("_ObservationInterpretationSusceptibility", "2.16.840.1.113883.5.83", "ObservationInterpretationSusceptibility", "ObservationInterpretationSusceptibility", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ONE__50_49_99_KU_L_VERY_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST4", "1.2.40.0.34.5.104", "17.50 \u2013 49.99 kU/l (very high level of allergen specific IgE)", "17.50 \u2013 49.99 kU/l (very high level of allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OUTSIDE_THRESHOLD_L1("EX", "2.16.840.1.113883.5.83", "outside threshold", "outside threshold", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POSITIVE_L1("POS", "2.16.840.1.113883.5.83", "Positive", "Positive", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RAST("_RAST", "1.2.40.0.34.5.104", "RAST", "RAST", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    REFERENZBEREICH_NICHT_ANWENDBAR_L1("Refna", "1.2.40.0.34.5.179", "Referenzbereich nicht anwendbar", "Referenzbereich nicht anwendbar", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RESISTENT_L1("R", "2.16.840.1.113883.5.83", "resistent", "resistent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUSCEPTIBLE_L1("S", "2.16.840.1.113883.5.83", "susceptible", "susceptible", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    THREE_50_17_49_KU_L_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST3", "1.2.40.0.34.5.104", "3.50 \u2013 17.49 kU/l (high level of allergen specific IgE)", "3.50 \u2013 17.49 kU/l (high level of allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ZERO_35_0_69_KU_L_LOW_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST1", "1.2.40.0.34.5.104", "0.35 \u2013 0.69 kU/l (low level of allergen specific IgE)", "0.35 \u2013 0.69 kU/l (low level of allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ZERO_70_3_49_KU_L_MODERATE_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST2", "1.2.40.0.34.5.104", "0.70 \u2013 3.49 kU/l (moderate level of allergen specific IgE)", "0.70 \u2013 3.49 kU/l (moderate level of allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _0_35_KU_L_ABSENT_OR_UNDETECTABLE_ALLERGEN_SPECIFIC_IGE_L1("RAST0", "1.2.40.0.34.5.104", "< 0.35 kU/l (absent or undetectable allergen specific IgE)", "< 0.35 kU/l (absent or undetectable allergen specific IgE)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _100_00_KU_L_EXTREMELY_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1("RAST6", "1.2.40.0.34.5.104", "> 100.00 kU/l (extremely high level of allergen specific ige)", "> 100.00 kU/l (extremely high level of allergen specific ige)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ABNORMAL_ALERT_L2_CODE = "AA";
    public static final String ABNORMAL_L1_CODE = "A";
    public static final String DECREASED_L1_CODE = "D";
    public static final String FIVE__00_100_00_KU_L_ULTRA_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST5";
    public static final String HIGH_ALERT_L2_CODE = "HH";
    public static final String HIGH_L1_CODE = "H";
    public static final String HIGH_OFF_SCALE_L1_CODE = ">";
    public static final String INCREASED_L1_CODE = "U";
    public static final String INDETERMINATE_L1_CODE = "IND";
    public static final String INTERMEDIATE_L1_CODE = "I";
    public static final String LOW_ALERT_L2_CODE = "LL";
    public static final String LOW_L1_CODE = "L";
    public static final String LOW_OFF_SCALE_L1_CODE = "<";
    public static final String NEGATIVE_L1_CODE = "NEG";
    public static final String NORMAL_L1_CODE = "N";
    public static final String OBSERVATIONINTERPRETATIONDETECTION_CODE = "_ObservationInterpretationDetection";
    public static final String OBSERVATIONINTERPRETATIONEXCEPTIONS_CODE = "_ObservationInterpretationExceptions";
    public static final String OBSERVATIONINTERPRETATIONNORMALITY_CODE = "_ObservationInterpretationNormality";
    public static final String OBSERVATIONINTERPRETATIONSUSCEPTIBILITY_CODE = "_ObservationInterpretationSusceptibility";
    public static final String ONE__50_49_99_KU_L_VERY_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST4";
    public static final String OUTSIDE_THRESHOLD_L1_CODE = "EX";
    public static final String POSITIVE_L1_CODE = "POS";
    public static final String RAST_CODE = "_RAST";
    public static final String REFERENZBEREICH_NICHT_ANWENDBAR_L1_CODE = "Refna";
    public static final String RESISTENT_L1_CODE = "R";
    public static final String SUSCEPTIBLE_L1_CODE = "S";
    public static final String THREE_50_17_49_KU_L_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST3";
    public static final String ZERO_35_0_69_KU_L_LOW_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST1";
    public static final String ZERO_70_3_49_KU_L_MODERATE_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST2";
    public static final String _0_35_KU_L_ABSENT_OR_UNDETECTABLE_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST0";
    public static final String _100_00_KU_L_EXTREMELY_HIGH_LEVEL_OF_ALLERGEN_SPECIFIC_IGE_L1_CODE = "RAST6";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.13";
    public static final String VALUE_SET_NAME = "ELGA_ObservationInterpretation";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaObservationInterpretation getEnum(@Nullable String code) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaObservationInterpretation.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaObservationInterpretation(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

