/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaPregnanciesSummary implements ValueSetEnumInterface
{
    _ABORTIONS("11612-9", "2.16.840.1.113883.6.1", "[#] Abortions", "[#] Abortions", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _ABORTIONS_INDUCED("11613-7", "2.16.840.1.113883.6.1", "[#] Abortions.induced", "[#] Abortions.induced", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _ABORTIONS_SPONTANEOUS("11614-5", "2.16.840.1.113883.6.1", "[#] Abortions.spontaneous", "[#] Abortions.spontaneous", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _BIRTHS_LIVE("11636-8", "2.16.840.1.113883.6.1", "[#] Births.live", "[#] Births.live", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _BIRTHS_PRETERM("11637-6", "2.16.840.1.113883.6.1", "[#] Births.preterm", "[#] Births.preterm", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _BIRTHS_STILL_LIVING("11638-4", "2.16.840.1.113883.6.1", "[#] Births.still living", "[#] Births.still living", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _BIRTHS_TERM("11639-2", "2.16.840.1.113883.6.1", "[#] Births.term", "[#] Births.term", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _BIRTHS_TOTAL("11640-0", "2.16.840.1.113883.6.1", "[#] Births total", "[#] Births total", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _ECTOPIC_PREGNANCY("33065-4", "2.16.840.1.113883.6.1", "[#] Ectopic pregnancy", "[#] Ectopic pregnancy", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String _ABORTIONS_CODE = "11612-9";
    public static final String _ABORTIONS_INDUCED_CODE = "11613-7";
    public static final String _ABORTIONS_SPONTANEOUS_CODE = "11614-5";
    public static final String _BIRTHS_LIVE_CODE = "11636-8";
    public static final String _BIRTHS_PRETERM_CODE = "11637-6";
    public static final String _BIRTHS_STILL_LIVING_CODE = "11638-4";
    public static final String _BIRTHS_TERM_CODE = "11639-2";
    public static final String _BIRTHS_TOTAL_CODE = "11640-0";
    public static final String _ECTOPIC_PREGNANCY_CODE = "33065-4";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.203";
    public static final String VALUE_SET_NAME = "ELGA_PregnanciesSummary";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.1";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaPregnanciesSummary getEnum(@Nullable String code) {
        for (ElgaPregnanciesSummary x : ElgaPregnanciesSummary.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaPregnanciesSummary.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaPregnanciesSummary x : ElgaPregnanciesSummary.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaPregnanciesSummary(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

