/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryEingebettetesObjektEntry;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryExternalDocument;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryImpfPlan;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040ObservationMedia;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;

public class Appendix {
    private String title;
    private String author;
    private String creationTime;
    private String mediaType;
    private String document;
    private Identificator id;
    private Code cdaCode;
    private Identificator setId;
    private int version;

    public Appendix() {
    }

    public Appendix(POCDMT000040Entry entry) {
        if (entry != null && entry.getObservationMedia() != null && entry.getObservationMedia().getValue() != null) {
            this.mediaType = entry.getObservationMedia().getValue().getMediaType();
            this.document = entry.getObservationMedia().getValue().getMergedXmlMixed();
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public String getDocument() {
        return this.document;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public Code getCdaCode() {
        return this.cdaCode;
    }

    public void setCdaCode(Code cdaCode) {
        this.cdaCode = cdaCode;
    }

    public Identificator getSetId() {
        return this.setId;
    }

    public void setSetId(Identificator setId) {
        this.setId = setId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public POCDMT000040Entry getHl7CdaR2AppendixEntry(String prefix, int index) {
        if (this.document != null && this.mediaType != null) {
            POCDMT000040Entry entry = new POCDMT000040Entry();
            entry.setObservationMedia((POCDMT000040ObservationMedia)this.getEingebettetesObjektEntry(prefix, index));
            return entry;
        }
        return null;
    }

    public AtcdabbrEntryEingebettetesObjektEntry getEingebettetesObjektEntry(String prefix, int index) {
        AtcdabbrEntryEingebettetesObjektEntry object = new AtcdabbrEntryEingebettetesObjektEntry();
        object.setIDAttr("Attachment-" + prefix + "-" + index);
        object.getValue().setXmlMixed(this.getDocument());
        object.getValue().setMediaType(this.mediaType);
        return object;
    }

    public AtcdabbrEntryExternalDocument getAtcdabbrEntryExternalDocument(int index) {
        AtcdabbrEntryExternalDocument externalDoc = new AtcdabbrEntryExternalDocument();
        if (this.id != null) {
            externalDoc.setHl7Id(this.id.getHl7CdaR2Ii());
        }
        if (this.cdaCode != null) {
            externalDoc.setHl7Code(this.cdaCode.getHl7CdaR2Cd());
        }
        if (this.setId != null) {
            externalDoc.setHl7SetId(this.setId.getHl7CdaR2Ii());
        }
        if (this.version > 0) {
            externalDoc.setHl7VersionNumber(new INT(this.version));
        }
        externalDoc.setText(new ED(null, new TEL("#external-doc-" + index)));
        return externalDoc;
    }

    public AtcdabbrEntryImpfPlan getAtcdabbrEntryImpfPlan(int index) {
        AtcdabbrEntryImpfPlan immunizationPlan = new AtcdabbrEntryImpfPlan();
        if (this.id != null) {
            immunizationPlan.setHl7Id(this.id.getHl7CdaR2Ii());
        }
        if (this.cdaCode != null) {
            immunizationPlan.setHl7Code(this.cdaCode.getHl7CdaR2Cd());
        }
        immunizationPlan.setText(new ED(null, new TEL("#impfplan-" + index)));
        if (this.setId != null) {
            immunizationPlan.setHl7SetId(this.setId.getHl7CdaR2Ii());
            immunizationPlan.setVersionNumber(new INT(this.version));
        }
        return immunizationPlan;
    }
}

