/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrOtherVaccineProduct;
import org.projecthusky.cda.elga.generated.artdecor.emed.ArzneiEntry;
import org.projecthusky.cda.elga.models.Ingredient;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Material;
import org.projecthusky.common.hl7cdar2.POCDMT000040Product;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;

public class Drug {
    private String name;
    private String text;
    private Code unit;
    private String packageSize;
    private String pharmNo;
    private Code vaccination;
    private Code historicVaccination;
    private Code dosageForm;
    private String lotNumberTxt;
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private Organization drugProducer;

    public Drug(POCDMT000040Consumable consumable) {
        if (consumable != null && consumable.getManufacturedProduct() != null && consumable.getManufacturedProduct().getManufacturedMaterial() != null && consumable.getManufacturedProduct().getManufacturedMaterial().getCode() != null) {
            this.name = consumable.getManufacturedProduct().getManufacturedMaterial().getCode().getDisplayName();
            this.pharmNo = consumable.getManufacturedProduct().getManufacturedMaterial().getCode().getCode();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackageSize() {
        return this.packageSize;
    }

    public String getPharmNo() {
        return this.pharmNo;
    }

    public String getText() {
        return this.text;
    }

    public Code getUnit() {
        return this.unit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPackageSize(String packageSize) {
        this.packageSize = packageSize;
    }

    public void setPharmNo(String pharmNo) {
        this.pharmNo = pharmNo;
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public void setUnit(Code unit) {
        this.unit = unit;
    }

    public Code getVaccination() {
        return this.vaccination;
    }

    public void setVaccination(Code vaccination) {
        this.vaccination = vaccination;
    }

    public Code getHistoricVaccination() {
        return this.historicVaccination;
    }

    public void setHistoricVaccination(Code historicVaccination) {
        this.historicVaccination = historicVaccination;
    }

    public String getLotNumberTxt() {
        return this.lotNumberTxt;
    }

    public void setLotNumberTxt(String lotNumberTxt) {
        this.lotNumberTxt = lotNumberTxt;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public void addIngredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public Organization getDrugProducer() {
        return this.drugProducer;
    }

    public void setDrugProducer(Organization drugProducer) {
        this.drugProducer = drugProducer;
    }

    public Code getDosageForm() {
        return this.dosageForm;
    }

    public void setDosageForm(Code dosageForm) {
        this.dosageForm = dosageForm;
    }

    public POCDMT000040Consumable getVaccineProduct(boolean immunizationRecommendaction) {
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        consumable.getTypeCode().clear();
        consumable.getTypeCode().add("CSM");
        AtcdabbrOtherVaccineProduct vaccineProd = new AtcdabbrOtherVaccineProduct();
        POCDMT000040Material material = vaccineProd.getHl7ManufacturedMaterial();
        if (this.vaccination != null) {
            material.setCode(new CE(this.vaccination.getCode(), this.vaccination.getCodeSystem(), this.vaccination.getCodeSystemName(), this.vaccination.getDisplayName()));
        } else if (this.historicVaccination != null) {
            material.setCode(new CE(this.historicVaccination.getCode(), this.historicVaccination.getCodeSystem(), this.historicVaccination.getCodeSystemName(), this.historicVaccination.getDisplayName()));
        }
        ST lotNumber = new ST();
        if (this.lotNumberTxt != null && !immunizationRecommendaction) {
            lotNumber.setXmlMixed(this.lotNumberTxt);
        } else if (immunizationRecommendaction) {
            lotNumber.nullFlavor = new LinkedList();
            lotNumber.getNullFlavor().add("NA");
        } else {
            lotNumber.nullFlavor = new LinkedList();
            lotNumber.getNullFlavor().add("UNK");
        }
        material.setLotNumberText(lotNumber);
        if (this.ingredients != null && !this.ingredients.isEmpty()) {
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient == null) continue;
                material.getIngredient().add(ingredient.getCOCTMT230100UVIngredient());
            }
        }
        Name pharmName = new Name();
        if (this.name != null) {
            pharmName.setName(this.name);
        } else if (this.vaccination != null) {
            pharmName.setName(this.vaccination.getDisplayName());
        } else if (this.historicVaccination != null) {
            pharmName.setName(this.historicVaccination.getDisplayName());
        }
        material.setName(pharmName.getHl7CdaR2En());
        vaccineProd.setManufacturedMaterial(material);
        if (this.drugProducer != null) {
            vaccineProd.setManufacturerOrganization(this.drugProducer.getHl7CdaR2Pocdmt000040Organization());
        }
        consumable.setManufacturedProduct((POCDMT000040ManufacturedProduct)vaccineProd);
        return consumable;
    }

    public POCDMT000040Product getArzneiEntryDelivery(int index) {
        POCDMT000040Product product = new POCDMT000040Product();
        ArzneiEntry drugEntry = new ArzneiEntry();
        POCDMT000040Material material = drugEntry.getHl7ManufacturedMaterial();
        if (this.name != null && this.pharmNo != null) {
            material.setCode(new CE(this.pharmNo, "1.2.40.0.34.4.16", "Pharmazentralnummer", this.name));
            Name pharmName = new Name();
            pharmName.setName(this.name);
            material.getCode().setOriginalText(new ED(null, new TEL("#prodcode-" + index)));
            material.setName(pharmName.getHl7CdaR2En());
        } else {
            material.getNullFlavor().add("NA");
        }
        product.setManufacturedProduct((POCDMT000040ManufacturedProduct)drugEntry);
        return product;
    }

    public POCDMT000040Consumable getArzneiEntry() {
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        ArzneiEntry drugEntry = new ArzneiEntry();
        POCDMT000040Material material = drugEntry.getHl7ManufacturedMaterial();
        if (this.name != null && this.pharmNo != null) {
            material.setCode(new CE(this.pharmNo, "1.2.40.0.34.4.16", "Pharmazentralnummer", this.name));
            Name pharmName = new Name();
            pharmName.setName(this.name);
            material.setName(pharmName.getHl7CdaR2En());
        } else {
            material.getNullFlavor().add("NA");
        }
        consumable.setManufacturedProduct((POCDMT000040ManufacturedProduct)drugEntry);
        return consumable;
    }
}

