/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.projecthusky.cda.elga.generated.artdecor.base.enums.ElgaObservationInterpretation;
import org.projecthusky.cda.elga.models.LaboratoryValue;
import org.projecthusky.cda.elga.models.ParticipantAt;
import org.projecthusky.cda.elga.models.PerformerAt;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040ObservationRange;
import org.projecthusky.common.hl7cdar2.POCDMT000040ReferenceRange;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.DateUtil;

public class Laboratory {
    private Identificator labTestId;
    private Code analysisCode;
    private boolean aborted;
    private ZonedDateTime samplingTime;
    private LaboratoryValue value;
    private ParticipantAt validatingPerson;
    private ZonedDateTime validatingTime;
    private Map<ElgaObservationInterpretation, LaboratoryValue> observationRange;
    private Map<ZonedDateTime, PerformerAt> laboratories;

    private void setObservationRange(int index, POCDMT000040Observation observation) {
        Iterator<Map.Entry<ElgaObservationInterpretation, LaboratoryValue>> iteratorObservationRange = this.observationRange.entrySet().iterator();
        int indexObservationRange = 0;
        while (iteratorObservationRange.hasNext()) {
            Map.Entry<ElgaObservationInterpretation, LaboratoryValue> entry = iteratorObservationRange.next();
            if (entry == null) continue;
            POCDMT000040ReferenceRange referenceRange = new POCDMT000040ReferenceRange();
            referenceRange.getTypeCode().add("REFV");
            POCDMT000040ObservationRange pocdObservationRange = new POCDMT000040ObservationRange();
            pocdObservationRange.getClassCode().add("OBS");
            pocdObservationRange.getMoodCode().add("EVN.CRT");
            if (entry.getKey() != null) {
                Code code = entry.getKey().getCode();
                pocdObservationRange.setInterpretationCode(new CE(code.getCode(), code.getCodeSystem(), code.getCodeSystemName(), code.getDisplayName()));
            }
            if (entry.getValue() != null) {
                pocdObservationRange.setValue(entry.getValue().getValue());
            }
            pocdObservationRange.setText(new ED(null, new TEL("#analyseRef-" + index + "-" + indexObservationRange++)));
            referenceRange.setObservationRange(pocdObservationRange);
            observation.getReferenceRange().add(referenceRange);
        }
    }

    private void setSamplingTime(POCDMT000040Observation observation) {
        if (this.getSamplingTime() != null) {
            observation.setEffectiveTime(new IVLTS(DateUtil.formatDateTimeTzon((ZonedDateTime)this.getSamplingTime())));
        } else {
            IVLTS effectiveTimeUnk = new IVLTS();
            effectiveTimeUnk.nullFlavor = new ArrayList();
            effectiveTimeUnk.nullFlavor.add("UNK");
            observation.setEffectiveTime(effectiveTimeUnk);
        }
    }

    protected void fillPOCDMT000040Observation(POCDMT000040Observation observation, int index) {
        if (observation != null) {
            if (this.getLabTestId() != null) {
                observation.getId().add(this.getLabTestId().getHl7CdaR2Ii());
                observation.setText(new ED(null, new TEL("#" + this.getLabTestId().getExtension())));
            } else {
                observation.setText(new ED(null, new TEL("#analyse-" + index)));
            }
            if (this.getAnalysisCode() != null) {
                observation.setCode((CD)this.getAnalysisCode().getHl7CdaR2Ce());
            }
            this.setSamplingTime(observation);
            if (this.getValidatingPerson() != null) {
                observation.getParticipant().add(this.getValidatingPerson().getPOCDMT000040Participant2(this.getValidatingTime()));
            }
            if (this.value != null) {
                observation.getValue().add(this.value.getValue());
            }
            if (this.getObservationRange() != null) {
                this.setObservationRange(index, observation);
            }
        }
    }

    public Identificator getLabTestId() {
        return this.labTestId;
    }

    public void setLabTestId(Identificator labTestId) {
        this.labTestId = labTestId;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public ParticipantAt getValidatingPerson() {
        return this.validatingPerson;
    }

    public void setValidatingPerson(ParticipantAt validatingPerson) {
        this.validatingPerson = validatingPerson;
    }

    public ZonedDateTime getValidatingTime() {
        return this.validatingTime;
    }

    public void setValidatingTime(ZonedDateTime validatingTime) {
        this.validatingTime = validatingTime;
    }

    public ZonedDateTime getSamplingTime() {
        return this.samplingTime;
    }

    public void setSamplingTime(ZonedDateTime samplingTime) {
        this.samplingTime = samplingTime;
    }

    public LaboratoryValue getValue() {
        return this.value;
    }

    public void setValue(LaboratoryValue value) {
        this.value = value;
    }

    public Map<ElgaObservationInterpretation, LaboratoryValue> getObservationRange() {
        return this.observationRange;
    }

    public void setObservationRange(Map<ElgaObservationInterpretation, LaboratoryValue> observationRange) {
        this.observationRange = observationRange;
    }

    public Code getAnalysisCode() {
        return this.analysisCode;
    }

    public Map<ZonedDateTime, PerformerAt> getLaboratories() {
        return this.laboratories;
    }

    public void setAnalysisCode(Code analysisCode) {
        this.analysisCode = analysisCode;
    }

    public void setLaboratories(Map<ZonedDateTime, PerformerAt> laboratories) {
        this.laboratories = laboratories;
    }
}

