/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderComponentOfEncompassingEncounter;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderEncounterLocation;
import org.projecthusky.common.at.PractitionerAt;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040EncompassingEncounter;
import org.projecthusky.common.hl7cdar2.POCDMT000040HealthCareFacility;
import org.projecthusky.common.hl7cdar2.POCDMT000040Location;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;

public class PatientContact {
    private Identificator id;
    private Code encounterCode;
    private ZonedDateTime startTime;
    private ZonedDateTime stopTime;
    private PractitionerAt responsibleParty;

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public Code getEncounterCode() {
        return this.encounterCode;
    }

    public void setEncounterCode(Code encounterCode) {
        this.encounterCode = encounterCode;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
    }

    public ZonedDateTime getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(ZonedDateTime stopTime) {
        this.stopTime = stopTime;
    }

    public PractitionerAt getResponsibleParty() {
        return this.responsibleParty;
    }

    public void setResponsibleParty(PractitionerAt responsibleParty) {
        this.responsibleParty = responsibleParty;
    }

    public AtcdabbrHeaderComponentOfEncompassingEncounter getAtcdabbrHeaderComponentOfEncompassingEncounter() {
        AtcdabbrHeaderComponentOfEncompassingEncounter encounter = new AtcdabbrHeaderComponentOfEncompassingEncounter();
        POCDMT000040EncompassingEncounter encompassingEncounter = encounter.getEncompassingEncounter();
        if (this.id != null) {
            encompassingEncounter.getId().add(this.id.getHl7CdaR2Ii());
        }
        if (this.encounterCode != null) {
            encompassingEncounter.setCode(new CE(this.encounterCode.getCode(), this.encounterCode.getCodeSystem(), this.encounterCode.getCodeSystemName(), this.encounterCode.getDisplayName()));
        }
        encompassingEncounter.setEffectiveTime(new IVLTS());
        if (this.startTime != null) {
            encompassingEncounter.getEffectiveTime().getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startTime)));
        }
        if (this.stopTime != null) {
            encompassingEncounter.getEffectiveTime().getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stopTime)));
        }
        if (this.responsibleParty != null) {
            encompassingEncounter.setResponsibleParty(this.responsibleParty.getPOCDMT000040ResponsibleParty());
            encompassingEncounter.setLocation((POCDMT000040Location)this.getAtcdabbrHeaderEncounterLocation());
        }
        return encounter;
    }

    private AtcdabbrHeaderEncounterLocation getAtcdabbrHeaderEncounterLocation() {
        AtcdabbrHeaderEncounterLocation headerEncounterLocation = new AtcdabbrHeaderEncounterLocation();
        if (this.responsibleParty != null && this.responsibleParty.getOrganization() != null) {
            POCDMT000040HealthCareFacility healthcareFacility = headerEncounterLocation.getHealthCareFacility();
            healthcareFacility.setServiceProviderOrganization(this.responsibleParty.getOrganization().getHl7CdaR2Pocdmt000040Organization());
            headerEncounterLocation.setHl7HealthCareFacility(healthcareFacility);
        }
        return headerEncounterLocation;
    }
}

