/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.emed.Einnahmedauer;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;

public class PeriodOfPrescription {
    private Code frequence;
    private double quantitiy;
    private ZonedDateTime startIntake;
    private ZonedDateTime stopIntake;

    public PeriodOfPrescription(IVLTS time) {
        PQ element;
        if (time != null && (element = this.getPqElement(time).get("width")) != null) {
            this.quantitiy = Double.parseDouble(element.getValue());
            this.frequence = new Code(element.getUnit(), null, null);
        }
    }

    public PeriodOfPrescription() {
    }

    public Code getFrequence() {
        return this.frequence;
    }

    public double getQuantitiy() {
        return this.quantitiy;
    }

    public ZonedDateTime getStartIntake() {
        return this.startIntake;
    }

    public ZonedDateTime getStopIntake() {
        return this.stopIntake;
    }

    public void setFrequence(Code frequence) {
        this.frequence = frequence;
    }

    public void setQuantitiy(double quantitiy) {
        this.quantitiy = quantitiy;
    }

    public void setStartIntake(ZonedDateTime startIntake) {
        this.startIntake = startIntake;
    }

    public void setStopIntake(ZonedDateTime stopIntake) {
        this.stopIntake = stopIntake;
    }

    public Einnahmedauer getEinnahmedauer() {
        if (this.frequence != null && this.quantitiy > 0.0) {
            return this.getFrequenceEffectiveTime(this.quantitiy, this.frequence.getCode());
        }
        if (this.startIntake != null && this.stopIntake != null) {
            Einnahmedauer time = new Einnahmedauer();
            time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startIntake)));
            time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stopIntake)));
            return time;
        }
        return null;
    }

    private Einnahmedauer getFrequenceEffectiveTime(Double width, String unit) {
        Einnahmedauer takeInDuration = new Einnahmedauer();
        PQ pq = new PQ();
        pq.setUnit(unit);
        pq.setValue(String.valueOf(width));
        takeInDuration.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "width", ""), PQ.class, (Object)pq));
        return takeInDuration;
    }

    protected Map<String, PQ> getPqElement(IVLTS time) {
        HashMap<String, PQ> pqElements = new HashMap<String, PQ>();
        if (time != null) {
            for (JAXBElement pq : time.getRest()) {
                PQ value = new PQ();
                String elementName = "";
                if (pq != null && PQ.class.equals((Object)pq.getDeclaredType()) && pq.getValue() != null) {
                    value = (PQ)pq.getValue();
                }
                if (pq != null && pq.getName() != null) {
                    elementName = pq.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                pqElements.put(elementName, value);
            }
        }
        return pqElements;
    }
}

