/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderAuthor;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderDataEnterer;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderLegalAuthenticator;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrOtherAuthorBodyEImpfpass;
import org.projecthusky.cda.elga.generated.artdecor.ps.AuthorBodyPs;
import org.projecthusky.common.at.PractitionerAt;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedEntity;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer1;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.utils.time.DateTimes;

public class PractitionerCdaAt
extends PractitionerAt {
    public PractitionerCdaAt() {
    }

    public PractitionerCdaAt(POCDMT000040Author author) {
        super(author);
    }

    public PractitionerCdaAt(POCDMT000040LegalAuthenticator authenticator) {
        super(authenticator);
    }

    public AtcdabbrHeaderAuthor getAtcdabbrHeaderAuthor(ZonedDateTime timeAuthor) {
        AtcdabbrHeaderAuthor author = new AtcdabbrHeaderAuthor();
        TS time = new TS();
        if (timeAuthor == null) {
            time.getNullFlavor().add("UNK");
        } else {
            time.setValue(DateTimes.toDatetimeTs((TemporalAccessor)timeAuthor).getValue());
        }
        author.setTime(time);
        if (this.getCode() != null) {
            author.setFunctionCode(this.getCode().getHl7CdaR2Ce());
        }
        author.setAssignedAuthor(this.getHl7CdaR2Pocdmt000040AssignedAuthor(author.getAssignedAuthor()));
        return author;
    }

    public AtcdabbrHeaderLegalAuthenticator getHeaderLegalAuthenticator(ZonedDateTime timeLegalAuthen) {
        AtcdabbrHeaderLegalAuthenticator legalAuthenticator = new AtcdabbrHeaderLegalAuthenticator();
        TS time = new TS();
        if (timeLegalAuthen == null) {
            time.getNullFlavor().add("UNK");
        } else {
            time.setValue(DateTimes.toDatetimeTs((TemporalAccessor)timeLegalAuthen).getValue());
        }
        legalAuthenticator.setHl7Time(time);
        legalAuthenticator.setAssignedEntity(this.createAssignedEntity(new POCDMT000040AssignedEntity()));
        return legalAuthenticator;
    }

    public AtcdabbrOtherAuthorBodyEImpfpass getAtcdabbrOtherAuthorBodyEImpfpass(ZonedDateTime timeAuthor) {
        AtcdabbrOtherAuthorBodyEImpfpass author = new AtcdabbrOtherAuthorBodyEImpfpass();
        TS time = new TS();
        if (timeAuthor != null) {
            time.setValue(DateTimes.toDatetimeTs((TemporalAccessor)timeAuthor).getValue());
        } else {
            time.nullFlavor = new ArrayList();
            time.getNullFlavor().add("UNK");
        }
        author.setTime(time);
        author.setAssignedAuthor(this.getHl7CdaR2Pocdmt000040AssignedAuthor(author.getAssignedAuthor()));
        return author;
    }

    public AtcdabbrHeaderDataEnterer getHeaderDataEnterer(ZonedDateTime timeDataEnterer) {
        AtcdabbrHeaderDataEnterer dataEnterer = new AtcdabbrHeaderDataEnterer();
        dataEnterer.setTime(DateTimes.toDatetimeTs((TemporalAccessor)timeDataEnterer));
        POCDMT000040AssignedEntity assignedEntity = new POCDMT000040AssignedEntity();
        if (this.getIdentifier() != null && !this.getIdentifier().isEmpty()) {
            assignedEntity.getId().addAll(this.getIis());
        }
        if (this.getAddresses() != null && !this.getAddresses().isEmpty()) {
            assignedEntity.getAddr().addAll(this.getAds());
        }
        assignedEntity.setAssignedPerson(this.getHl7CdaR2Pocdmt000040Person(assignedEntity.getAssignedPerson()));
        if (this.getTelecom() != null && !this.getTelecom().isEmpty()) {
            assignedEntity.getTelecom().addAll(this.getTels());
        }
        if (this.getOrganization() != null) {
            assignedEntity.setRepresentedOrganization(this.getOrganization().getHl7CdaR2Pocdmt000040Organization());
        }
        dataEnterer.setAssignedEntity(assignedEntity);
        return dataEnterer;
    }

    public AuthorBodyPs getAuthorBodyPs(ZonedDateTime authTime) {
        AuthorBodyPs author = new AuthorBodyPs();
        author.setTime(DateTimes.toDatetimeTs((TemporalAccessor)authTime));
        author.setAssignedAuthor(this.getHl7CdaR2Pocdmt000040AssignedAuthor(author.getAssignedAuthor()));
        return author;
    }

    public POCDMT000040Performer1 getPerformer() {
        POCDMT000040Performer1 performer = new POCDMT000040Performer1();
        POCDMT000040AssignedEntity assignedEntity = new POCDMT000040AssignedEntity();
        if (this.getIdentifier() != null && !this.getIdentifier().isEmpty()) {
            assignedEntity.getId().addAll(this.getIis());
        }
        if (this.getAddresses() != null && !this.getAddresses().isEmpty()) {
            assignedEntity.getAddr().addAll(this.getAds());
        } else {
            Address addressUnk = new Address(new AddressBaseType());
            addressUnk.setNullFlavor(NullFlavor.UNKNOWN_L1);
            assignedEntity.getAddr().add(addressUnk.getHl7CdaR2Ad());
        }
        assignedEntity.setAssignedPerson(this.getHl7CdaR2Pocdmt000040Person(assignedEntity.getAssignedPerson()));
        if (this.getTelecom() != null && !this.getTelecom().isEmpty()) {
            assignedEntity.getTelecom().addAll(this.getTels());
        }
        if (this.getOrganization() != null) {
            assignedEntity.setRepresentedOrganization(this.getOrganization().getHl7CdaR2Pocdmt000040Organization());
        }
        performer.setAssignedEntity(assignedEntity);
        return performer;
    }
}

