/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.emed.Iddescontainers;
import org.projecthusky.cda.elga.generated.artdecor.emed.MedikationVerordnungEntryemed;
import org.projecthusky.cda.elga.generated.artdecor.emed.PatientInstructions;
import org.projecthusky.cda.elga.generated.artdecor.emed.PharmacistInstructions;
import org.projecthusky.cda.elga.generated.artdecor.emed.Therapieart;
import org.projecthusky.cda.elga.generated.artdecor.emed.enums.ElgaMedikationRezeptart;
import org.projecthusky.cda.elga.models.AdditionalInformation;
import org.projecthusky.cda.elga.models.Dose;
import org.projecthusky.cda.elga.models.Drug;
import org.projecthusky.cda.elga.models.Magistraliter;
import org.projecthusky.cda.elga.models.PeriodOfPrescription;
import org.projecthusky.common.hl7cdar2.ActClassSupply;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.POCDMT000040Supply;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriptionEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PrescriptionEntry.class.getName());
    public static final String TEMPLATE_ID_KIND_OF_THERAPY = "1.2.40.0.34.11.8.1.3.4";
    private ZonedDateTime changeDate;
    private List<Dose> doses;
    private PeriodOfPrescription periodOfPrescription;
    private int amountPackages;
    private int amountPossibleDispenses;
    private Code kindOfTherapy;
    private Code typeOfApplication;
    private String id;
    private List<AdditionalInformation> addInfoPat;
    private List<AdditionalInformation> addInfoPharm;
    private Drug drug;
    private Magistraliter magistraliter;
    private Identificator emedId;

    public PrescriptionEntry(POCDMT000040Entry entry) {
        if (entry != null && entry.getSubstanceAdministration() != null) {
            if (entry.getSubstanceAdministration().getEffectiveTime() != null) {
                for (SXCMTS time : entry.getSubstanceAdministration().getEffectiveTime()) {
                    if (!(time instanceof IVLTS)) continue;
                    IVLTS ivlts = (IVLTS)time;
                    this.periodOfPrescription = new PeriodOfPrescription(ivlts);
                }
            }
            if (entry.getSubstanceAdministration().getConsumable() != null) {
                this.drug = new Drug(entry.getSubstanceAdministration().getConsumable());
            }
            if (entry.getSubstanceAdministration().getEntryRelationship() != null) {
                for (POCDMT000040EntryRelationship entryRel : entry.getSubstanceAdministration().getEntryRelationship()) {
                    if (entryRel != null && entryRel.getAct() != null && entryRel.getAct().getCode() != null && "PINSTRUCT".equalsIgnoreCase(entryRel.getAct().getCode().getCode())) {
                        this.addInfoPat = new ArrayList<AdditionalInformation>();
                        for (POCDMT000040EntryRelationship entryR : entryRel.getAct().getEntryRelationship()) {
                            this.addInfoPat.add(new AdditionalInformation(entryR));
                        }
                        continue;
                    }
                    if (entryRel != null && entryRel.getAct() != null && entryRel.getAct().getCode() != null && "FINSTRUCT".equalsIgnoreCase(entryRel.getAct().getCode().getCode())) {
                        this.addInfoPharm = new ArrayList<AdditionalInformation>();
                        for (POCDMT000040EntryRelationship entryR : entryRel.getAct().getEntryRelationship()) {
                            this.addInfoPharm.add(new AdditionalInformation(entryR));
                        }
                        continue;
                    }
                    if (entryRel != null && entryRel.getAct() != null && entryRel.getAct().getCode() != null && entryRel.getAct().getTemplateId() != null && entryRel.getAct().getTemplateId().stream().anyMatch(tempId -> TEMPLATE_ID_KIND_OF_THERAPY.equalsIgnoreCase(tempId.getRoot()))) {
                        this.kindOfTherapy = new Code(entryRel.getAct().getCode());
                        continue;
                    }
                    if (entryRel != null && entryRel.getSupply() != null && entryRel.getSupply().getQuantity() != null) {
                        try {
                            this.amountPossibleDispenses = Integer.parseInt(entryRel.getSupply().getQuantity().getValue());
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.error(ex.getMessage());
                        }
                        continue;
                    }
                    if (entryRel == null || !entryRel.getTypeCode().equals((Object)XActRelationshipEntryRelationship.COMP) || entryRel.getSubstanceAdministration() == null) continue;
                    if (this.doses == null) {
                        this.doses = new ArrayList<Dose>();
                    }
                    this.doses.add(new Dose(entryRel.getSubstanceAdministration()));
                }
            }
        }
    }

    public List<AdditionalInformation> getAddInfoPat() {
        return this.addInfoPat;
    }

    public List<AdditionalInformation> getAddInfoPharm() {
        return this.addInfoPharm;
    }

    public int getAmountPackages() {
        return this.amountPackages;
    }

    public int getAmountPossibleDispenses() {
        return this.amountPossibleDispenses;
    }

    public ZonedDateTime getChangeDate() {
        return this.changeDate;
    }

    public Drug getDrug() {
        return this.drug;
    }

    public Identificator getEmedId() {
        return this.emedId;
    }

    public String getId() {
        return this.id;
    }

    public Code getKindOfTherapy() {
        return this.kindOfTherapy;
    }

    public Magistraliter getMagistraliter() {
        return this.magistraliter;
    }

    public PeriodOfPrescription getPeriodOfPrescription() {
        return this.periodOfPrescription;
    }

    public List<Dose> getSingleDoses() {
        return this.doses;
    }

    public void setAddInfoPat(List<AdditionalInformation> addInfoPat) {
        this.addInfoPat = addInfoPat;
    }

    public void setAddInfoPharm(List<AdditionalInformation> addInfoPharm) {
        this.addInfoPharm = addInfoPharm;
    }

    public void setAmountPackages(int amountPackages) {
        this.amountPackages = amountPackages;
    }

    public void setAmountPossibleDispenses(int amountPossibleDispenses) {
        this.amountPossibleDispenses = amountPossibleDispenses;
    }

    public void setChangeDate(ZonedDateTime changeDate) {
        this.changeDate = changeDate;
    }

    public void setDoses(List<Dose> doses) {
        this.doses = doses;
    }

    public void setDrug(Drug drug) {
        this.drug = drug;
    }

    public void setEmedId(Identificator emedId) {
        this.emedId = emedId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKindOfTherapy(Code kindOfTherapy) {
        this.kindOfTherapy = kindOfTherapy;
    }

    public Code getTypeOfApplication() {
        return this.typeOfApplication;
    }

    public void setTypeOfApplication(Code typeOfApplication) {
        this.typeOfApplication = typeOfApplication;
    }

    public void setMagistraliter(Magistraliter magistraliter) {
        this.magistraliter = magistraliter;
    }

    public void setPeriodOfPrescription(PeriodOfPrescription periodOfPrescription) {
        this.periodOfPrescription = periodOfPrescription;
    }

    public POCDMT000040Entry getMedikationVerordnungEntryemed() {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        MedikationVerordnungEntryemed substance = new MedikationVerordnungEntryemed();
        if (this.id != null && !this.id.isEmpty()) {
            II prescriptionId = new II("1.2.40.0.10.1.4.3.4.2.2", this.id);
            substance.getId().add(prescriptionId);
        }
        substance.setText(new ED(null, new TEL("#vpos-1")));
        substance.setStatusCode(new CS("completed"));
        if (this.periodOfPrescription != null && (this.periodOfPrescription.getStartIntake() != null || this.periodOfPrescription.getFrequence() != null)) {
            substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531421());
            substance.setHl7EffectiveTime(this.periodOfPrescription.getEinnahmedauer());
        }
        IVLINT ivlint = new IVLINT();
        ivlint.setValue(BigInteger.valueOf(this.amountPossibleDispenses));
        substance.setRepeatNumber(ivlint);
        if (this.doses != null && !this.doses.isEmpty()) {
            this.setDoses(substance);
        }
        if (this.drug != null) {
            substance.setConsumable(this.drug.getArzneiEntry());
        }
        substance.getEntryRelationship().add(this.getHl7CdaR2Pocdmt000040EntryRelationshipForPackageAmount());
        if (this.addInfoPat != null && !this.addInfoPat.isEmpty()) {
            substance.getEntryRelationship().add(this.getAdditionalPatInformation());
        }
        if (this.addInfoPharm != null && !this.addInfoPharm.isEmpty()) {
            substance.getEntryRelationship().add(this.getAdditionalPharmInformation());
        }
        if (this.kindOfTherapy != null) {
            substance.getEntryRelationship().add(this.getKindOfTherapy(this.kindOfTherapy));
        }
        if (this.emedId != null) {
            substance.getReference().add(this.getReferencePrescriptionEMedId());
        }
        entry.setSubstanceAdministration((POCDMT000040SubstanceAdministration)substance);
        return entry;
    }

    private void setDoses(MedikationVerordnungEntryemed substance) {
        int index = 1;
        for (Dose dose : this.doses) {
            if (dose == null) continue;
            if (dose.getFrequence() != null && dose.getDays() != null && !dose.getDays().isEmpty()) {
                POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
                POCDMT000040SubstanceAdministration substanceAdmin = new POCDMT000040SubstanceAdministration();
                substanceAdmin.getEffectiveTime().add(dose.getDosierung3dqDailyDoseWithPauseMultipleWeekDays());
                entryRel.setSubstanceAdministration(substanceAdmin);
                substance.getEntryRelationship().add(entryRel);
                substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531471());
            } else if (dose.getFrequence() != null) {
                substance.getEffectiveTime().add(dose.getDosierung1DailyDose());
                substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531471());
            }
            if (dose.getIntakeTime() != null && dose.getDays() != null && !dose.getDays().isEmpty()) {
                LOGGER.debug("add dose 4 single dose");
                substance.getEntryRelationship().add(dose.getDosierung4erSingleDoseWithPause(index++));
                substance.getTemplateId().remove(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
                substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
                continue;
            }
            if (dose.getIntakeTime() == null) continue;
            LOGGER.debug("add dose 2 single dose");
            substance.getEntryRelationship().add(dose.getDosierung2erSingleDose(index++));
            substance.getTemplateId().remove(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
            substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
        }
    }

    private POCDMT000040EntryRelationship getAdditionalPatInformation() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        PatientInstructions patInstructions = new PatientInstructions();
        patInstructions.setText(new ED(null, new TEL("#patinfo-0")));
        int index = 1;
        for (AdditionalInformation info : this.addInfoPat) {
            if (info == null || info.getKindOfInformation() == null) continue;
            patInstructions.addHl7EntryRelationship(info.getEntryRelationshipForPatientInformation(index++));
        }
        entryRel.setAct((POCDMT000040Act)patInstructions);
        return entryRel;
    }

    private POCDMT000040EntryRelationship getAdditionalPharmInformation() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        PharmacistInstructions pharmInstructions = new PharmacistInstructions();
        int index = 1;
        for (AdditionalInformation info : this.addInfoPharm) {
            if (info == null || info.getKindOfInformation() == null) continue;
            pharmInstructions.addHl7EntryRelationship(info.getEntryRelationshipForDispenseInformation(index++));
            ++index;
        }
        entryRel.setAct((POCDMT000040Act)pharmInstructions);
        return entryRel;
    }

    public POCDMT000040Entry getMedikationVerordnungEntryemedEmedication(int indexPrescription, Identificator gdaId, Code kindOfPrescription) {
        II prescriptionId;
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setTypeCode(XActRelationshipEntry.DRIV);
        MedikationVerordnungEntryemed substance = new MedikationVerordnungEntryemed();
        if (this.emedId != null && gdaId != null) {
            prescriptionId = gdaId.getHl7CdaR2Ii();
            substance.getId().add(prescriptionId);
        }
        if (this.id != null && !this.id.isEmpty()) {
            prescriptionId = new Identificator("1.2.40.0.10.1.4.3.4.2.2", this.id).getHl7CdaR2Ii();
            substance.getId().add(prescriptionId);
        }
        substance.setText(new ED(null, new TEL("#vpos-" + indexPrescription)));
        substance.setStatusCode(new CS("completed"));
        if (this.periodOfPrescription != null && (this.periodOfPrescription.getStartIntake() != null || this.periodOfPrescription.getFrequence() != null)) {
            substance.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531421());
            substance.setHl7EffectiveTime(this.periodOfPrescription.getEinnahmedauer());
        }
        IVLINT ivlint = new IVLINT();
        if (kindOfPrescription.equals((Object)ElgaMedikationRezeptart.KASSENREZEPT.getCode())) {
            ivlint.setValue(BigInteger.valueOf(0L));
        } else {
            ivlint.setValue(BigInteger.valueOf(this.amountPossibleDispenses));
        }
        substance.setRepeatNumber(ivlint);
        if (this.typeOfApplication != null && this.typeOfApplication.getCode() != null) {
            substance.setRouteCode(this.typeOfApplication.getHl7CdaR2Ce());
        }
        if (this.doses != null && !this.doses.isEmpty()) {
            this.setDoses(substance);
        }
        if (this.drug != null) {
            substance.setConsumable(this.drug.getArzneiEntry());
        }
        substance.getEntryRelationship().clear();
        substance.getEntryRelationship().add(this.getHl7CdaR2Pocdmt000040EntryRelationshipForPackageAmount());
        if (this.addInfoPat != null && !this.addInfoPat.isEmpty()) {
            substance.getEntryRelationship().add(this.getAdditionalPatInformation());
        }
        if (this.addInfoPharm != null && !this.addInfoPharm.isEmpty()) {
            substance.getEntryRelationship().add(this.getAdditionalPharmInformation());
        }
        if (this.kindOfTherapy != null) {
            substance.getEntryRelationship().add(this.getKindOfTherapy(this.kindOfTherapy));
        }
        if (this.emedId != null && this.emedId.getRoot() != null) {
            substance.getReference().add(this.getReferencePrescriptionEMedId());
        }
        entry.setSubstanceAdministration((POCDMT000040SubstanceAdministration)substance);
        return entry;
    }

    protected Therapieart getKindOfTherapy(Code kindOfTherapy) {
        Therapieart entryRelTherapy = new Therapieart();
        POCDMT000040Act act = entryRelTherapy.getAct();
        act.getTemplateId().add(new Identificator(TEMPLATE_ID_KIND_OF_THERAPY).getHl7CdaR2Ii());
        act.setCode((CD)new CE(kindOfTherapy.getCode(), kindOfTherapy.getCodeSystem(), kindOfTherapy.getCodeSystemName(), kindOfTherapy.getDisplayName()));
        return entryRelTherapy;
    }

    protected Iddescontainers getReferencePrescriptionEMedId() {
        if (this.emedId != null) {
            Iddescontainers idContainer = new Iddescontainers();
            POCDMT000040ExternalDocument doc = new POCDMT000040ExternalDocument();
            doc.getId().clear();
            II emedIdII = this.emedId.getHl7CdaR2Ii();
            emedIdII.setAssigningAuthorityName("e-MedAT");
            doc.getId().add(emedIdII);
            idContainer.setExternalDocument(doc);
            return idContainer;
        }
        return null;
    }

    protected POCDMT000040EntryRelationship getHl7CdaR2Pocdmt000040EntryRelationshipForPackageAmount() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
        entryRel.setInversionInd(Boolean.valueOf(false));
        POCDMT000040Supply supply = new POCDMT000040Supply();
        supply.setClassCode(ActClassSupply.SPLY);
        supply.setMoodCode(XDocumentSubstanceMood.RQO);
        BL bl = new BL();
        bl.setValue(Boolean.valueOf(false));
        supply.setIndependentInd(bl);
        supply.setQuantity(new PQ(String.valueOf(this.amountPackages)));
        entryRel.setSupply(supply);
        return entryRel;
    }
}

