/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryExpositionsrisikoProblem;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;

public class ExposureRiskProblem {
    private Identificator id;
    private ZonedDateTime exposureRiskStart;
    private Code exposureRisk;

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public ZonedDateTime getExposureRiskStart() {
        return this.exposureRiskStart;
    }

    public void setExposureRiskStart(ZonedDateTime exposureRiskStart) {
        this.exposureRiskStart = exposureRiskStart;
    }

    public Code getExposureRisk() {
        return this.exposureRisk;
    }

    public void setExposureRisk(Code exposureRisk) {
        this.exposureRisk = exposureRisk;
    }

    public AtcdabbrEntryExpositionsrisikoProblem getExposureRiskProblem(int index) {
        AtcdabbrEntryExpositionsrisikoProblem problem = new AtcdabbrEntryExpositionsrisikoProblem();
        if (this.id != null) {
            problem.getId().add(this.id.getHl7CdaR2Ii());
        }
        if (this.exposureRiskStart != null) {
            IVLTS effectiveTime = new IVLTS();
            effectiveTime.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.exposureRiskStart)));
            problem.setEffectiveTime(effectiveTime);
        }
        if (this.exposureRisk != null) {
            CD cd = new CD();
            cd.setCode(this.exposureRisk.getCode());
            cd.setCodeSystem(this.exposureRisk.getCodeSystem());
            cd.setCodeSystemName(this.exposureRisk.getCodeSystemName());
            cd.setDisplayName(this.exposureRisk.getDisplayName());
            cd.setOriginalText(new ED(null, new TEL("#risk-" + index)));
            problem.getValue().add(cd);
        }
        problem.setText(new ED(null, new TEL("#risk-" + index)));
        return problem;
    }
}

