/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.util.ArrayList;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryImmunizationSchedule;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Criterion;
import org.projecthusky.common.hl7cdar2.POCDMT000040Precondition;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;

public class ImmunizationSchedule {
    private static final String REFERENCE_TEXT_EIMPF_DOSE = "#schedule-dose-";
    private Code immunizationScheme;
    private Code immunizationDose;

    public Code getImmunizationScheme() {
        return this.immunizationScheme;
    }

    public void setImmunizationScheme(Code immunizationScheme) {
        this.immunizationScheme = immunizationScheme;
    }

    public Code getImmunizationDose() {
        return this.immunizationDose;
    }

    public void setImmunizationDose(Code immunizationDose) {
        this.immunizationDose = immunizationDose;
    }

    public POCDMT000040Precondition getImmunizationRecommendationEntry(int index) {
        POCDMT000040Precondition precondition = new POCDMT000040Precondition();
        precondition.getTypeCode().add("PRCN");
        AtcdabbrEntryImmunizationSchedule schedule = new AtcdabbrEntryImmunizationSchedule();
        if (this.immunizationScheme != null) {
            schedule.setCode((CD)new CE(this.immunizationScheme.getCode(), this.immunizationScheme.getCodeSystem(), this.immunizationScheme.getCodeSystemName(), this.immunizationScheme.getDisplayName()));
        } else {
            CE code = new CE();
            code.getNullFlavor().add("NI");
            schedule.setCode((CD)code);
        }
        if (this.immunizationDose != null) {
            schedule.setValue((ANY)new CD(this.immunizationDose.getCode(), this.immunizationDose.getCodeSystem(), this.immunizationDose.getCodeSystemName(), this.immunizationDose.getDisplayName()));
        } else {
            CD value = new CD();
            value.nullFlavor = new ArrayList();
            value.nullFlavor.add("UNK");
            schedule.setValue((ANY)value);
        }
        StringBuilder sbEimpfDose = new StringBuilder(REFERENCE_TEXT_EIMPF_DOSE);
        sbEimpfDose.append(index);
        schedule.setHl7Text(new ED(null, new TEL(sbEimpfDose.toString())));
        precondition.setCriterion((POCDMT000040Criterion)schedule);
        return precondition;
    }

    public POCDMT000040Precondition getImmunizationScheduleEntry(int index) {
        POCDMT000040Precondition precondition = new POCDMT000040Precondition();
        precondition.getTypeCode().add("PRCN");
        AtcdabbrEntryImmunizationSchedule schedule = new AtcdabbrEntryImmunizationSchedule();
        if (this.immunizationScheme != null) {
            schedule.setCode((CD)new CE(this.immunizationScheme.getCode(), this.immunizationScheme.getCodeSystem(), this.immunizationScheme.getCodeSystemName(), this.immunizationScheme.getDisplayName()));
        } else {
            CE code = new CE();
            code.getNullFlavor().add("NI");
            schedule.setCode((CD)code);
        }
        StringBuilder sbEimpfDose = new StringBuilder(REFERENCE_TEXT_EIMPF_DOSE);
        sbEimpfDose.append(index);
        if (this.immunizationDose != null) {
            schedule.setValue((ANY)new CD(this.immunizationDose.getCode(), this.immunizationDose.getCodeSystem(), this.immunizationDose.getCodeSystemName(), this.immunizationDose.getDisplayName()));
        }
        schedule.setHl7Text(new ED(null, new TEL(sbEimpfDose.toString())));
        precondition.setCriterion((POCDMT000040Criterion)schedule);
        return precondition;
    }
}

