/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderDocumentReplacementRelatedDocument;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderDocumentationOfServiceEventEImpfpass;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabrrSectionExpositionsrisikoPersonengruppenKodiert;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabrrSectionImpfempfehlungenKodiert;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabrrSectionImpfungenKodiert;
import org.projecthusky.cda.elga.generated.artdecor.EimpfSectionAntikoerperBestimmungKodiert;
import org.projecthusky.cda.elga.generated.artdecor.EimpfSectionImpfrelevanteErkrankungen;
import org.projecthusky.cda.elga.models.Disease;
import org.projecthusky.cda.elga.models.PatientCdaAt;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.Translation;
import org.projecthusky.cda.elga.models.eimpf.AntibodyDetermination;
import org.projecthusky.cda.elga.models.eimpf.ExposureRiskPersonGroup;
import org.projecthusky.cda.elga.models.eimpf.Immunization;
import org.projecthusky.cda.elga.models.eimpf.ImmunizationRecommendation;
import org.projecthusky.cda.elga.narrative.ExposureRiskNarrativeTextGenerator;
import org.projecthusky.cda.elga.narrative.ImmunizationLabResultNarrativeTextGenerator;
import org.projecthusky.cda.elga.narrative.ImmunizationNarrativeTextGenerator;
import org.projecthusky.cda.elga.narrative.ImmunizationRecommendationNarrativeTextGenerator;
import org.projecthusky.cda.elga.narrative.ImmunizationRelevantDiseasesNarrativeTextGenerator;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component3;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component5;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.POCDMT000040StructuredBody;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.utils.time.DateTimes;

public class ImmunizationState {
    private String title;
    private String docId;
    private String setId;
    private int version;
    private PatientCdaAt patient;
    private List<PractitionerCdaAt> authors;
    private ZonedDateTime authorTime;
    private Organization custodian;
    private ZonedDateTime startImmunization;
    private ZonedDateTime stopImmunization;
    private Identificator parentDocument;
    private List<Immunization> immunizations;
    private List<ExposureRiskPersonGroup> exposureRiskPersons;
    private List<Disease> immunizationRelevantDiseases;
    private List<AntibodyDetermination> antibodyDeterminations;
    private List<ImmunizationRecommendation> immunizationRecommendations;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String setId) {
        this.setId = setId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PatientCdaAt getPatient() {
        return this.patient;
    }

    public void setPatient(PatientCdaAt patient) {
        this.patient = patient;
    }

    public List<PractitionerCdaAt> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<PractitionerCdaAt> authors) {
        this.authors = authors;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public Organization getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Organization custodian) {
        this.custodian = custodian;
    }

    public ZonedDateTime getStartImmunization() {
        return this.startImmunization;
    }

    public void setStartImmunization(ZonedDateTime startImmunization) {
        this.startImmunization = startImmunization;
    }

    public ZonedDateTime getStopImmunization() {
        return this.stopImmunization;
    }

    public void setStopImmunization(ZonedDateTime stopImmunization) {
        this.stopImmunization = stopImmunization;
    }

    public Identificator getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(Identificator parentDocument) {
        this.parentDocument = parentDocument;
    }

    public List<Immunization> getImmunizations() {
        return this.immunizations;
    }

    public void setImmunizations(List<Immunization> immunizations) {
        this.immunizations = immunizations;
    }

    public List<ExposureRiskPersonGroup> getExposureRiskPersons() {
        return this.exposureRiskPersons;
    }

    public void setExposureRiskPersons(List<ExposureRiskPersonGroup> exposureRiskPersons) {
        this.exposureRiskPersons = exposureRiskPersons;
    }

    public List<Disease> getImmunizationRelevantDiseases() {
        return this.immunizationRelevantDiseases;
    }

    public void setImmunizationRelevantDiseases(List<Disease> immunizationRelevantDiseases) {
        this.immunizationRelevantDiseases = immunizationRelevantDiseases;
    }

    public List<AntibodyDetermination> getAntibodyDeterminations() {
        return this.antibodyDeterminations;
    }

    public void setAntibodyDeterminations(List<AntibodyDetermination> antibodyDeterminations) {
        this.antibodyDeterminations = antibodyDeterminations;
    }

    public List<ImmunizationRecommendation> getImmunizationRecommendations() {
        return this.immunizationRecommendations;
    }

    public void setImmunizationRecommendations(List<ImmunizationRecommendation> immunizationRecommendations) {
        this.immunizationRecommendations = immunizationRecommendations;
    }

    protected AtcdabbrHeaderDocumentationOfServiceEventEImpfpass getAtcdabbrHeaderDocumentationOfServiceEvent() {
        AtcdabbrHeaderDocumentationOfServiceEventEImpfpass documentationOfServiceEvent = new AtcdabbrHeaderDocumentationOfServiceEventEImpfpass();
        CE eventCode = new CE("41000179103", "2.16.840.1.113883.6.96", "SNOMEDCT", "Immunization record (record artifact)");
        documentationOfServiceEvent.getServiceEvent().setCode(eventCode);
        documentationOfServiceEvent.getServiceEvent().setEffectiveTime(new IVLTS());
        if (this.startImmunization != null) {
            documentationOfServiceEvent.getServiceEvent().getEffectiveTime().getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startImmunization)));
        }
        if (this.stopImmunization != null) {
            documentationOfServiceEvent.getServiceEvent().getEffectiveTime().getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stopImmunization)));
        }
        return documentationOfServiceEvent;
    }

    protected AtcdabbrHeaderDocumentReplacementRelatedDocument getAtcdabbrHeaderDocumentReplacementRelatedDocument() {
        AtcdabbrHeaderDocumentReplacementRelatedDocument relatedDocument = new AtcdabbrHeaderDocumentReplacementRelatedDocument();
        relatedDocument.getHl7ParentDocument().getId().add(this.parentDocument.getHl7CdaR2Ii());
        return relatedDocument;
    }

    protected POCDMT000040StructuredBody getHl7CdaR2Pocdmt000040StructuredBodyImmunizationState() {
        POCDMT000040Component3 comp3;
        POCDMT000040StructuredBody structuredBody = new POCDMT000040StructuredBody();
        structuredBody.getClassCode().add("DOCBODY");
        structuredBody.getMoodCode().add("EVN");
        if (this.immunizations != null && !this.immunizations.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getAtcdabbrSectionImpfungenKodiert());
            structuredBody.getComponent().add(comp3);
        }
        if (this.exposureRiskPersons != null) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getAtcdabbrSectionExpositionsrisikoPersonengruppenKodiert());
            structuredBody.getComponent().add(comp3);
        }
        if (this.immunizationRelevantDiseases != null && !this.immunizationRelevantDiseases.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getEimpfSectionImpfrelevanteErkrankungen());
            structuredBody.getComponent().add(comp3);
        }
        if (this.antibodyDeterminations != null && !this.antibodyDeterminations.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getEimpfSectionAntikoerperBestimmungKodiert());
            structuredBody.getComponent().add(comp3);
        }
        if (this.immunizationRecommendations != null && !this.immunizationRecommendations.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getAtcdabbrSectionImpfempfehlungenKodiert());
            structuredBody.getComponent().add(comp3);
        }
        return structuredBody;
    }

    protected AtcdabrrSectionImpfungenKodiert getAtcdabbrSectionImpfungenKodiert() {
        if (this.immunizations == null || this.immunizations.isEmpty()) {
            return null;
        }
        AtcdabrrSectionImpfungenKodiert vaccinationSection = new AtcdabrrSectionImpfungenKodiert();
        vaccinationSection.setTitle(this.createTitle("Impfungen"));
        int index = 0;
        for (Immunization immunization : this.immunizations) {
            if (immunization == null) continue;
            vaccinationSection.getEntry().add(immunization.getImmunizationEntry(index++));
            if (immunization.getTranslations() == null) continue;
            for (Translation translation : immunization.getTranslations()) {
                if (translation == null) continue;
                vaccinationSection.getComponent().add(this.getPOCDMT000040Component5(ActRelationshipHasComponent.COMP, true, translation.getAtcdabbrSectionUebersetzung()));
            }
        }
        StrucDocText narrativeVaccText = new StrucDocText();
        ImmunizationNarrativeTextGenerator textbuilder = new ImmunizationNarrativeTextGenerator(vaccinationSection.getEntry());
        narrativeVaccText.getContent().addAll(textbuilder.getTables());
        vaccinationSection.setText(narrativeVaccText);
        return vaccinationSection;
    }

    protected AtcdabrrSectionExpositionsrisikoPersonengruppenKodiert getAtcdabbrSectionExpositionsrisikoPersonengruppenKodiert() {
        if (this.exposureRiskPersons == null || this.exposureRiskPersons.isEmpty()) {
            return null;
        }
        AtcdabrrSectionExpositionsrisikoPersonengruppenKodiert riskGroupSection = new AtcdabrrSectionExpositionsrisikoPersonengruppenKodiert();
        riskGroupSection.setTitle(this.createTitle("Spezielle Impfindikation"));
        int index = 0;
        for (ExposureRiskPersonGroup personGroup : this.exposureRiskPersons) {
            riskGroupSection.getEntry().add(personGroup.getExposureRiskPersonGroupEntry(index++));
            if (personGroup.getTranslations() == null) continue;
            for (Translation translation : personGroup.getTranslations()) {
                if (translation == null) continue;
                riskGroupSection.getComponent().add(this.getPOCDMT000040Component5(ActRelationshipHasComponent.COMP, true, translation.getAtcdabbrSectionUebersetzung()));
            }
        }
        StrucDocText textRisks = new StrucDocText();
        ExposureRiskNarrativeTextGenerator textbuilder = new ExposureRiskNarrativeTextGenerator(riskGroupSection.getEntry());
        textRisks.getContent().add(textbuilder.toString());
        riskGroupSection.setText(textRisks);
        return riskGroupSection;
    }

    protected EimpfSectionImpfrelevanteErkrankungen getEimpfSectionImpfrelevanteErkrankungen() {
        if (this.immunizationRelevantDiseases == null || this.immunizationRelevantDiseases.isEmpty()) {
            return null;
        }
        EimpfSectionImpfrelevanteErkrankungen relevantDiseases = new EimpfSectionImpfrelevanteErkrankungen();
        relevantDiseases.setTitle(this.createTitle("Impfrelevante Erkrankungen"));
        relevantDiseases.getEntry().clear();
        int index = 0;
        for (Disease disease : this.immunizationRelevantDiseases) {
            if (disease == null) continue;
            POCDMT000040Entry entry = new POCDMT000040Entry();
            entry.setTypeCode(XActRelationshipEntry.DRIV);
            entry.setContextConductionInd(Boolean.valueOf(true));
            entry.setAct((POCDMT000040Act)disease.getEimpfEntryImpfrelevanteErkrankungenProblemConcern(index++));
            relevantDiseases.getEntry().add(entry);
            if (disease.getTranslations() == null) continue;
            for (Translation translation : disease.getTranslations()) {
                if (translation == null) continue;
                relevantDiseases.getComponent().add(this.getPOCDMT000040Component5(ActRelationshipHasComponent.COMP, true, translation.getAtcdabbrSectionUebersetzung()));
            }
        }
        StrucDocText relevanteDiseasesText = new StrucDocText();
        ImmunizationRelevantDiseasesNarrativeTextGenerator textbuilder = new ImmunizationRelevantDiseasesNarrativeTextGenerator(relevantDiseases.getEntry());
        relevanteDiseasesText.getContent().add(textbuilder.toString());
        relevantDiseases.setText(relevanteDiseasesText);
        return relevantDiseases;
    }

    protected EimpfSectionAntikoerperBestimmungKodiert getEimpfSectionAntikoerperBestimmungKodiert() {
        if (this.antibodyDeterminations == null || this.antibodyDeterminations.isEmpty()) {
            return null;
        }
        EimpfSectionAntikoerperBestimmungKodiert antibodiesSection = new EimpfSectionAntikoerperBestimmungKodiert();
        antibodiesSection.setTitle(this.createTitle("Laboruntersuchungen"));
        int index = 0;
        antibodiesSection.getEntry().clear();
        for (AntibodyDetermination determination : this.antibodyDeterminations) {
            antibodiesSection.getEntry().add(determination.getEimpfEntryAntikoerperBestimmungDataProcessing(index++));
            if (determination.getTranslations() == null) continue;
            for (Translation translation : determination.getTranslations()) {
                if (translation == null) continue;
                antibodiesSection.getComponent().add(this.getPOCDMT000040Component5(ActRelationshipHasComponent.COMP, true, translation.getAtcdabbrSectionUebersetzung()));
            }
        }
        StrucDocText textImmunizationLabResult = new StrucDocText();
        ImmunizationLabResultNarrativeTextGenerator textbuilder = new ImmunizationLabResultNarrativeTextGenerator(antibodiesSection.getEntry());
        textImmunizationLabResult.getContent().add(textbuilder.toString());
        antibodiesSection.setText(textImmunizationLabResult);
        return antibodiesSection;
    }

    protected AtcdabrrSectionImpfempfehlungenKodiert getAtcdabbrSectionImpfempfehlungenKodiert() {
        if (this.immunizationRecommendations == null || this.immunizationRecommendations.isEmpty()) {
            return null;
        }
        AtcdabrrSectionImpfempfehlungenKodiert treatmentPlanSection = new AtcdabrrSectionImpfempfehlungenKodiert();
        treatmentPlanSection.setTitle(this.createTitle("Impfempfehlungen"));
        int index = 0;
        treatmentPlanSection.getEntry().clear();
        for (ImmunizationRecommendation immunizationRec : this.immunizationRecommendations) {
            treatmentPlanSection.getEntry().add(immunizationRec.getImmunizationRecommendationEntry(index++));
            if (immunizationRec.getTranslations() == null) continue;
            for (Translation translation : immunizationRec.getTranslations()) {
                if (translation == null) continue;
                treatmentPlanSection.getComponent().add(this.getPOCDMT000040Component5(ActRelationshipHasComponent.COMP, true, translation.getAtcdabbrSectionUebersetzung()));
            }
        }
        StrucDocText textImmunizationRecommendation = new StrucDocText();
        ImmunizationRecommendationNarrativeTextGenerator textbuilder = new ImmunizationRecommendationNarrativeTextGenerator(treatmentPlanSection.getEntry());
        textImmunizationRecommendation.getContent().add(textbuilder.toString());
        treatmentPlanSection.setText(textImmunizationRecommendation);
        return treatmentPlanSection;
    }

    private POCDMT000040Component5 getPOCDMT000040Component5(ActRelationshipHasComponent typeCode, boolean contextInduction, POCDMT000040Section section) {
        POCDMT000040Component5 comp5 = new POCDMT000040Component5();
        comp5.setTypeCode(typeCode);
        comp5.setContextConductionInd(Boolean.valueOf(contextInduction));
        comp5.setSection(section);
        return comp5;
    }

    protected ST createTitle(String text) {
        ST titleSt = new ST();
        if (text != null) {
            titleSt.setXmlMixed(text);
        }
        return titleSt;
    }
}

