/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.emed;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.emed.AlteredDosageInformation;
import org.projecthusky.cda.elga.generated.artdecor.emed.Iddescontainers;
import org.projecthusky.cda.elga.generated.artdecor.emed.MedikationAbgabeEntryemed;
import org.projecthusky.cda.elga.generated.artdecor.emed.MedikationVerordnungEntryemed;
import org.projecthusky.cda.elga.generated.artdecor.emed.PatientInstructions;
import org.projecthusky.cda.elga.generated.artdecor.emed.PharmacistInstructions;
import org.projecthusky.cda.elga.generated.artdecor.emed.Therapieart;
import org.projecthusky.cda.elga.models.AdditionalInformation;
import org.projecthusky.cda.elga.models.Dose;
import org.projecthusky.cda.elga.models.Drug;
import org.projecthusky.cda.elga.models.PeriodOfPrescription;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Material;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.POCDMT000040Supply;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;

public class DispenseEntry {
    private Code kindOfDelivery;
    private int packageAmount;
    private Drug drug;
    private Identificator prescriptionId;
    private List<AdditionalInformation> addInfoPatient;
    private List<AdditionalInformation> addInfoPharmacist;
    private Code kindOfTherapy;
    private List<Dose> alteredDoses;
    private Code alteredTypeOfApplication;
    private PeriodOfPrescription alteredPeriodOfPrescription;
    private Identificator emedId;

    public Code getKindOfDelivery() {
        return this.kindOfDelivery;
    }

    public void setKindOfDelivery(Code kindOfDelivery) {
        this.kindOfDelivery = kindOfDelivery;
    }

    public int getPackageAmount() {
        return this.packageAmount;
    }

    public void setPackageAmount(int packageAmount) {
        this.packageAmount = packageAmount;
    }

    public Drug getDrug() {
        return this.drug;
    }

    public void setDrug(Drug drug) {
        this.drug = drug;
    }

    public Identificator getPrescriptionId() {
        return this.prescriptionId;
    }

    public void setPrescriptionId(Identificator prescriptionId) {
        this.prescriptionId = prescriptionId;
    }

    public List<AdditionalInformation> getAdditionalInformationPatient() {
        return this.addInfoPatient;
    }

    public void setAdditionalInformationPatient(List<AdditionalInformation> additionalInformationPatient) {
        this.addInfoPatient = additionalInformationPatient;
    }

    public List<AdditionalInformation> getAdditionalInformationPharmacist() {
        return this.addInfoPharmacist;
    }

    public void setAdditionalInformationPharmacist(List<AdditionalInformation> additionalInformationPharmacist) {
        this.addInfoPharmacist = additionalInformationPharmacist;
    }

    public Code getKindOfTherapy() {
        return this.kindOfTherapy;
    }

    public void setKindOfTherapy(Code kindOfTherapy) {
        this.kindOfTherapy = kindOfTherapy;
    }

    public List<Dose> getAlteredDoses() {
        return this.alteredDoses;
    }

    public void setAlteredDoses(List<Dose> alteredDoses) {
        this.alteredDoses = alteredDoses;
    }

    public Code getAlteredTypeOfApplication() {
        return this.alteredTypeOfApplication;
    }

    public void setAlteredTypeOfApplication(Code alteredTypeOfApplication) {
        this.alteredTypeOfApplication = alteredTypeOfApplication;
    }

    public PeriodOfPrescription getAlteredPeriodOfPrescription() {
        return this.alteredPeriodOfPrescription;
    }

    public void setAlteredPeriodOfPrescription(PeriodOfPrescription alteredPeriodOfPrescription) {
        this.alteredPeriodOfPrescription = alteredPeriodOfPrescription;
    }

    public Identificator getEmedId() {
        return this.emedId;
    }

    public void setEmedId(Identificator emedId) {
        this.emedId = emedId;
    }

    public POCDMT000040SubstanceAdministration getMedikationAbgabeSubstanceAdministration(int indexDelivery, Identificator gdaId) {
        POCDMT000040SubstanceAdministration substanceAdministration = new POCDMT000040SubstanceAdministration();
        substanceAdministration.getClassCode().add("SBADM");
        substanceAdministration.setMoodCode(XDocumentSubstanceMood.INT);
        substanceAdministration.getTemplateId().add(new Identificator("1.3.6.1.4.1.19376.1.9.1.3.6").getHl7CdaR2Ii());
        if (this.emedId != null && gdaId != null) {
            II deliveryId = this.emedId.getHl7CdaR2Ii();
            deliveryId.setExtension(String.format("%s_%d", deliveryId.getExtension(), indexDelivery));
            deliveryId.setAssigningAuthorityName(gdaId.getAssigningAuthorityName());
            substanceAdministration.getId().add(deliveryId);
        }
        substanceAdministration.setText(new ED(null, new TEL("#apos-" + indexDelivery)));
        substanceAdministration.setStatusCode(new CS("completed"));
        if (this.packageAmount > 0) {
            substanceAdministration.setDoseQuantity(new IVLPQ(String.valueOf(this.packageAmount)));
        } else {
            IVLPQ mskPq = new IVLPQ();
            mskPq.nullFlavor = new ArrayList();
            mskPq.nullFlavor.add("MSK");
            substanceAdministration.setDoseQuantity(mskPq);
        }
        if (this.drug != null) {
            POCDMT000040Consumable consumable = new POCDMT000040Consumable();
            POCDMT000040ManufacturedProduct manufacturedProduct = new POCDMT000040ManufacturedProduct();
            POCDMT000040Material material = new POCDMT000040Material();
            material.getNullFlavor().add("NA");
            manufacturedProduct.setManufacturedMaterial(material);
            consumable.setManufacturedProduct(manufacturedProduct);
            substanceAdministration.setConsumable(consumable);
        }
        if (this.prescriptionId != null) {
            substanceAdministration.getEntryRelationship().add(this.getReferencePrescription());
        }
        if (this.addInfoPatient != null && !this.addInfoPatient.isEmpty()) {
            substanceAdministration.getEntryRelationship().add(this.getPatientInstructions());
        }
        if (this.addInfoPharmacist != null && !this.addInfoPharmacist.isEmpty()) {
            substanceAdministration.getEntryRelationship().add(this.getPharmInstructions());
        }
        if (this.kindOfTherapy != null && this.kindOfTherapy.getCode() != null) {
            substanceAdministration.getEntryRelationship().add(this.getEntryRelKindOfTherapy());
        }
        if (this.alteredDoses != null || this.alteredPeriodOfPrescription != null || this.alteredTypeOfApplication != null) {
            substanceAdministration.getEntryRelationship().add(this.getAlteredDosageInformationEntryRel());
        }
        if (this.emedId != null) {
            substanceAdministration.getReference().add(this.getReferencePrescriptionEMedId());
        }
        return substanceAdministration;
    }

    public POCDMT000040Entry getMedikationAbgabeEntryemed(int indexDelivery, Identificator gdaId) {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        MedikationAbgabeEntryemed supply = new MedikationAbgabeEntryemed();
        if (this.emedId != null && gdaId != null) {
            II deliveryId = this.emedId.getHl7CdaR2Ii();
            deliveryId.setExtension(String.format("%s_%d", deliveryId.getExtension(), indexDelivery));
            deliveryId.setAssigningAuthorityName(gdaId.getAssigningAuthorityName());
            supply.getId().add(deliveryId);
        }
        supply.setText(new ED(null, new TEL("#apos-" + indexDelivery)));
        supply.setStatusCode(new CS("completed"));
        if (this.packageAmount > 0) {
            supply.setQuantity(new PQ(String.valueOf(this.packageAmount)));
        } else {
            PQ mskPq = new PQ();
            mskPq.nullFlavor = new ArrayList();
            mskPq.nullFlavor.add("MSK");
            supply.setQuantity(mskPq);
        }
        if (this.drug != null) {
            supply.setProduct(this.drug.getArzneiEntryDelivery(indexDelivery));
        }
        if (this.prescriptionId != null) {
            supply.getEntryRelationship().add(this.getReferencePrescription());
        }
        if (this.addInfoPatient != null && !this.addInfoPatient.isEmpty()) {
            supply.getEntryRelationship().add(this.getPatientInstructions());
        }
        if (this.addInfoPharmacist != null && !this.addInfoPharmacist.isEmpty()) {
            supply.getEntryRelationship().add(this.getPharmInstructions());
        }
        if (this.kindOfTherapy != null && this.kindOfTherapy.getCode() != null) {
            supply.getEntryRelationship().add(this.getEntryRelKindOfTherapy());
        }
        if (this.alteredDoses != null || this.alteredPeriodOfPrescription != null || this.alteredTypeOfApplication != null) {
            supply.getEntryRelationship().add(this.getAlteredDosageInformationEntryRel());
        }
        if (this.emedId != null) {
            supply.getReference().add(this.getReferencePrescriptionEMedId());
        }
        entry.setSupply((POCDMT000040Supply)supply);
        return entry;
    }

    public POCDMT000040EntryRelationship getReferencePrescription() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.REFR);
        POCDMT000040SubstanceAdministration substanceAdministration = new POCDMT000040SubstanceAdministration();
        substanceAdministration.getClassCode().add("SBADM");
        substanceAdministration.setMoodCode(XDocumentSubstanceMood.INT);
        if (this.prescriptionId != null) {
            substanceAdministration.getId().add(this.prescriptionId.getHl7CdaR2Ii());
        }
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        POCDMT000040ManufacturedProduct manufacturedProd = new POCDMT000040ManufacturedProduct();
        POCDMT000040Material material = new POCDMT000040Material();
        material.getNullFlavor().add("NA");
        manufacturedProd.setManufacturedMaterial(material);
        consumable.setManufacturedProduct(manufacturedProd);
        substanceAdministration.setConsumable(consumable);
        entryRel.setSubstanceAdministration(substanceAdministration);
        return entryRel;
    }

    public POCDMT000040EntryRelationship getPatientInstructions() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        PatientInstructions patInstructions = new PatientInstructions();
        patInstructions.setText(new ED(null, new TEL("#patinfo-0")));
        int index = 1;
        for (AdditionalInformation info : this.addInfoPatient) {
            if (info == null || info.getKindOfInformation() == null) continue;
            patInstructions.addHl7EntryRelationship(info.getEntryRelationshipForPatientInformation(index++));
        }
        entryRel.setAct((POCDMT000040Act)patInstructions);
        return entryRel;
    }

    public POCDMT000040EntryRelationship getPharmInstructions() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        PharmacistInstructions pharmInstructions = new PharmacistInstructions();
        int index = 1;
        for (AdditionalInformation info : this.addInfoPharmacist) {
            if (info == null || info.getKindOfInformation() == null) continue;
            pharmInstructions.addHl7EntryRelationship(info.getEntryRelationshipForDispenseInformation(index++));
            ++index;
        }
        entryRel.setAct((POCDMT000040Act)pharmInstructions);
        return entryRel;
    }

    public POCDMT000040EntryRelationship getEntryRelKindOfTherapy() {
        Therapieart therapieArtEntryRel = new Therapieart();
        POCDMT000040Act act = therapieArtEntryRel.getAct();
        act.setCode((CD)this.kindOfTherapy.getHl7CdaR2Ce());
        therapieArtEntryRel.setAct(act);
        return therapieArtEntryRel;
    }

    public POCDMT000040EntryRelationship getAlteredDosageInformationEntryRel() {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
        AlteredDosageInformation alteredDosageInfoEntryRel = new AlteredDosageInformation();
        alteredDosageInfoEntryRel.setRouteCode(this.alteredTypeOfApplication.getHl7CdaR2Ce());
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        POCDMT000040ManufacturedProduct manufacturedProduct = new POCDMT000040ManufacturedProduct();
        POCDMT000040Material material = new POCDMT000040Material();
        material.getNullFlavor().add("NA");
        manufacturedProduct.setManufacturedMaterial(material);
        consumable.setManufacturedProduct(manufacturedProduct);
        alteredDosageInfoEntryRel.setConsumable(consumable);
        if (this.alteredPeriodOfPrescription != null && (this.alteredPeriodOfPrescription.getStartIntake() != null || this.alteredPeriodOfPrescription.getFrequence() != null)) {
            alteredDosageInfoEntryRel.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531421());
            alteredDosageInfoEntryRel.setHl7EffectiveTime(this.alteredPeriodOfPrescription.getEinnahmedauer());
        }
        if (this.alteredDoses != null && !this.alteredDoses.isEmpty()) {
            int index = 1;
            for (Dose dose : this.alteredDoses) {
                if (dose == null) continue;
                if (dose.getFrequence() != null && dose.getDays() != null && !dose.getDays().isEmpty()) {
                    POCDMT000040EntryRelationship entryRelDose = new POCDMT000040EntryRelationship();
                    POCDMT000040SubstanceAdministration substanceAdmin = new POCDMT000040SubstanceAdministration();
                    substanceAdmin.getEffectiveTime().add(dose.getDosierung3dqDailyDoseWithPauseMultipleWeekDays());
                    entryRel.setSubstanceAdministration(substanceAdmin);
                    alteredDosageInfoEntryRel.getEntryRelationship().add(entryRel);
                    alteredDosageInfoEntryRel.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531471());
                } else if (dose.getFrequence() != null) {
                    alteredDosageInfoEntryRel.getEffectiveTime().add(dose.getDosierung1DailyDose());
                    alteredDosageInfoEntryRel.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId136141193761531471());
                }
                if (dose.getIntakeTime() != null && dose.getDays() != null && !dose.getDays().isEmpty()) {
                    alteredDosageInfoEntryRel.getEntryRelationship().add(dose.getDosierung4erSingleDoseWithPause(index++));
                    alteredDosageInfoEntryRel.getTemplateId().remove(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
                    alteredDosageInfoEntryRel.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
                    continue;
                }
                if (dose.getIntakeTime() == null) continue;
                alteredDosageInfoEntryRel.getEntryRelationship().add(dose.getDosierung2erSingleDose(index++));
                alteredDosageInfoEntryRel.getTemplateId().remove(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
                alteredDosageInfoEntryRel.getTemplateId().add(MedikationVerordnungEntryemed.getPredefinedTemplateId13614119376153149());
            }
        }
        entryRel.setSubstanceAdministration((POCDMT000040SubstanceAdministration)alteredDosageInfoEntryRel);
        return entryRel;
    }

    protected Iddescontainers getReferencePrescriptionEMedId() {
        if (this.emedId != null) {
            Iddescontainers idContainer = new Iddescontainers();
            POCDMT000040ExternalDocument doc = new POCDMT000040ExternalDocument();
            doc.setSetId(this.emedId.getHl7CdaR2Ii());
            idContainer.setExternalDocument(doc);
            return idContainer;
        }
        return null;
    }
}

