/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.emed;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.emed.EMedikationPharmazeutischeEmpfehlung;
import org.projecthusky.cda.elga.generated.artdecor.emed.HeaderRelatedDocument;
import org.projecthusky.cda.elga.generated.artdecor.emed.PharmazeutischeEmpfehlungSektion;
import org.projecthusky.cda.elga.models.PatientCdaAt;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.emed.PharmaceuticalRecommendationEntry;
import org.projecthusky.cda.elga.narrative.PharmRecommendationNarrativeTextGenerator;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component3;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.POCDMT000040StructuredBody;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.utils.time.DateTimes;

public class EmedPharmaceuticalRecommendation {
    private Identificator docId;
    private Identificator setId;
    private int version;
    private PatientCdaAt patient;
    private List<PractitionerCdaAt> authors;
    private ZonedDateTime authorTime;
    private Organization custodian;
    private PractitionerCdaAt legalAuthenticator;
    private ZonedDateTime startValidityPeriod;
    private ZonedDateTime stopValidityPeriod;
    private Identificator parentDocument;
    private Code kindOfPrescription;
    private List<PharmaceuticalRecommendationEntry> pharmRecommendationEntries;
    private Identificator gdaId;

    public Code getKindOfPrescription() {
        return this.kindOfPrescription;
    }

    public void setKindOfPrescription(Code kindOfPrescription) {
        this.kindOfPrescription = kindOfPrescription;
    }

    public Identificator getDocId() {
        return this.docId;
    }

    public void setDocId(Identificator docId) {
        this.docId = docId;
    }

    public Identificator getSetId() {
        return this.setId;
    }

    public void setSetId(Identificator setId) {
        this.setId = setId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PatientCdaAt getPatient() {
        return this.patient;
    }

    public void setPatient(PatientCdaAt patient) {
        this.patient = patient;
    }

    public List<PractitionerCdaAt> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<PractitionerCdaAt> authors) {
        this.authors = authors;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public Organization getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Organization custodian) {
        this.custodian = custodian;
    }

    public PractitionerCdaAt getLegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public void setLegalAuthenticator(PractitionerCdaAt legalAuthenticator) {
        this.legalAuthenticator = legalAuthenticator;
    }

    public ZonedDateTime getStartValidityPeriod() {
        return this.startValidityPeriod;
    }

    public void setStartValidityPeriod(ZonedDateTime startValidityPeriod) {
        this.startValidityPeriod = startValidityPeriod;
    }

    public ZonedDateTime getStopValidityPeriod() {
        return this.stopValidityPeriod;
    }

    public void setStopValidityPeriod(ZonedDateTime stopValidityPeriod) {
        this.stopValidityPeriod = stopValidityPeriod;
    }

    public Identificator getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(Identificator parentDocument) {
        this.parentDocument = parentDocument;
    }

    public List<PharmaceuticalRecommendationEntry> getPharmRecommendationEntries() {
        return this.pharmRecommendationEntries;
    }

    public void setPharmRecommendationEntries(List<PharmaceuticalRecommendationEntry> pharmRecommendationEntries) {
        this.pharmRecommendationEntries = pharmRecommendationEntries;
    }

    public Identificator getGdaId() {
        return this.gdaId;
    }

    public void setGdaId(Identificator gdaId) {
        this.gdaId = gdaId;
    }

    protected HeaderRelatedDocument getAtcdabbrHeaderDocumentReplacementRelatedDocument() {
        HeaderRelatedDocument relatedDocument = new HeaderRelatedDocument();
        relatedDocument.getHl7ParentDocument().getId().add(this.parentDocument.getHl7CdaR2Ii());
        return relatedDocument;
    }

    protected POCDMT000040StructuredBody getHl7CdaR2Pocdmt000040StructuredBodyEMedicationPharmaceuticalRecommendation() {
        POCDMT000040StructuredBody structuredBody = new POCDMT000040StructuredBody();
        structuredBody.getClassCode().add("DOCBODY");
        structuredBody.getMoodCode().add("EVN");
        if (this.pharmRecommendationEntries != null && !this.pharmRecommendationEntries.isEmpty()) {
            POCDMT000040Component3 comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getPharmaceuticalRecommendationSection());
            structuredBody.getComponent().add(comp3);
        }
        return structuredBody;
    }

    protected PharmazeutischeEmpfehlungSektion getPharmaceuticalRecommendationSection() {
        if (this.pharmRecommendationEntries == null || this.pharmRecommendationEntries.isEmpty()) {
            return null;
        }
        PharmazeutischeEmpfehlungSektion pharmaceuticalRecommendationSection = new PharmazeutischeEmpfehlungSektion();
        int index = 0;
        for (PharmaceuticalRecommendationEntry entry : this.pharmRecommendationEntries) {
            if (entry == null) continue;
            pharmaceuticalRecommendationSection.getEntry().add(entry.getMedikationPharmazeutischeEmpfehlungEntryemed(index, this.gdaId, this.kindOfPrescription));
        }
        StrucDocText textKonsUeberwGrund = new StrucDocText();
        PharmRecommendationNarrativeTextGenerator textbuilder = new PharmRecommendationNarrativeTextGenerator(pharmaceuticalRecommendationSection.getEntry());
        textKonsUeberwGrund.getContent().add(textbuilder.toString());
        pharmaceuticalRecommendationSection.setText(textKonsUeberwGrund);
        return pharmaceuticalRecommendationSection;
    }

    public EMedikationPharmazeutischeEmpfehlung getEMedicationPharmaceuticalRecommencation() {
        EMedikationPharmazeutischeEmpfehlung cda = new EMedikationPharmazeutischeEmpfehlung();
        this.addHeader(cda);
        POCDMT000040Component2 comp2 = new POCDMT000040Component2();
        comp2.setStructuredBody(this.getHl7CdaR2Pocdmt000040StructuredBodyEMedicationPharmaceuticalRecommendation());
        cda.setHl7Component(comp2);
        return cda;
    }

    private void addHeader(EMedikationPharmazeutischeEmpfehlung cda) {
        cda.setHl7Id(this.getDocId().getHl7CdaR2Ii());
        cda.setEffectiveTime(DateTimes.toDatetimeTs((TemporalAccessor)ZonedDateTime.now()));
        cda.setSetId(this.getSetId().getHl7CdaR2Ii());
        cda.setVersionNumber(new INT(this.getVersion()));
        cda.getRealmCode().add(new CS("AT"));
        if (this.patient != null) {
            cda.getRecordTarget().clear();
            cda.getRecordTarget().add(this.patient.getHeaderRecordTargetBase());
        }
        if (this.getAuthors() != null && !this.getAuthors().isEmpty()) {
            for (PractitionerCdaAt author : this.getAuthors()) {
                cda.getAuthor().add(author.getAtcdabbrHeaderAuthor(this.authorTime));
            }
        }
        if (this.custodian != null) {
            cda.setCustodian(this.custodian.getHl7CdaR2Pocdmt000040Custodian());
        }
        if (this.legalAuthenticator != null) {
            cda.setLegalAuthenticator(this.legalAuthenticator.getHeaderLegalAuthenticator(this.getAuthorTime()));
        }
        if (this.getParentDocument() != null) {
            cda.getRelatedDocument().add(this.getAtcdabbrHeaderDocumentReplacementRelatedDocument());
        }
    }
}

