/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.ems;

import java.time.ZonedDateTime;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryProblem;
import org.projecthusky.cda.elga.utils.DateTimeUtils;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClinicalManifestationItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClinicalManifestationItem.class);
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;
    private Code code;

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public EpimsEntryProblem getEpimsEntryProblem(Identificator id, int index) {
        EpimsEntryProblem problem = new EpimsEntryProblem();
        problem.setHl7Id(id.getHl7CdaR2Ii());
        problem.setText(new ED(null, new TEL(String.format("#epims-entry-problem-%d", index))));
        problem.setEffectiveTime(DateTimeUtils.createIvlts(this.startDate, this.stopDate));
        if (this.code != null) {
            problem.setHl7Value(this.code.getHl7CdaR2Cd());
        } else {
            LOGGER.warn("Code for clinical manifestation is null");
        }
        return problem;
    }
}

