/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.projecthusky.cda.elga.models.lab.LaboratoryBatteryOrganizer;
import org.projecthusky.cda.elga.models.lab.Specimen;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;

public class Antibiogram {
    private ZonedDateTime resultTime;
    private Specimen specimen;
    private LaboratoryBatteryOrganizer laboratoryBattery;

    public ZonedDateTime getResultTime() {
        return this.resultTime;
    }

    public Specimen getSpecimen() {
        return this.specimen;
    }

    public LaboratoryBatteryOrganizer getLaboratoryBattery() {
        return this.laboratoryBattery;
    }

    public void setResultTime(ZonedDateTime resultTime) {
        this.resultTime = resultTime;
    }

    public void setSpecimen(Specimen specimen) {
        this.specimen = specimen;
    }

    public void setLaboratoryBattery(LaboratoryBatteryOrganizer laboratoryBattery) {
        this.laboratoryBattery = laboratoryBattery;
    }

    public org.projecthusky.cda.elga.generated.artdecor.base.Antibiogram getAntibiogram() {
        org.projecthusky.cda.elga.generated.artdecor.base.Antibiogram antibiogram = new org.projecthusky.cda.elga.generated.artdecor.base.Antibiogram();
        if (this.resultTime != null) {
            antibiogram.setHl7EffectiveTime(new IVLTS(DateTimes.toDatetimeTs((TemporalAccessor)this.resultTime).getValue()));
        }
        antibiogram.setHl7Specimen(this.specimen.getPOCDMT000040Specimen());
        POCDMT000040Component4 comp = new POCDMT000040Component4();
        comp.setTypeCode(ActRelationshipHasComponent.COMP);
        Code defaultCodeAntibiogram = new Code();
        defaultCodeAntibiogram.setCode("29576-6");
        defaultCodeAntibiogram.setCodeSystem("2.16.840.1.113883.6.1");
        defaultCodeAntibiogram.setCodeSystemName("LOINC");
        defaultCodeAntibiogram.setDisplayName("Antibiogramm");
        this.laboratoryBattery.setStructure(defaultCodeAntibiogram);
        comp.setOrganizer((POCDMT000040Organizer)this.laboratoryBattery.getLaboratoryBatteryOrganizer());
        antibiogram.setHl7Component(comp);
        return antibiogram;
    }
}

