/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.ps;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.base.Brieftext;
import org.projecthusky.cda.elga.generated.artdecor.ps.AbschliessendeBemerkung;
import org.projecthusky.cda.elga.generated.artdecor.ps.AllergienUnvertraeglichkeiten;
import org.projecthusky.cda.elga.generated.artdecor.ps.ElgapatientConsultationSummary;
import org.projecthusky.cda.elga.generated.artdecor.ps.EmpfohleneMedikationFull;
import org.projecthusky.cda.elga.generated.artdecor.ps.KonsultationsUeberweisunggrund;
import org.projecthusky.cda.elga.generated.artdecor.ps.MedikationVerordnungEntryNoDrugTherapy;
import org.projecthusky.cda.elga.generated.artdecor.ps.WeitereInformation;
import org.projecthusky.cda.elga.generated.artdecor.ps.WichtigeHinweise;
import org.projecthusky.cda.elga.models.AdditionalInformation;
import org.projecthusky.cda.elga.models.Allergy;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.BaseDocument;
import org.projecthusky.cda.elga.models.Disease;
import org.projecthusky.cda.elga.models.PatientCdaAt;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.PrescriptionEntry;
import org.projecthusky.cda.elga.narrative.KonsUeberwGrundNarrativeTextGenerator;
import org.projecthusky.cda.elga.narrative.MedBaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component3;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.POCDMT000040StructuredBody;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class PatientConsultationSummary
extends BaseDocument {
    private PatientCdaAt patient;
    private PractitionerCdaAt author;
    private ZonedDateTime authorTime;
    private Organization custodian;
    private PractitionerCdaAt legalAuthenticator;
    private ZonedDateTime legalAuthenticatorTime;
    private String docId;
    private String setId;
    private int version;
    private String title;
    private List<Disease> diseases;
    private String lettertext;
    private String importantNotes;
    private String furtherInformation;
    private String finalRemarks;
    private List<Appendix> appendices;
    private List<PrescriptionEntry> prescriptions;
    private List<Allergy> allergies;

    public List<PrescriptionEntry> getPrescriptions() {
        return this.prescriptions;
    }

    public void setPrescriptions(List<PrescriptionEntry> prescriptions) {
        this.prescriptions = prescriptions;
    }

    public List<Allergy> getAllergies() {
        return this.allergies;
    }

    public void setAllergies(List<Allergy> allergies) {
        this.allergies = allergies;
    }

    public PatientCdaAt getPatient() {
        return this.patient;
    }

    public void setPatient(PatientCdaAt patient) {
        this.patient = patient;
    }

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public Organization getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Organization organization) {
        this.custodian = organization;
    }

    public PractitionerCdaAt getLegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public void setLegalAuthenticator(PractitionerCdaAt legalAuthenticator) {
        this.legalAuthenticator = legalAuthenticator;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String setId) {
        this.setId = setId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Disease> getDiseases() {
        return this.diseases;
    }

    public void setDiseases(List<Disease> diseases) {
        this.diseases = diseases;
    }

    public String getLettertext() {
        return this.lettertext;
    }

    public void setLettertext(String lettertext) {
        this.lettertext = lettertext;
    }

    public String getImportantNotes() {
        return this.importantNotes;
    }

    public void setImportantNotes(String importantNotes) {
        this.importantNotes = importantNotes;
    }

    public String getFurtherInformation() {
        return this.furtherInformation;
    }

    public void setFurtherInformation(String furtherInformation) {
        this.furtherInformation = furtherInformation;
    }

    public String getFinalRemarks() {
        return this.finalRemarks;
    }

    public void setFinalRemarks(String finalRemarks) {
        this.finalRemarks = finalRemarks;
    }

    public List<Appendix> getAppendices() {
        return this.appendices;
    }

    public void setAppendices(List<Appendix> appendices) {
        this.appendices = appendices;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public ZonedDateTime getLegalAuthenticatorTime() {
        return this.legalAuthenticatorTime;
    }

    public void setLegalAuthenticatorTime(ZonedDateTime legalAuthenticatorTime) {
        this.legalAuthenticatorTime = legalAuthenticatorTime;
    }

    private KonsultationsUeberweisunggrund getConsultationCauseSection() {
        if (this.diseases == null) {
            return null;
        }
        KonsultationsUeberweisunggrund cause = new KonsultationsUeberweisunggrund();
        int index = 0;
        for (Disease problem : this.diseases) {
            if (problem == null) continue;
            cause.setHl7Entry(problem.getGesundheitsProblemEntry(index++));
        }
        StrucDocText textKonsUeberwGrund = new StrucDocText();
        KonsUeberwGrundNarrativeTextGenerator textbuilder = new KonsUeberwGrundNarrativeTextGenerator(cause.getEntry());
        textKonsUeberwGrund.getContent().add(textbuilder.toString());
        cause.setText(textKonsUeberwGrund);
        ST stTitle = new ST();
        stTitle.setXmlMixed("Konsultations- oder \u00dcberweisungsgrund");
        cause.setTitle(stTitle);
        return cause;
    }

    private POCDMT000040Section getAllergyIntoleranceSection() {
        if (this.allergies == null) {
            return null;
        }
        AllergienUnvertraeglichkeiten allergySection = new AllergienUnvertraeglichkeiten();
        ST stTitle = new ST();
        stTitle.setXmlMixed("Allergien und Intoleranzen");
        allergySection.setTitle(stTitle);
        if (this.allergies.stream().allMatch(allergy -> allergy.getAbsentAllergy() != null || allergy.getKindOfAllergy() != null)) {
            int index = 0;
            for (Allergy allergy2 : this.allergies) {
                if (allergy2 == null) continue;
                allergySection.addHl7Entry(allergy2.getHl7CdaR2AllergyEntry(index++));
            }
        } else {
            StrucDocText structext = new StrucDocText();
            structext.setMediaType("text/plain");
            for (Allergy allergy3 : this.allergies) {
                structext.getContent().add(allergy3.getText());
            }
            allergySection.setText(structext);
            allergySection.getEntry().clear();
        }
        return allergySection;
    }

    protected POCDMT000040Section getRecommendedMedicationSection() {
        EmpfohleneMedikationFull recommendedMedSection = new EmpfohleneMedikationFull();
        ST stTitle = new ST();
        stTitle.setXmlMixed("Empfohlene Medikation");
        recommendedMedSection.setTitle(stTitle);
        if (this.prescriptions != null && !this.prescriptions.isEmpty()) {
            for (PrescriptionEntry prescription : this.prescriptions) {
                recommendedMedSection.setHl7Entry(prescription.getMedikationVerordnungEntryemed());
            }
        } else {
            recommendedMedSection.setHl7Entry(this.getMedikationVerordnungEntryNoDrugTherapy());
        }
        LinkedList<List<AdditionalInformation>> patientInstructions = new LinkedList<List<AdditionalInformation>>();
        LinkedList<List<AdditionalInformation>> pharmacistInstructions = new LinkedList<List<AdditionalInformation>>();
        for (PrescriptionEntry entry : this.prescriptions) {
            if (entry == null) continue;
            patientInstructions.add(entry.getAddInfoPat());
            pharmacistInstructions.add(entry.getAddInfoPharm());
        }
        StrucDocText text = new StrucDocText();
        MedBaseTextGenerator textbuilder = new MedBaseTextGenerator(patientInstructions, pharmacistInstructions);
        text.getContent().addAll(textbuilder.getTablesFromCda(recommendedMedSection.getEntry()));
        recommendedMedSection.setText(text);
        return recommendedMedSection;
    }

    protected POCDMT000040Entry getMedikationVerordnungEntryNoDrugTherapy() {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        MedikationVerordnungEntryNoDrugTherapy noDrugTherapy = new MedikationVerordnungEntryNoDrugTherapy();
        noDrugTherapy.setText(new ED(null, new TEL("#nomed1")));
        entry.setSubstanceAdministration((POCDMT000040SubstanceAdministration)noDrugTherapy);
        return entry;
    }

    protected POCDMT000040StructuredBody getHl7CdaR2Pocdmt000040StructuredBody() {
        POCDMT000040Component3 comp3;
        POCDMT000040StructuredBody structuredBody = new POCDMT000040StructuredBody();
        structuredBody.getClassCode().add("DOCBODY");
        structuredBody.getMoodCode().add("EVN");
        if (this.lettertext != null && !this.lettertext.isEmpty()) {
            structuredBody.getComponent().add(this.createComp3FreeText(new Brieftext(), this.lettertext, "Brieftext"));
        }
        if (this.diseases != null && !this.diseases.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getConsultationCauseSection());
            structuredBody.getComponent().add(comp3);
        }
        if (this.allergies != null && !this.allergies.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection(this.getAllergyIntoleranceSection());
            structuredBody.getComponent().add(comp3);
        }
        if (this.prescriptions != null && !this.prescriptions.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection(this.getRecommendedMedicationSection());
            structuredBody.getComponent().add(comp3);
        }
        if (this.importantNotes != null && !this.importantNotes.isEmpty()) {
            structuredBody.getComponent().add(this.createComp3FreeText(new WichtigeHinweise(), this.importantNotes, "Wichtige Hinweise"));
        }
        if (this.furtherInformation != null && !this.furtherInformation.isEmpty()) {
            structuredBody.getComponent().add(this.createComp3FreeText(new WeitereInformation(), this.furtherInformation, "Weitere Informationen"));
        }
        if (this.finalRemarks != null && !this.finalRemarks.isEmpty()) {
            structuredBody.getComponent().add(this.createComp3FreeText(new AbschliessendeBemerkung(), this.finalRemarks, "Abschlie\u00dfende Bemerkungen"));
        }
        if (this.appendices != null && !this.appendices.isEmpty()) {
            comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getAppendixSection(this.appendices, "consultation"));
            structuredBody.getComponent().add(comp3);
        }
        return structuredBody;
    }

    private void getHeader(ElgapatientConsultationSummary cda) {
        ST stTitle = new ST();
        stTitle.setXmlMixed(this.title);
        cda.setTitle(stTitle);
        cda.setEffectiveTime(DateTimes.toDatetimeTs((TemporalAccessor)ZonedDateTime.now()));
        if (this.patient != null) {
            cda.setHl7RecordTarget(this.patient.getHeaderRecordTargetBase());
        }
        if (this.author != null) {
            String gdaIndex = this.author.getGdaIndex();
            cda.setHl7Id(new Identificator(gdaIndex, this.docId).getHl7CdaR2Ii());
            cda.setVersion(new Identificator(gdaIndex, this.setId), 1);
            cda.setHl7Author(this.author.getAtcdabbrHeaderAuthor(this.authorTime));
        }
        cda.setHl7Custodian(this.custodian.getHl7CdaR2Pocdmt000040Custodian());
        if (this.legalAuthenticator != null) {
            cda.setHl7LegalAuthenticator(this.legalAuthenticator.getHeaderLegalAuthenticator(this.legalAuthenticatorTime));
        }
    }

    private void setHeader(ElgapatientConsultationSummary cda) {
        if (cda.getTitle() != null && cda.getTitle().getReference() != null) {
            this.title = cda.getTitle().getReference().getMergedXmlMixed();
        }
        if (cda.getEffectiveTime() != null && cda.getEffectiveTime().getValue() != null) {
            Hl7Dtm hl7dtm = Hl7Dtm.fromHl7((String)cda.getEffectiveTime().getValue());
            this.authorTime = hl7dtm.getDateTime().toZonedDateTime();
        }
        if (cda.getRecordTarget() != null) {
            for (POCDMT000040RecordTarget target : cda.getRecordTarget()) {
                this.patient = new PatientCdaAt(target);
            }
        }
        if (cda.getAuthor() != null) {
            for (POCDMT000040Author authorHl7cdar2 : cda.getAuthor()) {
                this.author = new PractitionerCdaAt(authorHl7cdar2);
            }
        }
        if (cda.getCustodian() != null && cda.getCustodian().getAssignedCustodian() != null && cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() != null) {
            this.custodian = new Organization(cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization());
        }
        if (cda.getLegalAuthenticator() != null && cda.getCustodian().getAssignedCustodian() != null && cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() != null) {
            this.legalAuthenticator = new PractitionerCdaAt(cda.getLegalAuthenticator());
        }
    }

    private void setStructuredBody(ElgapatientConsultationSummary cda) {
        if (cda.getComponent() != null && cda.getComponent().getStructuredBody() != null) {
            this.extractContent(cda);
            this.extractPatient(cda);
            this.extractAuthor(cda);
            this.extractLegalAuthenticator(cda);
            this.extractCustodian(cda);
        }
    }

    private void extractContent(POCDMT000040ClinicalDocument cda) {
        for (POCDMT000040Component3 component3 : cda.getComponent().getStructuredBody().getComponent()) {
            if (component3 == null || component3.getSection() == null || component3.getSection().getCode() == null) continue;
            Code sectionCode = new Code(component3.getSection().getCode());
            this.extractText(sectionCode, component3);
            if (sectionCode.getCode().equalsIgnoreCase("BEIL")) {
                this.extractAppendices(component3);
                continue;
            }
            if (sectionCode.getCode().equalsIgnoreCase("75311-1")) {
                this.extractPrescriptions(component3);
                continue;
            }
            if (sectionCode.getCode().equalsIgnoreCase("48765-2")) {
                this.extractAllergies(component3);
                continue;
            }
            if (!sectionCode.getCode().equalsIgnoreCase("46239-0")) continue;
            this.extractDiseases(component3);
        }
    }

    private void extractText(Code sectionCode, POCDMT000040Component3 component3) {
        if (component3.getSection() != null && component3.getSection().getText() != null) {
            if (sectionCode.getCode().equalsIgnoreCase("BRIEFT")) {
                this.lettertext = component3.getSection().getText().getMergedXmlMixed();
            } else if (sectionCode.getCode().equalsIgnoreCase("74018-3")) {
                this.importantNotes = component3.getSection().getText().getMergedXmlMixed();
            } else if (sectionCode.getCode().equalsIgnoreCase("55752-0")) {
                this.furtherInformation = component3.getSection().getText().getMergedXmlMixed();
            } else if (sectionCode.getCode().equalsIgnoreCase("ABBEM")) {
                this.finalRemarks = component3.getSection().getText().getMergedXmlMixed();
            }
        }
    }

    private void extractAppendices(POCDMT000040Component3 component3) {
        this.appendices = new ArrayList<Appendix>();
        for (POCDMT000040Entry entry : component3.getSection().getEntry()) {
            this.appendices.add(new Appendix(entry));
        }
    }

    private void extractPrescriptions(POCDMT000040Component3 component3) {
        this.prescriptions = new ArrayList<PrescriptionEntry>();
        for (POCDMT000040Entry entry : component3.getSection().getEntry()) {
            this.prescriptions.add(new PrescriptionEntry(entry));
        }
    }

    private void extractDiseases(POCDMT000040Component3 component3) {
        this.diseases = new ArrayList<Disease>();
        for (POCDMT000040Entry entry : component3.getSection().getEntry()) {
            this.diseases.add(new Disease(entry));
        }
    }

    private void extractAllergies(POCDMT000040Component3 component3) {
        this.allergies = new ArrayList<Allergy>();
        if (!component3.getSection().getEntry().isEmpty()) {
            for (POCDMT000040Entry entry : component3.getSection().getEntry()) {
                this.allergies.add(new Allergy(entry));
            }
        } else {
            this.allergies.add(new Allergy(component3.getSection().getText().getMergedXmlMixed()));
        }
    }

    private void extractCustodian(POCDMT000040ClinicalDocument cda) {
        if (cda.getCustodian() != null && cda.getCustodian().getAssignedCustodian() != null && cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() != null) {
            this.custodian = new Organization(cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization());
        }
    }

    private void extractLegalAuthenticator(POCDMT000040ClinicalDocument cda) {
        if (cda.getLegalAuthenticator() != null && cda.getCustodian().getAssignedCustodian() != null && cda.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() != null) {
            this.legalAuthenticator = new PractitionerCdaAt(cda.getLegalAuthenticator());
        }
    }

    private void extractAuthor(POCDMT000040ClinicalDocument cda) {
        for (POCDMT000040Author authorHl7cdar2 : cda.getAuthor()) {
            this.author = new PractitionerCdaAt(authorHl7cdar2);
        }
    }

    private void extractPatient(POCDMT000040ClinicalDocument cda) {
        for (POCDMT000040RecordTarget target : cda.getRecordTarget()) {
            this.patient = new PatientCdaAt(target);
        }
    }

    public ElgapatientConsultationSummary getElgapatientConsultationSummaryCdaDocument() {
        ElgapatientConsultationSummary cda = new ElgapatientConsultationSummary();
        this.getHeader(cda);
        POCDMT000040Component2 comp2 = new POCDMT000040Component2();
        comp2.setStructuredBody(this.getHl7CdaR2Pocdmt000040StructuredBody());
        cda.setHl7Component(comp2);
        return cda;
    }

    public void setElgapatientConsultationSummaryCdaDocument(ElgapatientConsultationSummary cda) {
        this.setHeader(cda);
        this.setStructuredBody(cda);
    }
}

