/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.models.ems.Arztmeldung;
import org.projecthusky.cda.elga.models.ems.CaseIdentification;
import org.projecthusky.cda.elga.models.ems.ClinicalManifestation;
import org.projecthusky.cda.elga.models.ems.ClinicalManifestationItem;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.model.Code;

public class ArztmeldungNarrativeTextGenerator
extends BaseTextGenerator {
    private Arztmeldung document;

    public ArztmeldungNarrativeTextGenerator(Arztmeldung document) {
        this.document = document;
    }

    protected StrucDocTr getRow(String title, String text, String contentId) {
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getCellTd(title, null));
        tr.getThOrTd().add(this.getCellTd(text, contentId));
        return tr;
    }

    private StrucDocTable getBody(CaseIdentification entry, ClinicalManifestation clinicalManifestation, ZonedDateTime hospitalization) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (entry.getDiagnosisDate() != null) {
            body.getTr().add(this.getRow("Diagnosedatum", DateTimeFormatter.ofPattern("dd.MM.yyyy").format(entry.getDiagnosisDate()), "epims-diag-date"));
        }
        body.getTr().add(this.getRow("Diagnose", entry.getDisease().getDisplayName(), "epims-diag"));
        body.getTr().add(this.getRow("Diagnosesicherheit", entry.getDiagnosisConfidence().getDisplayName(), "epims-diag-conf"));
        if (entry.getFieldValues() != null && !entry.getFieldValues().isEmpty()) {
            int index = 1;
            for (Map.Entry<Code, Code> mapEntry : entry.getFieldValues().entrySet()) {
                if (mapEntry == null || mapEntry.getKey() == null || mapEntry.getValue() == null) continue;
                body.getTr().add(this.getRow(mapEntry.getKey().getDisplayName(), mapEntry.getValue().getDisplayName(), String.format("epims-parameter-%d", index++)));
            }
        }
        this.addClinicalManifestationRow(clinicalManifestation, body);
        if (hospitalization != null) {
            body.getTr().add(this.getRow("Hospitalisierung", DateTimeFormatter.ofPattern("dd.MM.yyyy").format(hospitalization), "epims-hospitalization"));
        }
        table.getTbody().add(body);
        return table;
    }

    private void addClinicalManifestationRow(ClinicalManifestation clinicalManifestation, StrucDocTbody body) {
        if (clinicalManifestation != null && clinicalManifestation.getClinicalManifestationItems() != null && !clinicalManifestation.getClinicalManifestationItems().isEmpty()) {
            int index = 1;
            for (ClinicalManifestationItem item : clinicalManifestation.getClinicalManifestationItems()) {
                if (item == null || item.getCode() == null) continue;
                body.getTr().add(this.getRow(String.format("Klinische Manifestation %d", index), item.getCode().getDisplayName(), String.format("epims-entry-problem-%d", index++)));
            }
        }
    }

    private StrucDocTd getCellTd(String text, String id) {
        if (text == null) {
            text = "";
        }
        StrucDocTd td = new StrucDocTd();
        if (id != null && !id.isEmpty()) {
            td.setID(id);
        }
        td.getContent().add(text);
        return td;
    }

    public JAXBElement<StrucDocTable> getTable() {
        return new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(this.document.getCaseIdentification(), this.document.getClinicalManifestation(), this.document.getHospitalisation()));
    }
}

