/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Precondition;
import org.projecthusky.common.hl7cdar2.StrucDocContent;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;

public class ImmunizationBaseTextGenerator
extends BaseTextGenerator {
    protected StrucDocTr getRowScheme(POCDMT000040Precondition precondition, int index) {
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getCellTd("Impfschema:"));
        if (precondition != null && precondition.getCriterion() != null) {
            String contentId = String.format("criterion-%d", index);
            if (precondition.getCriterion().getText() != null && precondition.getCriterion().getText().getReference() != null && precondition.getCriterion().getText().getReference().getValue() != null) {
                contentId = precondition.getCriterion().getText().getReference().getValue().replace("#", "");
            }
            if (precondition.getCriterion().getCode() != null) {
                tr.getThOrTd().add(this.getCellTdWithContent(precondition.getCriterion().getCode().getDisplayName(), contentId));
            }
        }
        return tr;
    }

    protected List<StrucDocTr> getRowTargetDiseases(List<POCDMT000040EntryRelationship> entryRelationships) {
        LinkedList<StrucDocTr> list = new LinkedList<StrucDocTr>();
        for (POCDMT000040EntryRelationship entryRel : entryRelationships) {
            if (entryRel == null || entryRel.getObservation() == null || !entryRel.getTypeCode().equals((Object)XActRelationshipEntryRelationship.RSON) || entryRel.getObservation().getCode() == null) continue;
            StrucDocTr tr = new StrucDocTr();
            StrucDocTd td = new StrucDocTd();
            td.getStyleCode().add("xELGA_colw:20");
            td.getContent().add("Impfung gegen:");
            tr.getThOrTd().add(td);
            String contentId = "";
            if (entryRel.getObservation().getText() != null && entryRel.getObservation().getText().getReference() != null && entryRel.getObservation().getText().getReference().getValue() != null) {
                contentId = entryRel.getObservation().getText().getReference().getValue().replace("#", "");
            }
            tr.getThOrTd().add(this.getCellTdWithContent(entryRel.getObservation().getCode().getDisplayName(), contentId));
            list.add(tr);
        }
        return list;
    }

    protected StrucDocTr getRowDose(POCDMT000040Precondition precondition) {
        ANY aNY;
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getCellTd("Dosis:"));
        if (precondition != null && precondition.getCriterion() != null && (aNY = precondition.getCriterion().getValue()) instanceof CD) {
            CD code = (CD)aNY;
            tr.getThOrTd().add(this.getCellTd(code.getDisplayName()));
        }
        return tr;
    }

    protected void addCommentContent(StrucDocText text, POCDMT000040Entry entry, Map<String, String> comments) {
        for (POCDMT000040EntryRelationship entryRel : entry.getSubstanceAdministration().getEntryRelationship()) {
            if (entryRel == null || entryRel.getAct() == null) continue;
            String commentReference = "";
            if (entryRel.getAct().getText() == null || entryRel.getAct().getText().getReference() == null || entryRel.getAct().getText().getReference().getValue() == null) continue;
            commentReference = entryRel.getAct().getText().getReference().getValue().replace("#", "");
            StrucDocContent content = new StrucDocContent();
            String commentToAdd = "";
            if (comments.containsKey(commentReference)) {
                commentToAdd = comments.get(commentReference);
            }
            content.getContent().add(commentToAdd);
            content.setID(commentReference);
            text.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "content"), StrucDocContent.class, (Object)content));
        }
    }

    private StrucDocContent getCommentContent(Map<String, String> comments, String commentReference) {
        StrucDocContent content = new StrucDocContent();
        String commentToAdd = "";
        if (comments.containsKey(commentReference)) {
            commentToAdd = comments.get(commentReference);
        }
        content.getContent().add(commentToAdd);
        content.setID(commentReference.replace("#", ""));
        return content;
    }
}

