/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CV;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVXBINT;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.POCDMT000040ReferenceRange;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.QTY;
import org.projecthusky.common.hl7cdar2.RTO;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocParagraph;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.hl7cdar2.TS;

public class ImmunizationLabResultNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public ImmunizationLabResultNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTbody getBody(List<POCDMT000040Component4> components) {
        StrucDocTbody body = new StrucDocTbody();
        for (POCDMT000040Component4 component : components) {
            if (component == null || component.getObservation() == null) continue;
            StrucDocTr tr = new StrucDocTr();
            if (component.getObservation().getText() != null && component.getObservation().getText().getReference() != null && component.getObservation().getText().getReference().getValue() != null) {
                tr.setID(component.getObservation().getText().getReference().getValue().replace("#", ""));
            }
            tr.getThOrTd().add(this.getCellTdCode(component.getObservation().getCode()));
            tr.getThOrTd().add(this.getCellTdAny((ANY)component.getObservation().getValue().get(0)));
            tr.getThOrTd().add(this.getCellTdAnyUnit((ANY)component.getObservation().getValue().get(0)));
            tr.getThOrTd().add(this.getCellTdReferenceRange(component.getObservation().getReferenceRange()));
            tr.getThOrTd().add(this.getCellTdCodes(component.getObservation().getInterpretationCode()));
            body.getTr().add(tr);
        }
        return body;
    }

    protected StrucDocTd getCellTdReferenceRange(List<POCDMT000040ReferenceRange> referenceRange) {
        StrucDocTd td = new StrucDocTd();
        for (POCDMT000040ReferenceRange range : referenceRange) {
            ANY aNY;
            if (range == null || range.getObservationRange() == null) continue;
            if (range.getObservationRange().getText() != null && range.getObservationRange().getText().getReference() != null && range.getObservationRange().getText().getReference().getValue() != null) {
                td.setID(range.getObservationRange().getText().getReference().getValue().replace("#", ""));
            }
            if ((aNY = range.getObservationRange().getValue()) instanceof IVLPQ) {
                IVLPQ ivlpq = (IVLPQ)aNY;
                td.getContent().add(this.getPqString(ivlpq));
                continue;
            }
            aNY = range.getObservationRange().getValue();
            if (!(aNY instanceof RTO)) continue;
            RTO rto = (RTO)aNY;
            td.getContent().add(this.getRatio(rto));
        }
        return td;
    }

    private String getRatio(RTO rto) {
        StringBuilder sb = new StringBuilder();
        String textNumerator = "";
        QTY qTY = rto.getNumerator();
        if (qTY instanceof INT) {
            INT numerator = (INT)qTY;
            textNumerator = numerator.getValue().toString();
        }
        if ((qTY = rto.getDenominator()) instanceof IVLINT) {
            IVLINT denominator = (IVLINT)qTY;
            sb.append(this.getDenominator(denominator, textNumerator));
        }
        return sb.toString();
    }

    private String getDenominator(IVLINT denominator, String textNumerator) {
        StringBuilder sb = new StringBuilder();
        Map<String, IVXBINT> ivxbint = this.getIvxbIntElement(denominator);
        IVXBINT lowElement = ivxbint.get("low");
        if (lowElement != null && lowElement.getValue() != null) {
            sb.append(textNumerator);
            sb.append(":");
            if (lowElement.isInclusive()) {
                sb.append("\u2265");
            } else {
                sb.append(">");
            }
            sb.append(lowElement.getValue());
        }
        IVXBINT highElement = ivxbint.get("high");
        if (lowElement != null && highElement != null) {
            sb.append(" - ");
        }
        if (highElement != null && highElement.getValue() != null) {
            sb.append(textNumerator);
            sb.append(":");
            if (highElement.isInclusive()) {
                sb.append("\u2264");
            } else {
                sb.append("<");
            }
            sb.append(highElement.getValue());
        }
        return sb.toString();
    }

    private String getPqString(IVLPQ ivlpq) {
        PQ highElement;
        StringBuilder sb = new StringBuilder();
        Map<String, PQ> pq = this.getPqElement(ivlpq);
        PQ lowElement = pq.get("low");
        if (lowElement != null && lowElement.getValue() != null) {
            sb.append(lowElement.getValue());
            if (!lowElement.getUnit().isEmpty()) {
                sb.append(" ");
                sb.append(lowElement.getUnit());
            }
            sb.append(" - ");
        }
        if ((highElement = pq.get("high")) != null && highElement.getValue() != null) {
            sb.append(highElement.getValue());
            if (!highElement.getUnit().isEmpty()) {
                sb.append(" ");
                sb.append(highElement.getUnit());
            }
        }
        return sb.toString();
    }

    protected Map<String, PQ> getPqElement(IVLPQ range) {
        HashMap<String, PQ> pqElements = new HashMap<String, PQ>();
        if (range != null) {
            for (JAXBElement pq : range.getRest()) {
                PQ value = new PQ();
                String elementName = "";
                if (pq != null && PQ.class.equals((Object)pq.getDeclaredType()) && pq.getValue() != null) {
                    value = (PQ)pq.getValue();
                }
                if (pq != null && pq.getName() != null) {
                    elementName = pq.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                pqElements.put(elementName, value);
            }
        }
        return pqElements;
    }

    protected Map<String, IVXBINT> getIvxbIntElement(IVLINT qty) {
        HashMap<String, IVXBINT> ivxbintElements = new HashMap<String, IVXBINT>();
        if (qty != null) {
            for (JAXBElement ivxbint : qty.getRest()) {
                IVXBINT value = new IVXBINT();
                String elementName = "";
                if (ivxbint != null && IVXBINT.class.equals((Object)ivxbint.getDeclaredType()) && ivxbint.getValue() != null) {
                    value = (IVXBINT)ivxbint.getValue();
                }
                if (ivxbint != null && ivxbint.getName() != null) {
                    elementName = ivxbint.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                ivxbintElements.put(elementName, value);
            }
        }
        return ivxbintElements;
    }

    protected StrucDocTd getCellTdAny(ANY resultTest) {
        String text = "";
        if (resultTest instanceof PQ) {
            PQ pq = (PQ)resultTest;
            return this.getCellTd(pq.getValue());
        }
        if (resultTest instanceof BL) {
            BL bl = (BL)resultTest;
            return this.getCellTd(bl.isValue().toString());
        }
        if (resultTest instanceof INT) {
            INT intVal = (INT)resultTest;
            return this.getCellTd(intVal.getValue().toString());
        }
        if (resultTest instanceof ST) {
            ST stVal = (ST)resultTest;
            return this.getCellTd(stVal.getMergedXmlMixed());
        }
        if (resultTest instanceof CD) {
            CD cdVal = (CD)resultTest;
            return this.getCellTd(cdVal.getDisplayName());
        }
        if (resultTest instanceof CV) {
            CV cvVal = (CV)resultTest;
            return this.getCellTd(cvVal.getDisplayName());
        }
        if (resultTest instanceof TS) {
            TS tsVal = (TS)resultTest;
            return this.getCellTd(tsVal.getValue());
        }
        return this.getCellTd(text);
    }

    protected StrucDocTd getCellTdAnyUnit(ANY resultTest) {
        String text = "";
        if (resultTest instanceof PQ) {
            PQ pq = (PQ)resultTest;
            return this.getCellTd(pq.getUnit());
        }
        return this.getCellTd(text);
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Analyse", "xELGA_colw:40"));
        tr.getThOrTd().add(this.getTableHeaderCell("Ergebnis", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Einheit", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Referenzbereiche", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Interpretation", "xELGA_colw:10"));
        thead.getTr().add(tr);
        return thead;
    }

    public StrucDocTable getTable(List<POCDMT000040Component4> components) {
        StrucDocTable table = new StrucDocTable();
        table.setThead(this.getTableHeader());
        table.getTbody().add(this.getBody(components));
        return table;
    }

    public StrucDocParagraph getParagraph(POCDMT000040Organizer organizer) {
        StrucDocParagraph paragraph = new StrucDocParagraph();
        paragraph.getStyleCode().add("xELGA_h3");
        if (organizer != null && organizer.getCode() != null) {
            paragraph.getContent().add(organizer.getCode().getDisplayName());
        }
        return paragraph;
    }

    public StrucDocText getText() {
        StrucDocText text = new StrucDocText();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null || entry.getAct().getEntryRelationship() == null || entry.getAct().getEntryRelationship().isEmpty()) continue;
            for (POCDMT000040EntryRelationship entryRel : entry.getAct().getEntryRelationship()) {
                if (entryRel == null || entryRel.getOrganizer() == null) continue;
                text.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "paragraph"), StrucDocParagraph.class, (Object)this.getParagraph(entryRel.getOrganizer())));
                text.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getTable(entryRel.getOrganizer().getComponent())));
            }
        }
        return text;
    }
}

