/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.StrucDocContent;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.model.Code;

public class ImmunizationRelevantDiseasesNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public ImmunizationRelevantDiseasesNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTable getBody(POCDMT000040Act act, Map<String, String> comments) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (act != null) {
            for (POCDMT000040EntryRelationship entryRel : act.getEntryRelationship()) {
                if (entryRel == null || entryRel.getObservation() == null) continue;
                StrucDocTd td = new StrucDocTd();
                Code diseaseCode = this.extractDiseaseCode(entryRel.getObservation());
                td.getContent().add(diseaseCode.getDisplayName());
                td.setID(diseaseCode.getOriginalText());
                StrucDocTr tr = new StrucDocTr();
                if (entryRel.getObservation().getText() != null && entryRel.getObservation().getText().getReference() != null && entryRel.getObservation().getText().getReference().getValue() != null) {
                    tr.setID(entryRel.getObservation().getText().getReference().getValue().replace("#", ""));
                }
                tr.getThOrTd().add(this.getCellTdTime(entryRel.getObservation().getEffectiveTime()));
                tr.getThOrTd().add(td);
                tr.getThOrTd().add(this.getCellTdComment(comments, diseaseCode.getCode(), entryRel.getObservation().getEntryRelationship()));
                body.getTr().add(tr);
            }
        }
        table.getTbody().add(body);
        return table;
    }

    private Code extractDiseaseCode(POCDMT000040Observation obs) {
        Code code = new Code();
        if (!obs.getValue().isEmpty()) {
            for (ANY value : obs.getValue()) {
                if (!(value instanceof CD)) continue;
                CD cd = (CD)value;
                code.setDisplayName(cd.getDisplayName());
                code.setCode(cd.getCode());
                if (cd.getOriginalText() == null || cd.getOriginalText().getReference() == null || cd.getOriginalText().getReference().getValue() == null) continue;
                code.setOriginalText(cd.getOriginalText().getReference().getValue().replace("#", ""));
            }
        }
        return code;
    }

    private StrucDocTd getCellTdComment(Map<String, String> comments, String diseaseCode, List<POCDMT000040EntryRelationship> entryRel) {
        StrucDocTd tdComment = new StrucDocTd();
        StrucDocContent content = new StrucDocContent();
        String commentToAdd = "";
        if (comments.containsKey(diseaseCode)) {
            commentToAdd = comments.get(diseaseCode);
        }
        if (entryRel != null && !entryRel.isEmpty()) {
            for (POCDMT000040EntryRelationship entryRelComment : entryRel) {
                content.getContent().add(commentToAdd);
                if (entryRelComment == null || entryRelComment.getAct() == null || entryRelComment.getAct().getText() == null || entryRelComment.getAct().getText().getReference() == null || entryRelComment.getAct().getText().getReference().getValue() == null) continue;
                content.setID(entryRelComment.getAct().getText().getReference().getValue().replace("#", ""));
                tdComment.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "content"), StrucDocContent.class, (Object)content));
            }
        }
        return tdComment;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda(Map<String, String> comments) {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(entry.getAct(), comments)));
        }
        return tables;
    }
}

