/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.models.AdditionalInformation;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.COCTMT230100UVIngredient;
import org.projecthusky.common.hl7cdar2.COCTMT230100UVSubstance;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.hl7cdar2.TN;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class MedBaseTextGenerator
extends BaseTextGenerator {
    protected List<List<AdditionalInformation>> patientInstructions;
    protected List<List<AdditionalInformation>> pharmInstructions;

    public MedBaseTextGenerator(List<List<AdditionalInformation>> patientInstructions, List<List<AdditionalInformation>> pharmInstructions) {
        this.patientInstructions = patientInstructions;
        this.pharmInstructions = pharmInstructions;
    }

    protected void addAdditionalInformationRows(POCDMT000040Act act, StrucDocTbody body, int index) {
        List<Object> additionalInformations = new LinkedList();
        if ("PINSTRUCT".equalsIgnoreCase(act.getCode().getCode())) {
            additionalInformations = this.patientInstructions.get(index);
        } else if ("FINSTRUCT".equalsIgnoreCase(act.getCode().getCode())) {
            additionalInformations = this.pharmInstructions.get(index);
        }
        StringBuilder infos = new StringBuilder();
        int indexLastInfo = additionalInformations.size();
        int indexInfo = 0;
        for (AdditionalInformation additionalInformation : additionalInformations) {
            if (additionalInformation == null) continue;
            infos.append(additionalInformation.getInformation());
            if (indexInfo == indexLastInfo) continue;
            infos.append(",");
        }
        body.getTr().add(this.getRow("Zusatzinformationen f\u00fcr den Patienten und alternative Einnahme", infos.toString()));
    }

    protected void addTimeRows(List<SXCMTS> time, StrucDocTbody body) {
        if (time != null) {
            Map<String, String> timeMap = this.getTsElement((IVLTS)time.get(0));
            String startDateDisease = timeMap.get("low");
            String endDateDisease = timeMap.get("high");
            String duration = timeMap.get("width");
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            if (startDateDisease != null) {
                body.getTr().add(this.getRow("Einnahmestart", sdf.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)startDateDisease)))));
            }
            if (endDateDisease != null) {
                body.getTr().add(this.getRow("Einnahmeende", sdf.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)endDateDisease)))));
            }
            if (duration != null) {
                body.getTr().add(this.getRow("Einnahmedauer", duration));
            }
        }
    }

    protected StrucDocTr getRow(String title, String text) {
        StrucDocTr tr = new StrucDocTr();
        StrucDocTd titleTd = new StrucDocTd();
        titleTd.getContent().add(title);
        tr.getThOrTd().add(titleTd);
        StrucDocTd textTd = new StrucDocTd();
        textTd.getContent().add(text);
        tr.getThOrTd().add(textTd);
        return tr;
    }

    protected void addInformationOfEntryRelRows(List<POCDMT000040EntryRelationship> entryRels, StrucDocTbody body, int index) {
        if (entryRels != null) {
            for (POCDMT000040EntryRelationship entryRel : entryRels) {
                if (entryRel == null) continue;
                if (entryRel.getTypeCode().equals((Object)XActRelationshipEntryRelationship.COMP)) {
                    if (entryRel.getAct() != null && entryRel.getAct().getCode() != null) {
                        body.getTr().add(this.getRow("Therapieart", entryRel.getAct().getCode().getDisplayName()));
                        continue;
                    }
                    if (entryRel.getSupply() == null || entryRel.getSupply().getQuantity() == null) continue;
                    body.getTr().add(this.getRow("Anzahl der Packungen", entryRel.getSupply().getQuantity().getValue()));
                    continue;
                }
                if (!entryRel.getTypeCode().equals((Object)XActRelationshipEntryRelationship.SUBJ) || entryRel.getAct() == null) continue;
                this.addAdditionalInformationRows(entryRel.getAct(), body, index);
            }
        }
    }

    protected void addConsumableInformationRows(POCDMT000040Consumable consumable, StrucDocTbody body) {
        if (consumable != null && consumable.getManufacturedProduct() != null && consumable.getManufacturedProduct().getManufacturedMaterial() != null) {
            body.getTr().add(this.getRow("Arznei: Handelsname", consumable.getManufacturedProduct().getManufacturedMaterial().getName().getMergedXmlMixed()));
            body.getTr().add(this.getRow("Arznei: Pharmazentralnummer", consumable.getManufacturedProduct().getManufacturedMaterial().getCode().getCode()));
            if (consumable.getManufacturedProduct().getManufacturedMaterial().getFormCode() != null) {
                body.getTr().add(this.getRow("Arznei: Darreichungsform", consumable.getManufacturedProduct().getManufacturedMaterial().getFormCode().getDisplayName()));
            }
            if (consumable.getManufacturedProduct().getManufacturedMaterial().getAsContent() != null && consumable.getManufacturedProduct().getManufacturedMaterial().getAsContent().getContainerPackagedMedicine() != null && consumable.getManufacturedProduct().getManufacturedMaterial().getAsContent().getContainerPackagedMedicine().getCapacityQuantity() != null) {
                body.getTr().add(this.getRow("Arznei: Angaben zur Packung", String.format("%s %s", consumable.getManufacturedProduct().getManufacturedMaterial().getAsContent().getContainerPackagedMedicine().getCapacityQuantity().getValue(), consumable.getManufacturedProduct().getManufacturedMaterial().getAsContent().getContainerPackagedMedicine().getCapacityQuantity().getUnit())));
            }
            this.addIngredientRows(consumable.getManufacturedProduct().getManufacturedMaterial().getIngredient(), body);
        }
    }

    protected void addIngredientRows(List<COCTMT230100UVIngredient> ingredients, StrucDocTbody body) {
        for (COCTMT230100UVIngredient ingredient : ingredients) {
            if (ingredient == null || ingredient.getIngredient() == null || ingredient.getIngredient().getValue() == null) continue;
            StringBuilder ingredientsSb = new StringBuilder();
            for (TN tn : ((COCTMT230100UVSubstance)ingredient.getIngredient().getValue()).getName()) {
                if (tn == null) continue;
                ingredientsSb.append(tn.getMergedXmlMixed());
            }
            if (((COCTMT230100UVSubstance)ingredient.getIngredient().getValue()).getCode() != null) {
                ingredientsSb.append("(");
                ingredientsSb.append(((COCTMT230100UVSubstance)ingredient.getIngredient().getValue()).getCode().getCode());
                ingredientsSb.append(")");
            }
            body.getTr().add(this.getRow("Arznei: Wirkstoffklassifikation (ATC Code)", ingredients.toString()));
        }
    }

    protected StrucDocTable getBodyPrescriptionEntry(POCDMT000040SubstanceAdministration substance, int index) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (substance != null) {
            body.getTr().add(this.getRow("Verordnung", "" + index));
            if (!substance.getId().isEmpty() && substance.getId().get(0) != null) {
                body.getTr().add(this.getRow("VerordnungsID", ((II)substance.getId().get(0)).getRoot() + " / " + ((II)substance.getId().get(0)).getExtension() + "_" + index));
            }
            this.addConsumableInformationRows(substance.getConsumable(), body);
            this.addTimeRows(substance.getEffectiveTime(), body);
            this.addInformationOfEntryRelRows(substance.getEntryRelationship(), body, index);
            if (substance.getRouteCode() != null) {
                body.getTr().add(this.getRow("Art der Anwendung", substance.getRouteCode().getDisplayName()));
            }
            if (substance.getRepeatNumber() != null) {
                body.getTr().add(this.getRow("Anzahl der Einl\u00f6sungen", String.format("%d", substance.getRepeatNumber().getValue())));
            }
            table.getTbody().add(body);
        }
        return table;
    }

    protected StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Rezeptart", null));
        tr.getThOrTd().add(this.getTableHeaderCell("G\u00fcltig von", null));
        tr.getThOrTd().add(this.getTableHeaderCell("G\u00fcltig bis", null));
        thead.getTr().add(tr);
        return thead;
    }

    protected StrucDocTable getBody(POCDMT000040SubstanceAdministration substance) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (substance != null) {
            if (!substance.getId().isEmpty()) {
                table.setID(((II)substance.getId().get(0)).getExtension());
            }
            StrucDocTr tr = new StrucDocTr();
            StrucDocTd td = new StrucDocTd();
            if (substance.getCode() != null) {
                td.getContent().add(substance.getCode().getDisplayName());
                if (substance.getCode().getOriginalText() != null && substance.getCode().getOriginalText().getReference() != null && substance.getCode().getOriginalText().getReference().getValue() != null) {
                    td.setID(substance.getCode().getOriginalText().getReference().getValue().replace("#", ""));
                }
            }
            tr.getThOrTd().add(td);
            Map<String, String> timeMap = this.getTsElement((IVLTS)substance.getEffectiveTime().get(0));
            Instant startDateDisease = DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)timeMap.get("low")));
            Instant endDateDisease = DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)timeMap.get("high")));
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            StrucDocTd tdStartTime = new StrucDocTd();
            tdStartTime.getContent().add(sdf.format(startDateDisease));
            tr.getThOrTd().add(tdStartTime);
            StrucDocTd tdEndTime = new StrucDocTd();
            tdEndTime.getContent().add(sdf.format(endDateDisease));
            tr.getThOrTd().add(tdEndTime);
            body.getTr().add(tr);
        }
        table.setThead(this.getTableHeader());
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda(List<POCDMT000040Entry> entries) {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        int index = 0;
        for (POCDMT000040Entry entry : entries) {
            if (entry == null || entry.getAct() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(entry.getSubstanceAdministration())));
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBodyPrescriptionEntry(entry.getSubstanceAdministration(), index)));
            ++index;
        }
        return tables;
    }
}

