/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.utils;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.utils.time.DateTimes;

public class DateTimeUtils {
    private DateTimeUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static IVLTS createIvlts(ZonedDateTime startDate, ZonedDateTime stopDate) {
        if (startDate == null) {
            return null;
        }
        IVLTS ivlts = new IVLTS();
        ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDatetimeTs((TemporalAccessor)startDate)));
        if (stopDate == null) {
            TS ts = new TS(NullFlavor.UNKNOWN_L1);
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)ts));
        } else {
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDatetimeTs((TemporalAccessor)stopDate)));
        }
        return ivlts;
    }

    public static IVLTS createIvltsWithNullflavor(ZonedDateTime startDate, ZonedDateTime stopDate) {
        TS ts;
        IVLTS ivlts = new IVLTS();
        if (startDate == null) {
            ts = new TS(NullFlavor.UNKNOWN_L1);
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)ts));
        } else {
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDatetimeTs((TemporalAccessor)startDate)));
        }
        if (stopDate == null) {
            ts = new TS(NullFlavor.UNKNOWN_L1);
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)ts));
        } else {
            ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDatetimeTs((TemporalAccessor)stopDate)));
        }
        return ivlts;
    }
}

