/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.emed.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_MedikationMengenart values
 * <p>
 * EN: ELGA ValueSet for units of measure in e-Medikation.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.32<br>
 * Effective date: 2015-05-27 00:00<br>
 * Version: null<br>
 * Status: FINAL
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-22")
public enum ElgaMedikationMengenart implements ValueSetEnumInterface {

    /**
     * EN: a.<br>
     */
    A("a",
      "2.16.840.1.113883.6.8",
      "a",
      "a",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: bar.<br>
     */
    BAR("bar",
        "2.16.840.1.113883.6.8",
        "bar",
        "bar",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: Beutel/Aufgussbeutel.<br>
     */
    BEUTEL_AUFGUSSBEUTEL("{Beutel/Aufgussbeutel}",
                         "2.16.840.1.113883.6.8",
                         "Beutel/Aufgussbeutel",
                         "Beutel/Aufgussbeutel",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Broteinheiten.<br>
     */
    BROTEINHEITEN("{Broteinheiten}",
                  "2.16.840.1.113883.6.8",
                  "Broteinheiten",
                  "Broteinheiten",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Cal.<br>
     */
    CAL("Cal",
        "2.16.840.1.113883.6.8",
        "Cal",
        "Cal",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: cal/d.<br>
     */
    CAL_D("cal/d",
          "2.16.840.1.113883.6.8",
          "cal/d",
          "cal/d",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: cal/g.<br>
     */
    CAL_G("cal/g",
          "2.16.840.1.113883.6.8",
          "cal/g",
          "cal/g",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: cal/h.<br>
     */
    CAL_H("cal/h",
          "2.16.840.1.113883.6.8",
          "cal/h",
          "cal/h",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: cal/ml.<br>
     */
    CAL_ML("cal/mL",
           "2.16.840.1.113883.6.8",
           "cal/ml",
           "cal/ml",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Cel.<br>
     */
    CEL("Cel",
        "2.16.840.1.113883.6.8",
        "Cel",
        "Cel",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: cm.<br>
     */
    CM("cm",
       "2.16.840.1.113883.6.8",
       "cm",
       "cm",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: cm2.<br>
     */
    CM2("cm2",
        "2.16.840.1.113883.6.8",
        "cm2",
        "cm2",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: cm3.<br>
     */
    CM3("cm3",
        "2.16.840.1.113883.6.8",
        "cm3",
        "cm3",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: d.<br>
     */
    D("d",
      "2.16.840.1.113883.6.8",
      "d",
      "d",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: Esslöffel.<br>
     */
    ESSL_FFEL("{Essloeffel}",
              "2.16.840.1.113883.6.8",
              "Esslöffel",
              "Esslöffel",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Flaschen.<br>
     */
    FLASCHEN("{Flaschen}",
             "2.16.840.1.113883.6.8",
             "Flaschen",
             "Flaschen",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: g.<br>
     */
    G("g",
      "2.16.840.1.113883.6.8",
      "g",
      "g",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: Globuli.<br>
     */
    GLOBULI("{Globuli}",
            "2.16.840.1.113883.6.8",
            "Globuli",
            "Globuli",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: g/kg.<br>
     */
    G_KG("g/kg",
         "2.16.840.1.113883.6.8",
         "g/kg",
         "g/kg",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: g/l.<br>
     */
    G_L("g/L",
        "2.16.840.1.113883.6.8",
        "g/l",
        "g/l",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: g/ml.<br>
     */
    G_ML("g/mL",
         "2.16.840.1.113883.6.8",
         "g/ml",
         "g/ml",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: h.<br>
     */
    H("h",
      "2.16.840.1.113883.6.8",
      "h",
      "h",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: Hub.<br>
     */
    HUB("{Hub}",
        "2.16.840.1.113883.6.8",
        "Hub",
        "Hub",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: IE.<br>
     */
    IE("[iU]",
       "2.16.840.1.113883.6.8",
       "IE",
       "IE",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: IE/g.<br>
     */
    IE_G("[iU]/g",
         "2.16.840.1.113883.6.8",
         "IE/g",
         "IE/g",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: IE/ml.<br>
     */
    IE_ML("[iU]/mL",
          "2.16.840.1.113883.6.8",
          "IE/ml",
          "IE/ml",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: J.<br>
     */
    J("J",
      "2.16.840.1.113883.6.8",
      "J",
      "J",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: kat.<br>
     */
    KAT("kat",
        "2.16.840.1.113883.6.8",
        "kat",
        "kat",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: kcal.<br>
     */
    KCAL("kcal",
         "2.16.840.1.113883.6.8",
         "kcal",
         "kcal",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: kcal/d.<br>
     */
    KCAL_D("kcal/d",
           "2.16.840.1.113883.6.8",
           "kcal/d",
           "kcal/d",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: kcal/g.<br>
     */
    KCAL_G("kcal/g",
           "2.16.840.1.113883.6.8",
           "kcal/g",
           "kcal/g",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: kcal/h.<br>
     */
    KCAL_H("kcal/h",
           "2.16.840.1.113883.6.8",
           "kcal/h",
           "kcal/h",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: kcal/ml.<br>
     */
    KCAL_ML("kcal/mL",
            "2.16.840.1.113883.6.8",
            "kcal/ml",
            "kcal/ml",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: kg.<br>
     */
    KG("kg",
       "2.16.840.1.113883.6.8",
       "kg",
       "kg",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: kg/m2.<br>
     */
    KG_M2("kg/m2",
          "2.16.840.1.113883.6.8",
          "kg/m2",
          "kg/m2",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: kg/m3.<br>
     */
    KG_M3("kg/m3",
          "2.16.840.1.113883.6.8",
          "kg/m3",
          "kg/m3",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: kIE.<br>
     */
    KIE("k[iU]",
        "2.16.840.1.113883.6.8",
        "kIE",
        "kIE",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: kIE/l.<br>
     */
    KIE_L("k[iU]/L",
          "2.16.840.1.113883.6.8",
          "kIE/l",
          "kIE/l",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: kJ.<br>
     */
    KJ("kJ",
       "2.16.840.1.113883.6.8",
       "kJ",
       "kJ",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: kPa.<br>
     */
    KPA("kPa",
        "2.16.840.1.113883.6.8",
        "kPa",
        "kPa",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: l.<br>
     */
    L("L",
      "2.16.840.1.113883.6.8",
      "l",
      "l",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: l/s.<br>
     */
    L_S("L/s",
        "2.16.840.1.113883.6.8",
        "l/s",
        "l/s",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: m.<br>
     */
    M("m",
      "2.16.840.1.113883.6.8",
      "m",
      "m",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: m2.<br>
     */
    M2("m2",
       "2.16.840.1.113883.6.8",
       "m2",
       "m2",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: mbar.<br>
     */
    MBAR("mbar",
         "2.16.840.1.113883.6.8",
         "mbar",
         "mbar",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Messlöffel.<br>
     */
    MESSL_FFEL("{Messloeffel}",
               "2.16.840.1.113883.6.8",
               "Messlöffel",
               "Messlöffel",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: mg.<br>
     */
    MG("mg",
       "2.16.840.1.113883.6.8",
       "mg",
       "mg",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: mg/l.<br>
     */
    MG_L("mg/L",
         "2.16.840.1.113883.6.8",
         "mg/l",
         "mg/l",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: mIE.<br>
     */
    MIE("m[iU]",
        "2.16.840.1.113883.6.8",
        "mIE",
        "mIE",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: mIE/l.<br>
     */
    MIE_L("m[iU]/L",
          "2.16.840.1.113883.6.8",
          "mIE/l",
          "mIE/l",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: min.<br>
     */
    MIN("min",
        "2.16.840.1.113883.6.8",
        "min",
        "min",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: ml.<br>
     */
    ML("mL",
       "2.16.840.1.113883.6.8",
       "ml",
       "ml",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: ml/s.<br>
     */
    ML_S("mL/s",
         "2.16.840.1.113883.6.8",
         "ml/s",
         "ml/s",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: mm.<br>
     */
    MM("mm",
       "2.16.840.1.113883.6.8",
       "mm",
       "mm",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: mm2.<br>
     */
    MM2("mm2",
        "2.16.840.1.113883.6.8",
        "mm2",
        "mm2",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: mmHg.<br>
     */
    MMHG("mm[Hg]",
         "2.16.840.1.113883.6.8",
         "mmHg",
         "mmHg",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: mmol.<br>
     */
    MMOL("mmol",
         "2.16.840.1.113883.6.8",
         "mmol",
         "mmol",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: mmol/l.<br>
     */
    MMOL_L("mmol/L",
           "2.16.840.1.113883.6.8",
           "mmol/l",
           "mmol/l",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: mo.<br>
     */
    MO("mo",
       "2.16.840.1.113883.6.8",
       "mo",
       "mo",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: mol/l.<br>
     */
    MOL_L("mol/L",
          "2.16.840.1.113883.6.8",
          "mol/l",
          "mol/l",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: ng.<br>
     */
    NG("ng",
       "2.16.840.1.113883.6.8",
       "ng",
       "ng",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: ng/l.<br>
     */
    NG_L("ng/L",
         "2.16.840.1.113883.6.8",
         "ng/l",
         "ng/l",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: nmol/l.<br>
     */
    NMOL_L("nmol/L",
           "2.16.840.1.113883.6.8",
           "nmol/l",
           "nmol/l",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: 1.<br>
     */
    ONE_1("1",
          "2.16.840.1.113883.6.8",
          "1",
          "1",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Packung.<br>
     */
    PACKUNG("{Packung}",
            "2.16.840.1.113883.6.8",
            "Packung",
            "Packung",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Packungsbeutel.<br>
     */
    PACKUNGSBEUTEL("{Packungsbeutel}",
                   "2.16.840.1.113883.6.8",
                   "Packungsbeutel",
                   "Packungsbeutel",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: %.<br>
     */
    PERCENT("%",
            "2.16.840.1.113883.6.8",
            "%",
            "%",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: pH.<br>
     */
    PH("[pH]",
       "2.16.840.1.113883.6.8",
       "pH",
       "pH",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: s.<br>
     */
    S("s",
      "2.16.840.1.113883.6.8",
      "s",
      "s",
      "TOTRANSLATE",
      "TOTRANSLATE",
      "TOTRANSLATE"),
    /**
     * EN: Stück.<br>
     */
    ST_CK("{Stueck}",
          "2.16.840.1.113883.6.8",
          "Stück",
          "Stück",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Teelöffel.<br>
     */
    TEEL_FFEL("{Teeloeffel}",
              "2.16.840.1.113883.6.8",
              "Teelöffel",
              "Teelöffel",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tropfen.<br>
     */
    TROPFEN("{Tropfen}",
            "2.16.840.1.113883.6.8",
            "Tropfen",
            "Tropfen",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: µg.<br>
     */
    UG("ug",
       "2.16.840.1.113883.6.8",
       "µg",
       "µg",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: µg/(kg.min).<br>
     */
    UG_KG_MIN("ug/(kg.min)",
              "2.16.840.1.113883.6.8",
              "µg/(kg.min)",
              "µg/(kg.min)",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: µg/l.<br>
     */
    UG_L("ug/L",
         "2.16.840.1.113883.6.8",
         "µg/l",
         "µg/l",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: µkat.<br>
     */
    UKAT("ukat",
         "2.16.840.1.113883.6.8",
         "µkat",
         "µkat",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: µkat/l.<br>
     */
    UKAT_L("ukat/L",
           "2.16.840.1.113883.6.8",
           "µkat/l",
           "µkat/l",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: µkat/ml.<br>
     */
    UKAT_ML("ukat/mL",
            "2.16.840.1.113883.6.8",
            "µkat/ml",
            "µkat/ml",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: µl.<br>
     */
    UL("uL",
       "2.16.840.1.113883.6.8",
       "µl",
       "µl",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: µmol.<br>
     */
    UMOL("umol",
         "2.16.840.1.113883.6.8",
         "µmol",
         "µmol",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: µmol/l.<br>
     */
    UMOL_L("umol/L",
           "2.16.840.1.113883.6.8",
           "µmol/l",
           "µmol/l",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: wk.<br>
     */
    WK("wk",
       "2.16.840.1.113883.6.8",
       "wk",
       "wk",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: /d.<br>
     */
    _D("/d",
       "2.16.840.1.113883.6.8",
       "/d",
       "/d",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: /g.<br>
     */
    _G("/g",
       "2.16.840.1.113883.6.8",
       "/g",
       "/g",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: /h.<br>
     */
    _H("/h",
       "2.16.840.1.113883.6.8",
       "/h",
       "/h",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: /kg.<br>
     */
    _KG("/kg",
        "2.16.840.1.113883.6.8",
        "/kg",
        "/kg",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: /kg Körpergewicht.<br>
     */
    _KG_K_RPERGEWICHT("/kg{body`wt}",
                      "2.16.840.1.113883.6.8",
                      "/kg Körpergewicht",
                      "/kg Körpergewicht",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: /min.<br>
     */
    _MIN("/min",
         "2.16.840.1.113883.6.8",
         "/min",
         "/min",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: /s.<br>
     */
    _S("/s",
       "2.16.840.1.113883.6.8",
       "/s",
       "/s",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE");

    /**
     * EN: Code for a.<br>
     */
    public static final String A_CODE = "a";

    /**
     * EN: Code for bar.<br>
     */
    public static final String BAR_CODE = "bar";

    /**
     * EN: Code for Beutel/Aufgussbeutel.<br>
     */
    public static final String BEUTEL_AUFGUSSBEUTEL_CODE = "{Beutel/Aufgussbeutel}";

    /**
     * EN: Code for Broteinheiten.<br>
     */
    public static final String BROTEINHEITEN_CODE = "{Broteinheiten}";

    /**
     * EN: Code for Cal.<br>
     */
    public static final String CAL_CODE = "Cal";

    /**
     * EN: Code for cal/d.<br>
     */
    public static final String CAL_D_CODE = "cal/d";

    /**
     * EN: Code for cal/g.<br>
     */
    public static final String CAL_G_CODE = "cal/g";

    /**
     * EN: Code for cal/h.<br>
     */
    public static final String CAL_H_CODE = "cal/h";

    /**
     * EN: Code for cal/ml.<br>
     */
    public static final String CAL_ML_CODE = "cal/mL";

    /**
     * EN: Code for Cel.<br>
     */
    public static final String CEL_CODE = "Cel";

    /**
     * EN: Code for cm.<br>
     */
    public static final String CM_CODE = "cm";

    /**
     * EN: Code for cm2.<br>
     */
    public static final String CM2_CODE = "cm2";

    /**
     * EN: Code for cm3.<br>
     */
    public static final String CM3_CODE = "cm3";

    /**
     * EN: Code for d.<br>
     */
    public static final String D_CODE = "d";

    /**
     * EN: Code for Esslöffel.<br>
     */
    public static final String ESSL_FFEL_CODE = "{Essloeffel}";

    /**
     * EN: Code for Flaschen.<br>
     */
    public static final String FLASCHEN_CODE = "{Flaschen}";

    /**
     * EN: Code for g.<br>
     */
    public static final String G_CODE = "g";

    /**
     * EN: Code for Globuli.<br>
     */
    public static final String GLOBULI_CODE = "{Globuli}";

    /**
     * EN: Code for g/kg.<br>
     */
    public static final String G_KG_CODE = "g/kg";

    /**
     * EN: Code for g/l.<br>
     */
    public static final String G_L_CODE = "g/L";

    /**
     * EN: Code for g/ml.<br>
     */
    public static final String G_ML_CODE = "g/mL";

    /**
     * EN: Code for h.<br>
     */
    public static final String H_CODE = "h";

    /**
     * EN: Code for Hub.<br>
     */
    public static final String HUB_CODE = "{Hub}";

    /**
     * EN: Code for IE.<br>
     */
    public static final String IE_CODE = "[iU]";

    /**
     * EN: Code for IE/g.<br>
     */
    public static final String IE_G_CODE = "[iU]/g";

    /**
     * EN: Code for IE/ml.<br>
     */
    public static final String IE_ML_CODE = "[iU]/mL";

    /**
     * EN: Code for J.<br>
     */
    public static final String J_CODE = "J";

    /**
     * EN: Code for kat.<br>
     */
    public static final String KAT_CODE = "kat";

    /**
     * EN: Code for kcal.<br>
     */
    public static final String KCAL_CODE = "kcal";

    /**
     * EN: Code for kcal/d.<br>
     */
    public static final String KCAL_D_CODE = "kcal/d";

    /**
     * EN: Code for kcal/g.<br>
     */
    public static final String KCAL_G_CODE = "kcal/g";

    /**
     * EN: Code for kcal/h.<br>
     */
    public static final String KCAL_H_CODE = "kcal/h";

    /**
     * EN: Code for kcal/ml.<br>
     */
    public static final String KCAL_ML_CODE = "kcal/mL";

    /**
     * EN: Code for kg.<br>
     */
    public static final String KG_CODE = "kg";

    /**
     * EN: Code for kg/m2.<br>
     */
    public static final String KG_M2_CODE = "kg/m2";

    /**
     * EN: Code for kg/m3.<br>
     */
    public static final String KG_M3_CODE = "kg/m3";

    /**
     * EN: Code for kIE.<br>
     */
    public static final String KIE_CODE = "k[iU]";

    /**
     * EN: Code for kIE/l.<br>
     */
    public static final String KIE_L_CODE = "k[iU]/L";

    /**
     * EN: Code for kJ.<br>
     */
    public static final String KJ_CODE = "kJ";

    /**
     * EN: Code for kPa.<br>
     */
    public static final String KPA_CODE = "kPa";

    /**
     * EN: Code for l.<br>
     */
    public static final String L_CODE = "L";

    /**
     * EN: Code for l/s.<br>
     */
    public static final String L_S_CODE = "L/s";

    /**
     * EN: Code for m.<br>
     */
    public static final String M_CODE = "m";

    /**
     * EN: Code for m2.<br>
     */
    public static final String M2_CODE = "m2";

    /**
     * EN: Code for mbar.<br>
     */
    public static final String MBAR_CODE = "mbar";

    /**
     * EN: Code for Messlöffel.<br>
     */
    public static final String MESSL_FFEL_CODE = "{Messloeffel}";

    /**
     * EN: Code for mg.<br>
     */
    public static final String MG_CODE = "mg";

    /**
     * EN: Code for mg/l.<br>
     */
    public static final String MG_L_CODE = "mg/L";

    /**
     * EN: Code for mIE.<br>
     */
    public static final String MIE_CODE = "m[iU]";

    /**
     * EN: Code for mIE/l.<br>
     */
    public static final String MIE_L_CODE = "m[iU]/L";

    /**
     * EN: Code for min.<br>
     */
    public static final String MIN_CODE = "min";

    /**
     * EN: Code for ml.<br>
     */
    public static final String ML_CODE = "mL";

    /**
     * EN: Code for ml/s.<br>
     */
    public static final String ML_S_CODE = "mL/s";

    /**
     * EN: Code for mm.<br>
     */
    public static final String MM_CODE = "mm";

    /**
     * EN: Code for mm2.<br>
     */
    public static final String MM2_CODE = "mm2";

    /**
     * EN: Code for mmHg.<br>
     */
    public static final String MMHG_CODE = "mm[Hg]";

    /**
     * EN: Code for mmol.<br>
     */
    public static final String MMOL_CODE = "mmol";

    /**
     * EN: Code for mmol/l.<br>
     */
    public static final String MMOL_L_CODE = "mmol/L";

    /**
     * EN: Code for mo.<br>
     */
    public static final String MO_CODE = "mo";

    /**
     * EN: Code for mol/l.<br>
     */
    public static final String MOL_L_CODE = "mol/L";

    /**
     * EN: Code for ng.<br>
     */
    public static final String NG_CODE = "ng";

    /**
     * EN: Code for ng/l.<br>
     */
    public static final String NG_L_CODE = "ng/L";

    /**
     * EN: Code for nmol/l.<br>
     */
    public static final String NMOL_L_CODE = "nmol/L";

    /**
     * EN: Code for 1.<br>
     */
    public static final String ONE_1_CODE = "1";

    /**
     * EN: Code for Packung.<br>
     */
    public static final String PACKUNG_CODE = "{Packung}";

    /**
     * EN: Code for Packungsbeutel.<br>
     */
    public static final String PACKUNGSBEUTEL_CODE = "{Packungsbeutel}";

    /**
     * EN: Code for %.<br>
     */
    public static final String PERCENT_CODE = "%";

    /**
     * EN: Code for pH.<br>
     */
    public static final String PH_CODE = "[pH]";

    /**
     * EN: Code for s.<br>
     */
    public static final String S_CODE = "s";

    /**
     * EN: Code for Stück.<br>
     */
    public static final String ST_CK_CODE = "{Stueck}";

    /**
     * EN: Code for Teelöffel.<br>
     */
    public static final String TEEL_FFEL_CODE = "{Teeloeffel}";

    /**
     * EN: Code for Tropfen.<br>
     */
    public static final String TROPFEN_CODE = "{Tropfen}";

    /**
     * EN: Code for µg.<br>
     */
    public static final String UG_CODE = "ug";

    /**
     * EN: Code for µg/(kg.min).<br>
     */
    public static final String UG_KG_MIN_CODE = "ug/(kg.min)";

    /**
     * EN: Code for µg/l.<br>
     */
    public static final String UG_L_CODE = "ug/L";

    /**
     * EN: Code for µkat.<br>
     */
    public static final String UKAT_CODE = "ukat";

    /**
     * EN: Code for µkat/l.<br>
     */
    public static final String UKAT_L_CODE = "ukat/L";

    /**
     * EN: Code for µkat/ml.<br>
     */
    public static final String UKAT_ML_CODE = "ukat/mL";

    /**
     * EN: Code for µl.<br>
     */
    public static final String UL_CODE = "uL";

    /**
     * EN: Code for µmol.<br>
     */
    public static final String UMOL_CODE = "umol";

    /**
     * EN: Code for µmol/l.<br>
     */
    public static final String UMOL_L_CODE = "umol/L";

    /**
     * EN: Code for wk.<br>
     */
    public static final String WK_CODE = "wk";

    /**
     * EN: Code for /d.<br>
     */
    public static final String _D_CODE = "/d";

    /**
     * EN: Code for /g.<br>
     */
    public static final String _G_CODE = "/g";

    /**
     * EN: Code for /h.<br>
     */
    public static final String _H_CODE = "/h";

    /**
     * EN: Code for /kg.<br>
     */
    public static final String _KG_CODE = "/kg";

    /**
     * EN: Code for /kg Körpergewicht.<br>
     */
    public static final String _KG_K_RPERGEWICHT_CODE = "/kg{body`wt}";

    /**
     * EN: Code for /min.<br>
     */
    public static final String _MIN_CODE = "/min";

    /**
     * EN: Code for /s.<br>
     */
    public static final String _S_CODE = "/s";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.32";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_MedikationMengenart";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.8";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaMedikationMengenart getEnum(@Nullable final String code) {
        for (final ElgaMedikationMengenart x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaMedikationMengenart.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaMedikationMengenart x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaMedikationMengenart(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
