/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_MedikationMengenart_VS values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.32<br>
 * Effective date: 2020-09-11 08:37<br>
 * Version: 201910.1<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-18")
public enum ElgaMedikationMengenartVs implements ValueSetEnumInterface {

    /**
     * EN: Ampulle(n).<br>
     */
    AMPULLE_N("{Ampulle}",
              "2.16.840.1.113883.6.8",
              "Ampulle(n)",
              "Ampulle(n)",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Bar.<br>
     */
    BAR("bar",
        "2.16.840.1.113883.6.8",
        "Bar",
        "Bar",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: Beutel/Aufgussbeutel.<br>
     */
    BEUTEL_AUFGUSSBEUTEL("{Beutel/Aufgussbeutel}",
                         "2.16.840.1.113883.6.8",
                         "Beutel/Aufgussbeutel",
                         "Beutel/Aufgussbeutel",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Broteinheit(en).<br>
     */
    BROTEINHEIT_EN("{Broteinheiten}",
                   "2.16.840.1.113883.6.8",
                   "Broteinheit(en)",
                   "Broteinheit(en)",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Calorie.<br>
     */
    CALORIE("cal",
            "2.16.840.1.113883.6.8",
            "Calorie",
            "Calorie",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: CaloriesPerDay.<br>
     */
    CALORIESPERDAY("cal/d",
                   "2.16.840.1.113883.6.8",
                   "CaloriesPerDay",
                   "CaloriesPerDay",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: CaloriesPerGram.<br>
     */
    CALORIESPERGRAM("cal/g",
                    "2.16.840.1.113883.6.8",
                    "CaloriesPerGram",
                    "CaloriesPerGram",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: CaloriesPerHour.<br>
     */
    CALORIESPERHOUR("cal/h",
                    "2.16.840.1.113883.6.8",
                    "CaloriesPerHour",
                    "CaloriesPerHour",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: CaloriesPerMilliLiter.<br>
     */
    CALORIESPERMILLILITER("cal/mL",
                          "2.16.840.1.113883.6.8",
                          "CaloriesPerMilliLiter",
                          "CaloriesPerMilliLiter",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: CentiMeter.<br>
     */
    CENTIMETER("cm",
               "2.16.840.1.113883.6.8",
               "CentiMeter",
               "CentiMeter",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: CubicCentimeter.<br>
     */
    CUBICCENTIMETER("cm3",
                    "2.16.840.1.113883.6.8",
                    "CubicCentimeter",
                    "CubicCentimeter",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Day.<br>
     */
    DAY("d",
        "2.16.840.1.113883.6.8",
        "Day",
        "Day",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: DegreeCelsius.<br>
     */
    DEGREECELSIUS("Cel",
                  "2.16.840.1.113883.6.8",
                  "DegreeCelsius",
                  "DegreeCelsius",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Esslöffel.<br>
     */
    ESSL_FFEL("{Essloeffel}",
              "2.16.840.1.113883.6.8",
              "Esslöffel",
              "Esslöffel",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Flasche(n).<br>
     */
    FLASCHE_N("{Flaschen}",
              "2.16.840.1.113883.6.8",
              "Flasche(n)",
              "Flasche(n)",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: GigaBecquerel.<br>
     */
    GIGABECQUEREL("GBq",
                  "2.16.840.1.113883.6.8",
                  "GigaBecquerel",
                  "GigaBecquerel",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Globuli.<br>
     */
    GLOBULI("{Globuli}",
            "2.16.840.1.113883.6.8",
            "Globuli",
            "Globuli",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Gram.<br>
     */
    GRAM("g",
         "2.16.840.1.113883.6.8",
         "Gram",
         "Gram",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: GramsPerKiloGram.<br>
     */
    GRAMSPERKILOGRAM("g/kg",
                     "2.16.840.1.113883.6.8",
                     "GramsPerKiloGram",
                     "GramsPerKiloGram",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: GramsPerLiter.<br>
     */
    GRAMSPERLITER("g/L",
                  "2.16.840.1.113883.6.8",
                  "GramsPerLiter",
                  "GramsPerLiter",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: GramsPerMilliliter.<br>
     */
    GRAMSPERMILLILITER("g/mL",
                       "2.16.840.1.113883.6.8",
                       "GramsPerMilliliter",
                       "GramsPerMilliliter",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Hour.<br>
     */
    HOUR("h",
         "2.16.840.1.113883.6.8",
         "Hour",
         "Hour",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Hub/Hübe.<br>
     */
    HUB_H_BE("{Hub}",
             "2.16.840.1.113883.6.8",
             "Hub/Hübe",
             "Hub/Hübe",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: InternationalUnit.<br>
     */
    INTERNATIONALUNIT("[iU]",
                      "2.16.840.1.113883.6.8",
                      "InternationalUnit",
                      "InternationalUnit",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: InternationalUnitsPerGram.<br>
     */
    INTERNATIONALUNITSPERGRAM("[iU]/g",
                              "2.16.840.1.113883.6.8",
                              "InternationalUnitsPerGram",
                              "InternationalUnitsPerGram",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: InternationalUnitsPerMilliLiter.<br>
     */
    INTERNATIONALUNITSPERMILLILITER("[iU]/mL",
                                    "2.16.840.1.113883.6.8",
                                    "InternationalUnitsPerMilliLiter",
                                    "InternationalUnitsPerMilliLiter",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: International Unit(s) per Bread Unit(s).<br>
     */
    INTERNATIONAL_UNIT_PER_BREAD_UNIT("[iU]/{Broteinheiten}",
                                      "2.16.840.1.113883.6.8",
                                      "International Unit(s) per Bread Unit(s)",
                                      "International Unit(s) per Bread Unit(s)",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Joule.<br>
     */
    JOULE("J",
          "2.16.840.1.113883.6.8",
          "Joule",
          "Joule",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Katal.<br>
     */
    KATAL("kat",
          "2.16.840.1.113883.6.8",
          "Katal",
          "Katal",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: KiloCalorie.<br>
     */
    KILOCALORIE("kcal",
                "2.16.840.1.113883.6.8",
                "KiloCalorie",
                "KiloCalorie",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: KiloCaloriesPerDay.<br>
     */
    KILOCALORIESPERDAY("kcal/d",
                       "2.16.840.1.113883.6.8",
                       "KiloCaloriesPerDay",
                       "KiloCaloriesPerDay",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: KiloCaloriesPerGram.<br>
     */
    KILOCALORIESPERGRAM("kcal/g",
                        "2.16.840.1.113883.6.8",
                        "KiloCaloriesPerGram",
                        "KiloCaloriesPerGram",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: KiloCaloriesPerHour.<br>
     */
    KILOCALORIESPERHOUR("kcal/h",
                        "2.16.840.1.113883.6.8",
                        "KiloCaloriesPerHour",
                        "KiloCaloriesPerHour",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: KiloCaloriesPerMilliliter.<br>
     */
    KILOCALORIESPERMILLILITER("kcal/mL",
                              "2.16.840.1.113883.6.8",
                              "KiloCaloriesPerMilliliter",
                              "KiloCaloriesPerMilliliter",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: KilogramPerSquareMeter.<br>
     */
    KILOGRAMPERSQUAREMETER("kg/m2",
                           "2.16.840.1.113883.6.8",
                           "KilogramPerSquareMeter",
                           "KilogramPerSquareMeter",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: KiloGrams.<br>
     */
    KILOGRAMS("kg",
              "2.16.840.1.113883.6.8",
              "KiloGrams",
              "KiloGrams",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: KiloGramsPerCubicMeter.<br>
     */
    KILOGRAMSPERCUBICMETER("kg/m3",
                           "2.16.840.1.113883.6.8",
                           "KiloGramsPerCubicMeter",
                           "KiloGramsPerCubicMeter",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: KiloInternationalUnits.<br>
     */
    KILOINTERNATIONALUNITS("k[iU]",
                           "2.16.840.1.113883.6.8",
                           "KiloInternationalUnits",
                           "KiloInternationalUnits",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: KiloInternationalUnitsPerLiter.<br>
     */
    KILOINTERNATIONALUNITSPERLITER("k[iU]/L",
                                   "2.16.840.1.113883.6.8",
                                   "KiloInternationalUnitsPerLiter",
                                   "KiloInternationalUnitsPerLiter",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: KiloJoule.<br>
     */
    KILOJOULE("kJ",
              "2.16.840.1.113883.6.8",
              "KiloJoule",
              "KiloJoule",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: KiloPascal.<br>
     */
    KILOPASCAL("kPa",
               "2.16.840.1.113883.6.8",
               "KiloPascal",
               "KiloPascal",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Liter.<br>
     */
    LITER("L",
          "2.16.840.1.113883.6.8",
          "Liter",
          "Liter",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: LitersPerSecond.<br>
     */
    LITERSPERSECOND("L/s",
                    "2.16.840.1.113883.6.8",
                    "LitersPerSecond",
                    "LitersPerSecond",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Messlöffel.<br>
     */
    MESSL_FFEL("{Messloeffel}",
               "2.16.840.1.113883.6.8",
               "Messlöffel",
               "Messlöffel",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Meter.<br>
     */
    METER("m",
          "2.16.840.1.113883.6.8",
          "Meter",
          "Meter",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Microgram.<br>
     */
    MICROGRAM("ug",
              "2.16.840.1.113883.6.8",
              "Microgram",
              "Microgram",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: MicroGramsPerKiloGramAndMinute.<br>
     */
    MICROGRAMSPERKILOGRAMANDMINUTE("ug/(kg.min)",
                                   "2.16.840.1.113883.6.8",
                                   "MicroGramsPerKiloGramAndMinute",
                                   "MicroGramsPerKiloGramAndMinute",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: MicroGramsPerLiter.<br>
     */
    MICROGRAMSPERLITER("ug/L",
                       "2.16.840.1.113883.6.8",
                       "MicroGramsPerLiter",
                       "MicroGramsPerLiter",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: MicroKatal.<br>
     */
    MICROKATAL("ukat",
               "2.16.840.1.113883.6.8",
               "MicroKatal",
               "MicroKatal",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: MicroKatalsPerLiter.<br>
     */
    MICROKATALSPERLITER("ukat/L",
                        "2.16.840.1.113883.6.8",
                        "MicroKatalsPerLiter",
                        "MicroKatalsPerLiter",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: MicroKatalsPerMilliLiter.<br>
     */
    MICROKATALSPERMILLILITER("ukat/mL",
                             "2.16.840.1.113883.6.8",
                             "MicroKatalsPerMilliLiter",
                             "MicroKatalsPerMilliLiter",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: MicroLiter.<br>
     */
    MICROLITER("uL",
               "2.16.840.1.113883.6.8",
               "MicroLiter",
               "MicroLiter",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: MicroMole.<br>
     */
    MICROMOLE("umol",
              "2.16.840.1.113883.6.8",
              "MicroMole",
              "MicroMole",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: MicroMolesPerLiter.<br>
     */
    MICROMOLESPERLITER("umol/L",
                       "2.16.840.1.113883.6.8",
                       "MicroMolesPerLiter",
                       "MicroMolesPerLiter",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: MilliBar.<br>
     */
    MILLIBAR("mbar",
             "2.16.840.1.113883.6.8",
             "MilliBar",
             "MilliBar",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: MilliGram.<br>
     */
    MILLIGRAM("mg",
              "2.16.840.1.113883.6.8",
              "MilliGram",
              "MilliGram",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: MilliGramsPerLiter.<br>
     */
    MILLIGRAMSPERLITER("mg/L",
                       "2.16.840.1.113883.6.8",
                       "MilliGramsPerLiter",
                       "MilliGramsPerLiter",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: MilliInternationalUnit.<br>
     */
    MILLIINTERNATIONALUNIT("m[iU]",
                           "2.16.840.1.113883.6.8",
                           "MilliInternationalUnit",
                           "MilliInternationalUnit",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: MilliInternationalUnitsPerLiter.<br>
     */
    MILLIINTERNATIONALUNITSPERLITER("m[iU]/L",
                                    "2.16.840.1.113883.6.8",
                                    "MilliInternationalUnitsPerLiter",
                                    "MilliInternationalUnitsPerLiter",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: MilliLiter.<br>
     */
    MILLILITER("mL",
               "2.16.840.1.113883.6.8",
               "MilliLiter",
               "MilliLiter",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: MilliLitersPerSecond.<br>
     */
    MILLILITERSPERSECOND("mL/s",
                         "2.16.840.1.113883.6.8",
                         "MilliLitersPerSecond",
                         "MilliLitersPerSecond",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Millimeter.<br>
     */
    MILLIMETER("mm",
               "2.16.840.1.113883.6.8",
               "Millimeter",
               "Millimeter",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: MilliMetersOfMercury.<br>
     */
    MILLIMETERSOFMERCURY("mm[Hg]",
                         "2.16.840.1.113883.6.8",
                         "MilliMetersOfMercury",
                         "MilliMetersOfMercury",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: MilliMole.<br>
     */
    MILLIMOLE("mmol",
              "2.16.840.1.113883.6.8",
              "MilliMole",
              "MilliMole",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: MilliMolesPerLiter.<br>
     */
    MILLIMOLESPERLITER("mmol/L",
                       "2.16.840.1.113883.6.8",
                       "MilliMolesPerLiter",
                       "MilliMolesPerLiter",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: MillionInternationalUnits.<br>
     */
    MILLIONINTERNATIONALUNITS("10*6[iU]",
                              "2.16.840.1.113883.6.8",
                              "MillionInternationalUnits",
                              "MillionInternationalUnits",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Minute.<br>
     */
    MINUTE("min",
           "2.16.840.1.113883.6.8",
           "Minute",
           "Minute",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: MolePerLiter.<br>
     */
    MOLEPERLITER("mol/L",
                 "2.16.840.1.113883.6.8",
                 "MolePerLiter",
                 "MolePerLiter",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Month.<br>
     */
    MONTH("mo",
          "2.16.840.1.113883.6.8",
          "Month",
          "Month",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: NanoGram.<br>
     */
    NANOGRAM("ng",
             "2.16.840.1.113883.6.8",
             "NanoGram",
             "NanoGram",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: NanoGramsPerLiter.<br>
     */
    NANOGRAMSPERLITER("ng/L",
                      "2.16.840.1.113883.6.8",
                      "NanoGramsPerLiter",
                      "NanoGramsPerLiter",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: NanoMolesPerLiter.<br>
     */
    NANOMOLESPERLITER("nmol/L",
                      "2.16.840.1.113883.6.8",
                      "NanoMolesPerLiter",
                      "NanoMolesPerLiter",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Packungsbeutel.<br>
     */
    PACKUNGSBEUTEL("{Packungsbeutel}",
                   "2.16.840.1.113883.6.8",
                   "Packungsbeutel",
                   "Packungsbeutel",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Packung(en).<br>
     */
    PACKUNG_EN("{Packung}",
               "2.16.840.1.113883.6.8",
               "Packung(en)",
               "Packung(en)",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Percent.<br>
     */
    PERCENT("%",
            "2.16.840.1.113883.6.8",
            "Percent",
            "Percent",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: PerDay.<br>
     */
    PERDAY("/d",
           "2.16.840.1.113883.6.8",
           "PerDay",
           "PerDay",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: PerGram.<br>
     */
    PERGRAM("/g",
            "2.16.840.1.113883.6.8",
            "PerGram",
            "PerGram",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: PerHour.<br>
     */
    PERHOUR("/h",
            "2.16.840.1.113883.6.8",
            "PerHour",
            "PerHour",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: PerKiloGram.<br>
     */
    PERKILOGRAM("/kg",
                "2.16.840.1.113883.6.8",
                "PerKiloGram",
                "PerKiloGram",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: PerKiloGramBodyWeight.<br>
     */
    PERKILOGRAMBODYWEIGHT("/kg{body`wt}",
                          "2.16.840.1.113883.6.8",
                          "PerKiloGramBodyWeight",
                          "PerKiloGramBodyWeight",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: PerMinute.<br>
     */
    PERMINUTE("/min",
              "2.16.840.1.113883.6.8",
              "PerMinute",
              "PerMinute",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: PerSecond.<br>
     */
    PERSECOND("/s",
              "2.16.840.1.113883.6.8",
              "PerSecond",
              "PerSecond",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: pH.<br>
     */
    PH("[pH]",
       "2.16.840.1.113883.6.8",
       "pH",
       "pH",
       "TOTRANSLATE",
       "TOTRANSLATE",
       "TOTRANSLATE"),
    /**
     * EN: Second.<br>
     */
    SECOND("s",
           "2.16.840.1.113883.6.8",
           "Second",
           "Second",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: SquareCentimeter.<br>
     */
    SQUARECENTIMETER("cm2",
                     "2.16.840.1.113883.6.8",
                     "SquareCentimeter",
                     "SquareCentimeter",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: SquareMeter.<br>
     */
    SQUAREMETER("m2",
                "2.16.840.1.113883.6.8",
                "SquareMeter",
                "SquareMeter",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: SquareMilliMeter.<br>
     */
    SQUAREMILLIMETER("mm2",
                     "2.16.840.1.113883.6.8",
                     "SquareMilliMeter",
                     "SquareMilliMeter",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Stück.<br>
     */
    ST_CK("{Stueck}",
          "2.16.840.1.113883.6.8",
          "Stück",
          "Stück",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Teelöffel.<br>
     */
    TEEL_FFEL("{Teeloeffel}",
              "2.16.840.1.113883.6.8",
              "Teelöffel",
              "Teelöffel",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tropfen.<br>
     */
    TROPFEN("{Tropfen}",
            "2.16.840.1.113883.6.8",
            "Tropfen",
            "Tropfen",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Unit.<br>
     */
    UNIT("1",
         "2.16.840.1.113883.6.8",
         "Unit",
         "Unit",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Week.<br>
     */
    WEEK("wk",
         "2.16.840.1.113883.6.8",
         "Week",
         "Week",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Year.<br>
     */
    YEAR("a",
         "2.16.840.1.113883.6.8",
         "Year",
         "Year",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE");

    /**
     * EN: Code for Ampulle(n).<br>
     */
    public static final String AMPULLE_N_CODE = "{Ampulle}";

    /**
     * EN: Code for Bar.<br>
     */
    public static final String BAR_CODE = "bar";

    /**
     * EN: Code for Beutel/Aufgussbeutel.<br>
     */
    public static final String BEUTEL_AUFGUSSBEUTEL_CODE = "{Beutel/Aufgussbeutel}";

    /**
     * EN: Code for Broteinheit(en).<br>
     */
    public static final String BROTEINHEIT_EN_CODE = "{Broteinheiten}";

    /**
     * EN: Code for Calorie.<br>
     */
    public static final String CALORIE_CODE = "cal";

    /**
     * EN: Code for CaloriesPerDay.<br>
     */
    public static final String CALORIESPERDAY_CODE = "cal/d";

    /**
     * EN: Code for CaloriesPerGram.<br>
     */
    public static final String CALORIESPERGRAM_CODE = "cal/g";

    /**
     * EN: Code for CaloriesPerHour.<br>
     */
    public static final String CALORIESPERHOUR_CODE = "cal/h";

    /**
     * EN: Code for CaloriesPerMilliLiter.<br>
     */
    public static final String CALORIESPERMILLILITER_CODE = "cal/mL";

    /**
     * EN: Code for CentiMeter.<br>
     */
    public static final String CENTIMETER_CODE = "cm";

    /**
     * EN: Code for CubicCentimeter.<br>
     */
    public static final String CUBICCENTIMETER_CODE = "cm3";

    /**
     * EN: Code for Day.<br>
     */
    public static final String DAY_CODE = "d";

    /**
     * EN: Code for DegreeCelsius.<br>
     */
    public static final String DEGREECELSIUS_CODE = "Cel";

    /**
     * EN: Code for Esslöffel.<br>
     */
    public static final String ESSL_FFEL_CODE = "{Essloeffel}";

    /**
     * EN: Code for Flasche(n).<br>
     */
    public static final String FLASCHE_N_CODE = "{Flaschen}";

    /**
     * EN: Code for GigaBecquerel.<br>
     */
    public static final String GIGABECQUEREL_CODE = "GBq";

    /**
     * EN: Code for Globuli.<br>
     */
    public static final String GLOBULI_CODE = "{Globuli}";

    /**
     * EN: Code for Gram.<br>
     */
    public static final String GRAM_CODE = "g";

    /**
     * EN: Code for GramsPerKiloGram.<br>
     */
    public static final String GRAMSPERKILOGRAM_CODE = "g/kg";

    /**
     * EN: Code for GramsPerLiter.<br>
     */
    public static final String GRAMSPERLITER_CODE = "g/L";

    /**
     * EN: Code for GramsPerMilliliter.<br>
     */
    public static final String GRAMSPERMILLILITER_CODE = "g/mL";

    /**
     * EN: Code for Hour.<br>
     */
    public static final String HOUR_CODE = "h";

    /**
     * EN: Code for Hub/Hübe.<br>
     */
    public static final String HUB_H_BE_CODE = "{Hub}";

    /**
     * EN: Code for InternationalUnit.<br>
     */
    public static final String INTERNATIONALUNIT_CODE = "[iU]";

    /**
     * EN: Code for InternationalUnitsPerGram.<br>
     */
    public static final String INTERNATIONALUNITSPERGRAM_CODE = "[iU]/g";

    /**
     * EN: Code for InternationalUnitsPerMilliLiter.<br>
     */
    public static final String INTERNATIONALUNITSPERMILLILITER_CODE = "[iU]/mL";

    /**
     * EN: Code for International Unit(s) per Bread Unit(s).<br>
     */
    public static final String INTERNATIONAL_UNIT_PER_BREAD_UNIT_CODE = "[iU]/{Broteinheiten}";

    /**
     * EN: Code for Joule.<br>
     */
    public static final String JOULE_CODE = "J";

    /**
     * EN: Code for Katal.<br>
     */
    public static final String KATAL_CODE = "kat";

    /**
     * EN: Code for KiloCalorie.<br>
     */
    public static final String KILOCALORIE_CODE = "kcal";

    /**
     * EN: Code for KiloCaloriesPerDay.<br>
     */
    public static final String KILOCALORIESPERDAY_CODE = "kcal/d";

    /**
     * EN: Code for KiloCaloriesPerGram.<br>
     */
    public static final String KILOCALORIESPERGRAM_CODE = "kcal/g";

    /**
     * EN: Code for KiloCaloriesPerHour.<br>
     */
    public static final String KILOCALORIESPERHOUR_CODE = "kcal/h";

    /**
     * EN: Code for KiloCaloriesPerMilliliter.<br>
     */
    public static final String KILOCALORIESPERMILLILITER_CODE = "kcal/mL";

    /**
     * EN: Code for KilogramPerSquareMeter.<br>
     */
    public static final String KILOGRAMPERSQUAREMETER_CODE = "kg/m2";

    /**
     * EN: Code for KiloGrams.<br>
     */
    public static final String KILOGRAMS_CODE = "kg";

    /**
     * EN: Code for KiloGramsPerCubicMeter.<br>
     */
    public static final String KILOGRAMSPERCUBICMETER_CODE = "kg/m3";

    /**
     * EN: Code for KiloInternationalUnits.<br>
     */
    public static final String KILOINTERNATIONALUNITS_CODE = "k[iU]";

    /**
     * EN: Code for KiloInternationalUnitsPerLiter.<br>
     */
    public static final String KILOINTERNATIONALUNITSPERLITER_CODE = "k[iU]/L";

    /**
     * EN: Code for KiloJoule.<br>
     */
    public static final String KILOJOULE_CODE = "kJ";

    /**
     * EN: Code for KiloPascal.<br>
     */
    public static final String KILOPASCAL_CODE = "kPa";

    /**
     * EN: Code for Liter.<br>
     */
    public static final String LITER_CODE = "L";

    /**
     * EN: Code for LitersPerSecond.<br>
     */
    public static final String LITERSPERSECOND_CODE = "L/s";

    /**
     * EN: Code for Messlöffel.<br>
     */
    public static final String MESSL_FFEL_CODE = "{Messloeffel}";

    /**
     * EN: Code for Meter.<br>
     */
    public static final String METER_CODE = "m";

    /**
     * EN: Code for Microgram.<br>
     */
    public static final String MICROGRAM_CODE = "ug";

    /**
     * EN: Code for MicroGramsPerKiloGramAndMinute.<br>
     */
    public static final String MICROGRAMSPERKILOGRAMANDMINUTE_CODE = "ug/(kg.min)";

    /**
     * EN: Code for MicroGramsPerLiter.<br>
     */
    public static final String MICROGRAMSPERLITER_CODE = "ug/L";

    /**
     * EN: Code for MicroKatal.<br>
     */
    public static final String MICROKATAL_CODE = "ukat";

    /**
     * EN: Code for MicroKatalsPerLiter.<br>
     */
    public static final String MICROKATALSPERLITER_CODE = "ukat/L";

    /**
     * EN: Code for MicroKatalsPerMilliLiter.<br>
     */
    public static final String MICROKATALSPERMILLILITER_CODE = "ukat/mL";

    /**
     * EN: Code for MicroLiter.<br>
     */
    public static final String MICROLITER_CODE = "uL";

    /**
     * EN: Code for MicroMole.<br>
     */
    public static final String MICROMOLE_CODE = "umol";

    /**
     * EN: Code for MicroMolesPerLiter.<br>
     */
    public static final String MICROMOLESPERLITER_CODE = "umol/L";

    /**
     * EN: Code for MilliBar.<br>
     */
    public static final String MILLIBAR_CODE = "mbar";

    /**
     * EN: Code for MilliGram.<br>
     */
    public static final String MILLIGRAM_CODE = "mg";

    /**
     * EN: Code for MilliGramsPerLiter.<br>
     */
    public static final String MILLIGRAMSPERLITER_CODE = "mg/L";

    /**
     * EN: Code for MilliInternationalUnit.<br>
     */
    public static final String MILLIINTERNATIONALUNIT_CODE = "m[iU]";

    /**
     * EN: Code for MilliInternationalUnitsPerLiter.<br>
     */
    public static final String MILLIINTERNATIONALUNITSPERLITER_CODE = "m[iU]/L";

    /**
     * EN: Code for MilliLiter.<br>
     */
    public static final String MILLILITER_CODE = "mL";

    /**
     * EN: Code for MilliLitersPerSecond.<br>
     */
    public static final String MILLILITERSPERSECOND_CODE = "mL/s";

    /**
     * EN: Code for Millimeter.<br>
     */
    public static final String MILLIMETER_CODE = "mm";

    /**
     * EN: Code for MilliMetersOfMercury.<br>
     */
    public static final String MILLIMETERSOFMERCURY_CODE = "mm[Hg]";

    /**
     * EN: Code for MilliMole.<br>
     */
    public static final String MILLIMOLE_CODE = "mmol";

    /**
     * EN: Code for MilliMolesPerLiter.<br>
     */
    public static final String MILLIMOLESPERLITER_CODE = "mmol/L";

    /**
     * EN: Code for MillionInternationalUnits.<br>
     */
    public static final String MILLIONINTERNATIONALUNITS_CODE = "10*6[iU]";

    /**
     * EN: Code for Minute.<br>
     */
    public static final String MINUTE_CODE = "min";

    /**
     * EN: Code for MolePerLiter.<br>
     */
    public static final String MOLEPERLITER_CODE = "mol/L";

    /**
     * EN: Code for Month.<br>
     */
    public static final String MONTH_CODE = "mo";

    /**
     * EN: Code for NanoGram.<br>
     */
    public static final String NANOGRAM_CODE = "ng";

    /**
     * EN: Code for NanoGramsPerLiter.<br>
     */
    public static final String NANOGRAMSPERLITER_CODE = "ng/L";

    /**
     * EN: Code for NanoMolesPerLiter.<br>
     */
    public static final String NANOMOLESPERLITER_CODE = "nmol/L";

    /**
     * EN: Code for Packungsbeutel.<br>
     */
    public static final String PACKUNGSBEUTEL_CODE = "{Packungsbeutel}";

    /**
     * EN: Code for Packung(en).<br>
     */
    public static final String PACKUNG_EN_CODE = "{Packung}";

    /**
     * EN: Code for Percent.<br>
     */
    public static final String PERCENT_CODE = "%";

    /**
     * EN: Code for PerDay.<br>
     */
    public static final String PERDAY_CODE = "/d";

    /**
     * EN: Code for PerGram.<br>
     */
    public static final String PERGRAM_CODE = "/g";

    /**
     * EN: Code for PerHour.<br>
     */
    public static final String PERHOUR_CODE = "/h";

    /**
     * EN: Code for PerKiloGram.<br>
     */
    public static final String PERKILOGRAM_CODE = "/kg";

    /**
     * EN: Code for PerKiloGramBodyWeight.<br>
     */
    public static final String PERKILOGRAMBODYWEIGHT_CODE = "/kg{body`wt}";

    /**
     * EN: Code for PerMinute.<br>
     */
    public static final String PERMINUTE_CODE = "/min";

    /**
     * EN: Code for PerSecond.<br>
     */
    public static final String PERSECOND_CODE = "/s";

    /**
     * EN: Code for pH.<br>
     */
    public static final String PH_CODE = "[pH]";

    /**
     * EN: Code for Second.<br>
     */
    public static final String SECOND_CODE = "s";

    /**
     * EN: Code for SquareCentimeter.<br>
     */
    public static final String SQUARECENTIMETER_CODE = "cm2";

    /**
     * EN: Code for SquareMeter.<br>
     */
    public static final String SQUAREMETER_CODE = "m2";

    /**
     * EN: Code for SquareMilliMeter.<br>
     */
    public static final String SQUAREMILLIMETER_CODE = "mm2";

    /**
     * EN: Code for Stück.<br>
     */
    public static final String ST_CK_CODE = "{Stueck}";

    /**
     * EN: Code for Teelöffel.<br>
     */
    public static final String TEEL_FFEL_CODE = "{Teeloeffel}";

    /**
     * EN: Code for Tropfen.<br>
     */
    public static final String TROPFEN_CODE = "{Tropfen}";

    /**
     * EN: Code for Unit.<br>
     */
    public static final String UNIT_CODE = "1";

    /**
     * EN: Code for Week.<br>
     */
    public static final String WEEK_CODE = "wk";

    /**
     * EN: Code for Year.<br>
     */
    public static final String YEAR_CODE = "a";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.32";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_MedikationMengenart_VS";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.8";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaMedikationMengenartVs getEnum(@Nullable final String code) {
        for (final ElgaMedikationMengenartVs x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaMedikationMengenartVs.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaMedikationMengenartVs x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaMedikationMengenartVs(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
