/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_Laborstruktur values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.47<br>
 * Effective date: 2018-01-18 00:00<br>
 * Version: 4.3<br>
 * Status: FINAL
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-03-01")
public enum ElgaLaborstruktur implements ValueSetEnumInterface {

    /**
     * EN: Allergiechip IgE.<br>
     */
    ALLERGIECHIP_IGE_L2("12080",
                        "1.2.40.0.34.5.11",
                        "Allergiechip IgE",
                        "Allergiechip IgE",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Allergiediagnostik.<br>
     */
    ALLERGIEDIAGNOSTIK_L1("1800",
                          "1.2.40.0.34.5.11",
                          "Allergiediagnostik",
                          "Allergiediagnostik",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Allgemeiner Laborbefund.<br>
     */
    ALLGEMEINER_LABORBEFUND("1",
                            "1.2.40.0.34.5.11",
                            "Allgemeiner Laborbefund",
                            "Allgemeiner Laborbefund",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Antibiotika.<br>
     */
    ANTIBIOTIKA_L2("08260",
                   "1.2.40.0.34.5.11",
                   "Antibiotika",
                   "Antibiotika",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Antiepileptika.<br>
     */
    ANTIEPILEPTIKA_L2("08280",
                      "1.2.40.0.34.5.11",
                      "Antiepileptika",
                      "Antiepileptika",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Autoimmundiagnostik.<br>
     */
    AUTOIMMUNDIAGNOSTIK_L1("1300",
                           "1.2.40.0.34.5.11",
                           "Autoimmundiagnostik",
                           "Autoimmundiagnostik",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Bakteriologie.<br>
     */
    BAKTERIOLOGIE_L2("10790",
                     "1.2.40.0.34.5.11",
                     "Bakteriologie",
                     "Bakteriologie",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Befundbewertung.<br>
     */
    BEFUNDBEWERTUNG_L1("20",
                       "1.2.40.0.34.5.11",
                       "Befundbewertung",
                       "Befundbewertung",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: BGA Sonstiges.<br>
     */
    BGA_SONSTIGES_L2("02130",
                     "1.2.40.0.34.5.11",
                     "BGA Sonstiges",
                     "BGA Sonstiges",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Blutbild.<br>
     */
    BLUTBILD_L2("03010",
                "1.2.40.0.34.5.11",
                "Blutbild",
                "Blutbild",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Blutgasanalyse arteriell.<br>
     */
    BLUTGASANALYSE_ARTERIELL_L2("02060",
                                "1.2.40.0.34.5.11",
                                "Blutgasanalyse arteriell",
                                "Blutgasanalyse arteriell",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Blutgasanalyse kapillär.<br>
     */
    BLUTGASANALYSE_KAPILL_R_L2("02100",
                               "1.2.40.0.34.5.11",
                               "Blutgasanalyse kapillär",
                               "Blutgasanalyse kapillär",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Blutgasanalyse venös.<br>
     */
    BLUTGASANALYSE_VEN_S_L2("02080",
                            "1.2.40.0.34.5.11",
                            "Blutgasanalyse venös",
                            "Blutgasanalyse venös",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Blutgasanalytik.<br>
     */
    BLUTGASANALYTIK_L1("200",
                       "1.2.40.0.34.5.11",
                       "Blutgasanalytik",
                       "Blutgasanalytik",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Blutgruppenserologie.<br>
     */
    BLUTGRUPPENSEROLOGIE_L1("100",
                            "1.2.40.0.34.5.11",
                            "Blutgruppenserologie",
                            "Blutgruppenserologie",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Blutgruppenserologie.<br>
     */
    BLUTGRUPPENSEROLOGIE_L2("01850",
                            "1.2.40.0.34.5.11",
                            "Blutgruppenserologie",
                            "Blutgruppenserologie",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Blut.<br>
     */
    BLUT_L2("07240",
            "1.2.40.0.34.5.11",
            "Blut",
            "Blut",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Diabetes Mellitus assoziierte Autoantikörper.<br>
     */
    DIABETES_MELLITUS_ASSOZIIERTE_AUTOANTIK_RPER_L2("11450",
                                                    "1.2.40.0.34.5.11",
                                                    "Diabetes Mellitus assoziierte Autoantikörper",
                                                    "Diabetes Mellitus assoziierte Autoantikörper",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Einzelfaktoranalysen.<br>
     */
    EINZELFAKTORANALYSEN_L2("04150",
                            "1.2.40.0.34.5.11",
                            "Einzelfaktoranalysen",
                            "Einzelfaktoranalysen",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Genetische Diagnostik.<br>
     */
    GENETISCHE_DIAGNOSTIK_L1("2300",
                             "1.2.40.0.34.5.11",
                             "Genetische Diagnostik",
                             "Genetische Diagnostik",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Gerinnung/Hämostaseologie.<br>
     */
    GERINNUNG_H_MOSTASEOLOGIE_L1("400",
                                 "1.2.40.0.34.5.11",
                                 "Gerinnung/Hämostaseologie",
                                 "Gerinnung/Hämostaseologie",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Gerinnung Sonstiges.<br>
     */
    GERINNUNG_SONSTIGES_L2("04170",
                           "1.2.40.0.34.5.11",
                           "Gerinnung Sonstiges",
                           "Gerinnung Sonstiges",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Globalmarker.<br>
     */
    GLOBALMARKER_L2("12010",
                    "1.2.40.0.34.5.11",
                    "Globalmarker",
                    "Globalmarker",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Goodpasture Syndrom assoziierte Autoantikörper.<br>
     */
    GOODPASTURE_SYNDROM_ASSOZIIERTE_AUTOANTIK_RPER_L2("11420",
                                                      "1.2.40.0.34.5.11",
                                                      "Goodpasture Syndrom assoziierte Autoantikörper",
                                                      "Goodpasture Syndrom assoziierte Autoantikörper",
                                                      "TOTRANSLATE",
                                                      "TOTRANSLATE",
                                                      "TOTRANSLATE"),
    /**
     * EN: Hb-Derivate arteriell.<br>
     */
    HB_DERIVATE_ARTERIELL_L2("02070",
                             "1.2.40.0.34.5.11",
                             "Hb-Derivate arteriell",
                             "Hb-Derivate arteriell",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Hb-Derivate, gemischtvenös (Rechtsherzkatheter).<br>
     */
    HB_DERIVATE_GEMISCHTVEN_S_RECHTSHERZKATHETER_L2("02120",
                                                    "1.2.40.0.34.5.11",
                                                    "Hb-Derivate, gemischtvenös (Rechtsherzkatheter)",
                                                    "Hb-Derivate, gemischtvenös (Rechtsherzkatheter)",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Hb-Derivate kapillär.<br>
     */
    HB_DERIVATE_KAPILL_R_L2("02110",
                            "1.2.40.0.34.5.11",
                            "Hb-Derivate kapillär",
                            "Hb-Derivate kapillär",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Hb-Derivate venös.<br>
     */
    HB_DERIVATE_VEN_S_L2("02090",
                         "1.2.40.0.34.5.11",
                         "Hb-Derivate venös",
                         "Hb-Derivate venös",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: HLA-Diagnostik.<br>
     */
    HLA_DIAGNOSTIK_L2("01860",
                      "1.2.40.0.34.5.11",
                      "HLA-Diagnostik",
                      "HLA-Diagnostik",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Hormone.<br>
     */
    HORMONE_L2("06330",
               "1.2.40.0.34.5.11",
               "Hormone",
               "Hormone",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Hormone/Vitamine/Tumormarker.<br>
     */
    HORMONE_VITAMINE_TUMORMARKER_L1("600",
                                    "1.2.40.0.34.5.11",
                                    "Hormone/Vitamine/Tumormarker",
                                    "Hormone/Vitamine/Tumormarker",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: HPA-Diagnostik.<br>
     */
    HPA_DIAGNOSTIK_L2("01870",
                      "1.2.40.0.34.5.11",
                      "HPA-Diagnostik",
                      "HPA-Diagnostik",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Humangenetik.<br>
     */
    HUMANGENETIK_L2("16840",
                    "1.2.40.0.34.5.11",
                    "Humangenetik",
                    "Humangenetik",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Hämatologie.<br>
     */
    H_MATOLOGIE_L1("300",
                   "1.2.40.0.34.5.11",
                   "Hämatologie",
                   "Hämatologie",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Hämatologie Sonstiges.<br>
     */
    H_MATOLOGIE_SONSTIGES_L2("03050",
                             "1.2.40.0.34.5.11",
                             "Hämatologie Sonstiges",
                             "Hämatologie Sonstiges",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Hämatologische Genetik.<br>
     */
    H_MATOLOGISCHE_GENETIK_L2("16841",
                              "1.2.40.0.34.5.11",
                              "Hämatologische Genetik",
                              "Hämatologische Genetik",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Hämostaseologie Globaltests.<br>
     */
    H_MOSTASEOLOGIE_GLOBALTESTS_L2("04140",
                                   "1.2.40.0.34.5.11",
                                   "Hämostaseologie Globaltests",
                                   "Hämostaseologie Globaltests",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: IBD assoziierte Autoantikörper.<br>
     */
    IBD_ASSOZIIERTE_AUTOANTIK_RPER_L2("11430",
                                      "1.2.40.0.34.5.11",
                                      "IBD assoziierte Autoantikörper",
                                      "IBD assoziierte Autoantikörper",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: IgG Antigene.<br>
     */
    IGG_ANTIGENE_L2("12090",
                    "1.2.40.0.34.5.11",
                    "IgG Antigene",
                    "IgG Antigene",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Immunphänotypisierung.<br>
     */
    IMMUNPH_NOTYPISIERUNG_L2("03030",
                             "1.2.40.0.34.5.11",
                             "Immunphänotypisierung",
                             "Immunphänotypisierung",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Immunsuppressiva.<br>
     */
    IMMUNSUPPRESSIVA_L2("08310",
                        "1.2.40.0.34.5.11",
                        "Immunsuppressiva",
                        "Immunsuppressiva",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Infektionsdiagnostik.<br>
     */
    INFEKTIONSDIAGNOSTIK_L1("1100",
                            "1.2.40.0.34.5.11",
                            "Infektionsdiagnostik",
                            "Infektionsdiagnostik",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Inhalationsallergene IgE.<br>
     */
    INHALATIONSALLERGENE_IGE_L2("12020",
                                "1.2.40.0.34.5.11",
                                "Inhalationsallergene IgE",
                                "Inhalationsallergene IgE",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Insekten und Insektengifte IgE.<br>
     */
    INSEKTEN_UND_INSEKTENGIFTE_IGE_L2("12060",
                                      "1.2.40.0.34.5.11",
                                      "Insekten und Insektengifte IgE",
                                      "Insekten und Insektengifte IgE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Kardiaka.<br>
     */
    KARDIAKA_L2("08300",
                "1.2.40.0.34.5.11",
                "Kardiaka",
                "Kardiaka",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Klinische Chemie.<br>
     */
    KLINISCHE_CHEMIE_L2("05180",
                        "1.2.40.0.34.5.11",
                        "Klinische Chemie",
                        "Klinische Chemie",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Klinische Chemie/Proteindiagnostik.<br>
     */
    KLINISCHE_CHEMIE_PROTEINDIAGNOSTIK_L1("500",
                                          "1.2.40.0.34.5.11",
                                          "Klinische Chemie/Proteindiagnostik",
                                          "Klinische Chemie/Proteindiagnostik",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Knochenmark Morphologie.<br>
     */
    KNOCHENMARK_MORPHOLOGIE_L2("03020",
                               "1.2.40.0.34.5.11",
                               "Knochenmark Morphologie",
                               "Knochenmark Morphologie",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Kollagenose-assoziierte Autoantikörper.<br>
     */
    KOLLAGENOSE_ASSOZIIERTE_AUTOANTIK_RPER_L2("11370",
                                              "1.2.40.0.34.5.11",
                                              "Kollagenose-assoziierte Autoantikörper",
                                              "Kollagenose-assoziierte Autoantikörper",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Lebererkrankungen-assoziierte Autoantikörper.<br>
     */
    LEBERERKRANKUNGEN_ASSOZIIERTE_AUTOANTIK_RPER_L2("11390",
                                                    "1.2.40.0.34.5.11",
                                                    "Lebererkrankungen-assoziierte Autoantikörper",
                                                    "Lebererkrankungen-assoziierte Autoantikörper",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Liquordiagnostik.<br>
     */
    LIQUORDIAGNOSTIK_L1("1600",
                        "1.2.40.0.34.5.11",
                        "Liquordiagnostik",
                        "Liquordiagnostik",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Liquordiagnostik.<br>
     */
    LIQUORDIAGNOSTIK_L2("15770",
                        "1.2.40.0.34.5.11",
                        "Liquordiagnostik",
                        "Liquordiagnostik",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Makroskopie/Mikroskopie.<br>
     */
    MAKROSKOPIE_MIKROSKOPIE_L2("10820",
                               "1.2.40.0.34.5.11",
                               "Makroskopie/Mikroskopie",
                               "Makroskopie/Mikroskopie",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Medikamente IgE.<br>
     */
    MEDIKAMENTE_IGE_L2("12050",
                       "1.2.40.0.34.5.11",
                       "Medikamente IgE",
                       "Medikamente IgE",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Medikamente.<br>
     */
    MEDIKAMENTE_L1("1000",
                   "1.2.40.0.34.5.11",
                   "Medikamente",
                   "Medikamente",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Medikamente Sonstiges.<br>
     */
    MEDIKAMENTE_SONSTIGES_L2("08320",
                             "1.2.40.0.34.5.11",
                             "Medikamente Sonstiges",
                             "Medikamente Sonstiges",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Mykologie.<br>
     */
    MYKOLOGIE_L2("10800",
                 "1.2.40.0.34.5.11",
                 "Mykologie",
                 "Mykologie",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Myositis-assoziierte Autoantikörper.<br>
     */
    MYOSITIS_ASSOZIIERTE_AUTOANTIK_RPER_L2("11380",
                                           "1.2.40.0.34.5.11",
                                           "Myositis-assoziierte Autoantikörper",
                                           "Myositis-assoziierte Autoantikörper",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Nahrungsmittelallergene IgE.<br>
     */
    NAHRUNGSMITTELALLERGENE_IGE_L2("12030",
                                   "1.2.40.0.34.5.11",
                                   "Nahrungsmittelallergene IgE",
                                   "Nahrungsmittelallergene IgE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Paraneoplasie assoziierte Autoantikörper.<br>
     */
    PARANEOPLASIE_ASSOZIIERTE_AUTOANTIK_RPER_L2("11460",
                                                "1.2.40.0.34.5.11",
                                                "Paraneoplasie assoziierte Autoantikörper",
                                                "Paraneoplasie assoziierte Autoantikörper",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Parasitologie.<br>
     */
    PARASITOLOGIE_L2("10810",
                     "1.2.40.0.34.5.11",
                     "Parasitologie",
                     "Parasitologie",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Perniziöse Anämie assoziierte Autoantikörper.<br>
     */
    PERNIZI_SE_AN_MIE_ASSOZIIERTE_AUTOANTIK_RPER_L2("11400",
                                                    "1.2.40.0.34.5.11",
                                                    "Perniziöse Anämie assoziierte Autoantikörper",
                                                    "Perniziöse Anämie assoziierte Autoantikörper",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Pharmakogenetik.<br>
     */
    PHARMAKOGENETIK_L2("16830",
                       "1.2.40.0.34.5.11",
                       "Pharmakogenetik",
                       "Pharmakogenetik",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Probeninformation.<br>
     */
    PROBENINFORMATION_L1("10",
                         "1.2.40.0.34.5.11",
                         "Probeninformation",
                         "Probeninformation",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Proteindiagnostik.<br>
     */
    PROTEINDIAGNOSTIK_L2("05190",
                         "1.2.40.0.34.5.11",
                         "Proteindiagnostik",
                         "Proteindiagnostik",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Psychopharmaka.<br>
     */
    PSYCHOPHARMAKA_L2("08290",
                      "1.2.40.0.34.5.11",
                      "Psychopharmaka",
                      "Psychopharmaka",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Rheumatoide Arthritis-assoziierte Autoantikörper.<br>
     */
    RHEUMATOIDE_ARTHRITIS_ASSOZIIERTE_AUTOANTIK_RPER_L2("11360",
                                                        "1.2.40.0.34.5.11",
                                                        "Rheumatoide Arthritis-assoziierte Autoantikörper",
                                                        "Rheumatoide Arthritis-assoziierte Autoantikörper",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE"),
    /**
     * EN: Sondermaterialien.<br>
     */
    SONDERMATERIALIEN_L2("05210",
                         "1.2.40.0.34.5.11",
                         "Sondermaterialien",
                         "Sondermaterialien",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Sonstige Autoantikörper.<br>
     */
    SONSTIGE_AUTOANTIK_RPER_L2("11470",
                               "1.2.40.0.34.5.11",
                               "Sonstige Autoantikörper",
                               "Sonstige Autoantikörper",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Sonstige IgE.<br>
     */
    SONSTIGE_IGE_L2("12070",
                    "1.2.40.0.34.5.11",
                    "Sonstige IgE",
                    "Sonstige IgE",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Sonstige.<br>
     */
    SONSTIGE_L1("2500",
                "1.2.40.0.34.5.11",
                "Sonstige",
                "Sonstige",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Sonstige.<br>
     */
    SONSTIGE_L2("17890",
                "1.2.40.0.34.5.11",
                "Sonstige",
                "Sonstige",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Spurenelemente.<br>
     */
    SPURENELEMENTE_L2("05200",
                      "1.2.40.0.34.5.11",
                      "Spurenelemente",
                      "Spurenelemente",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Stuhldiagnostik.<br>
     */
    STUHLDIAGNOSTIK_L1("1500",
                       "1.2.40.0.34.5.11",
                       "Stuhldiagnostik",
                       "Stuhldiagnostik",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Stuhldiagnostik.<br>
     */
    STUHLDIAGNOSTIK_L2("14760",
                       "1.2.40.0.34.5.11",
                       "Stuhldiagnostik",
                       "Stuhldiagnostik",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Thrombophilie Tests.<br>
     */
    THROMBOPHILIE_TESTS_L2("04160",
                           "1.2.40.0.34.5.11",
                           "Thrombophilie Tests",
                           "Thrombophilie Tests",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Toxikologie.<br>
     */
    TOXIKOLOGIE_L1("900",
                   "1.2.40.0.34.5.11",
                   "Toxikologie",
                   "Toxikologie",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Toxikologie Sonstiges.<br>
     */
    TOXIKOLOGIE_SONSTIGES_L2("07250",
                             "1.2.40.0.34.5.11",
                             "Toxikologie Sonstiges",
                             "Toxikologie Sonstiges",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Tumormarker.<br>
     */
    TUMORMARKER_L2("06350",
                   "1.2.40.0.34.5.11",
                   "Tumormarker",
                   "Tumormarker",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Umwelt- und Berufsallergene IgE.<br>
     */
    UMWELT_UND_BERUFSALLERGENE_IGE_L2("12040",
                                      "1.2.40.0.34.5.11",
                                      "Umwelt- und Berufsallergene IgE",
                                      "Umwelt- und Berufsallergene IgE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Unters. bei Stoffwechselerkrankungen.<br>
     */
    UNTERS_BEI_STOFFWECHSELERKRANKUNGEN_L2("05220",
                                           "1.2.40.0.34.5.11",
                                           "Unters. bei Stoffwechselerkrankungen",
                                           "Unters. bei Stoffwechselerkrankungen",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Urinchemie.<br>
     */
    URINCHEMIE_L2("13750",
                  "1.2.40.0.34.5.11",
                  "Urinchemie",
                  "Urinchemie",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Urindiagnostik.<br>
     */
    URINDIAGNOSTIK_L1("1400",
                      "1.2.40.0.34.5.11",
                      "Urindiagnostik",
                      "Urindiagnostik",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Urinsediment.<br>
     */
    URINSEDIMENT_L2("13740",
                    "1.2.40.0.34.5.11",
                    "Urinsediment",
                    "Urinsediment",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Urinstreifen.<br>
     */
    URINSTREIFEN_L2("13730",
                    "1.2.40.0.34.5.11",
                    "Urinstreifen",
                    "Urinstreifen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Urin-Screening.<br>
     */
    URIN_SCREENING_L2("07230",
                      "1.2.40.0.34.5.11",
                      "Urin-Screening",
                      "Urin-Screening",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Vasculitis-assoziierte Antikörper.<br>
     */
    VASCULITIS_ASSOZIIERTE_ANTIK_RPER_L2("11410",
                                         "1.2.40.0.34.5.11",
                                         "Vasculitis-assoziierte Antikörper",
                                         "Vasculitis-assoziierte Antikörper",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Virologie.<br>
     */
    VIROLOGIE_L2("10780",
                 "1.2.40.0.34.5.11",
                 "Virologie",
                 "Virologie",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Virostatika.<br>
     */
    VIROSTATIKA_L2("08270",
                   "1.2.40.0.34.5.11",
                   "Virostatika",
                   "Virostatika",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Vitamine.<br>
     */
    VITAMINE_L2("06340",
                "1.2.40.0.34.5.11",
                "Vitamine",
                "Vitamine",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Zytologie.<br>
     */
    ZYTOLOGIE_L2("17880",
                 "1.2.40.0.34.5.11",
                 "Zytologie",
                 "Zytologie",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Zöliakie assoziierte Autoantikörper.<br>
     */
    Z_LIAKIE_ASSOZIIERTE_AUTOANTIK_RPER_L2("11440",
                                           "1.2.40.0.34.5.11",
                                           "Zöliakie assoziierte Autoantikörper",
                                           "Zöliakie assoziierte Autoantikörper",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE");

    /**
     * EN: Code for Allergiechip IgE.<br>
     */
    public static final String ALLERGIECHIP_IGE_L2_CODE = "12080";

    /**
     * EN: Code for Allergiediagnostik.<br>
     */
    public static final String ALLERGIEDIAGNOSTIK_L1_CODE = "1800";

    /**
     * EN: Code for Allgemeiner Laborbefund.<br>
     */
    public static final String ALLGEMEINER_LABORBEFUND_CODE = "1";

    /**
     * EN: Code for Antibiotika.<br>
     */
    public static final String ANTIBIOTIKA_L2_CODE = "08260";

    /**
     * EN: Code for Antiepileptika.<br>
     */
    public static final String ANTIEPILEPTIKA_L2_CODE = "08280";

    /**
     * EN: Code for Autoimmundiagnostik.<br>
     */
    public static final String AUTOIMMUNDIAGNOSTIK_L1_CODE = "1300";

    /**
     * EN: Code for Bakteriologie.<br>
     */
    public static final String BAKTERIOLOGIE_L2_CODE = "10790";

    /**
     * EN: Code for Befundbewertung.<br>
     */
    public static final String BEFUNDBEWERTUNG_L1_CODE = "20";

    /**
     * EN: Code for BGA Sonstiges.<br>
     */
    public static final String BGA_SONSTIGES_L2_CODE = "02130";

    /**
     * EN: Code for Blutbild.<br>
     */
    public static final String BLUTBILD_L2_CODE = "03010";

    /**
     * EN: Code for Blutgasanalyse arteriell.<br>
     */
    public static final String BLUTGASANALYSE_ARTERIELL_L2_CODE = "02060";

    /**
     * EN: Code for Blutgasanalyse kapillär.<br>
     */
    public static final String BLUTGASANALYSE_KAPILL_R_L2_CODE = "02100";

    /**
     * EN: Code for Blutgasanalyse venös.<br>
     */
    public static final String BLUTGASANALYSE_VEN_S_L2_CODE = "02080";

    /**
     * EN: Code for Blutgasanalytik.<br>
     */
    public static final String BLUTGASANALYTIK_L1_CODE = "200";

    /**
     * EN: Code for Blutgruppenserologie.<br>
     */
    public static final String BLUTGRUPPENSEROLOGIE_L1_CODE = "100";

    /**
     * EN: Code for Blutgruppenserologie.<br>
     */
    public static final String BLUTGRUPPENSEROLOGIE_L2_CODE = "01850";

    /**
     * EN: Code for Blut.<br>
     */
    public static final String BLUT_L2_CODE = "07240";

    /**
     * EN: Code for Diabetes Mellitus assoziierte Autoantikörper.<br>
     */
    public static final String DIABETES_MELLITUS_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11450";

    /**
     * EN: Code for Einzelfaktoranalysen.<br>
     */
    public static final String EINZELFAKTORANALYSEN_L2_CODE = "04150";

    /**
     * EN: Code for Genetische Diagnostik.<br>
     */
    public static final String GENETISCHE_DIAGNOSTIK_L1_CODE = "2300";

    /**
     * EN: Code for Gerinnung/Hämostaseologie.<br>
     */
    public static final String GERINNUNG_H_MOSTASEOLOGIE_L1_CODE = "400";

    /**
     * EN: Code for Gerinnung Sonstiges.<br>
     */
    public static final String GERINNUNG_SONSTIGES_L2_CODE = "04170";

    /**
     * EN: Code for Globalmarker.<br>
     */
    public static final String GLOBALMARKER_L2_CODE = "12010";

    /**
     * EN: Code for Goodpasture Syndrom assoziierte Autoantikörper.<br>
     */
    public static final String GOODPASTURE_SYNDROM_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11420";

    /**
     * EN: Code for Hb-Derivate arteriell.<br>
     */
    public static final String HB_DERIVATE_ARTERIELL_L2_CODE = "02070";

    /**
     * EN: Code for Hb-Derivate, gemischtvenös (Rechtsherzkatheter).<br>
     */
    public static final String HB_DERIVATE_GEMISCHTVEN_S_RECHTSHERZKATHETER_L2_CODE = "02120";

    /**
     * EN: Code for Hb-Derivate kapillär.<br>
     */
    public static final String HB_DERIVATE_KAPILL_R_L2_CODE = "02110";

    /**
     * EN: Code for Hb-Derivate venös.<br>
     */
    public static final String HB_DERIVATE_VEN_S_L2_CODE = "02090";

    /**
     * EN: Code for HLA-Diagnostik.<br>
     */
    public static final String HLA_DIAGNOSTIK_L2_CODE = "01860";

    /**
     * EN: Code for Hormone.<br>
     */
    public static final String HORMONE_L2_CODE = "06330";

    /**
     * EN: Code for Hormone/Vitamine/Tumormarker.<br>
     */
    public static final String HORMONE_VITAMINE_TUMORMARKER_L1_CODE = "600";

    /**
     * EN: Code for HPA-Diagnostik.<br>
     */
    public static final String HPA_DIAGNOSTIK_L2_CODE = "01870";

    /**
     * EN: Code for Humangenetik.<br>
     */
    public static final String HUMANGENETIK_L2_CODE = "16840";

    /**
     * EN: Code for Hämatologie.<br>
     */
    public static final String H_MATOLOGIE_L1_CODE = "300";

    /**
     * EN: Code for Hämatologie Sonstiges.<br>
     */
    public static final String H_MATOLOGIE_SONSTIGES_L2_CODE = "03050";

    /**
     * EN: Code for Hämatologische Genetik.<br>
     */
    public static final String H_MATOLOGISCHE_GENETIK_L2_CODE = "16841";

    /**
     * EN: Code for Hämostaseologie Globaltests.<br>
     */
    public static final String H_MOSTASEOLOGIE_GLOBALTESTS_L2_CODE = "04140";

    /**
     * EN: Code for IBD assoziierte Autoantikörper.<br>
     */
    public static final String IBD_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11430";

    /**
     * EN: Code for IgG Antigene.<br>
     */
    public static final String IGG_ANTIGENE_L2_CODE = "12090";

    /**
     * EN: Code for Immunphänotypisierung.<br>
     */
    public static final String IMMUNPH_NOTYPISIERUNG_L2_CODE = "03030";

    /**
     * EN: Code for Immunsuppressiva.<br>
     */
    public static final String IMMUNSUPPRESSIVA_L2_CODE = "08310";

    /**
     * EN: Code for Infektionsdiagnostik.<br>
     */
    public static final String INFEKTIONSDIAGNOSTIK_L1_CODE = "1100";

    /**
     * EN: Code for Inhalationsallergene IgE.<br>
     */
    public static final String INHALATIONSALLERGENE_IGE_L2_CODE = "12020";

    /**
     * EN: Code for Insekten und Insektengifte IgE.<br>
     */
    public static final String INSEKTEN_UND_INSEKTENGIFTE_IGE_L2_CODE = "12060";

    /**
     * EN: Code for Kardiaka.<br>
     */
    public static final String KARDIAKA_L2_CODE = "08300";

    /**
     * EN: Code for Klinische Chemie.<br>
     */
    public static final String KLINISCHE_CHEMIE_L2_CODE = "05180";

    /**
     * EN: Code for Klinische Chemie/Proteindiagnostik.<br>
     */
    public static final String KLINISCHE_CHEMIE_PROTEINDIAGNOSTIK_L1_CODE = "500";

    /**
     * EN: Code for Knochenmark Morphologie.<br>
     */
    public static final String KNOCHENMARK_MORPHOLOGIE_L2_CODE = "03020";

    /**
     * EN: Code for Kollagenose-assoziierte Autoantikörper.<br>
     */
    public static final String KOLLAGENOSE_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11370";

    /**
     * EN: Code for Lebererkrankungen-assoziierte Autoantikörper.<br>
     */
    public static final String LEBERERKRANKUNGEN_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11390";

    /**
     * EN: Code for Liquordiagnostik.<br>
     */
    public static final String LIQUORDIAGNOSTIK_L1_CODE = "1600";

    /**
     * EN: Code for Liquordiagnostik.<br>
     */
    public static final String LIQUORDIAGNOSTIK_L2_CODE = "15770";

    /**
     * EN: Code for Makroskopie/Mikroskopie.<br>
     */
    public static final String MAKROSKOPIE_MIKROSKOPIE_L2_CODE = "10820";

    /**
     * EN: Code for Medikamente IgE.<br>
     */
    public static final String MEDIKAMENTE_IGE_L2_CODE = "12050";

    /**
     * EN: Code for Medikamente.<br>
     */
    public static final String MEDIKAMENTE_L1_CODE = "1000";

    /**
     * EN: Code for Medikamente Sonstiges.<br>
     */
    public static final String MEDIKAMENTE_SONSTIGES_L2_CODE = "08320";

    /**
     * EN: Code for Mykologie.<br>
     */
    public static final String MYKOLOGIE_L2_CODE = "10800";

    /**
     * EN: Code for Myositis-assoziierte Autoantikörper.<br>
     */
    public static final String MYOSITIS_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11380";

    /**
     * EN: Code for Nahrungsmittelallergene IgE.<br>
     */
    public static final String NAHRUNGSMITTELALLERGENE_IGE_L2_CODE = "12030";

    /**
     * EN: Code for Paraneoplasie assoziierte Autoantikörper.<br>
     */
    public static final String PARANEOPLASIE_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11460";

    /**
     * EN: Code for Parasitologie.<br>
     */
    public static final String PARASITOLOGIE_L2_CODE = "10810";

    /**
     * EN: Code for Perniziöse Anämie assoziierte Autoantikörper.<br>
     */
    public static final String PERNIZI_SE_AN_MIE_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11400";

    /**
     * EN: Code for Pharmakogenetik.<br>
     */
    public static final String PHARMAKOGENETIK_L2_CODE = "16830";

    /**
     * EN: Code for Probeninformation.<br>
     */
    public static final String PROBENINFORMATION_L1_CODE = "10";

    /**
     * EN: Code for Proteindiagnostik.<br>
     */
    public static final String PROTEINDIAGNOSTIK_L2_CODE = "05190";

    /**
     * EN: Code for Psychopharmaka.<br>
     */
    public static final String PSYCHOPHARMAKA_L2_CODE = "08290";

    /**
     * EN: Code for Rheumatoide Arthritis-assoziierte Autoantikörper.<br>
     */
    public static final String RHEUMATOIDE_ARTHRITIS_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11360";

    /**
     * EN: Code for Sondermaterialien.<br>
     */
    public static final String SONDERMATERIALIEN_L2_CODE = "05210";

    /**
     * EN: Code for Sonstige Autoantikörper.<br>
     */
    public static final String SONSTIGE_AUTOANTIK_RPER_L2_CODE = "11470";

    /**
     * EN: Code for Sonstige IgE.<br>
     */
    public static final String SONSTIGE_IGE_L2_CODE = "12070";

    /**
     * EN: Code for Sonstige.<br>
     */
    public static final String SONSTIGE_L1_CODE = "2500";

    /**
     * EN: Code for Sonstige.<br>
     */
    public static final String SONSTIGE_L2_CODE = "17890";

    /**
     * EN: Code for Spurenelemente.<br>
     */
    public static final String SPURENELEMENTE_L2_CODE = "05200";

    /**
     * EN: Code for Stuhldiagnostik.<br>
     */
    public static final String STUHLDIAGNOSTIK_L1_CODE = "1500";

    /**
     * EN: Code for Stuhldiagnostik.<br>
     */
    public static final String STUHLDIAGNOSTIK_L2_CODE = "14760";

    /**
     * EN: Code for Thrombophilie Tests.<br>
     */
    public static final String THROMBOPHILIE_TESTS_L2_CODE = "04160";

    /**
     * EN: Code for Toxikologie.<br>
     */
    public static final String TOXIKOLOGIE_L1_CODE = "900";

    /**
     * EN: Code for Toxikologie Sonstiges.<br>
     */
    public static final String TOXIKOLOGIE_SONSTIGES_L2_CODE = "07250";

    /**
     * EN: Code for Tumormarker.<br>
     */
    public static final String TUMORMARKER_L2_CODE = "06350";

    /**
     * EN: Code for Umwelt- und Berufsallergene IgE.<br>
     */
    public static final String UMWELT_UND_BERUFSALLERGENE_IGE_L2_CODE = "12040";

    /**
     * EN: Code for Unters. bei Stoffwechselerkrankungen.<br>
     */
    public static final String UNTERS_BEI_STOFFWECHSELERKRANKUNGEN_L2_CODE = "05220";

    /**
     * EN: Code for Urinchemie.<br>
     */
    public static final String URINCHEMIE_L2_CODE = "13750";

    /**
     * EN: Code for Urindiagnostik.<br>
     */
    public static final String URINDIAGNOSTIK_L1_CODE = "1400";

    /**
     * EN: Code for Urinsediment.<br>
     */
    public static final String URINSEDIMENT_L2_CODE = "13740";

    /**
     * EN: Code for Urinstreifen.<br>
     */
    public static final String URINSTREIFEN_L2_CODE = "13730";

    /**
     * EN: Code for Urin-Screening.<br>
     */
    public static final String URIN_SCREENING_L2_CODE = "07230";

    /**
     * EN: Code for Vasculitis-assoziierte Antikörper.<br>
     */
    public static final String VASCULITIS_ASSOZIIERTE_ANTIK_RPER_L2_CODE = "11410";

    /**
     * EN: Code for Virologie.<br>
     */
    public static final String VIROLOGIE_L2_CODE = "10780";

    /**
     * EN: Code for Virostatika.<br>
     */
    public static final String VIROSTATIKA_L2_CODE = "08270";

    /**
     * EN: Code for Vitamine.<br>
     */
    public static final String VITAMINE_L2_CODE = "06340";

    /**
     * EN: Code for Zytologie.<br>
     */
    public static final String ZYTOLOGIE_L2_CODE = "17880";

    /**
     * EN: Code for Zöliakie assoziierte Autoantikörper.<br>
     */
    public static final String Z_LIAKIE_ASSOZIIERTE_AUTOANTIK_RPER_L2_CODE = "11440";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.47";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_Laborstruktur";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.11";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaLaborstruktur getEnum(@Nullable final String code) {
        for (final ElgaLaborstruktur x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaLaborstruktur.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaLaborstruktur x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaLaborstruktur(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
