/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_ReligiousAffiliation values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.18<br>
 * Effective date: 2013-11-12 00:00<br>
 * Version: null<br>
 * Status: FINAL
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-03-01")
public enum ElgaReligiousAffiliation implements ValueSetEnumInterface {

    /**
     * EN: Alevitische Religionsgesellschaft.<br>
     */
    ALEVITISCHE_RELIGIONSGESELLSCHAFT_L1("151",
                                         "2.16.840.1.113883.2.16.1.4.1",
                                         "Alevitische Religionsgesellschaft",
                                         "Alevitische Religionsgesellschaft",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Altkatholische Kirche Österreichs.<br>
     */
    ALTKATHOLISCHE_KIRCHE_STERREICHS_L1("131",
                                        "2.16.840.1.113883.2.16.1.4.1",
                                        "Altkatholische Kirche Österreichs",
                                        "Altkatholische Kirche Österreichs",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Andere Christliche Kirchen.<br>
     */
    ANDERE_CHRISTLICHE_KIRCHEN("130",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "Andere Christliche Kirchen",
                               "Andere Christliche Kirchen",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Andere religiöse Bekenntnisgemeinschaften.<br>
     */
    ANDERE_RELIGI_SE_BEKENNTNISGEMEINSCHAFTEN_L1("158",
                                                 "2.16.840.1.113883.2.16.1.4.1",
                                                 "Andere religiöse Bekenntnisgemeinschaften",
                                                 "Andere religiöse Bekenntnisgemeinschaften",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Anglikanische Kirche.<br>
     */
    ANGLIKANISCHE_KIRCHE_L1("132",
                            "2.16.840.1.113883.2.16.1.4.1",
                            "Anglikanische Kirche",
                            "Anglikanische Kirche",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Armenisch-apostolische Kirche.<br>
     */
    ARMENISCH_APOSTOLISCHE_KIRCHE_L1("120",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Armenisch-apostolische Kirche",
                                     "Armenisch-apostolische Kirche",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Armenisch-Katholische Kirche.<br>
     */
    ARMENISCH_KATHOLISCHE_KIRCHE_L1("103",
                                    "2.16.840.1.113883.2.16.1.4.1",
                                    "Armenisch-Katholische Kirche",
                                    "Armenisch-Katholische Kirche",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Baha‘ i.<br>
     */
    BAHA_I_L1("153",
              "2.16.840.1.113883.2.16.1.4.1",
              "Baha‘ i",
              "Baha‘ i",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Baptisten.<br>
     */
    BAPTISTEN_L1("135",
                 "2.16.840.1.113883.2.16.1.4.1",
                 "Baptisten",
                 "Baptisten",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Buddhistische Religionsgesellschaft.<br>
     */
    BUDDHISTISCHE_RELIGIONSGESELLSCHAFT_L1("152",
                                           "2.16.840.1.113883.2.16.1.4.1",
                                           "Buddhistische Religionsgesellschaft",
                                           "Buddhistische Religionsgesellschaft",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Bulgarisch-Katholische Kirche.<br>
     */
    BULGARISCH_KATHOLISCHE_KIRCHE_L1("104",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Bulgarisch-Katholische Kirche",
                                     "Bulgarisch-Katholische Kirche",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Bulgarisch-Orthodoxe Kirche.<br>
     */
    BULGARISCH_ORTHODOXE_KIRCHE_L1("114",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Bulgarisch-Orthodoxe Kirche",
                                   "Bulgarisch-Orthodoxe Kirche",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Bund evangelikaler Gemeinden in Österreich.<br>
     */
    BUND_EVANGELIKALER_GEMEINDEN_IN_STERREICH_L1("136",
                                                 "2.16.840.1.113883.2.16.1.4.1",
                                                 "Bund evangelikaler Gemeinden in Österreich",
                                                 "Bund evangelikaler Gemeinden in Österreich",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Christengemeinschaft.<br>
     */
    CHRISTENGEMEINSCHAFT_L1("140",
                            "2.16.840.1.113883.2.16.1.4.1",
                            "Christengemeinschaft",
                            "Christengemeinschaft",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: ELAIA Christengemeinden.<br>
     */
    ELAIA_CHRISTENGEMEINDEN_L1("145",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "ELAIA Christengemeinden",
                               "ELAIA Christengemeinden",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Evangelische Kirchen Österreich.<br>
     */
    EVANGELISCHE_KIRCHEN_STERREICH("126",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Evangelische Kirchen Österreich",
                                   "Evangelische Kirchen Österreich",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Evangelische Kirche A.B.<br>
     */
    EVANGELISCHE_KIRCHE_A_B_L1("128",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "Evangelische Kirche A.B.",
                               "Evangelische Kirche A.B.",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Evangelische Kirche H.B.<br>
     */
    EVANGELISCHE_KIRCHE_H_B_L1("129",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "Evangelische Kirche H.B.",
                               "Evangelische Kirche H.B.",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Evangelische Kirche (o.n.A.).<br>
     */
    EVANGELISCHE_KIRCHE_O_N_A_L1("127",
                                 "2.16.840.1.113883.2.16.1.4.1",
                                 "Evangelische Kirche (o.n.A.)",
                                 "Evangelische Kirche (o.n.A.)",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Evangelisch-methodistische Kirche (EmK).<br>
     */
    EVANGELISCH_METHODISTISCHE_KIRCHE_EMK_L1("133",
                                             "2.16.840.1.113883.2.16.1.4.1",
                                             "Evangelisch-methodistische Kirche (EmK)",
                                             "Evangelisch-methodistische Kirche (EmK)",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Freie Christengemeinde/Pfingstgemeinde.<br>
     */
    FREIE_CHRISTENGEMEINDE_PFINGSTGEMEINDE_L1("137",
                                              "2.16.840.1.113883.2.16.1.4.1",
                                              "Freie Christengemeinde/Pfingstgemeinde",
                                              "Freie Christengemeinde/Pfingstgemeinde",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Griechisch-Katholische Kirche.<br>
     */
    GRIECHISCH_KATHOLISCHE_KIRCHE_L1("102",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Griechisch-Katholische Kirche",
                                     "Griechisch-Katholische Kirche",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Griechisch-Orientalische Kirchen.<br>
     */
    GRIECHISCH_ORIENTALISCHE_KIRCHEN("110",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Griechisch-Orientalische Kirchen",
                                     "Griechisch-Orientalische Kirchen",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Griechisch-Orthodoxe Kirche (Hl.Dreifaltigkeit).<br>
     */
    GRIECHISCH_ORTHODOXE_KIRCHE_HL_DREIFALTIGKEIT_L1("112",
                                                     "2.16.840.1.113883.2.16.1.4.1",
                                                     "Griechisch-Orthodoxe Kirche (Hl.Dreifaltigkeit)",
                                                     "Griechisch-Orthodoxe Kirche (Hl.Dreifaltigkeit)",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Griechisch-Orthodoxe Kirche (Hl.Georg).<br>
     */
    GRIECHISCH_ORTHODOXE_KIRCHE_HL_GEORG_L1("113",
                                            "2.16.840.1.113883.2.16.1.4.1",
                                            "Griechisch-Orthodoxe Kirche (Hl.Georg)",
                                            "Griechisch-Orthodoxe Kirche (Hl.Georg)",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Hinduistische Religionsgesellschaft.<br>
     */
    HINDUISTISCHE_RELIGIONSGESELLSCHAFT_L1("154",
                                           "2.16.840.1.113883.2.16.1.4.1",
                                           "Hinduistische Religionsgesellschaft",
                                           "Hinduistische Religionsgesellschaft",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Islamische Glaubensgemeinschaft.<br>
     */
    ISLAMISCHE_GLAUBENSGEMEINSCHAFT_L1("150",
                                       "2.16.840.1.113883.2.16.1.4.1",
                                       "Islamische Glaubensgemeinschaft",
                                       "Islamische Glaubensgemeinschaft",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Israelitische Religionsgesellschaft.<br>
     */
    ISRAELITISCHE_RELIGIONSGESELLSCHAFT_L1("149",
                                           "2.16.840.1.113883.2.16.1.4.1",
                                           "Israelitische Religionsgesellschaft",
                                           "Israelitische Religionsgesellschaft",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Jehovas Zeugen.<br>
     */
    JEHOVAS_ZEUGEN_L1("141",
                      "2.16.840.1.113883.2.16.1.4.1",
                      "Jehovas Zeugen",
                      "Jehovas Zeugen",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Katholische Kirche (o.n.A.).<br>
     */
    KATHOLISCHE_KIRCHE_O_N_A("100",
                             "2.16.840.1.113883.2.16.1.4.1",
                             "Katholische Kirche (o.n.A.)",
                             "Katholische Kirche (o.n.A.)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Katholische Ostkirche (ohne nähere Angabe).<br>
     */
    KATHOLISCHE_OSTKIRCHE_OHNE_N_HERE_ANGABE_L1("109",
                                                "2.16.840.1.113883.2.16.1.4.1",
                                                "Katholische Ostkirche (ohne nähere Angabe)",
                                                "Katholische Ostkirche (ohne nähere Angabe)",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Kirche der Siebenten-Tags-Adventisten.<br>
     */
    KIRCHE_DER_SIEBENTEN_TAGS_ADVENTISTEN_L1("139",
                                             "2.16.840.1.113883.2.16.1.4.1",
                                             "Kirche der Siebenten-Tags-Adventisten",
                                             "Kirche der Siebenten-Tags-Adventisten",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Konfessionslos.<br>
     */
    KONFESSIONSLOS_L1("160",
                      "2.16.840.1.113883.2.16.1.4.1",
                      "Konfessionslos",
                      "Konfessionslos",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Konfessionslos; ohne Angabe.<br>
     */
    KONFESSIONSLOS_OHNE_ANGABE("159",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "Konfessionslos; ohne Angabe",
                               "Konfessionslos; ohne Angabe",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Koptisch-orthodoxe Kirche.<br>
     */
    KOPTISCH_ORTHODOXE_KIRCHE_L1("123",
                                 "2.16.840.1.113883.2.16.1.4.1",
                                 "Koptisch-orthodoxe Kirche",
                                 "Koptisch-orthodoxe Kirche",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Mennonitische Freikirche.<br>
     */
    MENNONITISCHE_FREIKIRCHE_L1("138",
                                "2.16.840.1.113883.2.16.1.4.1",
                                "Mennonitische Freikirche",
                                "Mennonitische Freikirche",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Mormonen.<br>
     */
    MORMONEN_L1("143",
                "2.16.840.1.113883.2.16.1.4.1",
                "Mormonen",
                "Mormonen",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Neuapostolische Kirche.<br>
     */
    NEUAPOSTOLISCHE_KIRCHE_L1("142",
                              "2.16.840.1.113883.2.16.1.4.1",
                              "Neuapostolische Kirche",
                              "Neuapostolische Kirche",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Nicht-christliche Gemeinschaften.<br>
     */
    NICHT_CHRISTLICHE_GEMEINSCHAFTEN("148",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Nicht-christliche Gemeinschaften",
                                     "Nicht-christliche Gemeinschaften",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Ohne Angabe.<br>
     */
    OHNE_ANGABE_L1("161",
                   "2.16.840.1.113883.2.16.1.4.1",
                   "Ohne Angabe",
                   "Ohne Angabe",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Orientalisch-Orthodoxe Kirchen.<br>
     */
    ORIENTALISCH_ORTHODOXE_KIRCHEN("119",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Orientalisch-Orthodoxe Kirchen",
                                   "Orientalisch-Orthodoxe Kirchen",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Orthodoxe Kirchen (o.n.A.).<br>
     */
    ORTHODOXE_KIRCHEN_O_N_A_L1("111",
                               "2.16.840.1.113883.2.16.1.4.1",
                               "Orthodoxe Kirchen (o.n.A.)",
                               "Orthodoxe Kirchen (o.n.A.)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Pastafarianismus.<br>
     */
    PASTAFARIANISMUS_L1("162",
                        "2.16.840.1.113883.2.16.1.4.1",
                        "Pastafarianismus",
                        "Pastafarianismus",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Pfingstkirche Gemeinde Gottes.<br>
     */
    PFINGSTKIRCHE_GEMEINDE_GOTTES_L1("146",
                                     "2.16.840.1.113883.2.16.1.4.1",
                                     "Pfingstkirche Gemeinde Gottes",
                                     "Pfingstkirche Gemeinde Gottes",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Rumänische griechisch-katholische Kirche.<br>
     */
    RUM_NISCHE_GRIECHISCH_KATHOLISCHE_KIRCHE_L1("105",
                                                "2.16.840.1.113883.2.16.1.4.1",
                                                "Rumänische griechisch-katholische Kirche",
                                                "Rumänische griechisch-katholische Kirche",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Rumänisch-griechisch-orientalische Kirche.<br>
     */
    RUM_NISCH_GRIECHISCH_ORIENTALISCHE_KIRCHE_L1("115",
                                                 "2.16.840.1.113883.2.16.1.4.1",
                                                 "Rumänisch-griechisch-orientalische Kirche",
                                                 "Rumänisch-griechisch-orientalische Kirche",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Russisch-Katholische Kirche.<br>
     */
    RUSSISCH_KATHOLISCHE_KIRCHE_L1("106",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Russisch-Katholische Kirche",
                                   "Russisch-Katholische Kirche",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Russisch-Orthodoxe Kirche.<br>
     */
    RUSSISCH_ORTHODOXE_KIRCHE_L1("116",
                                 "2.16.840.1.113883.2.16.1.4.1",
                                 "Russisch-Orthodoxe Kirche",
                                 "Russisch-Orthodoxe Kirche",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Römisch-Katholisch.<br>
     */
    R_MISCH_KATHOLISCH_L1("101",
                          "2.16.840.1.113883.2.16.1.4.1",
                          "Römisch-Katholisch",
                          "Römisch-Katholisch",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Serbisch-griechisch-Orthodoxe Kirche.<br>
     */
    SERBISCH_GRIECHISCH_ORTHODOXE_KIRCHE_L1("117",
                                            "2.16.840.1.113883.2.16.1.4.1",
                                            "Serbisch-griechisch-Orthodoxe Kirche",
                                            "Serbisch-griechisch-Orthodoxe Kirche",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Shintoismus.<br>
     */
    SHINTOISMUS_L1("156",
                   "2.16.840.1.113883.2.16.1.4.1",
                   "Shintoismus",
                   "Shintoismus",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sikh.<br>
     */
    SIKH_L1("155",
            "2.16.840.1.113883.2.16.1.4.1",
            "Sikh",
            "Sikh",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Sonstige Christliche Gemeinschaften.<br>
     */
    SONSTIGE_CHRISTLICHE_GEMEINSCHAFTEN("134",
                                        "2.16.840.1.113883.2.16.1.4.1",
                                        "Sonstige Christliche Gemeinschaften",
                                        "Sonstige Christliche Gemeinschaften",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Sonstige Christliche Gemeinschaften (O.n.A.).<br>
     */
    SONSTIGE_CHRISTLICHE_GEMEINSCHAFTEN_O_N_A_L1("144",
                                                 "2.16.840.1.113883.2.16.1.4.1",
                                                 "Sonstige Christliche Gemeinschaften (O.n.A.)",
                                                 "Sonstige Christliche Gemeinschaften (O.n.A.)",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Syrisch-Katholische Kirche.<br>
     */
    SYRISCH_KATHOLISCHE_KIRCHE_L1("107",
                                  "2.16.840.1.113883.2.16.1.4.1",
                                  "Syrisch-Katholische Kirche",
                                  "Syrisch-Katholische Kirche",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Syrisch-orthodoxe Kirche.<br>
     */
    SYRISCH_ORTHODOXE_KIRCHE_L1("121",
                                "2.16.840.1.113883.2.16.1.4.1",
                                "Syrisch-orthodoxe Kirche",
                                "Syrisch-orthodoxe Kirche",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Ukrainische Griechisch-Katholische Kirche.<br>
     */
    UKRAINISCHE_GRIECHISCH_KATHOLISCHE_KIRCHE_L1("108",
                                                 "2.16.840.1.113883.2.16.1.4.1",
                                                 "Ukrainische Griechisch-Katholische Kirche",
                                                 "Ukrainische Griechisch-Katholische Kirche",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Ukrainisch-Orthodoxe Kirche.<br>
     */
    UKRAINISCH_ORTHODOXE_KIRCHE_L1("118",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Ukrainisch-Orthodoxe Kirche",
                                   "Ukrainisch-Orthodoxe Kirche",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Vereinigungskirche.<br>
     */
    VEREINIGUNGSKIRCHE_L1("157",
                          "2.16.840.1.113883.2.16.1.4.1",
                          "Vereinigungskirche",
                          "Vereinigungskirche",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Äthiopisch-Orthodoxe Kirche.<br>
     */
    _THIOPISCH_ORTHODOXE_KIRCHE_L1("125",
                                   "2.16.840.1.113883.2.16.1.4.1",
                                   "Äthiopisch-Orthodoxe Kirche",
                                   "Äthiopisch-Orthodoxe Kirche",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE");

    /**
     * EN: Code for Alevitische Religionsgesellschaft.<br>
     */
    public static final String ALEVITISCHE_RELIGIONSGESELLSCHAFT_L1_CODE = "151";

    /**
     * EN: Code for Altkatholische Kirche Österreichs.<br>
     */
    public static final String ALTKATHOLISCHE_KIRCHE_STERREICHS_L1_CODE = "131";

    /**
     * EN: Code for Andere Christliche Kirchen.<br>
     */
    public static final String ANDERE_CHRISTLICHE_KIRCHEN_CODE = "130";

    /**
     * EN: Code for Andere religiöse Bekenntnisgemeinschaften.<br>
     */
    public static final String ANDERE_RELIGI_SE_BEKENNTNISGEMEINSCHAFTEN_L1_CODE = "158";

    /**
     * EN: Code for Anglikanische Kirche.<br>
     */
    public static final String ANGLIKANISCHE_KIRCHE_L1_CODE = "132";

    /**
     * EN: Code for Armenisch-apostolische Kirche.<br>
     */
    public static final String ARMENISCH_APOSTOLISCHE_KIRCHE_L1_CODE = "120";

    /**
     * EN: Code for Armenisch-Katholische Kirche.<br>
     */
    public static final String ARMENISCH_KATHOLISCHE_KIRCHE_L1_CODE = "103";

    /**
     * EN: Code for Baha‘ i.<br>
     */
    public static final String BAHA_I_L1_CODE = "153";

    /**
     * EN: Code for Baptisten.<br>
     */
    public static final String BAPTISTEN_L1_CODE = "135";

    /**
     * EN: Code for Buddhistische Religionsgesellschaft.<br>
     */
    public static final String BUDDHISTISCHE_RELIGIONSGESELLSCHAFT_L1_CODE = "152";

    /**
     * EN: Code for Bulgarisch-Katholische Kirche.<br>
     */
    public static final String BULGARISCH_KATHOLISCHE_KIRCHE_L1_CODE = "104";

    /**
     * EN: Code for Bulgarisch-Orthodoxe Kirche.<br>
     */
    public static final String BULGARISCH_ORTHODOXE_KIRCHE_L1_CODE = "114";

    /**
     * EN: Code for Bund evangelikaler Gemeinden in Österreich.<br>
     */
    public static final String BUND_EVANGELIKALER_GEMEINDEN_IN_STERREICH_L1_CODE = "136";

    /**
     * EN: Code for Christengemeinschaft.<br>
     */
    public static final String CHRISTENGEMEINSCHAFT_L1_CODE = "140";

    /**
     * EN: Code for ELAIA Christengemeinden.<br>
     */
    public static final String ELAIA_CHRISTENGEMEINDEN_L1_CODE = "145";

    /**
     * EN: Code for Evangelische Kirchen Österreich.<br>
     */
    public static final String EVANGELISCHE_KIRCHEN_STERREICH_CODE = "126";

    /**
     * EN: Code for Evangelische Kirche A.B.<br>
     */
    public static final String EVANGELISCHE_KIRCHE_A_B_L1_CODE = "128";

    /**
     * EN: Code for Evangelische Kirche H.B.<br>
     */
    public static final String EVANGELISCHE_KIRCHE_H_B_L1_CODE = "129";

    /**
     * EN: Code for Evangelische Kirche (o.n.A.).<br>
     */
    public static final String EVANGELISCHE_KIRCHE_O_N_A_L1_CODE = "127";

    /**
     * EN: Code for Evangelisch-methodistische Kirche (EmK).<br>
     */
    public static final String EVANGELISCH_METHODISTISCHE_KIRCHE_EMK_L1_CODE = "133";

    /**
     * EN: Code for Freie Christengemeinde/Pfingstgemeinde.<br>
     */
    public static final String FREIE_CHRISTENGEMEINDE_PFINGSTGEMEINDE_L1_CODE = "137";

    /**
     * EN: Code for Griechisch-Katholische Kirche.<br>
     */
    public static final String GRIECHISCH_KATHOLISCHE_KIRCHE_L1_CODE = "102";

    /**
     * EN: Code for Griechisch-Orientalische Kirchen.<br>
     */
    public static final String GRIECHISCH_ORIENTALISCHE_KIRCHEN_CODE = "110";

    /**
     * EN: Code for Griechisch-Orthodoxe Kirche (Hl.Dreifaltigkeit).<br>
     */
    public static final String GRIECHISCH_ORTHODOXE_KIRCHE_HL_DREIFALTIGKEIT_L1_CODE = "112";

    /**
     * EN: Code for Griechisch-Orthodoxe Kirche (Hl.Georg).<br>
     */
    public static final String GRIECHISCH_ORTHODOXE_KIRCHE_HL_GEORG_L1_CODE = "113";

    /**
     * EN: Code for Hinduistische Religionsgesellschaft.<br>
     */
    public static final String HINDUISTISCHE_RELIGIONSGESELLSCHAFT_L1_CODE = "154";

    /**
     * EN: Code for Islamische Glaubensgemeinschaft.<br>
     */
    public static final String ISLAMISCHE_GLAUBENSGEMEINSCHAFT_L1_CODE = "150";

    /**
     * EN: Code for Israelitische Religionsgesellschaft.<br>
     */
    public static final String ISRAELITISCHE_RELIGIONSGESELLSCHAFT_L1_CODE = "149";

    /**
     * EN: Code for Jehovas Zeugen.<br>
     */
    public static final String JEHOVAS_ZEUGEN_L1_CODE = "141";

    /**
     * EN: Code for Katholische Kirche (o.n.A.).<br>
     */
    public static final String KATHOLISCHE_KIRCHE_O_N_A_CODE = "100";

    /**
     * EN: Code for Katholische Ostkirche (ohne nähere Angabe).<br>
     */
    public static final String KATHOLISCHE_OSTKIRCHE_OHNE_N_HERE_ANGABE_L1_CODE = "109";

    /**
     * EN: Code for Kirche der Siebenten-Tags-Adventisten.<br>
     */
    public static final String KIRCHE_DER_SIEBENTEN_TAGS_ADVENTISTEN_L1_CODE = "139";

    /**
     * EN: Code for Konfessionslos.<br>
     */
    public static final String KONFESSIONSLOS_L1_CODE = "160";

    /**
     * EN: Code for Konfessionslos; ohne Angabe.<br>
     */
    public static final String KONFESSIONSLOS_OHNE_ANGABE_CODE = "159";

    /**
     * EN: Code for Koptisch-orthodoxe Kirche.<br>
     */
    public static final String KOPTISCH_ORTHODOXE_KIRCHE_L1_CODE = "123";

    /**
     * EN: Code for Mennonitische Freikirche.<br>
     */
    public static final String MENNONITISCHE_FREIKIRCHE_L1_CODE = "138";

    /**
     * EN: Code for Mormonen.<br>
     */
    public static final String MORMONEN_L1_CODE = "143";

    /**
     * EN: Code for Neuapostolische Kirche.<br>
     */
    public static final String NEUAPOSTOLISCHE_KIRCHE_L1_CODE = "142";

    /**
     * EN: Code for Nicht-christliche Gemeinschaften.<br>
     */
    public static final String NICHT_CHRISTLICHE_GEMEINSCHAFTEN_CODE = "148";

    /**
     * EN: Code for Ohne Angabe.<br>
     */
    public static final String OHNE_ANGABE_L1_CODE = "161";

    /**
     * EN: Code for Orientalisch-Orthodoxe Kirchen.<br>
     */
    public static final String ORIENTALISCH_ORTHODOXE_KIRCHEN_CODE = "119";

    /**
     * EN: Code for Orthodoxe Kirchen (o.n.A.).<br>
     */
    public static final String ORTHODOXE_KIRCHEN_O_N_A_L1_CODE = "111";

    /**
     * EN: Code for Pastafarianismus.<br>
     */
    public static final String PASTAFARIANISMUS_L1_CODE = "162";

    /**
     * EN: Code for Pfingstkirche Gemeinde Gottes.<br>
     */
    public static final String PFINGSTKIRCHE_GEMEINDE_GOTTES_L1_CODE = "146";

    /**
     * EN: Code for Rumänische griechisch-katholische Kirche.<br>
     */
    public static final String RUM_NISCHE_GRIECHISCH_KATHOLISCHE_KIRCHE_L1_CODE = "105";

    /**
     * EN: Code for Rumänisch-griechisch-orientalische Kirche.<br>
     */
    public static final String RUM_NISCH_GRIECHISCH_ORIENTALISCHE_KIRCHE_L1_CODE = "115";

    /**
     * EN: Code for Russisch-Katholische Kirche.<br>
     */
    public static final String RUSSISCH_KATHOLISCHE_KIRCHE_L1_CODE = "106";

    /**
     * EN: Code for Russisch-Orthodoxe Kirche.<br>
     */
    public static final String RUSSISCH_ORTHODOXE_KIRCHE_L1_CODE = "116";

    /**
     * EN: Code for Römisch-Katholisch.<br>
     */
    public static final String R_MISCH_KATHOLISCH_L1_CODE = "101";

    /**
     * EN: Code for Serbisch-griechisch-Orthodoxe Kirche.<br>
     */
    public static final String SERBISCH_GRIECHISCH_ORTHODOXE_KIRCHE_L1_CODE = "117";

    /**
     * EN: Code for Shintoismus.<br>
     */
    public static final String SHINTOISMUS_L1_CODE = "156";

    /**
     * EN: Code for Sikh.<br>
     */
    public static final String SIKH_L1_CODE = "155";

    /**
     * EN: Code for Sonstige Christliche Gemeinschaften.<br>
     */
    public static final String SONSTIGE_CHRISTLICHE_GEMEINSCHAFTEN_CODE = "134";

    /**
     * EN: Code for Sonstige Christliche Gemeinschaften (O.n.A.).<br>
     */
    public static final String SONSTIGE_CHRISTLICHE_GEMEINSCHAFTEN_O_N_A_L1_CODE = "144";

    /**
     * EN: Code for Syrisch-Katholische Kirche.<br>
     */
    public static final String SYRISCH_KATHOLISCHE_KIRCHE_L1_CODE = "107";

    /**
     * EN: Code for Syrisch-orthodoxe Kirche.<br>
     */
    public static final String SYRISCH_ORTHODOXE_KIRCHE_L1_CODE = "121";

    /**
     * EN: Code for Ukrainische Griechisch-Katholische Kirche.<br>
     */
    public static final String UKRAINISCHE_GRIECHISCH_KATHOLISCHE_KIRCHE_L1_CODE = "108";

    /**
     * EN: Code for Ukrainisch-Orthodoxe Kirche.<br>
     */
    public static final String UKRAINISCH_ORTHODOXE_KIRCHE_L1_CODE = "118";

    /**
     * EN: Code for Vereinigungskirche.<br>
     */
    public static final String VEREINIGUNGSKIRCHE_L1_CODE = "157";

    /**
     * EN: Code for Äthiopisch-Orthodoxe Kirche.<br>
     */
    public static final String _THIOPISCH_ORTHODOXE_KIRCHE_L1_CODE = "125";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.18";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_ReligiousAffiliation";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.2.16.1.4.1";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaReligiousAffiliation getEnum(@Nullable final String code) {
        for (final ElgaReligiousAffiliation x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaReligiousAffiliation.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaReligiousAffiliation x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaReligiousAffiliation(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
