/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant1;
import org.projecthusky.common.hl7cdar2.ST;

public class Laborbefund
extends POCDMT000040ClinicalDocument {
    public Laborbefund() {
        super.getTemplateId().add(Laborbefund.createHl7TemplateIdFixedValue("1.2.40.0.34.11.4"));
        super.setCode(Laborbefund.createHl7CodeFixedValue("11502-2", "2.16.840.1.113883.6.1", null, "Laboratory report"));
    }

    public void addHl7DocumentationOf(POCDMT000040DocumentationOf value) {
        this.getDocumentationOf().add(value);
    }

    public void clearHl7DocumentationOf() {
        this.getDocumentationOf().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Component2 createHl7ComponentFixedValue(String typeCode, String contextConductionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Component2 retVal = factory.createPOCDMT000040Component2();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        if (contextConductionInd != null) {
            retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        }
        return retVal;
    }

    private static POCDMT000040Participant1 createHl7ParticipantFixedValue(String typeCode, String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Participant1 retVal = factory.createPOCDMT000040Participant1();
        retVal.getTypeCode().add(typeCode);
        if (nullFlavor != null) {
            retVal.getNullFlavor().add(nullFlavor);
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return this.code;
    }

    public POCDMT000040Component2 getHl7Component() {
        return this.component;
    }

    public II getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040Participant1> getHl7Participant() {
        return this.participant;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public static POCDMT000040Component2 getPredefinedComponentCompTrue() {
        return Laborbefund.createHl7ComponentFixedValue("COMP", "true");
    }

    public static POCDMT000040Participant1 getPredefinedParticipantRef() {
        return Laborbefund.createHl7ParticipantFixedValue("REF", null);
    }

    public static POCDMT000040Participant1 getPredefinedParticipantRefUnk() {
        return Laborbefund.createHl7ParticipantFixedValue("REF", "UNK");
    }

    public static II getPredefinedTemplateId124003411401() {
        return Laborbefund.createHl7TemplateIdFixedValue("1.2.40.0.34.11.4.0.1");
    }

    public static II getPredefinedTemplateId124003411402() {
        return Laborbefund.createHl7TemplateIdFixedValue("1.2.40.0.34.11.4.0.2");
    }

    public static II getPredefinedTemplateId124003411403() {
        return Laborbefund.createHl7TemplateIdFixedValue("1.2.40.0.34.11.4.0.3");
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Component(POCDMT000040Component2 value) {
        this.component = value;
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7Participant(POCDMT000040Participant1 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }
}

