/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.XActMoodDocumentObservation;
import org.projecthusky.common.model.Code;

public class EpimsEntryProblem
extends POCDMT000040Observation {
    private final List<Code> vocabStatusCodeCode = new ArrayList<Code>();

    public EpimsEntryProblem() {
        super.getClassCode().add("OBS");
        super.setMoodCode(XActMoodDocumentObservation.EVN);
        super.setNegationInd(Boolean.valueOf(false));
        super.getTemplateId().add(EpimsEntryProblem.createHl7TemplateIdFixedValue("1.2.40.0.34.6.0.11.3.99"));
        super.getTemplateId().add(EpimsEntryProblem.createHl7TemplateIdFixedValue("1.2.40.0.34.6.0.11.3.6"));
        super.getTemplateId().add(EpimsEntryProblem.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.28"));
        super.getTemplateId().add(EpimsEntryProblem.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.5"));
        super.setCode((CD)EpimsEntryProblem.createHl7CodeFixedValue("404684003", "2.16.840.1.113883.6.96", "SNOMED CT", "Clinical finding (finding)"));
        super.setStatusCode(new Code(CodeBaseType.builder().withCode("completed").build()).getHl7CdaR2Cs());
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<II> getHl7Id() {
        return this.id;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public List<ANY> getHl7Value() {
        return this.value;
    }

    public List<Code> getVocabStatusCodeCode() {
        return this.vocabStatusCodeCode;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        if (this.id == null) {
            this.id = new LinkedList();
        }
        this.id.clear();
        this.id.add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }

    public void setHl7Value(CD value) {
        if (this.value == null) {
            this.value = new LinkedList();
        }
        this.value.add(value);
    }
}

