/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum EpimsMaterialMethod implements ValueSetEnumInterface
{
    METHODE_KULTUR_MATERIAL("KULTUR", "1.2.40.0.34.5.99", "Methode Kultur Material", "Methode Kultur Material", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    METHODE_MATERIAL_HISTOLOGIE("HIST", "1.2.40.0.34.5.99", "Methode Material Histologie", "Methode Material Histologie", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    METHODE_MATERIAL_SEROLOGIE("SERO", "1.2.40.0.34.5.99", "Methode Material Serologie", "Methode Material Serologie", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    METHODE_MATERIAL_VIRUSNACHWEIS("VIRUS", "1.2.40.0.34.5.99", "Methode Material Virusnachweis", "Methode Material Virusnachweis", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    METHODE_MIKROSKOPIE_MATERIAL("MIKRO", "1.2.40.0.34.5.99", "Methode Mikroskopie Material", "Methode Mikroskopie Material", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    METHODE_NAT_MATERIAL("NAT", "1.2.40.0.34.5.99", "Methode NAT Material", "Methode NAT Material", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PRIMARY_SAMPLE("MAT1", "1.2.40.0.34.5.99", "Primary Sample", "Primary Sample", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SECONDARY_SAMPLE("MAT2", "1.2.40.0.34.5.99", "Secondary Sample", "Secondary Sample", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String METHODE_KULTUR_MATERIAL_CODE = "KULTUR";
    public static final String METHODE_MATERIAL_HISTOLOGIE_CODE = "HIST";
    public static final String METHODE_MATERIAL_SEROLOGIE_CODE = "SERO";
    public static final String METHODE_MATERIAL_VIRUSNACHWEIS_CODE = "VIRUS";
    public static final String METHODE_MIKROSKOPIE_MATERIAL_CODE = "MIKRO";
    public static final String METHODE_NAT_MATERIAL_CODE = "NAT";
    public static final String PRIMARY_SAMPLE_CODE = "MAT1";
    public static final String SECONDARY_SAMPLE_CODE = "MAT2";
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.16";
    public static final String VALUE_SET_NAME = "epims_materialMethod";
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.99";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable EpimsMaterialMethod getEnum(@Nullable String code) {
        for (EpimsMaterialMethod x : EpimsMaterialMethod.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EpimsMaterialMethod.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (EpimsMaterialMethod x : EpimsMaterialMethod.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private EpimsMaterialMethod(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

