/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import jakarta.xml.bind.JAXBElement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.ps.ProblemEntryAllergyReaction;
import org.projecthusky.cda.elga.generated.artdecor.ps.SeverityObservation;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;

public class AllergyReaction {
    private Code reaction;
    private Code severity;
    private ZonedDateTime start;
    private ZonedDateTime stop;

    public Code getReaction() {
        return this.reaction;
    }

    public Code getSeverity() {
        return this.severity;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getStop() {
        return this.stop;
    }

    public void setReaction(Code reaction) {
        this.reaction = reaction;
    }

    public void setSeverity(Code severity) {
        this.severity = severity;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public void setStop(ZonedDateTime stop) {
        this.stop = stop;
    }

    public POCDMT000040EntryRelationship getAllergyReactionObservationEntryRel(int indexReaction, int indexAllergy) {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.MFST);
        entryRel.setInversionInd(Boolean.valueOf(true));
        ProblemEntryAllergyReaction allergyReactionObservation = new ProblemEntryAllergyReaction();
        allergyReactionObservation.setText(new ED(null, new TEL("#react" + indexAllergy + indexReaction)));
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
        allergyReactionObservation.setEffectiveTime(time);
        CD code = this.reaction.getHl7CdaR2Cd();
        code.setOriginalText(new ED(null, new TEL("#react" + indexAllergy + indexReaction)));
        allergyReactionObservation.getValue().add(code);
        allergyReactionObservation.getEntryRelationship().add(this.getSeverityObservationEntryRel(indexReaction, indexAllergy, (POCDMT000040EntryRelationship)allergyReactionObservation.getEntryRelationship().get(0)));
        entryRel.setObservation((POCDMT000040Observation)allergyReactionObservation);
        return entryRel;
    }

    private POCDMT000040EntryRelationship getSeverityObservationEntryRel(int indexReaction, int indexAllergy, POCDMT000040EntryRelationship entryRel) {
        SeverityObservation severityObservation = new SeverityObservation();
        severityObservation.setText(new ED(null, new TEL("#sev" + indexAllergy + indexReaction)));
        CD code = this.severity.getHl7CdaR2Cd();
        code.setOriginalText(new ED(null, new TEL("#sev" + indexAllergy + indexReaction)));
        severityObservation.getValue().add(code);
        entryRel.setObservation((POCDMT000040Observation)severityObservation);
        return entryRel;
    }
}

