/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.ZonedDateTime;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrSectionUebersetzung;
import org.projecthusky.cda.elga.generated.artdecor.enums.ElgaHumanLanguage;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.model.Identificator;

public class Translation {
    private List<PractitionerCdaAt> authors;
    private ZonedDateTime authorTime;
    private ElgaHumanLanguage language;
    private String text;
    private String title;
    private Identificator id;

    public List<PractitionerCdaAt> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<PractitionerCdaAt> authors) {
        this.authors = authors;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public ElgaHumanLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(ElgaHumanLanguage language) {
        this.language = language;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public AtcdabbrSectionUebersetzung getAtcdabbrSectionUebersetzung() {
        AtcdabbrSectionUebersetzung translationSection = new AtcdabbrSectionUebersetzung();
        if (this.id != null) {
            translationSection.setHl7Id(this.id.getHl7CdaR2Ii());
        }
        if (this.title != null) {
            ST st = new ST();
            st.setXmlMixed(this.title);
            translationSection.setTitle(st);
        }
        if (this.text != null) {
            StrucDocText strucDocText = new StrucDocText();
            strucDocText.setXmlMixed(this.text);
            translationSection.setText(strucDocText);
        }
        if (this.language != null) {
            translationSection.setLanguageCode(new CS(this.language.getCode().getCode()));
        }
        if (this.authors != null && !this.authors.isEmpty()) {
            for (PractitionerCdaAt author : this.authors) {
                if (author == null) continue;
                translationSection.addHl7Author(author.getAtcdabbrOtherAuthorBodyEImpfpass(this.authorTime));
            }
        }
        return translationSection;
    }
}

