/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.projecthusky.cda.elga.generated.artdecor.EimpfEntryAntikoerperBestimmungLaboratoryObservation;
import org.projecthusky.cda.elga.generated.artdecor.base.enums.ElgaObservationInterpretation;
import org.projecthusky.cda.elga.generated.artdecor.enums.EImpfAntikoerperbestimmungVs;
import org.projecthusky.cda.elga.models.Comment;
import org.projecthusky.cda.elga.models.Laboratory;
import org.projecthusky.cda.elga.models.PerformerAt;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;

public class AntibodyLaboratory
extends Laboratory {
    private EImpfAntikoerperbestimmungVs antibodyDetermination;
    private ElgaObservationInterpretation interpretationCode;
    private List<Comment> comments;

    public EimpfEntryAntikoerperBestimmungLaboratoryObservation getEimpfEntryAntikoerperBestimmungLaboratoryObservation(int index) {
        EimpfEntryAntikoerperBestimmungLaboratoryObservation observation = new EimpfEntryAntikoerperBestimmungLaboratoryObservation();
        this.fillPOCDMT000040Observation(observation, index);
        if (this.antibodyDetermination != null) {
            observation.setCode((CD)new CE(this.antibodyDetermination.getCode().getCode(), this.antibodyDetermination.getCode().getCodeSystem(), this.antibodyDetermination.getCode().getCodeSystemName(), this.antibodyDetermination.getCode().getDisplayName()));
        }
        if (this.isAborted()) {
            observation.setStatusCode(new CS("aborted"));
        } else {
            observation.setStatusCode(new CS("completed"));
        }
        if (this.interpretationCode != null) {
            observation.getInterpretationCode().add(new CE(this.interpretationCode.getCode().getCode(), this.interpretationCode.getCode().getCodeSystem(), this.interpretationCode.getCode().getCodeSystemName(), this.interpretationCode.getCode().getDisplayName()));
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            this.setComments(observation);
        }
        this.setLaboratories(observation);
        return observation;
    }

    private void setComments(EimpfEntryAntikoerperBestimmungLaboratoryObservation observation) {
        int commentIndex = 0;
        for (Comment comment : this.comments) {
            POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
            entryRel.setContextConductionInd(Boolean.valueOf(true));
            if (comment != null) {
                entryRel.setAct((POCDMT000040Act)comment.getAtcdabbrEntryComment(commentIndex));
            }
            observation.getEntryRelationship().add(entryRel);
        }
    }

    private void setLaboratories(POCDMT000040Observation observation) {
        if (this.getLaboratories() != null) {
            for (Map.Entry<ZonedDateTime, PerformerAt> entry : this.getLaboratories().entrySet()) {
                if (entry == null) continue;
                observation.getPerformer().add(entry.getValue().getAtcdabbrOtherPerformerBodyLaboratory(entry.getKey()));
            }
        }
    }

    public EImpfAntikoerperbestimmungVs getAntibodyDetermination() {
        return this.antibodyDetermination;
    }

    public void setAntibodyDetermination(EImpfAntikoerperbestimmungVs antibodyDetermination) {
        this.antibodyDetermination = antibodyDetermination;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public ElgaObservationInterpretation getInterpretationCode() {
        return this.interpretationCode;
    }

    public void setInterpretationCode(ElgaObservationInterpretation interpretationCode) {
        this.interpretationCode = interpretationCode;
    }
}

