/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.emed;

import jakarta.xml.bind.JAXBElement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.emed.Cdarezept;
import org.projecthusky.cda.elga.generated.artdecor.emed.HeaderRelatedDocument;
import org.projecthusky.cda.elga.generated.artdecor.emed.RezeptSection;
import org.projecthusky.cda.elga.models.AdditionalInformation;
import org.projecthusky.cda.elga.models.PatientCdaAt;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.PrescriptionEntry;
import org.projecthusky.cda.elga.narrative.MedBaseTextGenerator;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component3;
import org.projecthusky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.POCDMT000040ServiceEvent;
import org.projecthusky.common.hl7cdar2.POCDMT000040StructuredBody;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.utils.time.DateTimes;

public class EmedPrescription {
    private Identificator docId;
    private Identificator setId;
    private int version;
    private PatientCdaAt patient;
    private List<PractitionerCdaAt> authors;
    private ZonedDateTime authorTime;
    private Organization custodian;
    private PractitionerCdaAt legalAuthenticator;
    private ZonedDateTime startValidityPeriod;
    private ZonedDateTime stopValidityPeriod;
    private Identificator parentDocument;
    private Code kindOfPrescription;
    private List<PrescriptionEntry> prescriptionEntries;
    private Identificator gdaId;

    public Code getKindOfPrescription() {
        return this.kindOfPrescription;
    }

    public void setKindOfPrescription(Code kindOfPrescription) {
        this.kindOfPrescription = kindOfPrescription;
    }

    public Identificator getDocId() {
        return this.docId;
    }

    public void setDocId(Identificator docId) {
        this.docId = docId;
    }

    public Identificator getSetId() {
        return this.setId;
    }

    public void setSetId(Identificator setId) {
        this.setId = setId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PatientCdaAt getPatient() {
        return this.patient;
    }

    public void setPatient(PatientCdaAt patient) {
        this.patient = patient;
    }

    public List<PractitionerCdaAt> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<PractitionerCdaAt> authors) {
        this.authors = authors;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public Organization getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Organization custodian) {
        this.custodian = custodian;
    }

    public PractitionerCdaAt getLegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public void setLegalAuthenticator(PractitionerCdaAt legalAuthenticator) {
        this.legalAuthenticator = legalAuthenticator;
    }

    public ZonedDateTime getStartValidityPeriod() {
        return this.startValidityPeriod;
    }

    public void setStartValidityPeriod(ZonedDateTime startValidityPeriod) {
        this.startValidityPeriod = startValidityPeriod;
    }

    public ZonedDateTime getStopValidityPeriod() {
        return this.stopValidityPeriod;
    }

    public void setStopValidityPeriod(ZonedDateTime stopValidityPeriod) {
        this.stopValidityPeriod = stopValidityPeriod;
    }

    public Identificator getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(Identificator parentDocument) {
        this.parentDocument = parentDocument;
    }

    public List<PrescriptionEntry> getPrescriptionEntries() {
        return this.prescriptionEntries;
    }

    public void setPrescriptionEntries(List<PrescriptionEntry> prescriptionEntries) {
        this.prescriptionEntries = prescriptionEntries;
    }

    public Identificator getGdaId() {
        return this.gdaId;
    }

    public void setGdaId(Identificator gdaId) {
        this.gdaId = gdaId;
    }

    protected POCDMT000040DocumentationOf getAtcdabbrHeaderDocumentationOfServiceEvent() {
        POCDMT000040DocumentationOf documentationOfServiceEvent = new POCDMT000040DocumentationOf();
        POCDMT000040ServiceEvent serviceEvent = new POCDMT000040ServiceEvent();
        if (this.kindOfPrescription != null) {
            serviceEvent.setCode(this.kindOfPrescription.getHl7CdaR2Ce());
            if (this.kindOfPrescription.getCode() != null && (this.kindOfPrescription.getCode().equals("KASSEN") || this.kindOfPrescription.getCode().equals("PRIVAT"))) {
                this.startValidityPeriod = ZonedDateTime.now();
            }
            if (this.kindOfPrescription.getCode().equals("KASSEN")) {
                this.stopValidityPeriod = this.startValidityPeriod.plusMonths(1L).plusDays(1L);
            }
            if (this.startValidityPeriod != null && this.stopValidityPeriod != null) {
                IVLTS time = new IVLTS();
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startValidityPeriod)));
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stopValidityPeriod)));
                serviceEvent.setEffectiveTime(time);
            } else {
                IVLTS ivlts = new IVLTS();
                ivlts.nullFlavor = new ArrayList();
                ivlts.nullFlavor.add("MSK");
                serviceEvent.setEffectiveTime(ivlts);
            }
        }
        documentationOfServiceEvent.setServiceEvent(serviceEvent);
        return documentationOfServiceEvent;
    }

    protected HeaderRelatedDocument getAtcdabbrHeaderDocumentReplacementRelatedDocument() {
        HeaderRelatedDocument relatedDocument = new HeaderRelatedDocument();
        relatedDocument.getHl7ParentDocument().getId().add(this.parentDocument.getHl7CdaR2Ii());
        return relatedDocument;
    }

    protected POCDMT000040StructuredBody getHl7CdaR2Pocdmt000040StructuredBodyEMedicationPrescription() {
        POCDMT000040StructuredBody structuredBody = new POCDMT000040StructuredBody();
        structuredBody.getClassCode().add("DOCBODY");
        structuredBody.getMoodCode().add("EVN");
        if (this.prescriptionEntries != null && !this.prescriptionEntries.isEmpty()) {
            POCDMT000040Component3 comp3 = new POCDMT000040Component3();
            comp3.setSection((POCDMT000040Section)this.getRezeptSection());
            structuredBody.getComponent().add(comp3);
        }
        return structuredBody;
    }

    protected RezeptSection getRezeptSection() {
        if (this.prescriptionEntries == null || this.prescriptionEntries.isEmpty()) {
            return null;
        }
        RezeptSection prescriptionSection = new RezeptSection();
        int index = 0;
        prescriptionSection.getEntry().clear();
        for (PrescriptionEntry entry : this.prescriptionEntries) {
            if (entry == null) continue;
            prescriptionSection.getEntry().add(entry.getMedikationVerordnungEntryemedEmedication(index, this.gdaId, this.kindOfPrescription));
        }
        LinkedList<List<AdditionalInformation>> patientInstructions = new LinkedList<List<AdditionalInformation>>();
        LinkedList<List<AdditionalInformation>> pharmacistInstructions = new LinkedList<List<AdditionalInformation>>();
        for (PrescriptionEntry entry : this.prescriptionEntries) {
            if (entry == null) continue;
            patientInstructions.add(entry.getAddInfoPat());
            pharmacistInstructions.add(entry.getAddInfoPharm());
        }
        StrucDocText textKonsUeberwGrund = new StrucDocText();
        MedBaseTextGenerator textbuilder = new MedBaseTextGenerator(patientInstructions, pharmacistInstructions);
        textKonsUeberwGrund.getContent().addAll(textbuilder.getTablesFromCda(prescriptionSection.getEntry()));
        prescriptionSection.setText(textKonsUeberwGrund);
        return prescriptionSection;
    }

    public Cdarezept getEMedicationPrescription() {
        Cdarezept cda = new Cdarezept();
        this.addHeader(cda);
        POCDMT000040Component2 comp2 = new POCDMT000040Component2();
        comp2.setStructuredBody(this.getHl7CdaR2Pocdmt000040StructuredBodyEMedicationPrescription());
        cda.setHl7Component(comp2);
        return cda;
    }

    private void addHeader(POCDMT000040ClinicalDocument cda) {
        cda.setId(this.getDocId().getHl7CdaR2Ii());
        cda.setEffectiveTime(DateTimes.toDatetimeTs((TemporalAccessor)ZonedDateTime.now()));
        cda.setSetId(this.getSetId().getHl7CdaR2Ii());
        cda.setVersionNumber(new INT(this.getVersion()));
        if (this.patient != null) {
            cda.getRecordTarget().clear();
            cda.getRecordTarget().add(this.patient.getHeaderRecordTargetBase());
        }
        if (this.getAuthors() != null && !this.getAuthors().isEmpty()) {
            for (PractitionerCdaAt author : this.getAuthors()) {
                cda.getAuthor().add(author.getAtcdabbrHeaderAuthor(this.authorTime));
            }
        }
        if (this.custodian != null) {
            cda.setCustodian(this.custodian.getHl7CdaR2Pocdmt000040Custodian());
        }
        if (this.legalAuthenticator != null) {
            cda.setLegalAuthenticator((POCDMT000040LegalAuthenticator)this.legalAuthenticator.getHeaderLegalAuthenticator(this.getAuthorTime()));
        }
        cda.getDocumentationOf().add(this.getAtcdabbrHeaderDocumentationOfServiceEvent());
        if (this.getParentDocument() != null && this.getParentDocument().getRoot() != null) {
            cda.getRelatedDocument().add(this.getAtcdabbrHeaderDocumentReplacementRelatedDocument());
        }
    }
}

