/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.ems;

import java.time.ZonedDateTime;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryEmsBetreuung;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryOrganizerBetreuung;
import org.projecthusky.cda.elga.utils.DateTimeUtils;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.model.Code;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Care {
    private static final Logger LOGGER = LoggerFactory.getLogger(Care.class);
    private Code facility;
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;

    public Code getFacility() {
        return this.facility;
    }

    public void setFacility(Code facility) {
        this.facility = facility;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    public POCDMT000040Entry getEpimsEntryOrganizerBetreuungEntry() {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setOrganizer(this.getEpimsEntryOrganizerBetreuung());
        return entry;
    }

    public POCDMT000040Organizer getEpimsEntryOrganizerBetreuung() {
        EpimsEntryOrganizerBetreuung organizerCare = new EpimsEntryOrganizerBetreuung();
        ((POCDMT000040Component4)organizerCare.getComponent().get(0)).setAct((POCDMT000040Act)this.getEpimsEntryEmsBetreuung());
        return organizerCare;
    }

    public EpimsEntryEmsBetreuung getEpimsEntryEmsBetreuung() {
        EpimsEntryEmsBetreuung emsCare = new EpimsEntryEmsBetreuung();
        if (this.facility != null) {
            emsCare.setCode(this.facility.getHl7CdaR2Cd());
        } else {
            LOGGER.error("facility of care is null");
        }
        emsCare.setEffectiveTime(DateTimeUtils.createIvlts(this.startDate, this.stopDate));
        return emsCare;
    }
}

