/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.projecthusky.cda.elga.generated.artdecor.base.KulturellerKeimnachweis;
import org.projecthusky.cda.elga.models.lab.Antibiogram;
import org.projecthusky.cda.elga.models.lab.Organizer;
import org.projecthusky.cda.elga.models.lab.Specimen;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.utils.time.DateTimes;

public class CultureGermDetection
extends Organizer {
    private Specimen specimen;
    private Antibiogram antibiogram;
    private ZonedDateTime samplingTime;

    public Specimen getSpecimen() {
        return this.specimen;
    }

    public Antibiogram getAntibiogram() {
        return this.antibiogram;
    }

    public ZonedDateTime getSamplingTime() {
        return this.samplingTime;
    }

    public void setSpecimen(Specimen specimen) {
        this.specimen = specimen;
    }

    public void setAntibiogram(Antibiogram antibiogram) {
        this.antibiogram = antibiogram;
    }

    public void setSamplingTime(ZonedDateTime samplingTime) {
        this.samplingTime = samplingTime;
    }

    public KulturellerKeimnachweis getKulturellerKeimnachweis() {
        KulturellerKeimnachweis detection = new KulturellerKeimnachweis();
        this.fillPOCDMT000040Organizer(detection);
        if (this.samplingTime != null) {
            detection.setHl7EffectiveTime(new IVLTS(DateTimes.toDateTs((TemporalAccessor)this.samplingTime).getValue()));
        }
        detection.setHl7Specimen(this.specimen.getPOCDMT000040Specimen());
        if (this.antibiogram != null) {
            POCDMT000040Component4 comp = new POCDMT000040Component4();
            comp.setTypeCode(ActRelationshipHasComponent.COMP);
            comp.setOrganizer((POCDMT000040Organizer)this.antibiogram.getAntibiogram());
            detection.setHl7Component(comp);
        }
        return detection;
    }
}

