/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import jakarta.xml.bind.JAXBElement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.models.lab.LaboratoryObservation;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.utils.time.DateTimes;

public class Organizer {
    private List<LaboratoryObservation> laboratoryResults;
    private List<LaboratoryObservation> laboratoryResultsActive;
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;

    public List<LaboratoryObservation> getLaboratoryResults() {
        return this.laboratoryResults;
    }

    public List<LaboratoryObservation> getLaboratoryResultsActive() {
        return this.laboratoryResultsActive;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setLaboratoryResults(List<LaboratoryObservation> laboratoryResults) {
        this.laboratoryResults = laboratoryResults;
    }

    public void setLaboratoryResultsActive(List<LaboratoryObservation> laboratoryResultsActive) {
        this.laboratoryResultsActive = laboratoryResultsActive;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    protected void fillPOCDMT000040Organizer(POCDMT000040Organizer organizer) {
        if (this.startDate != null && this.stopDate != null) {
            IVLTS time = new IVLTS();
            time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stopDate)));
            time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startDate)));
            organizer.setEffectiveTime(time);
        } else {
            IVLTS time = new IVLTS();
            time.getNullFlavor().add("UNK");
            organizer.setEffectiveTime(time);
        }
        this.addLaboratoryResults(organizer);
        this.addLaboratoryResultsActive(organizer);
    }

    private void addLaboratoryResultsActive(POCDMT000040Organizer organizer) {
        if (this.laboratoryResultsActive != null && !this.laboratoryResultsActive.isEmpty()) {
            for (LaboratoryObservation observation : this.laboratoryResultsActive) {
                if (observation == null) continue;
                organizer.getComponent().add(this.getComponentWithObservation(observation.getLaboratoryObservationActive()));
            }
        }
    }

    private void addLaboratoryResults(POCDMT000040Organizer organizer) {
        if (this.laboratoryResults != null && !this.laboratoryResults.isEmpty()) {
            int index = 0;
            for (LaboratoryObservation observation : this.laboratoryResults) {
                if (observation == null) continue;
                organizer.getComponent().add(this.getComponentWithObservation(observation.getLaboratoryObservation(index)));
                ++index;
            }
        }
    }

    private POCDMT000040Component4 getComponentWithObservation(POCDMT000040Observation observation) {
        POCDMT000040Component4 component = new POCDMT000040Component4();
        component.setTypeCode(ActRelationshipHasComponent.COMP);
        component.setObservation(observation);
        return component;
    }
}

