/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import jakarta.xml.bind.JAXBElement;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;

public class AppendixNarrativeTextGenerator
extends BaseTextGenerator {
    private List<Appendix> appendices;
    private List<POCDMT000040Entry> entries;

    public AppendixNarrativeTextGenerator(List<POCDMT000040Entry> entries, List<Appendix> appendices) {
        this.entries = entries;
        this.appendices = appendices;
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Name des Dokuments", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Ersteller", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Datum", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Dokument", null));
        thead.getTr().add(tr);
        return thead;
    }

    private StrucDocTable getBody() {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (this.entries != null) {
            int index = 0;
            for (POCDMT000040Entry entryRel : this.entries) {
                if (entryRel == null || entryRel.getObservationMedia() == null) continue;
                StrucDocTr tr = new StrucDocTr();
                tr.getThOrTd().add(this.getCellTd(this.appendices.get(index).getTitle()));
                tr.getThOrTd().add(this.getCellTd(this.appendices.get(index).getAuthor()));
                tr.getThOrTd().add(this.getCellTd(this.appendices.get(index).getCreationTime()));
                tr.getThOrTd().add(this.getCellWithRenderMultiMedia(entryRel.getObservationMedia().getIDAttr()));
                body.getTr().add(tr);
                ++index;
            }
        }
        table.setThead(this.getTableHeader());
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        tables.add(new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody()));
        return tables;
    }
}

