/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_HumanLanguage values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.173<br>
 * Effective date: 2021-05-19 15:19<br>
 * Version: 202105(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum ElgaHumanLanguage implements ValueSetEnumInterface {

    /**
     * EN: Abchasisch.<br>
     */
    ABCHASISCH("ab",
               "2.16.840.1.113883.6.121",
               "Abchasisch",
               "Abchasisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Aceh-Sprache.<br>
     */
    ACEH_SPRACHE("ace",
                 "2.16.840.1.113883.6.121",
                 "Aceh-Sprache",
                 "Aceh-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Acholi-Sprache.<br>
     */
    ACHOLI_SPRACHE("ach",
                   "2.16.840.1.113883.6.121",
                   "Acholi-Sprache",
                   "Acholi-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Adangme-Sprache.<br>
     */
    ADANGME_SPRACHE("ada",
                    "2.16.840.1.113883.6.121",
                    "Adangme-Sprache",
                    "Adangme-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Adygisch.<br>
     */
    ADYGISCH("ady",
             "2.16.840.1.113883.6.121",
             "Adygisch",
             "Adygisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Afrihili.<br>
     */
    AFRIHILI("afh",
             "2.16.840.1.113883.6.121",
             "Afrihili",
             "Afrihili",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Afrikaans.<br>
     */
    AFRIKAANS("af",
              "2.16.840.1.113883.6.121",
              "Afrikaans",
              "Afrikaans",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Ainu-Sprache.<br>
     */
    AINU_SPRACHE("ain",
                 "2.16.840.1.113883.6.121",
                 "Ainu-Sprache",
                 "Ainu-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Akan-Sprache.<br>
     */
    AKAN_SPRACHE("ak",
                 "2.16.840.1.113883.6.121",
                 "Akan-Sprache",
                 "Akan-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Akkadisch.<br>
     */
    AKKADISCH("akk",
              "2.16.840.1.113883.6.121",
              "Akkadisch",
              "Akkadisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Albanisch.<br>
     */
    ALBANISCH("sq",
              "2.16.840.1.113883.6.121",
              "Albanisch",
              "Albanisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Aleutisch.<br>
     */
    ALEUTISCH("ale",
              "2.16.840.1.113883.6.121",
              "Aleutisch",
              "Aleutisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Algonkin-Sprachen (Andere).<br>
     */
    ALGONKIN_SPRACHEN_ANDERE("alg",
                             "2.16.840.1.113883.6.121",
                             "Algonkin-Sprachen (Andere)",
                             "Algonkin-Sprachen (Andere)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Altaisch.<br>
     */
    ALTAISCH("alt",
             "2.16.840.1.113883.6.121",
             "Altaisch",
             "Altaisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Altaische Sprachen (Andere).<br>
     */
    ALTAISCHE_SPRACHEN_ANDERE("tut",
                              "2.16.840.1.113883.6.121",
                              "Altaische Sprachen (Andere)",
                              "Altaische Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Altenglisch.<br>
     */
    ALTENGLISCH("ang",
                "2.16.840.1.113883.6.121",
                "Altenglisch",
                "Altenglisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Altfranzösisch.<br>
     */
    ALTFRANZ_SISCH("fro",
                   "2.16.840.1.113883.6.121",
                   "Altfranzösisch",
                   "Altfranzösisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Althochdeutsch.<br>
     */
    ALTHOCHDEUTSCH("goh",
                   "2.16.840.1.113883.6.121",
                   "Althochdeutsch",
                   "Althochdeutsch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Altirisch.<br>
     */
    ALTIRISCH("sga",
              "2.16.840.1.113883.6.121",
              "Altirisch",
              "Altirisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Altnorwegisch.<br>
     */
    ALTNORWEGISCH("non",
                  "2.16.840.1.113883.6.121",
                  "Altnorwegisch",
                  "Altnorwegisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Altokzitanisch.<br>
     */
    ALTOKZITANISCH("pro",
                   "2.16.840.1.113883.6.121",
                   "Altokzitanisch",
                   "Altokzitanisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Altpersisch.<br>
     */
    ALTPERSISCH("peo",
                "2.16.840.1.113883.6.121",
                "Altpersisch",
                "Altpersisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Alt-Newari.<br>
     */
    ALT_NEWARI("nwc",
               "2.16.840.1.113883.6.121",
               "Alt-Newari",
               "Alt-Newari",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Altäthiopisch.<br>
     */
    ALT_THIOPISCH("gez",
                  "2.16.840.1.113883.6.121",
                  "Altäthiopisch",
                  "Altäthiopisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Amharisch.<br>
     */
    AMHARISCH("am",
              "2.16.840.1.113883.6.121",
              "Amharisch",
              "Amharisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Anga-Sprache.<br>
     */
    ANGA_SPRACHE("anp",
                 "2.16.840.1.113883.6.121",
                 "Anga-Sprache",
                 "Anga-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Apachen-Sprachen.<br>
     */
    APACHEN_SPRACHEN("apa",
                     "2.16.840.1.113883.6.121",
                     "Apachen-Sprachen",
                     "Apachen-Sprachen",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Arabisch.<br>
     */
    ARABISCH("ar",
             "2.16.840.1.113883.6.121",
             "Arabisch",
             "Arabisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Aragonesisch.<br>
     */
    ARAGONESISCH("an",
                 "2.16.840.1.113883.6.121",
                 "Aragonesisch",
                 "Aragonesisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Aramäisch.<br>
     */
    ARAM_ISCH("arc",
              "2.16.840.1.113883.6.121",
              "Aramäisch",
              "Aramäisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Arapaho-Sprache.<br>
     */
    ARAPAHO_SPRACHE("arp",
                    "2.16.840.1.113883.6.121",
                    "Arapaho-Sprache",
                    "Arapaho-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Arauka-Sprachen.<br>
     */
    ARAUKA_SPRACHEN("arn",
                    "2.16.840.1.113883.6.121",
                    "Arauka-Sprachen",
                    "Arauka-Sprachen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Arawak-Sprachen.<br>
     */
    ARAWAK_SPRACHEN("arw",
                    "2.16.840.1.113883.6.121",
                    "Arawak-Sprachen",
                    "Arawak-Sprachen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Armenisch.<br>
     */
    ARMENISCH("hy",
              "2.16.840.1.113883.6.121",
              "Armenisch",
              "Armenisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Aromunisch.<br>
     */
    AROMUNISCH("rup",
               "2.16.840.1.113883.6.121",
               "Aromunisch",
               "Aromunisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Aserbeidschanisch.<br>
     */
    ASERBEIDSCHANISCH("az",
                      "2.16.840.1.113883.6.121",
                      "Aserbeidschanisch",
                      "Aserbeidschanisch",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Assamesisch.<br>
     */
    ASSAMESISCH("as",
                "2.16.840.1.113883.6.121",
                "Assamesisch",
                "Assamesisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Asturisch.<br>
     */
    ASTURISCH("ast",
              "2.16.840.1.113883.6.121",
              "Asturisch",
              "Asturisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Athapaskische Sprachen (Andere).<br>
     */
    ATHAPASKISCHE_SPRACHEN_ANDERE("ath",
                                  "2.16.840.1.113883.6.121",
                                  "Athapaskische Sprachen (Andere)",
                                  "Athapaskische Sprachen (Andere)",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Australische Sprachen.<br>
     */
    AUSTRALISCHE_SPRACHEN("aus",
                          "2.16.840.1.113883.6.121",
                          "Australische Sprachen",
                          "Australische Sprachen",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Austronesische Sprachen (Andere).<br>
     */
    AUSTRONESISCHE_SPRACHEN_ANDERE("map",
                                   "2.16.840.1.113883.6.121",
                                   "Austronesische Sprachen (Andere)",
                                   "Austronesische Sprachen (Andere)",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Avestisch.<br>
     */
    AVESTISCH("ae",
              "2.16.840.1.113883.6.121",
              "Avestisch",
              "Avestisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Awadhi.<br>
     */
    AWADHI("awa",
           "2.16.840.1.113883.6.121",
           "Awadhi",
           "Awadhi",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Awarisch.<br>
     */
    AWARISCH("av",
             "2.16.840.1.113883.6.121",
             "Awarisch",
             "Awarisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Aymará-Sprache.<br>
     */
    AYMAR_SPRACHE("ay",
                  "2.16.840.1.113883.6.121",
                  "Aymará-Sprache",
                  "Aymará-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Bahasa Indonesia.<br>
     */
    BAHASA_INDONESIA("id",
                     "2.16.840.1.113883.6.121",
                     "Bahasa Indonesia",
                     "Bahasa Indonesia",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Balinesisch.<br>
     */
    BALINESISCH("ban",
                "2.16.840.1.113883.6.121",
                "Balinesisch",
                "Balinesisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Baltische Sprachen (Andere).<br>
     */
    BALTISCHE_SPRACHEN_ANDERE("bat",
                              "2.16.840.1.113883.6.121",
                              "Baltische Sprachen (Andere)",
                              "Baltische Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Bambara-Sprache.<br>
     */
    BAMBARA_SPRACHE("bm",
                    "2.16.840.1.113883.6.121",
                    "Bambara-Sprache",
                    "Bambara-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Bamileke-Sprachen.<br>
     */
    BAMILEKE_SPRACHEN("bai",
                      "2.16.840.1.113883.6.121",
                      "Bamileke-Sprachen",
                      "Bamileke-Sprachen",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Banda-Sprachen (Ubangi-Sprachen).<br>
     */
    BANDA_SPRACHEN_UBANGI_SPRACHEN("bad",
                                   "2.16.840.1.113883.6.121",
                                   "Banda-Sprachen (Ubangi-Sprachen)",
                                   "Banda-Sprachen (Ubangi-Sprachen)",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Bantusprachen (Andere).<br>
     */
    BANTUSPRACHEN_ANDERE("bnt",
                         "2.16.840.1.113883.6.121",
                         "Bantusprachen (Andere)",
                         "Bantusprachen (Andere)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Basaa-Sprache.<br>
     */
    BASAA_SPRACHE("bas",
                  "2.16.840.1.113883.6.121",
                  "Basaa-Sprache",
                  "Basaa-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Baschkirisch.<br>
     */
    BASCHKIRISCH("ba",
                 "2.16.840.1.113883.6.121",
                 "Baschkirisch",
                 "Baschkirisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Baskisch.<br>
     */
    BASKISCH("eu",
             "2.16.840.1.113883.6.121",
             "Baskisch",
             "Baskisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Batak-Sprache.<br>
     */
    BATAK_SPRACHE("btk",
                  "2.16.840.1.113883.6.121",
                  "Batak-Sprache",
                  "Batak-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Beach-la-mar.<br>
     */
    BEACH_LA_MAR("bi",
                 "2.16.840.1.113883.6.121",
                 "Beach-la-mar",
                 "Beach-la-mar",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Bedauye.<br>
     */
    BEDAUYE("bej",
            "2.16.840.1.113883.6.121",
            "Bedauye",
            "Bedauye",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Belutschisch.<br>
     */
    BELUTSCHISCH("bal",
                 "2.16.840.1.113883.6.121",
                 "Belutschisch",
                 "Belutschisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Bemba-Sprache.<br>
     */
    BEMBA_SPRACHE("bem",
                  "2.16.840.1.113883.6.121",
                  "Bemba-Sprache",
                  "Bemba-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Bengali.<br>
     */
    BENGALI("bn",
            "2.16.840.1.113883.6.121",
            "Bengali",
            "Bengali",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Berbersprachen (Andere).<br>
     */
    BERBERSPRACHEN_ANDERE("ber",
                          "2.16.840.1.113883.6.121",
                          "Berbersprachen (Andere)",
                          "Berbersprachen (Andere)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Bhojpuri.<br>
     */
    BHOJPURI("bho",
             "2.16.840.1.113883.6.121",
             "Bhojpuri",
             "Bhojpuri",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Bihari (Andere).<br>
     */
    BIHARI_ANDERE("bh",
                  "2.16.840.1.113883.6.121",
                  "Bihari (Andere)",
                  "Bihari (Andere)",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Bikol-Sprache.<br>
     */
    BIKOL_SPRACHE("bik",
                  "2.16.840.1.113883.6.121",
                  "Bikol-Sprache",
                  "Bikol-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Bilin-Sprache.<br>
     */
    BILIN_SPRACHE("byn",
                  "2.16.840.1.113883.6.121",
                  "Bilin-Sprache",
                  "Bilin-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Birmanisch.<br>
     */
    BIRMANISCH("my",
               "2.16.840.1.113883.6.121",
               "Birmanisch",
               "Birmanisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Blackfoot-Sprache.<br>
     */
    BLACKFOOT_SPRACHE("bla",
                      "2.16.840.1.113883.6.121",
                      "Blackfoot-Sprache",
                      "Blackfoot-Sprache",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Bliss-Symbol.<br>
     */
    BLISS_SYMBOL("zbl",
                 "2.16.840.1.113883.6.121",
                 "Bliss-Symbol",
                 "Bliss-Symbol",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Bokmål.<br>
     */
    BOKM_L("nb",
           "2.16.840.1.113883.6.121",
           "Bokmål",
           "Bokmål",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Bosnisch.<br>
     */
    BOSNISCH("bs",
             "2.16.840.1.113883.6.121",
             "Bosnisch",
             "Bosnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Braj-Bhakha.<br>
     */
    BRAJ_BHAKHA("bra",
                "2.16.840.1.113883.6.121",
                "Braj-Bhakha",
                "Braj-Bhakha",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Bretonisch.<br>
     */
    BRETONISCH("br",
               "2.16.840.1.113883.6.121",
               "Bretonisch",
               "Bretonisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Bugi-Sprache.<br>
     */
    BUGI_SPRACHE("bug",
                 "2.16.840.1.113883.6.121",
                 "Bugi-Sprache",
                 "Bugi-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Bulgarisch.<br>
     */
    BULGARISCH("bg",
               "2.16.840.1.113883.6.121",
               "Bulgarisch",
               "Bulgarisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Burjatisch.<br>
     */
    BURJATISCH("bua",
               "2.16.840.1.113883.6.121",
               "Burjatisch",
               "Burjatisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Caddo-Sprachen.<br>
     */
    CADDO_SPRACHEN("cad",
                   "2.16.840.1.113883.6.121",
                   "Caddo-Sprachen",
                   "Caddo-Sprachen",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Cebuano.<br>
     */
    CEBUANO("ceb",
            "2.16.840.1.113883.6.121",
            "Cebuano",
            "Cebuano",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Chamorro-Sprache.<br>
     */
    CHAMORRO_SPRACHE("ch",
                     "2.16.840.1.113883.6.121",
                     "Chamorro-Sprache",
                     "Chamorro-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Cham-Sprachen.<br>
     */
    CHAM_SPRACHEN("cmc",
                  "2.16.840.1.113883.6.121",
                  "Cham-Sprachen",
                  "Cham-Sprachen",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Cherokee-Sprache.<br>
     */
    CHEROKEE_SPRACHE("chr",
                     "2.16.840.1.113883.6.121",
                     "Cherokee-Sprache",
                     "Cherokee-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Cheyenne-Sprache.<br>
     */
    CHEYENNE_SPRACHE("chy",
                     "2.16.840.1.113883.6.121",
                     "Cheyenne-Sprache",
                     "Cheyenne-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Chibcha-Sprachen.<br>
     */
    CHIBCHA_SPRACHEN("chb",
                     "2.16.840.1.113883.6.121",
                     "Chibcha-Sprachen",
                     "Chibcha-Sprachen",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Chinesisch.<br>
     */
    CHINESISCH("zh",
               "2.16.840.1.113883.6.121",
               "Chinesisch",
               "Chinesisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Chinook-Jargon.<br>
     */
    CHINOOK_JARGON("chn",
                   "2.16.840.1.113883.6.121",
                   "Chinook-Jargon",
                   "Chinook-Jargon",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Chipewyan-Sprache.<br>
     */
    CHIPEWYAN_SPRACHE("chp",
                      "2.16.840.1.113883.6.121",
                      "Chipewyan-Sprache",
                      "Chipewyan-Sprache",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Choctaw-Sprache.<br>
     */
    CHOCTAW_SPRACHE("cho",
                    "2.16.840.1.113883.6.121",
                    "Choctaw-Sprache",
                    "Choctaw-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Cree-Sprache.<br>
     */
    CREE_SPRACHE("cr",
                 "2.16.840.1.113883.6.121",
                 "Cree-Sprache",
                 "Cree-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Dajakisch.<br>
     */
    DAJAKISCH("day",
              "2.16.840.1.113883.6.121",
              "Dajakisch",
              "Dajakisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Dakota-Sprache.<br>
     */
    DAKOTA_SPRACHE("dak",
                   "2.16.840.1.113883.6.121",
                   "Dakota-Sprache",
                   "Dakota-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Danakil-Sprache.<br>
     */
    DANAKIL_SPRACHE("aa",
                    "2.16.840.1.113883.6.121",
                    "Danakil-Sprache",
                    "Danakil-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Darginisch.<br>
     */
    DARGINISCH("dar",
               "2.16.840.1.113883.6.121",
               "Darginisch",
               "Darginisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Delaware-Sprache.<br>
     */
    DELAWARE_SPRACHE("del",
                     "2.16.840.1.113883.6.121",
                     "Delaware-Sprache",
                     "Delaware-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Deutsch.<br>
     */
    DEUTSCH("de",
            "2.16.840.1.113883.6.121",
            "Deutsch",
            "Deutsch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Dinka-Sprache.<br>
     */
    DINKA_SPRACHE("din",
                  "2.16.840.1.113883.6.121",
                  "Dinka-Sprache",
                  "Dinka-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Dogri.<br>
     */
    DOGRI("doi",
          "2.16.840.1.113883.6.121",
          "Dogri",
          "Dogri",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Dogrib-Sprache.<br>
     */
    DOGRIB_SPRACHE("dgr",
                   "2.16.840.1.113883.6.121",
                   "Dogrib-Sprache",
                   "Dogrib-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Drawidische Sprachen (Andere).<br>
     */
    DRAWIDISCHE_SPRACHEN_ANDERE("dra",
                                "2.16.840.1.113883.6.121",
                                "Drawidische Sprachen (Andere)",
                                "Drawidische Sprachen (Andere)",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Duala-Sprachen.<br>
     */
    DUALA_SPRACHEN("dua",
                   "2.16.840.1.113883.6.121",
                   "Duala-Sprachen",
                   "Duala-Sprachen",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Dyula-Sprache.<br>
     */
    DYULA_SPRACHE("dyu",
                  "2.16.840.1.113883.6.121",
                  "Dyula-Sprache",
                  "Dyula-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Dzongkha.<br>
     */
    DZONGKHA("dz",
             "2.16.840.1.113883.6.121",
             "Dzongkha",
             "Dzongkha",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Dänisch.<br>
     */
    D_NISCH("da",
            "2.16.840.1.113883.6.121",
            "Dänisch",
            "Dänisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Edo-Sprache.<br>
     */
    EDO_SPRACHE("bin",
                "2.16.840.1.113883.6.121",
                "Edo-Sprache",
                "Edo-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Efik.<br>
     */
    EFIK("efi",
         "2.16.840.1.113883.6.121",
         "Efik",
         "Efik",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Einzelne andere Sprachen.<br>
     */
    EINZELNE_ANDERE_SPRACHEN("mis",
                             "2.16.840.1.113883.6.121",
                             "Einzelne andere Sprachen",
                             "Einzelne andere Sprachen",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Ekajuk.<br>
     */
    EKAJUK("eka",
           "2.16.840.1.113883.6.121",
           "Ekajuk",
           "Ekajuk",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Elamisch.<br>
     */
    ELAMISCH("elx",
             "2.16.840.1.113883.6.121",
             "Elamisch",
             "Elamisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Elliceanisch.<br>
     */
    ELLICEANISCH("tvl",
                 "2.16.840.1.113883.6.121",
                 "Elliceanisch",
                 "Elliceanisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Englisch.<br>
     */
    ENGLISCH("en",
             "2.16.840.1.113883.6.121",
             "Englisch",
             "Englisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Erza-Mordwinisch.<br>
     */
    ERZA_MORDWINISCH("myv",
                     "2.16.840.1.113883.6.121",
                     "Erza-Mordwinisch",
                     "Erza-Mordwinisch",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Esperanto.<br>
     */
    ESPERANTO("eo",
              "2.16.840.1.113883.6.121",
              "Esperanto",
              "Esperanto",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Estnisch.<br>
     */
    ESTNISCH("et",
             "2.16.840.1.113883.6.121",
             "Estnisch",
             "Estnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Ewe-Sprache.<br>
     */
    EWE_SPRACHE("ee",
                "2.16.840.1.113883.6.121",
                "Ewe-Sprache",
                "Ewe-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Ewondo.<br>
     */
    EWONDO("ewo",
           "2.16.840.1.113883.6.121",
           "Ewondo",
           "Ewondo",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Fante-Sprache.<br>
     */
    FANTE_SPRACHE("fat",
                  "2.16.840.1.113883.6.121",
                  "Fante-Sprache",
                  "Fante-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Fidschi-Sprache.<br>
     */
    FIDSCHI_SPRACHE("fj",
                    "2.16.840.1.113883.6.121",
                    "Fidschi-Sprache",
                    "Fidschi-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Finnisch.<br>
     */
    FINNISCH("fi",
             "2.16.840.1.113883.6.121",
             "Finnisch",
             "Finnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Finnougrische Sprachen (Andere).<br>
     */
    FINNOUGRISCHE_SPRACHEN_ANDERE("fiu",
                                  "2.16.840.1.113883.6.121",
                                  "Finnougrische Sprachen (Andere)",
                                  "Finnougrische Sprachen (Andere)",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Fon-Sprache.<br>
     */
    FON_SPRACHE("fon",
                "2.16.840.1.113883.6.121",
                "Fon-Sprache",
                "Fon-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Französisch.<br>
     */
    FRANZ_SISCH("fr",
                "2.16.840.1.113883.6.121",
                "Französisch",
                "Französisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Friesisch.<br>
     */
    FRIESISCH("fy",
              "2.16.840.1.113883.6.121",
              "Friesisch",
              "Friesisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Friulisch.<br>
     */
    FRIULISCH("fur",
              "2.16.840.1.113883.6.121",
              "Friulisch",
              "Friulisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Ful.<br>
     */
    FUL("ff",
        "2.16.840.1.113883.6.121",
        "Ful",
        "Ful",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: Färöisch.<br>
     */
    F_R_ISCH("fo",
             "2.16.840.1.113883.6.121",
             "Färöisch",
             "Färöisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Galicisch.<br>
     */
    GALICISCH("gl",
              "2.16.840.1.113883.6.121",
              "Galicisch",
              "Galicisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Galla-Sprache.<br>
     */
    GALLA_SPRACHE("om",
                  "2.16.840.1.113883.6.121",
                  "Galla-Sprache",
                  "Galla-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Ganda-Sprache.<br>
     */
    GANDA_SPRACHE("lg",
                  "2.16.840.1.113883.6.121",
                  "Ganda-Sprache",
                  "Ganda-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gayo-Sprache.<br>
     */
    GAYO_SPRACHE("gay",
                 "2.16.840.1.113883.6.121",
                 "Gayo-Sprache",
                 "Gayo-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Ga-Sprache.<br>
     */
    GA_SPRACHE("gaa",
               "2.16.840.1.113883.6.121",
               "Ga-Sprache",
               "Ga-Sprache",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Gbaya-Sprache.<br>
     */
    GBAYA_SPRACHE("gba",
                  "2.16.840.1.113883.6.121",
                  "Gbaya-Sprache",
                  "Gbaya-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Georgisch.<br>
     */
    GEORGISCH("ka",
              "2.16.840.1.113883.6.121",
              "Georgisch",
              "Georgisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Germanische Sprachen (Andere).<br>
     */
    GERMANISCHE_SPRACHEN_ANDERE("gem",
                                "2.16.840.1.113883.6.121",
                                "Germanische Sprachen (Andere)",
                                "Germanische Sprachen (Andere)",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Gilbertesisch.<br>
     */
    GILBERTESISCH("gil",
                  "2.16.840.1.113883.6.121",
                  "Gilbertesisch",
                  "Gilbertesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gondi-Sprache.<br>
     */
    GONDI_SPRACHE("gon",
                  "2.16.840.1.113883.6.121",
                  "Gondi-Sprache",
                  "Gondi-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gorontalesisch.<br>
     */
    GORONTALESISCH("gor",
                   "2.16.840.1.113883.6.121",
                   "Gorontalesisch",
                   "Gorontalesisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Gotisch.<br>
     */
    GOTISCH("got",
            "2.16.840.1.113883.6.121",
            "Gotisch",
            "Gotisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Grebo-Sprache.<br>
     */
    GREBO_SPRACHE("grb",
                  "2.16.840.1.113883.6.121",
                  "Grebo-Sprache",
                  "Grebo-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Griechisch.<br>
     */
    GRIECHISCH("grc",
               "2.16.840.1.113883.6.121",
               "Griechisch",
               "Griechisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Grönländisch.<br>
     */
    GR_NL_NDISCH("kl",
                 "2.16.840.1.113883.6.121",
                 "Grönländisch",
                 "Grönländisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Guaraní-Sprache.<br>
     */
    GUARAN_SPRACHE("gn",
                   "2.16.840.1.113883.6.121",
                   "Guaraní-Sprache",
                   "Guaraní-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Gujarati-Sprache.<br>
     */
    GUJARATI_SPRACHE("gu",
                     "2.16.840.1.113883.6.121",
                     "Gujarati-Sprache",
                     "Gujarati-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Gälisch-Schottisch.<br>
     */
    G_LISCH_SCHOTTISCH("gd",
                       "2.16.840.1.113883.6.121",
                       "Gälisch-Schottisch",
                       "Gälisch-Schottisch",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Haida-Sprache.<br>
     */
    HAIDA_SPRACHE("hai",
                  "2.16.840.1.113883.6.121",
                  "Haida-Sprache",
                  "Haida-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Hamitosemitische Sprachen (Andere).<br>
     */
    HAMITOSEMITISCHE_SPRACHEN_ANDERE("afa",
                                     "2.16.840.1.113883.6.121",
                                     "Hamitosemitische Sprachen (Andere)",
                                     "Hamitosemitische Sprachen (Andere)",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Haussa-Sprache.<br>
     */
    HAUSSA_SPRACHE("ha",
                   "2.16.840.1.113883.6.121",
                   "Haussa-Sprache",
                   "Haussa-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Hawaiisch.<br>
     */
    HAWAIISCH("haw",
              "2.16.840.1.113883.6.121",
              "Hawaiisch",
              "Hawaiisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Haïtien (Haiti-Kreolisch).<br>
     */
    HA_TIEN_HAITI_KREOLISCH("ht",
                            "2.16.840.1.113883.6.121",
                            "Haïtien (Haiti-Kreolisch)",
                            "Haïtien (Haiti-Kreolisch)",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Hebräisch.<br>
     */
    HEBR_ISCH("he",
              "2.16.840.1.113883.6.121",
              "Hebräisch",
              "Hebräisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Herero-Sprache.<br>
     */
    HERERO_SPRACHE("hz",
                   "2.16.840.1.113883.6.121",
                   "Herero-Sprache",
                   "Herero-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Hethitisch.<br>
     */
    HETHITISCH("hit",
               "2.16.840.1.113883.6.121",
               "Hethitisch",
               "Hethitisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Hiligaynon-Sprache.<br>
     */
    HILIGAYNON_SPRACHE("hil",
                       "2.16.840.1.113883.6.121",
                       "Hiligaynon-Sprache",
                       "Hiligaynon-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Himachali.<br>
     */
    HIMACHALI("him",
              "2.16.840.1.113883.6.121",
              "Himachali",
              "Himachali",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Hindi.<br>
     */
    HINDI("hi",
          "2.16.840.1.113883.6.121",
          "Hindi",
          "Hindi",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Hiri-Motu.<br>
     */
    HIRI_MOTU("ho",
              "2.16.840.1.113883.6.121",
              "Hiri-Motu",
              "Hiri-Motu",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Hupa-Sprache.<br>
     */
    HUPA_SPRACHE("hup",
                 "2.16.840.1.113883.6.121",
                 "Hupa-Sprache",
                 "Hupa-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Iban-Sprache.<br>
     */
    IBAN_SPRACHE("iba",
                 "2.16.840.1.113883.6.121",
                 "Iban-Sprache",
                 "Iban-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Ibo-Sprache.<br>
     */
    IBO_SPRACHE("ig",
                "2.16.840.1.113883.6.121",
                "Ibo-Sprache",
                "Ibo-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Ido.<br>
     */
    IDO("io",
        "2.16.840.1.113883.6.121",
        "Ido",
        "Ido",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: Ijo-Sprache.<br>
     */
    IJO_SPRACHE("ijo",
                "2.16.840.1.113883.6.121",
                "Ijo-Sprache",
                "Ijo-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Ilokano-Sprache.<br>
     */
    ILOKANO_SPRACHE("ilo",
                    "2.16.840.1.113883.6.121",
                    "Ilokano-Sprache",
                    "Ilokano-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Inarisaamisch.<br>
     */
    INARISAAMISCH("smn",
                  "2.16.840.1.113883.6.121",
                  "Inarisaamisch",
                  "Inarisaamisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Indianersprachen, Nordamerika (Andere).<br>
     */
    INDIANERSPRACHEN_NORDAMERIKA_ANDERE("nai",
                                        "2.16.840.1.113883.6.121",
                                        "Indianersprachen, Nordamerika (Andere)",
                                        "Indianersprachen, Nordamerika (Andere)",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Indianersprachen, Südamerika (Andere).<br>
     */
    INDIANERSPRACHEN_S_DAMERIKA_ANDERE("sai",
                                       "2.16.840.1.113883.6.121",
                                       "Indianersprachen, Südamerika (Andere)",
                                       "Indianersprachen, Südamerika (Andere)",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Indianersprachen, Zentralamerika (Andere).<br>
     */
    INDIANERSPRACHEN_ZENTRALAMERIKA_ANDERE("cai",
                                           "2.16.840.1.113883.6.121",
                                           "Indianersprachen, Zentralamerika (Andere)",
                                           "Indianersprachen, Zentralamerika (Andere)",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Indoarische Sprachen (Andere).<br>
     */
    INDOARISCHE_SPRACHEN_ANDERE("inc",
                                "2.16.840.1.113883.6.121",
                                "Indoarische Sprachen (Andere)",
                                "Indoarische Sprachen (Andere)",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Indogermanische Sprachen (Andere).<br>
     */
    INDOGERMANISCHE_SPRACHEN_ANDERE("ine",
                                    "2.16.840.1.113883.6.121",
                                    "Indogermanische Sprachen (Andere)",
                                    "Indogermanische Sprachen (Andere)",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Inguschisch.<br>
     */
    INGUSCHISCH("inh",
                "2.16.840.1.113883.6.121",
                "Inguschisch",
                "Inguschisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Interlingua.<br>
     */
    INTERLINGUA("ia",
                "2.16.840.1.113883.6.121",
                "Interlingua",
                "Interlingua",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Interlingue.<br>
     */
    INTERLINGUE("ie",
                "2.16.840.1.113883.6.121",
                "Interlingue",
                "Interlingue",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Inuktitut.<br>
     */
    INUKTITUT("iu",
              "2.16.840.1.113883.6.121",
              "Inuktitut",
              "Inuktitut",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Inupik.<br>
     */
    INUPIK("ik",
           "2.16.840.1.113883.6.121",
           "Inupik",
           "Inupik",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Iranische Sprachen (Andere).<br>
     */
    IRANISCHE_SPRACHEN_ANDERE("ira",
                              "2.16.840.1.113883.6.121",
                              "Iranische Sprachen (Andere)",
                              "Iranische Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Irisch.<br>
     */
    IRISCH("ga",
           "2.16.840.1.113883.6.121",
           "Irisch",
           "Irisch",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Irokesische Sprachen.<br>
     */
    IROKESISCHE_SPRACHEN("iro",
                         "2.16.840.1.113883.6.121",
                         "Irokesische Sprachen",
                         "Irokesische Sprachen",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Isländisch.<br>
     */
    ISL_NDISCH("is",
               "2.16.840.1.113883.6.121",
               "Isländisch",
               "Isländisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Italienisch.<br>
     */
    ITALIENISCH("it",
                "2.16.840.1.113883.6.121",
                "Italienisch",
                "Italienisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Jakutisch.<br>
     */
    JAKUTISCH("sah",
              "2.16.840.1.113883.6.121",
              "Jakutisch",
              "Jakutisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Japanisch.<br>
     */
    JAPANISCH("ja",
              "2.16.840.1.113883.6.121",
              "Japanisch",
              "Japanisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Javanisch.<br>
     */
    JAVANISCH("jv",
              "2.16.840.1.113883.6.121",
              "Javanisch",
              "Javanisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Jiddisch.<br>
     */
    JIDDISCH("yi",
             "2.16.840.1.113883.6.121",
             "Jiddisch",
             "Jiddisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Judenspanisch.<br>
     */
    JUDENSPANISCH("lad",
                  "2.16.840.1.113883.6.121",
                  "Judenspanisch",
                  "Judenspanisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Jüdisch-Arabisch.<br>
     */
    J_DISCH_ARABISCH("jrb",
                     "2.16.840.1.113883.6.121",
                     "Jüdisch-Arabisch",
                     "Jüdisch-Arabisch",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Jüdisch-Persisch.<br>
     */
    J_DISCH_PERSISCH("jpr",
                     "2.16.840.1.113883.6.121",
                     "Jüdisch-Persisch",
                     "Jüdisch-Persisch",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Kabardinisch.<br>
     */
    KABARDINISCH("kbd",
                 "2.16.840.1.113883.6.121",
                 "Kabardinisch",
                 "Kabardinisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Kabylisch.<br>
     */
    KABYLISCH("kab",
              "2.16.840.1.113883.6.121",
              "Kabylisch",
              "Kabylisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Kachin-Sprache.<br>
     */
    KACHIN_SPRACHE("kac",
                   "2.16.840.1.113883.6.121",
                   "Kachin-Sprache",
                   "Kachin-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Kalmückisch.<br>
     */
    KALM_CKISCH("xal",
                "2.16.840.1.113883.6.121",
                "Kalmückisch",
                "Kalmückisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Kamba-Sprache.<br>
     */
    KAMBA_SPRACHE("kam",
                  "2.16.840.1.113883.6.121",
                  "Kamba-Sprache",
                  "Kamba-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Kambodschanisch.<br>
     */
    KAMBODSCHANISCH("km",
                    "2.16.840.1.113883.6.121",
                    "Kambodschanisch",
                    "Kambodschanisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Kannada.<br>
     */
    KANNADA("kn",
            "2.16.840.1.113883.6.121",
            "Kannada",
            "Kannada",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Kanuri-Sprache.<br>
     */
    KANURI_SPRACHE("kr",
                   "2.16.840.1.113883.6.121",
                   "Kanuri-Sprache",
                   "Kanuri-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Karakalpakisch.<br>
     */
    KARAKALPAKISCH("kaa",
                   "2.16.840.1.113883.6.121",
                   "Karakalpakisch",
                   "Karakalpakisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Karatschaiisch-Balkarisch.<br>
     */
    KARATSCHAIISCH_BALKARISCH("krc",
                              "2.16.840.1.113883.6.121",
                              "Karatschaiisch-Balkarisch",
                              "Karatschaiisch-Balkarisch",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Karelisch.<br>
     */
    KARELISCH("krl",
              "2.16.840.1.113883.6.121",
              "Karelisch",
              "Karelisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Karenisch.<br>
     */
    KARENISCH("kar",
              "2.16.840.1.113883.6.121",
              "Karenisch",
              "Karenisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Karibische Sprachen.<br>
     */
    KARIBISCHE_SPRACHEN("car",
                        "2.16.840.1.113883.6.121",
                        "Karibische Sprachen",
                        "Karibische Sprachen",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Kasachisch.<br>
     */
    KASACHISCH("kk",
               "2.16.840.1.113883.6.121",
               "Kasachisch",
               "Kasachisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Kaschmiri.<br>
     */
    KASCHMIRI("ks",
              "2.16.840.1.113883.6.121",
              "Kaschmiri",
              "Kaschmiri",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Kaschubisch.<br>
     */
    KASCHUBISCH("csb",
                "2.16.840.1.113883.6.121",
                "Kaschubisch",
                "Kaschubisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Katalanisch.<br>
     */
    KATALANISCH("ca",
                "2.16.840.1.113883.6.121",
                "Katalanisch",
                "Katalanisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Kaukasische Sprachen (Andere).<br>
     */
    KAUKASISCHE_SPRACHEN_ANDERE("cau",
                                "2.16.840.1.113883.6.121",
                                "Kaukasische Sprachen (Andere)",
                                "Kaukasische Sprachen (Andere)",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Kawi.<br>
     */
    KAWI("kaw",
         "2.16.840.1.113883.6.121",
         "Kawi",
         "Kawi",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Kein linguistischer Inhalt.<br>
     */
    KEIN_LINGUISTISCHER_INHALT("zxx",
                               "2.16.840.1.113883.6.121",
                               "Kein linguistischer Inhalt",
                               "Kein linguistischer Inhalt",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Keltische Sprachen (Andere).<br>
     */
    KELTISCHE_SPRACHEN_ANDERE("cel",
                              "2.16.840.1.113883.6.121",
                              "Keltische Sprachen (Andere)",
                              "Keltische Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Khasi-Sprache.<br>
     */
    KHASI_SPRACHE("kha",
                  "2.16.840.1.113883.6.121",
                  "Khasi-Sprache",
                  "Khasi-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Khoisan-Sprachen (Andere).<br>
     */
    KHOISAN_SPRACHEN_ANDERE("khi",
                            "2.16.840.1.113883.6.121",
                            "Khoisan-Sprachen (Andere)",
                            "Khoisan-Sprachen (Andere)",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Khotta.<br>
     */
    KHOTTA("mag",
           "2.16.840.1.113883.6.121",
           "Khotta",
           "Khotta",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Kikuyu-Sprache.<br>
     */
    KIKUYU_SPRACHE("ki",
                   "2.16.840.1.113883.6.121",
                   "Kikuyu-Sprache",
                   "Kikuyu-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Kimbundu-Sprache.<br>
     */
    KIMBUNDU_SPRACHE("kmb",
                     "2.16.840.1.113883.6.121",
                     "Kimbundu-Sprache",
                     "Kimbundu-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Kirchenslawisch.<br>
     */
    KIRCHENSLAWISCH("cu",
                    "2.16.840.1.113883.6.121",
                    "Kirchenslawisch",
                    "Kirchenslawisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Kirgisisch.<br>
     */
    KIRGISISCH("ky",
               "2.16.840.1.113883.6.121",
               "Kirgisisch",
               "Kirgisisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Klingonisch.<br>
     */
    KLINGONISCH("tlh",
                "2.16.840.1.113883.6.121",
                "Klingonisch",
                "Klingonisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Komi-Sprache.<br>
     */
    KOMI_SPRACHE("kv",
                 "2.16.840.1.113883.6.121",
                 "Komi-Sprache",
                 "Komi-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Kongo-Sprache.<br>
     */
    KONGO_SPRACHE("kg",
                  "2.16.840.1.113883.6.121",
                  "Kongo-Sprache",
                  "Kongo-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Konkani.<br>
     */
    KONKANI("kok",
            "2.16.840.1.113883.6.121",
            "Konkani",
            "Konkani",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Koptisch.<br>
     */
    KOPTISCH("cop",
             "2.16.840.1.113883.6.121",
             "Koptisch",
             "Koptisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Koreanisch.<br>
     */
    KOREANISCH("ko",
               "2.16.840.1.113883.6.121",
               "Koreanisch",
               "Koreanisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Kornisch.<br>
     */
    KORNISCH("kw",
             "2.16.840.1.113883.6.121",
             "Kornisch",
             "Kornisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Korsisch.<br>
     */
    KORSISCH("co",
             "2.16.840.1.113883.6.121",
             "Korsisch",
             "Korsisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Kosraeanisch.<br>
     */
    KOSRAEANISCH("kos",
                 "2.16.840.1.113883.6.121",
                 "Kosraeanisch",
                 "Kosraeanisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Kpelle-Sprache.<br>
     */
    KPELLE_SPRACHE("kpe",
                   "2.16.840.1.113883.6.121",
                   "Kpelle-Sprache",
                   "Kpelle-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Kreolische Sprachen; Pidginsprachen (Andere).<br>
     */
    KREOLISCHE_SPRACHEN_PIDGINSPRACHEN_ANDERE("crp",
                                              "2.16.840.1.113883.6.121",
                                              "Kreolische Sprachen; Pidginsprachen (Andere)",
                                              "Kreolische Sprachen; Pidginsprachen (Andere)",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Kreolisch-Englisch (Andere).<br>
     */
    KREOLISCH_ENGLISCH_ANDERE("cpe",
                              "2.16.840.1.113883.6.121",
                              "Kreolisch-Englisch (Andere)",
                              "Kreolisch-Englisch (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Kreolisch-Französisch (Andere).<br>
     */
    KREOLISCH_FRANZ_SISCH_ANDERE("cpf",
                                 "2.16.840.1.113883.6.121",
                                 "Kreolisch-Französisch (Andere)",
                                 "Kreolisch-Französisch (Andere)",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Kreolisch-Portugiesisch (Andere).<br>
     */
    KREOLISCH_PORTUGIESISCH_ANDERE("cpp",
                                   "2.16.840.1.113883.6.121",
                                   "Kreolisch-Portugiesisch (Andere)",
                                   "Kreolisch-Portugiesisch (Andere)",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Krimtatarisch.<br>
     */
    KRIMTATARISCH("crh",
                  "2.16.840.1.113883.6.121",
                  "Krimtatarisch",
                  "Krimtatarisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Kroatisch.<br>
     */
    KROATISCH("hr",
              "2.16.840.1.113883.6.121",
              "Kroatisch",
              "Kroatisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Kru-Sprachen (Andere).<br>
     */
    KRU_SPRACHEN_ANDERE("kro",
                        "2.16.840.1.113883.6.121",
                        "Kru-Sprachen (Andere)",
                        "Kru-Sprachen (Andere)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Kumükisch.<br>
     */
    KUM_KISCH("kum",
              "2.16.840.1.113883.6.121",
              "Kumükisch",
              "Kumükisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Kunstsprachen (Andere).<br>
     */
    KUNSTSPRACHEN_ANDERE("art",
                         "2.16.840.1.113883.6.121",
                         "Kunstsprachen (Andere)",
                         "Kunstsprachen (Andere)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Kurdisch.<br>
     */
    KURDISCH("ku",
             "2.16.840.1.113883.6.121",
             "Kurdisch",
             "Kurdisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Kuschitische Sprachen (Andere).<br>
     */
    KUSCHITISCHE_SPRACHEN_ANDERE("cus",
                                 "2.16.840.1.113883.6.121",
                                 "Kuschitische Sprachen (Andere)",
                                 "Kuschitische Sprachen (Andere)",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Kutchin-Sprache.<br>
     */
    KUTCHIN_SPRACHE("gwi",
                    "2.16.840.1.113883.6.121",
                    "Kutchin-Sprache",
                    "Kutchin-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Kutenai-Sprache.<br>
     */
    KUTENAI_SPRACHE("kut",
                    "2.16.840.1.113883.6.121",
                    "Kutenai-Sprache",
                    "Kutenai-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Kwanyama-Sprache.<br>
     */
    KWANYAMA_SPRACHE("kj",
                     "2.16.840.1.113883.6.121",
                     "Kwanyama-Sprache",
                     "Kwanyama-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Kymrisch.<br>
     */
    KYMRISCH("cy",
             "2.16.840.1.113883.6.121",
             "Kymrisch",
             "Kymrisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Lahnda.<br>
     */
    LAHNDA("lah",
           "2.16.840.1.113883.6.121",
           "Lahnda",
           "Lahnda",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Lalo-Sprache.<br>
     */
    LALO_SPRACHE("ii",
                 "2.16.840.1.113883.6.121",
                 "Lalo-Sprache",
                 "Lalo-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Lamba-Sprache (Bantusprache).<br>
     */
    LAMBA_SPRACHE_BANTUSPRACHE("lam",
                               "2.16.840.1.113883.6.121",
                               "Lamba-Sprache (Bantusprache)",
                               "Lamba-Sprache (Bantusprache)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Laotisch.<br>
     */
    LAOTISCH("lo",
             "2.16.840.1.113883.6.121",
             "Laotisch",
             "Laotisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Latein.<br>
     */
    LATEIN("la",
           "2.16.840.1.113883.6.121",
           "Latein",
           "Latein",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Lesgisch.<br>
     */
    LESGISCH("lez",
             "2.16.840.1.113883.6.121",
             "Lesgisch",
             "Lesgisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Lettisch.<br>
     */
    LETTISCH("lv",
             "2.16.840.1.113883.6.121",
             "Lettisch",
             "Lettisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Limburgisch.<br>
     */
    LIMBURGISCH("li",
                "2.16.840.1.113883.6.121",
                "Limburgisch",
                "Limburgisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Lingala.<br>
     */
    LINGALA("ln",
            "2.16.840.1.113883.6.121",
            "Lingala",
            "Lingala",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Litauisch.<br>
     */
    LITAUISCH("lt",
              "2.16.840.1.113883.6.121",
              "Litauisch",
              "Litauisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Lojban.<br>
     */
    LOJBAN("jbo",
           "2.16.840.1.113883.6.121",
           "Lojban",
           "Lojban",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Luba-Katanga-Sprache.<br>
     */
    LUBA_KATANGA_SPRACHE("lu",
                         "2.16.840.1.113883.6.121",
                         "Luba-Katanga-Sprache",
                         "Luba-Katanga-Sprache",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Luiseño-Sprache.<br>
     */
    LUISE_O_SPRACHE("lui",
                    "2.16.840.1.113883.6.121",
                    "Luiseño-Sprache",
                    "Luiseño-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Lulesaamisch.<br>
     */
    LULESAAMISCH("smj",
                 "2.16.840.1.113883.6.121",
                 "Lulesaamisch",
                 "Lulesaamisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Lulua-Sprache.<br>
     */
    LULUA_SPRACHE("lua",
                  "2.16.840.1.113883.6.121",
                  "Lulua-Sprache",
                  "Lulua-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Lunda-Sprache.<br>
     */
    LUNDA_SPRACHE("lun",
                  "2.16.840.1.113883.6.121",
                  "Lunda-Sprache",
                  "Lunda-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Luo-Sprache.<br>
     */
    LUO_SPRACHE("luo",
                "2.16.840.1.113883.6.121",
                "Luo-Sprache",
                "Luo-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Lushai-Sprache.<br>
     */
    LUSHAI_SPRACHE("lus",
                   "2.16.840.1.113883.6.121",
                   "Lushai-Sprache",
                   "Lushai-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Luxemburgisch.<br>
     */
    LUXEMBURGISCH("lb",
                  "2.16.840.1.113883.6.121",
                  "Luxemburgisch",
                  "Luxemburgisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Maduresisch.<br>
     */
    MADURESISCH("mad",
                "2.16.840.1.113883.6.121",
                "Maduresisch",
                "Maduresisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Maithili.<br>
     */
    MAITHILI("mai",
             "2.16.840.1.113883.6.121",
             "Maithili",
             "Maithili",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Makassarisch.<br>
     */
    MAKASSARISCH("mak",
                 "2.16.840.1.113883.6.121",
                 "Makassarisch",
                 "Makassarisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Makedonisch.<br>
     */
    MAKEDONISCH("mk",
                "2.16.840.1.113883.6.121",
                "Makedonisch",
                "Makedonisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Malagassi-Sprache.<br>
     */
    MALAGASSI_SPRACHE("mg",
                      "2.16.840.1.113883.6.121",
                      "Malagassi-Sprache",
                      "Malagassi-Sprache",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Malaiisch.<br>
     */
    MALAIISCH("ms",
              "2.16.840.1.113883.6.121",
              "Malaiisch",
              "Malaiisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Malayalam.<br>
     */
    MALAYALAM("ml",
              "2.16.840.1.113883.6.121",
              "Malayalam",
              "Malayalam",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Maledivisch.<br>
     */
    MALEDIVISCH("dv",
                "2.16.840.1.113883.6.121",
                "Maledivisch",
                "Maledivisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Malinke-Sprache.<br>
     */
    MALINKE_SPRACHE("man",
                    "2.16.840.1.113883.6.121",
                    "Malinke-Sprache",
                    "Malinke-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Maltesisch.<br>
     */
    MALTESISCH("mt",
               "2.16.840.1.113883.6.121",
               "Maltesisch",
               "Maltesisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mandaresisch.<br>
     */
    MANDARESISCH("mdr",
                 "2.16.840.1.113883.6.121",
                 "Mandaresisch",
                 "Mandaresisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Mandschurisch.<br>
     */
    MANDSCHURISCH("mnc",
                  "2.16.840.1.113883.6.121",
                  "Mandschurisch",
                  "Mandschurisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Manobo-Sprachen.<br>
     */
    MANOBO_SPRACHEN("mno",
                    "2.16.840.1.113883.6.121",
                    "Manobo-Sprachen",
                    "Manobo-Sprachen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Manx.<br>
     */
    MANX("gv",
         "2.16.840.1.113883.6.121",
         "Manx",
         "Manx",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Maori-Sprache.<br>
     */
    MAORI_SPRACHE("mi",
                  "2.16.840.1.113883.6.121",
                  "Maori-Sprache",
                  "Maori-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Marathi.<br>
     */
    MARATHI("mr",
            "2.16.840.1.113883.6.121",
            "Marathi",
            "Marathi",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Marschallesisch.<br>
     */
    MARSCHALLESISCH("mh",
                    "2.16.840.1.113883.6.121",
                    "Marschallesisch",
                    "Marschallesisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Marwari.<br>
     */
    MARWARI("mwr",
            "2.16.840.1.113883.6.121",
            "Marwari",
            "Marwari",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Massai-Sprache.<br>
     */
    MASSAI_SPRACHE("mas",
                   "2.16.840.1.113883.6.121",
                   "Massai-Sprache",
                   "Massai-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Maya-Sprachen.<br>
     */
    MAYA_SPRACHEN("myn",
                  "2.16.840.1.113883.6.121",
                  "Maya-Sprachen",
                  "Maya-Sprachen",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Mbundu-Sprache.<br>
     */
    MBUNDU_SPRACHE("umb",
                   "2.16.840.1.113883.6.121",
                   "Mbundu-Sprache",
                   "Mbundu-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Mehrere Sprachen.<br>
     */
    MEHRERE_SPRACHEN("mul",
                     "2.16.840.1.113883.6.121",
                     "Mehrere Sprachen",
                     "Mehrere Sprachen",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Meithei-Sprache.<br>
     */
    MEITHEI_SPRACHE("mni",
                    "2.16.840.1.113883.6.121",
                    "Meithei-Sprache",
                    "Meithei-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Mende-Sprache.<br>
     */
    MENDE_SPRACHE("men",
                  "2.16.840.1.113883.6.121",
                  "Mende-Sprache",
                  "Mende-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Miao-Sprachen.<br>
     */
    MIAO_SPRACHEN("hmn",
                  "2.16.840.1.113883.6.121",
                  "Miao-Sprachen",
                  "Miao-Sprachen",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Micmac-Sprache.<br>
     */
    MICMAC_SPRACHE("mic",
                   "2.16.840.1.113883.6.121",
                   "Micmac-Sprache",
                   "Micmac-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Minangkabau-Sprache.<br>
     */
    MINANGKABAU_SPRACHE("min",
                        "2.16.840.1.113883.6.121",
                        "Minangkabau-Sprache",
                        "Minangkabau-Sprache",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Mirandesisch.<br>
     */
    MIRANDESISCH("mwl",
                 "2.16.840.1.113883.6.121",
                 "Mirandesisch",
                 "Mirandesisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Mittelenglisch.<br>
     */
    MITTELENGLISCH("enm",
                   "2.16.840.1.113883.6.121",
                   "Mittelenglisch",
                   "Mittelenglisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Mittelfranzösisch.<br>
     */
    MITTELFRANZ_SISCH("frm",
                      "2.16.840.1.113883.6.121",
                      "Mittelfranzösisch",
                      "Mittelfranzösisch",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Mittelhochdeutsch.<br>
     */
    MITTELHOCHDEUTSCH("gmh",
                      "2.16.840.1.113883.6.121",
                      "Mittelhochdeutsch",
                      "Mittelhochdeutsch",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Mittelirisch.<br>
     */
    MITTELIRISCH("mga",
                 "2.16.840.1.113883.6.121",
                 "Mittelirisch",
                 "Mittelirisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Mittelniederländisch.<br>
     */
    MITTELNIEDERL_NDISCH("dum",
                         "2.16.840.1.113883.6.121",
                         "Mittelniederländisch",
                         "Mittelniederländisch",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Mittelpersisch.<br>
     */
    MITTELPERSISCH("pal",
                   "2.16.840.1.113883.6.121",
                   "Mittelpersisch",
                   "Mittelpersisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Mohawk-Sprache.<br>
     */
    MOHAWK_SPRACHE("moh",
                   "2.16.840.1.113883.6.121",
                   "Mohawk-Sprache",
                   "Mohawk-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Mokscha-Sprache.<br>
     */
    MOKSCHA_SPRACHE("mdf",
                    "2.16.840.1.113883.6.121",
                    "Mokscha-Sprache",
                    "Mokscha-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Mongolisch.<br>
     */
    MONGOLISCH("mn",
               "2.16.840.1.113883.6.121",
               "Mongolisch",
               "Mongolisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mongo-Sprache.<br>
     */
    MONGO_SPRACHE("lol",
                  "2.16.840.1.113883.6.121",
                  "Mongo-Sprache",
                  "Mongo-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Mon-Khmer-Sprachen (Andere).<br>
     */
    MON_KHMER_SPRACHEN_ANDERE("mkh",
                              "2.16.840.1.113883.6.121",
                              "Mon-Khmer-Sprachen (Andere)",
                              "Mon-Khmer-Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Mossi-Sprache.<br>
     */
    MOSSI_SPRACHE("mos",
                  "2.16.840.1.113883.6.121",
                  "Mossi-Sprache",
                  "Mossi-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Mundasprachen (Andere).<br>
     */
    MUNDASPRACHEN_ANDERE("mun",
                         "2.16.840.1.113883.6.121",
                         "Mundasprachen (Andere)",
                         "Mundasprachen (Andere)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Muskogisch.<br>
     */
    MUSKOGISCH("mus",
               "2.16.840.1.113883.6.121",
               "Muskogisch",
               "Muskogisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Nahuatl.<br>
     */
    NAHUATL("nah",
            "2.16.840.1.113883.6.121",
            "Nahuatl",
            "Nahuatl",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Nauruanisch.<br>
     */
    NAURUANISCH("na",
                "2.16.840.1.113883.6.121",
                "Nauruanisch",
                "Nauruanisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Navajo-Sprache.<br>
     */
    NAVAJO_SPRACHE("nv",
                   "2.16.840.1.113883.6.121",
                   "Navajo-Sprache",
                   "Navajo-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Ndebele-Sprache (Simbabwe).<br>
     */
    NDEBELE_SPRACHE_SIMBABWE("nd",
                             "2.16.840.1.113883.6.121",
                             "Ndebele-Sprache (Simbabwe)",
                             "Ndebele-Sprache (Simbabwe)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Ndebele-Sprache (Transvaal).<br>
     */
    NDEBELE_SPRACHE_TRANSVAAL("nr",
                              "2.16.840.1.113883.6.121",
                              "Ndebele-Sprache (Transvaal)",
                              "Ndebele-Sprache (Transvaal)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Ndonga.<br>
     */
    NDONGA("ng",
           "2.16.840.1.113883.6.121",
           "Ndonga",
           "Ndonga",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Neapel / Mundart.<br>
     */
    NEAPEL_MUNDART("nap",
                   "2.16.840.1.113883.6.121",
                   "Neapel / Mundart",
                   "Neapel / Mundart",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Nepali.<br>
     */
    NEPALI("ne",
           "2.16.840.1.113883.6.121",
           "Nepali",
           "Nepali",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Neugriechisch.<br>
     */
    NEUGRIECHISCH("el",
                  "2.16.840.1.113883.6.121",
                  "Neugriechisch",
                  "Neugriechisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Neumelanesisch.<br>
     */
    NEUMELANESISCH("tpi",
                   "2.16.840.1.113883.6.121",
                   "Neumelanesisch",
                   "Neumelanesisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Neuostaramäisch.<br>
     */
    NEUOSTARAM_ISCH("syr",
                    "2.16.840.1.113883.6.121",
                    "Neuostaramäisch",
                    "Neuostaramäisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Newari.<br>
     */
    NEWARI("new",
           "2.16.840.1.113883.6.121",
           "Newari",
           "Newari",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Nias-Sprache.<br>
     */
    NIAS_SPRACHE("nia",
                 "2.16.840.1.113883.6.121",
                 "Nias-Sprache",
                 "Nias-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Nicht zu entscheiden.<br>
     */
    NICHT_ZU_ENTSCHEIDEN("und",
                         "2.16.840.1.113883.6.121",
                         "Nicht zu entscheiden",
                         "Nicht zu entscheiden",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Niederdeutsch.<br>
     */
    NIEDERDEUTSCH("nds",
                  "2.16.840.1.113883.6.121",
                  "Niederdeutsch",
                  "Niederdeutsch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Niederländisch.<br>
     */
    NIEDERL_NDISCH("nl",
                   "2.16.840.1.113883.6.121",
                   "Niederländisch",
                   "Niederländisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Niedersorbisch.<br>
     */
    NIEDERSORBISCH("dsb",
                   "2.16.840.1.113883.6.121",
                   "Niedersorbisch",
                   "Niedersorbisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Nigerkordofanische Sprachen (Andere).<br>
     */
    NIGERKORDOFANISCHE_SPRACHEN_ANDERE("nic",
                                       "2.16.840.1.113883.6.121",
                                       "Nigerkordofanische Sprachen (Andere)",
                                       "Nigerkordofanische Sprachen (Andere)",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Nilosaharanische Sprachen (Andere).<br>
     */
    NILOSAHARANISCHE_SPRACHEN_ANDERE("ssa",
                                     "2.16.840.1.113883.6.121",
                                     "Nilosaharanische Sprachen (Andere)",
                                     "Nilosaharanische Sprachen (Andere)",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Niue-Sprache.<br>
     */
    NIUE_SPRACHE("niu",
                 "2.16.840.1.113883.6.121",
                 "Niue-Sprache",
                 "Niue-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Nkole-Sprache.<br>
     */
    NKOLE_SPRACHE("nyn",
                  "2.16.840.1.113883.6.121",
                  "Nkole-Sprache",
                  "Nkole-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Nogaisch.<br>
     */
    NOGAISCH("nog",
             "2.16.840.1.113883.6.121",
             "Nogaisch",
             "Nogaisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Nordfriesisch.<br>
     */
    NORDFRIESISCH("frr",
                  "2.16.840.1.113883.6.121",
                  "Nordfriesisch",
                  "Nordfriesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Nordsaamisch.<br>
     */
    NORDSAAMISCH("se",
                 "2.16.840.1.113883.6.121",
                 "Nordsaamisch",
                 "Nordsaamisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Norwegisch.<br>
     */
    NORWEGISCH("no",
               "2.16.840.1.113883.6.121",
               "Norwegisch",
               "Norwegisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Nubische Sprachen.<br>
     */
    NUBISCHE_SPRACHEN("nub",
                      "2.16.840.1.113883.6.121",
                      "Nubische Sprachen",
                      "Nubische Sprachen",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Nyamwezi-Sprache.<br>
     */
    NYAMWEZI_SPRACHE("nym",
                     "2.16.840.1.113883.6.121",
                     "Nyamwezi-Sprache",
                     "Nyamwezi-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Nyanja-Sprache.<br>
     */
    NYANJA_SPRACHE("ny",
                   "2.16.840.1.113883.6.121",
                   "Nyanja-Sprache",
                   "Nyanja-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Nynorsk.<br>
     */
    NYNORSK("nn",
            "2.16.840.1.113883.6.121",
            "Nynorsk",
            "Nynorsk",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Nyoro-Sprache.<br>
     */
    NYORO_SPRACHE("nyo",
                  "2.16.840.1.113883.6.121",
                  "Nyoro-Sprache",
                  "Nyoro-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Nzima-Sprache.<br>
     */
    NZIMA_SPRACHE("nzi",
                  "2.16.840.1.113883.6.121",
                  "Nzima-Sprache",
                  "Nzima-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: N'Ko.<br>
     */
    N_KO("nqo",
         "2.16.840.1.113883.6.121",
         "N'Ko",
         "N'Ko",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Obersorbisch.<br>
     */
    OBERSORBISCH("hsb",
                 "2.16.840.1.113883.6.121",
                 "Obersorbisch",
                 "Obersorbisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Ojibwa-Sprache.<br>
     */
    OJIBWA_SPRACHE("oj",
                   "2.16.840.1.113883.6.121",
                   "Ojibwa-Sprache",
                   "Ojibwa-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Okzitanisch.<br>
     */
    OKZITANISCH("oc",
                "2.16.840.1.113883.6.121",
                "Okzitanisch",
                "Okzitanisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Oraon-Sprache.<br>
     */
    ORAON_SPRACHE("kru",
                  "2.16.840.1.113883.6.121",
                  "Oraon-Sprache",
                  "Oraon-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Oriya-Sprache.<br>
     */
    ORIYA_SPRACHE("or",
                  "2.16.840.1.113883.6.121",
                  "Oriya-Sprache",
                  "Oriya-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Osage-Sprache.<br>
     */
    OSAGE_SPRACHE("osa",
                  "2.16.840.1.113883.6.121",
                  "Osage-Sprache",
                  "Osage-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Osmanisch.<br>
     */
    OSMANISCH("ota",
              "2.16.840.1.113883.6.121",
              "Osmanisch",
              "Osmanisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Ossetisch.<br>
     */
    OSSETISCH("os",
              "2.16.840.1.113883.6.121",
              "Ossetisch",
              "Ossetisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Osterinsel-Sprache.<br>
     */
    OSTERINSEL_SPRACHE("rap",
                       "2.16.840.1.113883.6.121",
                       "Osterinsel-Sprache",
                       "Osterinsel-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Ostfriesisch.<br>
     */
    OSTFRIESISCH("frs",
                 "2.16.840.1.113883.6.121",
                 "Ostfriesisch",
                 "Ostfriesisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Otomangue-Sprachen.<br>
     */
    OTOMANGUE_SPRACHEN("oto",
                       "2.16.840.1.113883.6.121",
                       "Otomangue-Sprachen",
                       "Otomangue-Sprachen",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Palau-Sprache.<br>
     */
    PALAU_SPRACHE("pau",
                  "2.16.840.1.113883.6.121",
                  "Palau-Sprache",
                  "Palau-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Pali.<br>
     */
    PALI("pi",
         "2.16.840.1.113883.6.121",
         "Pali",
         "Pali",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Pampanggan-Sprache.<br>
     */
    PAMPANGGAN_SPRACHE("pam",
                       "2.16.840.1.113883.6.121",
                       "Pampanggan-Sprache",
                       "Pampanggan-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Pandschabi-Sprache.<br>
     */
    PANDSCHABI_SPRACHE("pa",
                       "2.16.840.1.113883.6.121",
                       "Pandschabi-Sprache",
                       "Pandschabi-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Pangasinan-Sprache.<br>
     */
    PANGASINAN_SPRACHE("pag",
                       "2.16.840.1.113883.6.121",
                       "Pangasinan-Sprache",
                       "Pangasinan-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Pangwe-Sprache.<br>
     */
    PANGWE_SPRACHE("fan",
                   "2.16.840.1.113883.6.121",
                   "Pangwe-Sprache",
                   "Pangwe-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Papiamento.<br>
     */
    PAPIAMENTO("pap",
               "2.16.840.1.113883.6.121",
               "Papiamento",
               "Papiamento",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Papuasprachen (Andere).<br>
     */
    PAPUASPRACHEN_ANDERE("paa",
                         "2.16.840.1.113883.6.121",
                         "Papuasprachen (Andere)",
                         "Papuasprachen (Andere)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Paschtu.<br>
     */
    PASCHTU("ps",
            "2.16.840.1.113883.6.121",
            "Paschtu",
            "Paschtu",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Pedi-Sprache.<br>
     */
    PEDI_SPRACHE("nso",
                 "2.16.840.1.113883.6.121",
                 "Pedi-Sprache",
                 "Pedi-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Persisch.<br>
     */
    PERSISCH("fa",
             "2.16.840.1.113883.6.121",
             "Persisch",
             "Persisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Philippinisch-Austronesisch (Andere).<br>
     */
    PHILIPPINISCH_AUSTRONESISCH_ANDERE("phi",
                                       "2.16.840.1.113883.6.121",
                                       "Philippinisch-Austronesisch (Andere)",
                                       "Philippinisch-Austronesisch (Andere)",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Phönikisch.<br>
     */
    PH_NIKISCH("phn",
               "2.16.840.1.113883.6.121",
               "Phönikisch",
               "Phönikisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Pilipino.<br>
     */
    PILIPINO("fil",
             "2.16.840.1.113883.6.121",
             "Pilipino",
             "Pilipino",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Polnisch.<br>
     */
    POLNISCH("pl",
             "2.16.840.1.113883.6.121",
             "Polnisch",
             "Polnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Ponapeanisch.<br>
     */
    PONAPEANISCH("pon",
                 "2.16.840.1.113883.6.121",
                 "Ponapeanisch",
                 "Ponapeanisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Portugiesisch.<br>
     */
    PORTUGIESISCH("pt",
                  "2.16.840.1.113883.6.121",
                  "Portugiesisch",
                  "Portugiesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Prakrit.<br>
     */
    PRAKRIT("pra",
            "2.16.840.1.113883.6.121",
            "Prakrit",
            "Prakrit",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Quechua-Sprache.<br>
     */
    QUECHUA_SPRACHE("qu",
                    "2.16.840.1.113883.6.121",
                    "Quechua-Sprache",
                    "Quechua-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Rajasthani.<br>
     */
    RAJASTHANI("raj",
               "2.16.840.1.113883.6.121",
               "Rajasthani",
               "Rajasthani",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Rarotonganisch.<br>
     */
    RAROTONGANISCH("rar",
                   "2.16.840.1.113883.6.121",
                   "Rarotonganisch",
                   "Rarotonganisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Reserviert für lokale Verwendung.<br>
     */
    RESERVIERT_F_R_LOKALE_VERWENDUNG("qaa",
                                     "2.16.840.1.113883.6.121",
                                     "Reserviert für lokale Verwendung",
                                     "Reserviert für lokale Verwendung",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Romanische Sprachen (Andere).<br>
     */
    ROMANISCHE_SPRACHEN_ANDERE("roa",
                               "2.16.840.1.113883.6.121",
                               "Romanische Sprachen (Andere)",
                               "Romanische Sprachen (Andere)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Romani (Sprache).<br>
     */
    ROMANI_SPRACHE("rom",
                   "2.16.840.1.113883.6.121",
                   "Romani (Sprache)",
                   "Romani (Sprache)",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Rotse-Sprache.<br>
     */
    ROTSE_SPRACHE("loz",
                  "2.16.840.1.113883.6.121",
                  "Rotse-Sprache",
                  "Rotse-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Rumänisch.<br>
     */
    RUM_NISCH("ro",
              "2.16.840.1.113883.6.121",
              "Rumänisch",
              "Rumänisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Rundi-Sprache.<br>
     */
    RUNDI_SPRACHE("rn",
                  "2.16.840.1.113883.6.121",
                  "Rundi-Sprache",
                  "Rundi-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Russisch.<br>
     */
    RUSSISCH("ru",
             "2.16.840.1.113883.6.121",
             "Russisch",
             "Russisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Rwanda-Sprache.<br>
     */
    RWANDA_SPRACHE("rw",
                   "2.16.840.1.113883.6.121",
                   "Rwanda-Sprache",
                   "Rwanda-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Rätoromanisch.<br>
     */
    R_TOROMANISCH("rm",
                  "2.16.840.1.113883.6.121",
                  "Rätoromanisch",
                  "Rätoromanisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Saamisch.<br>
     */
    SAAMISCH("smi",
             "2.16.840.1.113883.6.121",
             "Saamisch",
             "Saamisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Sakisch.<br>
     */
    SAKISCH("kho",
            "2.16.840.1.113883.6.121",
            "Sakisch",
            "Sakisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Salish-Sprache.<br>
     */
    SALISH_SPRACHE("sal",
                   "2.16.840.1.113883.6.121",
                   "Salish-Sprache",
                   "Salish-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Samaritanisch.<br>
     */
    SAMARITANISCH("sam",
                  "2.16.840.1.113883.6.121",
                  "Samaritanisch",
                  "Samaritanisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Samoanisch.<br>
     */
    SAMOANISCH("sm",
               "2.16.840.1.113883.6.121",
               "Samoanisch",
               "Samoanisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Sandawe-Sprache.<br>
     */
    SANDAWE_SPRACHE("sad",
                    "2.16.840.1.113883.6.121",
                    "Sandawe-Sprache",
                    "Sandawe-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Sango-Sprache.<br>
     */
    SANGO_SPRACHE("sg",
                  "2.16.840.1.113883.6.121",
                  "Sango-Sprache",
                  "Sango-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Sanskrit.<br>
     */
    SANSKRIT("sa",
             "2.16.840.1.113883.6.121",
             "Sanskrit",
             "Sanskrit",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Santali.<br>
     */
    SANTALI("sat",
            "2.16.840.1.113883.6.121",
            "Santali",
            "Santali",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Sardisch.<br>
     */
    SARDISCH("sc",
             "2.16.840.1.113883.6.121",
             "Sardisch",
             "Sardisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Sasak.<br>
     */
    SASAK("sas",
          "2.16.840.1.113883.6.121",
          "Sasak",
          "Sasak",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Schan-Sprache.<br>
     */
    SCHAN_SPRACHE("shn",
                  "2.16.840.1.113883.6.121",
                  "Schan-Sprache",
                  "Schan-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Schona-Sprache.<br>
     */
    SCHONA_SPRACHE("sn",
                   "2.16.840.1.113883.6.121",
                   "Schona-Sprache",
                   "Schona-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Schottisch.<br>
     */
    SCHOTTISCH("sco",
               "2.16.840.1.113883.6.121",
               "Schottisch",
               "Schottisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Schwedisch.<br>
     */
    SCHWEDISCH("sv",
               "2.16.840.1.113883.6.121",
               "Schwedisch",
               "Schwedisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Schweizerdeutsch.<br>
     */
    SCHWEIZERDEUTSCH("gsw",
                     "2.16.840.1.113883.6.121",
                     "Schweizerdeutsch",
                     "Schweizerdeutsch",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Selkupisch.<br>
     */
    SELKUPISCH("sel",
               "2.16.840.1.113883.6.121",
               "Selkupisch",
               "Selkupisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Semitische Sprachen (Andere).<br>
     */
    SEMITISCHE_SPRACHEN_ANDERE("sem",
                               "2.16.840.1.113883.6.121",
                               "Semitische Sprachen (Andere)",
                               "Semitische Sprachen (Andere)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Serbisch.<br>
     */
    SERBISCH("sr",
             "2.16.840.1.113883.6.121",
             "Serbisch",
             "Serbisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Serer-Sprache.<br>
     */
    SERER_SPRACHE("srr",
                  "2.16.840.1.113883.6.121",
                  "Serer-Sprache",
                  "Serer-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Sidamo-Sprache.<br>
     */
    SIDAMO_SPRACHE("sid",
                   "2.16.840.1.113883.6.121",
                   "Sidamo-Sprache",
                   "Sidamo-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sindhi-Sprache.<br>
     */
    SINDHI_SPRACHE("sd",
                   "2.16.840.1.113883.6.121",
                   "Sindhi-Sprache",
                   "Sindhi-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Singhalesisch.<br>
     */
    SINGHALESISCH("si",
                  "2.16.840.1.113883.6.121",
                  "Singhalesisch",
                  "Singhalesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Sinotibetische Sprachen (Andere).<br>
     */
    SINOTIBETISCHE_SPRACHEN_ANDERE("sit",
                                   "2.16.840.1.113883.6.121",
                                   "Sinotibetische Sprachen (Andere)",
                                   "Sinotibetische Sprachen (Andere)",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Sioux-Sprachen (Andere).<br>
     */
    SIOUX_SPRACHEN_ANDERE("sio",
                          "2.16.840.1.113883.6.121",
                          "Sioux-Sprachen (Andere)",
                          "Sioux-Sprachen (Andere)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Sizilianisch.<br>
     */
    SIZILIANISCH("scn",
                 "2.16.840.1.113883.6.121",
                 "Sizilianisch",
                 "Sizilianisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Skoltsaamisch.<br>
     */
    SKOLTSAAMISCH("sms",
                  "2.16.840.1.113883.6.121",
                  "Skoltsaamisch",
                  "Skoltsaamisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Slave-Sprache.<br>
     */
    SLAVE_SPRACHE("den",
                  "2.16.840.1.113883.6.121",
                  "Slave-Sprache",
                  "Slave-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Slawische Sprachen (Andere).<br>
     */
    SLAWISCHE_SPRACHEN_ANDERE("sla",
                              "2.16.840.1.113883.6.121",
                              "Slawische Sprachen (Andere)",
                              "Slawische Sprachen (Andere)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Slowakisch.<br>
     */
    SLOWAKISCH("sk",
               "2.16.840.1.113883.6.121",
               "Slowakisch",
               "Slowakisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Slowenisch.<br>
     */
    SLOWENISCH("sl",
               "2.16.840.1.113883.6.121",
               "Slowenisch",
               "Slowenisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Sogdisch.<br>
     */
    SOGDISCH("sog",
             "2.16.840.1.113883.6.121",
             "Sogdisch",
             "Sogdisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Somali.<br>
     */
    SOMALI("so",
           "2.16.840.1.113883.6.121",
           "Somali",
           "Somali",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Songhai-Sprache.<br>
     */
    SONGHAI_SPRACHE("son",
                    "2.16.840.1.113883.6.121",
                    "Songhai-Sprache",
                    "Songhai-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Soninke-Sprache.<br>
     */
    SONINKE_SPRACHE("snk",
                    "2.16.840.1.113883.6.121",
                    "Soninke-Sprache",
                    "Soninke-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Sorbisch (Andere).<br>
     */
    SORBISCH_ANDERE("wen",
                    "2.16.840.1.113883.6.121",
                    "Sorbisch (Andere)",
                    "Sorbisch (Andere)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Spanisch.<br>
     */
    SPANISCH("es",
             "2.16.840.1.113883.6.121",
             "Spanisch",
             "Spanisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Sranantongo.<br>
     */
    SRANANTONGO("srn",
                "2.16.840.1.113883.6.121",
                "Sranantongo",
                "Sranantongo",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Sukuma-Sprache.<br>
     */
    SUKUMA_SPRACHE("suk",
                   "2.16.840.1.113883.6.121",
                   "Sukuma-Sprache",
                   "Sukuma-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sumerisch.<br>
     */
    SUMERISCH("sux",
              "2.16.840.1.113883.6.121",
              "Sumerisch",
              "Sumerisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Sundanesisch.<br>
     */
    SUNDANESISCH("su",
                 "2.16.840.1.113883.6.121",
                 "Sundanesisch",
                 "Sundanesisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Susu.<br>
     */
    SUSU("sus",
         "2.16.840.1.113883.6.121",
         "Susu",
         "Susu",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Swahili.<br>
     */
    SWAHILI("sw",
            "2.16.840.1.113883.6.121",
            "Swahili",
            "Swahili",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Swasi-Sprache.<br>
     */
    SWASI_SPRACHE("ss",
                  "2.16.840.1.113883.6.121",
                  "Swasi-Sprache",
                  "Swasi-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Syrisch.<br>
     */
    SYRISCH("syc",
            "2.16.840.1.113883.6.121",
            "Syrisch",
            "Syrisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Südsaamisch.<br>
     */
    S_DSAAMISCH("sma",
                "2.16.840.1.113883.6.121",
                "Südsaamisch",
                "Südsaamisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Süd-Sotho-Sprache.<br>
     */
    S_D_SOTHO_SPRACHE("st",
                      "2.16.840.1.113883.6.121",
                      "Süd-Sotho-Sprache",
                      "Süd-Sotho-Sprache",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Tadschikisch.<br>
     */
    TADSCHIKISCH("tg",
                 "2.16.840.1.113883.6.121",
                 "Tadschikisch",
                 "Tadschikisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Tagalog.<br>
     */
    TAGALOG("tl",
            "2.16.840.1.113883.6.121",
            "Tagalog",
            "Tagalog",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Tahitisch.<br>
     */
    TAHITISCH("ty",
              "2.16.840.1.113883.6.121",
              "Tahitisch",
              "Tahitisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tamazight.<br>
     */
    TAMAZIGHT("zgh",
              "2.16.840.1.113883.6.121",
              "Tamazight",
              "Tamazight",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tamašeq.<br>
     */
    TAMA_EQ("tmh",
            "2.16.840.1.113883.6.121",
            "Tamašeq",
            "Tamašeq",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Tamil.<br>
     */
    TAMIL("ta",
          "2.16.840.1.113883.6.121",
          "Tamil",
          "Tamil",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Tatarisch.<br>
     */
    TATARISCH("tt",
              "2.16.840.1.113883.6.121",
              "Tatarisch",
              "Tatarisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Telugu-Sprache.<br>
     */
    TELUGU_SPRACHE("te",
                   "2.16.840.1.113883.6.121",
                   "Telugu-Sprache",
                   "Telugu-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Temne-Sprache.<br>
     */
    TEMNE_SPRACHE("tem",
                  "2.16.840.1.113883.6.121",
                  "Temne-Sprache",
                  "Temne-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tereno-Sprache.<br>
     */
    TERENO_SPRACHE("ter",
                   "2.16.840.1.113883.6.121",
                   "Tereno-Sprache",
                   "Tereno-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tetum-Sprache.<br>
     */
    TETUM_SPRACHE("tet",
                  "2.16.840.1.113883.6.121",
                  "Tetum-Sprache",
                  "Tetum-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Thailändisch.<br>
     */
    THAIL_NDISCH("th",
                 "2.16.840.1.113883.6.121",
                 "Thailändisch",
                 "Thailändisch",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Thaisprachen (Andere).<br>
     */
    THAISPRACHEN_ANDERE("tai",
                        "2.16.840.1.113883.6.121",
                        "Thaisprachen (Andere)",
                        "Thaisprachen (Andere)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Tibetisch.<br>
     */
    TIBETISCH("bo",
              "2.16.840.1.113883.6.121",
              "Tibetisch",
              "Tibetisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tigre-Sprache.<br>
     */
    TIGRE_SPRACHE("tig",
                  "2.16.840.1.113883.6.121",
                  "Tigre-Sprache",
                  "Tigre-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tigrinja-Sprache.<br>
     */
    TIGRINJA_SPRACHE("ti",
                     "2.16.840.1.113883.6.121",
                     "Tigrinja-Sprache",
                     "Tigrinja-Sprache",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Tiv-Sprache.<br>
     */
    TIV_SPRACHE("tiv",
                "2.16.840.1.113883.6.121",
                "Tiv-Sprache",
                "Tiv-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Tlingit-Sprache.<br>
     */
    TLINGIT_SPRACHE("tli",
                    "2.16.840.1.113883.6.121",
                    "Tlingit-Sprache",
                    "Tlingit-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tokelauanisch.<br>
     */
    TOKELAUANISCH("tkl",
                  "2.16.840.1.113883.6.121",
                  "Tokelauanisch",
                  "Tokelauanisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tongaisch.<br>
     */
    TONGAISCH("to",
              "2.16.840.1.113883.6.121",
              "Tongaisch",
              "Tongaisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tonga (Bantusprache, Sambia).<br>
     */
    TONGA_BANTUSPRACHE_SAMBIA("tog",
                              "2.16.840.1.113883.6.121",
                              "Tonga (Bantusprache, Sambia)",
                              "Tonga (Bantusprache, Sambia)",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Trukesisch.<br>
     */
    TRUKESISCH("chk",
               "2.16.840.1.113883.6.121",
               "Trukesisch",
               "Trukesisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Tschagataisch.<br>
     */
    TSCHAGATAISCH("chg",
                  "2.16.840.1.113883.6.121",
                  "Tschagataisch",
                  "Tschagataisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tschechisch.<br>
     */
    TSCHECHISCH("cs",
                "2.16.840.1.113883.6.121",
                "Tschechisch",
                "Tschechisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Tscheremissisch.<br>
     */
    TSCHEREMISSISCH("chm",
                    "2.16.840.1.113883.6.121",
                    "Tscheremissisch",
                    "Tscheremissisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tschetschenisch.<br>
     */
    TSCHETSCHENISCH("ce",
                    "2.16.840.1.113883.6.121",
                    "Tschetschenisch",
                    "Tschetschenisch",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tschuwaschisch.<br>
     */
    TSCHUWASCHISCH("cv",
                   "2.16.840.1.113883.6.121",
                   "Tschuwaschisch",
                   "Tschuwaschisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tsimshian-Sprache.<br>
     */
    TSIMSHIAN_SPRACHE("tsi",
                      "2.16.840.1.113883.6.121",
                      "Tsimshian-Sprache",
                      "Tsimshian-Sprache",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Tsonga-Sprache.<br>
     */
    TSONGA_SPRACHE("ts",
                   "2.16.840.1.113883.6.121",
                   "Tsonga-Sprache",
                   "Tsonga-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tswana-Sprache.<br>
     */
    TSWANA_SPRACHE("tn",
                   "2.16.840.1.113883.6.121",
                   "Tswana-Sprache",
                   "Tswana-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tumbuka-Sprache.<br>
     */
    TUMBUKA_SPRACHE("tum",
                    "2.16.840.1.113883.6.121",
                    "Tumbuka-Sprache",
                    "Tumbuka-Sprache",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tupi-Sprache.<br>
     */
    TUPI_SPRACHE("tup",
                 "2.16.840.1.113883.6.121",
                 "Tupi-Sprache",
                 "Tupi-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Turkmenisch.<br>
     */
    TURKMENISCH("tk",
                "2.16.840.1.113883.6.121",
                "Turkmenisch",
                "Turkmenisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Tuwinisch.<br>
     */
    TUWINISCH("tyv",
              "2.16.840.1.113883.6.121",
              "Tuwinisch",
              "Tuwinisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Twi-Sprache.<br>
     */
    TWI_SPRACHE("tw",
                "2.16.840.1.113883.6.121",
                "Twi-Sprache",
                "Twi-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Türkisch.<br>
     */
    T_RKISCH("tr",
             "2.16.840.1.113883.6.121",
             "Türkisch",
             "Türkisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Udmurtisch.<br>
     */
    UDMURTISCH("udm",
               "2.16.840.1.113883.6.121",
               "Udmurtisch",
               "Udmurtisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Ugaritisch.<br>
     */
    UGARITISCH("uga",
               "2.16.840.1.113883.6.121",
               "Ugaritisch",
               "Ugaritisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Uigurisch.<br>
     */
    UIGURISCH("ug",
              "2.16.840.1.113883.6.121",
              "Uigurisch",
              "Uigurisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Ukrainisch.<br>
     */
    UKRAINISCH("uk",
               "2.16.840.1.113883.6.121",
               "Ukrainisch",
               "Ukrainisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Ungarisch.<br>
     */
    UNGARISCH("hu",
              "2.16.840.1.113883.6.121",
              "Ungarisch",
              "Ungarisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Urdu.<br>
     */
    URDU("ur",
         "2.16.840.1.113883.6.121",
         "Urdu",
         "Urdu",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Usbekisch.<br>
     */
    USBEKISCH("uz",
              "2.16.840.1.113883.6.121",
              "Usbekisch",
              "Usbekisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Vai-Sprache.<br>
     */
    VAI_SPRACHE("vai",
                "2.16.840.1.113883.6.121",
                "Vai-Sprache",
                "Vai-Sprache",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Venda-Sprache.<br>
     */
    VENDA_SPRACHE("ve",
                  "2.16.840.1.113883.6.121",
                  "Venda-Sprache",
                  "Venda-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Vietnamesisch.<br>
     */
    VIETNAMESISCH("vi",
                  "2.16.840.1.113883.6.121",
                  "Vietnamesisch",
                  "Vietnamesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Volapük.<br>
     */
    VOLAP_K("vo",
            "2.16.840.1.113883.6.121",
            "Volapük",
            "Volapük",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Wakash-Sprachen.<br>
     */
    WAKASH_SPRACHEN("wak",
                    "2.16.840.1.113883.6.121",
                    "Wakash-Sprachen",
                    "Wakash-Sprachen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Walamo-Sprache.<br>
     */
    WALAMO_SPRACHE("wal",
                   "2.16.840.1.113883.6.121",
                   "Walamo-Sprache",
                   "Walamo-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Wallonisch.<br>
     */
    WALLONISCH("wa",
               "2.16.840.1.113883.6.121",
               "Wallonisch",
               "Wallonisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Waray.<br>
     */
    WARAY("war",
          "2.16.840.1.113883.6.121",
          "Waray",
          "Waray",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Washo-Sprache.<br>
     */
    WASHO_SPRACHE("was",
                  "2.16.840.1.113883.6.121",
                  "Washo-Sprache",
                  "Washo-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Weißrussisch.<br>
     */
    WEISSRUSSISCH("be",
                  "2.16.840.1.113883.6.121",
                  "Weißrussisch",
                  "Weißrussisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Wolof-Sprache.<br>
     */
    WOLOF_SPRACHE("wo",
                  "2.16.840.1.113883.6.121",
                  "Wolof-Sprache",
                  "Wolof-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Wotisch.<br>
     */
    WOTISCH("vot",
            "2.16.840.1.113883.6.121",
            "Wotisch",
            "Wotisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Xhosa-Sprache.<br>
     */
    XHOSA_SPRACHE("xh",
                  "2.16.840.1.113883.6.121",
                  "Xhosa-Sprache",
                  "Xhosa-Sprache",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Yao-Sprache (Bantusprache).<br>
     */
    YAO_SPRACHE_BANTUSPRACHE("yao",
                             "2.16.840.1.113883.6.121",
                             "Yao-Sprache (Bantusprache)",
                             "Yao-Sprache (Bantusprache)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Yapesisch.<br>
     */
    YAPESISCH("yap",
              "2.16.840.1.113883.6.121",
              "Yapesisch",
              "Yapesisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Yoruba-Sprache.<br>
     */
    YORUBA_SPRACHE("yo",
                   "2.16.840.1.113883.6.121",
                   "Yoruba-Sprache",
                   "Yoruba-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Ypik-Sprachen.<br>
     */
    YPIK_SPRACHEN("ypk",
                  "2.16.840.1.113883.6.121",
                  "Ypik-Sprachen",
                  "Ypik-Sprachen",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Zande-Sprachen.<br>
     */
    ZANDE_SPRACHEN("znd",
                   "2.16.840.1.113883.6.121",
                   "Zande-Sprachen",
                   "Zande-Sprachen",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Zapotekisch.<br>
     */
    ZAPOTEKISCH("zap",
                "2.16.840.1.113883.6.121",
                "Zapotekisch",
                "Zapotekisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Zazaki.<br>
     */
    ZAZAKI("zza",
           "2.16.840.1.113883.6.121",
           "Zazaki",
           "Zazaki",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Zeichensprachen.<br>
     */
    ZEICHENSPRACHEN("sgn",
                    "2.16.840.1.113883.6.121",
                    "Zeichensprachen",
                    "Zeichensprachen",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Zenaga.<br>
     */
    ZENAGA("zen",
           "2.16.840.1.113883.6.121",
           "Zenaga",
           "Zenaga",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Zhuang.<br>
     */
    ZHUANG("za",
           "2.16.840.1.113883.6.121",
           "Zhuang",
           "Zhuang",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Zulu-Sprache.<br>
     */
    ZULU_SPRACHE("zu",
                 "2.16.840.1.113883.6.121",
                 "Zulu-Sprache",
                 "Zulu-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Zuñi-Sprache.<br>
     */
    ZU_I_SPRACHE("zun",
                 "2.16.840.1.113883.6.121",
                 "Zuñi-Sprache",
                 "Zuñi-Sprache",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Ägyptisch.<br>
     */
    _GYPTISCH("egy",
              "2.16.840.1.113883.6.121",
              "Ägyptisch",
              "Ägyptisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE");

    /**
     * EN: Code for Abchasisch.<br>
     */
    public static final String ABCHASISCH_CODE = "ab";

    /**
     * EN: Code for Aceh-Sprache.<br>
     */
    public static final String ACEH_SPRACHE_CODE = "ace";

    /**
     * EN: Code for Acholi-Sprache.<br>
     */
    public static final String ACHOLI_SPRACHE_CODE = "ach";

    /**
     * EN: Code for Adangme-Sprache.<br>
     */
    public static final String ADANGME_SPRACHE_CODE = "ada";

    /**
     * EN: Code for Adygisch.<br>
     */
    public static final String ADYGISCH_CODE = "ady";

    /**
     * EN: Code for Afrihili.<br>
     */
    public static final String AFRIHILI_CODE = "afh";

    /**
     * EN: Code for Afrikaans.<br>
     */
    public static final String AFRIKAANS_CODE = "af";

    /**
     * EN: Code for Ainu-Sprache.<br>
     */
    public static final String AINU_SPRACHE_CODE = "ain";

    /**
     * EN: Code for Akan-Sprache.<br>
     */
    public static final String AKAN_SPRACHE_CODE = "ak";

    /**
     * EN: Code for Akkadisch.<br>
     */
    public static final String AKKADISCH_CODE = "akk";

    /**
     * EN: Code for Albanisch.<br>
     */
    public static final String ALBANISCH_CODE = "sq";

    /**
     * EN: Code for Aleutisch.<br>
     */
    public static final String ALEUTISCH_CODE = "ale";

    /**
     * EN: Code for Algonkin-Sprachen (Andere).<br>
     */
    public static final String ALGONKIN_SPRACHEN_ANDERE_CODE = "alg";

    /**
     * EN: Code for Altaisch.<br>
     */
    public static final String ALTAISCH_CODE = "alt";

    /**
     * EN: Code for Altaische Sprachen (Andere).<br>
     */
    public static final String ALTAISCHE_SPRACHEN_ANDERE_CODE = "tut";

    /**
     * EN: Code for Altenglisch.<br>
     */
    public static final String ALTENGLISCH_CODE = "ang";

    /**
     * EN: Code for Altfranzösisch.<br>
     */
    public static final String ALTFRANZ_SISCH_CODE = "fro";

    /**
     * EN: Code for Althochdeutsch.<br>
     */
    public static final String ALTHOCHDEUTSCH_CODE = "goh";

    /**
     * EN: Code for Altirisch.<br>
     */
    public static final String ALTIRISCH_CODE = "sga";

    /**
     * EN: Code for Altnorwegisch.<br>
     */
    public static final String ALTNORWEGISCH_CODE = "non";

    /**
     * EN: Code for Altokzitanisch.<br>
     */
    public static final String ALTOKZITANISCH_CODE = "pro";

    /**
     * EN: Code for Altpersisch.<br>
     */
    public static final String ALTPERSISCH_CODE = "peo";

    /**
     * EN: Code for Alt-Newari.<br>
     */
    public static final String ALT_NEWARI_CODE = "nwc";

    /**
     * EN: Code for Altäthiopisch.<br>
     */
    public static final String ALT_THIOPISCH_CODE = "gez";

    /**
     * EN: Code for Amharisch.<br>
     */
    public static final String AMHARISCH_CODE = "am";

    /**
     * EN: Code for Anga-Sprache.<br>
     */
    public static final String ANGA_SPRACHE_CODE = "anp";

    /**
     * EN: Code for Apachen-Sprachen.<br>
     */
    public static final String APACHEN_SPRACHEN_CODE = "apa";

    /**
     * EN: Code for Arabisch.<br>
     */
    public static final String ARABISCH_CODE = "ar";

    /**
     * EN: Code for Aragonesisch.<br>
     */
    public static final String ARAGONESISCH_CODE = "an";

    /**
     * EN: Code for Aramäisch.<br>
     */
    public static final String ARAM_ISCH_CODE = "arc";

    /**
     * EN: Code for Arapaho-Sprache.<br>
     */
    public static final String ARAPAHO_SPRACHE_CODE = "arp";

    /**
     * EN: Code for Arauka-Sprachen.<br>
     */
    public static final String ARAUKA_SPRACHEN_CODE = "arn";

    /**
     * EN: Code for Arawak-Sprachen.<br>
     */
    public static final String ARAWAK_SPRACHEN_CODE = "arw";

    /**
     * EN: Code for Armenisch.<br>
     */
    public static final String ARMENISCH_CODE = "hy";

    /**
     * EN: Code for Aromunisch.<br>
     */
    public static final String AROMUNISCH_CODE = "rup";

    /**
     * EN: Code for Aserbeidschanisch.<br>
     */
    public static final String ASERBEIDSCHANISCH_CODE = "az";

    /**
     * EN: Code for Assamesisch.<br>
     */
    public static final String ASSAMESISCH_CODE = "as";

    /**
     * EN: Code for Asturisch.<br>
     */
    public static final String ASTURISCH_CODE = "ast";

    /**
     * EN: Code for Athapaskische Sprachen (Andere).<br>
     */
    public static final String ATHAPASKISCHE_SPRACHEN_ANDERE_CODE = "ath";

    /**
     * EN: Code for Australische Sprachen.<br>
     */
    public static final String AUSTRALISCHE_SPRACHEN_CODE = "aus";

    /**
     * EN: Code for Austronesische Sprachen (Andere).<br>
     */
    public static final String AUSTRONESISCHE_SPRACHEN_ANDERE_CODE = "map";

    /**
     * EN: Code for Avestisch.<br>
     */
    public static final String AVESTISCH_CODE = "ae";

    /**
     * EN: Code for Awadhi.<br>
     */
    public static final String AWADHI_CODE = "awa";

    /**
     * EN: Code for Awarisch.<br>
     */
    public static final String AWARISCH_CODE = "av";

    /**
     * EN: Code for Aymará-Sprache.<br>
     */
    public static final String AYMAR_SPRACHE_CODE = "ay";

    /**
     * EN: Code for Bahasa Indonesia.<br>
     */
    public static final String BAHASA_INDONESIA_CODE = "id";

    /**
     * EN: Code for Balinesisch.<br>
     */
    public static final String BALINESISCH_CODE = "ban";

    /**
     * EN: Code for Baltische Sprachen (Andere).<br>
     */
    public static final String BALTISCHE_SPRACHEN_ANDERE_CODE = "bat";

    /**
     * EN: Code for Bambara-Sprache.<br>
     */
    public static final String BAMBARA_SPRACHE_CODE = "bm";

    /**
     * EN: Code for Bamileke-Sprachen.<br>
     */
    public static final String BAMILEKE_SPRACHEN_CODE = "bai";

    /**
     * EN: Code for Banda-Sprachen (Ubangi-Sprachen).<br>
     */
    public static final String BANDA_SPRACHEN_UBANGI_SPRACHEN_CODE = "bad";

    /**
     * EN: Code for Bantusprachen (Andere).<br>
     */
    public static final String BANTUSPRACHEN_ANDERE_CODE = "bnt";

    /**
     * EN: Code for Basaa-Sprache.<br>
     */
    public static final String BASAA_SPRACHE_CODE = "bas";

    /**
     * EN: Code for Baschkirisch.<br>
     */
    public static final String BASCHKIRISCH_CODE = "ba";

    /**
     * EN: Code for Baskisch.<br>
     */
    public static final String BASKISCH_CODE = "eu";

    /**
     * EN: Code for Batak-Sprache.<br>
     */
    public static final String BATAK_SPRACHE_CODE = "btk";

    /**
     * EN: Code for Beach-la-mar.<br>
     */
    public static final String BEACH_LA_MAR_CODE = "bi";

    /**
     * EN: Code for Bedauye.<br>
     */
    public static final String BEDAUYE_CODE = "bej";

    /**
     * EN: Code for Belutschisch.<br>
     */
    public static final String BELUTSCHISCH_CODE = "bal";

    /**
     * EN: Code for Bemba-Sprache.<br>
     */
    public static final String BEMBA_SPRACHE_CODE = "bem";

    /**
     * EN: Code for Bengali.<br>
     */
    public static final String BENGALI_CODE = "bn";

    /**
     * EN: Code for Berbersprachen (Andere).<br>
     */
    public static final String BERBERSPRACHEN_ANDERE_CODE = "ber";

    /**
     * EN: Code for Bhojpuri.<br>
     */
    public static final String BHOJPURI_CODE = "bho";

    /**
     * EN: Code for Bihari (Andere).<br>
     */
    public static final String BIHARI_ANDERE_CODE = "bh";

    /**
     * EN: Code for Bikol-Sprache.<br>
     */
    public static final String BIKOL_SPRACHE_CODE = "bik";

    /**
     * EN: Code for Bilin-Sprache.<br>
     */
    public static final String BILIN_SPRACHE_CODE = "byn";

    /**
     * EN: Code for Birmanisch.<br>
     */
    public static final String BIRMANISCH_CODE = "my";

    /**
     * EN: Code for Blackfoot-Sprache.<br>
     */
    public static final String BLACKFOOT_SPRACHE_CODE = "bla";

    /**
     * EN: Code for Bliss-Symbol.<br>
     */
    public static final String BLISS_SYMBOL_CODE = "zbl";

    /**
     * EN: Code for Bokmål.<br>
     */
    public static final String BOKM_L_CODE = "nb";

    /**
     * EN: Code for Bosnisch.<br>
     */
    public static final String BOSNISCH_CODE = "bs";

    /**
     * EN: Code for Braj-Bhakha.<br>
     */
    public static final String BRAJ_BHAKHA_CODE = "bra";

    /**
     * EN: Code for Bretonisch.<br>
     */
    public static final String BRETONISCH_CODE = "br";

    /**
     * EN: Code for Bugi-Sprache.<br>
     */
    public static final String BUGI_SPRACHE_CODE = "bug";

    /**
     * EN: Code for Bulgarisch.<br>
     */
    public static final String BULGARISCH_CODE = "bg";

    /**
     * EN: Code for Burjatisch.<br>
     */
    public static final String BURJATISCH_CODE = "bua";

    /**
     * EN: Code for Caddo-Sprachen.<br>
     */
    public static final String CADDO_SPRACHEN_CODE = "cad";

    /**
     * EN: Code for Cebuano.<br>
     */
    public static final String CEBUANO_CODE = "ceb";

    /**
     * EN: Code for Chamorro-Sprache.<br>
     */
    public static final String CHAMORRO_SPRACHE_CODE = "ch";

    /**
     * EN: Code for Cham-Sprachen.<br>
     */
    public static final String CHAM_SPRACHEN_CODE = "cmc";

    /**
     * EN: Code for Cherokee-Sprache.<br>
     */
    public static final String CHEROKEE_SPRACHE_CODE = "chr";

    /**
     * EN: Code for Cheyenne-Sprache.<br>
     */
    public static final String CHEYENNE_SPRACHE_CODE = "chy";

    /**
     * EN: Code for Chibcha-Sprachen.<br>
     */
    public static final String CHIBCHA_SPRACHEN_CODE = "chb";

    /**
     * EN: Code for Chinesisch.<br>
     */
    public static final String CHINESISCH_CODE = "zh";

    /**
     * EN: Code for Chinook-Jargon.<br>
     */
    public static final String CHINOOK_JARGON_CODE = "chn";

    /**
     * EN: Code for Chipewyan-Sprache.<br>
     */
    public static final String CHIPEWYAN_SPRACHE_CODE = "chp";

    /**
     * EN: Code for Choctaw-Sprache.<br>
     */
    public static final String CHOCTAW_SPRACHE_CODE = "cho";

    /**
     * EN: Code for Cree-Sprache.<br>
     */
    public static final String CREE_SPRACHE_CODE = "cr";

    /**
     * EN: Code for Dajakisch.<br>
     */
    public static final String DAJAKISCH_CODE = "day";

    /**
     * EN: Code for Dakota-Sprache.<br>
     */
    public static final String DAKOTA_SPRACHE_CODE = "dak";

    /**
     * EN: Code for Danakil-Sprache.<br>
     */
    public static final String DANAKIL_SPRACHE_CODE = "aa";

    /**
     * EN: Code for Darginisch.<br>
     */
    public static final String DARGINISCH_CODE = "dar";

    /**
     * EN: Code for Delaware-Sprache.<br>
     */
    public static final String DELAWARE_SPRACHE_CODE = "del";

    /**
     * EN: Code for Deutsch.<br>
     */
    public static final String DEUTSCH_CODE = "de";

    /**
     * EN: Code for Dinka-Sprache.<br>
     */
    public static final String DINKA_SPRACHE_CODE = "din";

    /**
     * EN: Code for Dogri.<br>
     */
    public static final String DOGRI_CODE = "doi";

    /**
     * EN: Code for Dogrib-Sprache.<br>
     */
    public static final String DOGRIB_SPRACHE_CODE = "dgr";

    /**
     * EN: Code for Drawidische Sprachen (Andere).<br>
     */
    public static final String DRAWIDISCHE_SPRACHEN_ANDERE_CODE = "dra";

    /**
     * EN: Code for Duala-Sprachen.<br>
     */
    public static final String DUALA_SPRACHEN_CODE = "dua";

    /**
     * EN: Code for Dyula-Sprache.<br>
     */
    public static final String DYULA_SPRACHE_CODE = "dyu";

    /**
     * EN: Code for Dzongkha.<br>
     */
    public static final String DZONGKHA_CODE = "dz";

    /**
     * EN: Code for Dänisch.<br>
     */
    public static final String D_NISCH_CODE = "da";

    /**
     * EN: Code for Edo-Sprache.<br>
     */
    public static final String EDO_SPRACHE_CODE = "bin";

    /**
     * EN: Code for Efik.<br>
     */
    public static final String EFIK_CODE = "efi";

    /**
     * EN: Code for Einzelne andere Sprachen.<br>
     */
    public static final String EINZELNE_ANDERE_SPRACHEN_CODE = "mis";

    /**
     * EN: Code for Ekajuk.<br>
     */
    public static final String EKAJUK_CODE = "eka";

    /**
     * EN: Code for Elamisch.<br>
     */
    public static final String ELAMISCH_CODE = "elx";

    /**
     * EN: Code for Elliceanisch.<br>
     */
    public static final String ELLICEANISCH_CODE = "tvl";

    /**
     * EN: Code for Englisch.<br>
     */
    public static final String ENGLISCH_CODE = "en";

    /**
     * EN: Code for Erza-Mordwinisch.<br>
     */
    public static final String ERZA_MORDWINISCH_CODE = "myv";

    /**
     * EN: Code for Esperanto.<br>
     */
    public static final String ESPERANTO_CODE = "eo";

    /**
     * EN: Code for Estnisch.<br>
     */
    public static final String ESTNISCH_CODE = "et";

    /**
     * EN: Code for Ewe-Sprache.<br>
     */
    public static final String EWE_SPRACHE_CODE = "ee";

    /**
     * EN: Code for Ewondo.<br>
     */
    public static final String EWONDO_CODE = "ewo";

    /**
     * EN: Code for Fante-Sprache.<br>
     */
    public static final String FANTE_SPRACHE_CODE = "fat";

    /**
     * EN: Code for Fidschi-Sprache.<br>
     */
    public static final String FIDSCHI_SPRACHE_CODE = "fj";

    /**
     * EN: Code for Finnisch.<br>
     */
    public static final String FINNISCH_CODE = "fi";

    /**
     * EN: Code for Finnougrische Sprachen (Andere).<br>
     */
    public static final String FINNOUGRISCHE_SPRACHEN_ANDERE_CODE = "fiu";

    /**
     * EN: Code for Fon-Sprache.<br>
     */
    public static final String FON_SPRACHE_CODE = "fon";

    /**
     * EN: Code for Französisch.<br>
     */
    public static final String FRANZ_SISCH_CODE = "fr";

    /**
     * EN: Code for Friesisch.<br>
     */
    public static final String FRIESISCH_CODE = "fy";

    /**
     * EN: Code for Friulisch.<br>
     */
    public static final String FRIULISCH_CODE = "fur";

    /**
     * EN: Code for Ful.<br>
     */
    public static final String FUL_CODE = "ff";

    /**
     * EN: Code for Färöisch.<br>
     */
    public static final String F_R_ISCH_CODE = "fo";

    /**
     * EN: Code for Galicisch.<br>
     */
    public static final String GALICISCH_CODE = "gl";

    /**
     * EN: Code for Galla-Sprache.<br>
     */
    public static final String GALLA_SPRACHE_CODE = "om";

    /**
     * EN: Code for Ganda-Sprache.<br>
     */
    public static final String GANDA_SPRACHE_CODE = "lg";

    /**
     * EN: Code for Gayo-Sprache.<br>
     */
    public static final String GAYO_SPRACHE_CODE = "gay";

    /**
     * EN: Code for Ga-Sprache.<br>
     */
    public static final String GA_SPRACHE_CODE = "gaa";

    /**
     * EN: Code for Gbaya-Sprache.<br>
     */
    public static final String GBAYA_SPRACHE_CODE = "gba";

    /**
     * EN: Code for Georgisch.<br>
     */
    public static final String GEORGISCH_CODE = "ka";

    /**
     * EN: Code for Germanische Sprachen (Andere).<br>
     */
    public static final String GERMANISCHE_SPRACHEN_ANDERE_CODE = "gem";

    /**
     * EN: Code for Gilbertesisch.<br>
     */
    public static final String GILBERTESISCH_CODE = "gil";

    /**
     * EN: Code for Gondi-Sprache.<br>
     */
    public static final String GONDI_SPRACHE_CODE = "gon";

    /**
     * EN: Code for Gorontalesisch.<br>
     */
    public static final String GORONTALESISCH_CODE = "gor";

    /**
     * EN: Code for Gotisch.<br>
     */
    public static final String GOTISCH_CODE = "got";

    /**
     * EN: Code for Grebo-Sprache.<br>
     */
    public static final String GREBO_SPRACHE_CODE = "grb";

    /**
     * EN: Code for Griechisch.<br>
     */
    public static final String GRIECHISCH_CODE = "grc";

    /**
     * EN: Code for Grönländisch.<br>
     */
    public static final String GR_NL_NDISCH_CODE = "kl";

    /**
     * EN: Code for Guaraní-Sprache.<br>
     */
    public static final String GUARAN_SPRACHE_CODE = "gn";

    /**
     * EN: Code for Gujarati-Sprache.<br>
     */
    public static final String GUJARATI_SPRACHE_CODE = "gu";

    /**
     * EN: Code for Gälisch-Schottisch.<br>
     */
    public static final String G_LISCH_SCHOTTISCH_CODE = "gd";

    /**
     * EN: Code for Haida-Sprache.<br>
     */
    public static final String HAIDA_SPRACHE_CODE = "hai";

    /**
     * EN: Code for Hamitosemitische Sprachen (Andere).<br>
     */
    public static final String HAMITOSEMITISCHE_SPRACHEN_ANDERE_CODE = "afa";

    /**
     * EN: Code for Haussa-Sprache.<br>
     */
    public static final String HAUSSA_SPRACHE_CODE = "ha";

    /**
     * EN: Code for Hawaiisch.<br>
     */
    public static final String HAWAIISCH_CODE = "haw";

    /**
     * EN: Code for Haïtien (Haiti-Kreolisch).<br>
     */
    public static final String HA_TIEN_HAITI_KREOLISCH_CODE = "ht";

    /**
     * EN: Code for Hebräisch.<br>
     */
    public static final String HEBR_ISCH_CODE = "he";

    /**
     * EN: Code for Herero-Sprache.<br>
     */
    public static final String HERERO_SPRACHE_CODE = "hz";

    /**
     * EN: Code for Hethitisch.<br>
     */
    public static final String HETHITISCH_CODE = "hit";

    /**
     * EN: Code for Hiligaynon-Sprache.<br>
     */
    public static final String HILIGAYNON_SPRACHE_CODE = "hil";

    /**
     * EN: Code for Himachali.<br>
     */
    public static final String HIMACHALI_CODE = "him";

    /**
     * EN: Code for Hindi.<br>
     */
    public static final String HINDI_CODE = "hi";

    /**
     * EN: Code for Hiri-Motu.<br>
     */
    public static final String HIRI_MOTU_CODE = "ho";

    /**
     * EN: Code for Hupa-Sprache.<br>
     */
    public static final String HUPA_SPRACHE_CODE = "hup";

    /**
     * EN: Code for Iban-Sprache.<br>
     */
    public static final String IBAN_SPRACHE_CODE = "iba";

    /**
     * EN: Code for Ibo-Sprache.<br>
     */
    public static final String IBO_SPRACHE_CODE = "ig";

    /**
     * EN: Code for Ido.<br>
     */
    public static final String IDO_CODE = "io";

    /**
     * EN: Code for Ijo-Sprache.<br>
     */
    public static final String IJO_SPRACHE_CODE = "ijo";

    /**
     * EN: Code for Ilokano-Sprache.<br>
     */
    public static final String ILOKANO_SPRACHE_CODE = "ilo";

    /**
     * EN: Code for Inarisaamisch.<br>
     */
    public static final String INARISAAMISCH_CODE = "smn";

    /**
     * EN: Code for Indianersprachen, Nordamerika (Andere).<br>
     */
    public static final String INDIANERSPRACHEN_NORDAMERIKA_ANDERE_CODE = "nai";

    /**
     * EN: Code for Indianersprachen, Südamerika (Andere).<br>
     */
    public static final String INDIANERSPRACHEN_S_DAMERIKA_ANDERE_CODE = "sai";

    /**
     * EN: Code for Indianersprachen, Zentralamerika (Andere).<br>
     */
    public static final String INDIANERSPRACHEN_ZENTRALAMERIKA_ANDERE_CODE = "cai";

    /**
     * EN: Code for Indoarische Sprachen (Andere).<br>
     */
    public static final String INDOARISCHE_SPRACHEN_ANDERE_CODE = "inc";

    /**
     * EN: Code for Indogermanische Sprachen (Andere).<br>
     */
    public static final String INDOGERMANISCHE_SPRACHEN_ANDERE_CODE = "ine";

    /**
     * EN: Code for Inguschisch.<br>
     */
    public static final String INGUSCHISCH_CODE = "inh";

    /**
     * EN: Code for Interlingua.<br>
     */
    public static final String INTERLINGUA_CODE = "ia";

    /**
     * EN: Code for Interlingue.<br>
     */
    public static final String INTERLINGUE_CODE = "ie";

    /**
     * EN: Code for Inuktitut.<br>
     */
    public static final String INUKTITUT_CODE = "iu";

    /**
     * EN: Code for Inupik.<br>
     */
    public static final String INUPIK_CODE = "ik";

    /**
     * EN: Code for Iranische Sprachen (Andere).<br>
     */
    public static final String IRANISCHE_SPRACHEN_ANDERE_CODE = "ira";

    /**
     * EN: Code for Irisch.<br>
     */
    public static final String IRISCH_CODE = "ga";

    /**
     * EN: Code for Irokesische Sprachen.<br>
     */
    public static final String IROKESISCHE_SPRACHEN_CODE = "iro";

    /**
     * EN: Code for Isländisch.<br>
     */
    public static final String ISL_NDISCH_CODE = "is";

    /**
     * EN: Code for Italienisch.<br>
     */
    public static final String ITALIENISCH_CODE = "it";

    /**
     * EN: Code for Jakutisch.<br>
     */
    public static final String JAKUTISCH_CODE = "sah";

    /**
     * EN: Code for Japanisch.<br>
     */
    public static final String JAPANISCH_CODE = "ja";

    /**
     * EN: Code for Javanisch.<br>
     */
    public static final String JAVANISCH_CODE = "jv";

    /**
     * EN: Code for Jiddisch.<br>
     */
    public static final String JIDDISCH_CODE = "yi";

    /**
     * EN: Code for Judenspanisch.<br>
     */
    public static final String JUDENSPANISCH_CODE = "lad";

    /**
     * EN: Code for Jüdisch-Arabisch.<br>
     */
    public static final String J_DISCH_ARABISCH_CODE = "jrb";

    /**
     * EN: Code for Jüdisch-Persisch.<br>
     */
    public static final String J_DISCH_PERSISCH_CODE = "jpr";

    /**
     * EN: Code for Kabardinisch.<br>
     */
    public static final String KABARDINISCH_CODE = "kbd";

    /**
     * EN: Code for Kabylisch.<br>
     */
    public static final String KABYLISCH_CODE = "kab";

    /**
     * EN: Code for Kachin-Sprache.<br>
     */
    public static final String KACHIN_SPRACHE_CODE = "kac";

    /**
     * EN: Code for Kalmückisch.<br>
     */
    public static final String KALM_CKISCH_CODE = "xal";

    /**
     * EN: Code for Kamba-Sprache.<br>
     */
    public static final String KAMBA_SPRACHE_CODE = "kam";

    /**
     * EN: Code for Kambodschanisch.<br>
     */
    public static final String KAMBODSCHANISCH_CODE = "km";

    /**
     * EN: Code for Kannada.<br>
     */
    public static final String KANNADA_CODE = "kn";

    /**
     * EN: Code for Kanuri-Sprache.<br>
     */
    public static final String KANURI_SPRACHE_CODE = "kr";

    /**
     * EN: Code for Karakalpakisch.<br>
     */
    public static final String KARAKALPAKISCH_CODE = "kaa";

    /**
     * EN: Code for Karatschaiisch-Balkarisch.<br>
     */
    public static final String KARATSCHAIISCH_BALKARISCH_CODE = "krc";

    /**
     * EN: Code for Karelisch.<br>
     */
    public static final String KARELISCH_CODE = "krl";

    /**
     * EN: Code for Karenisch.<br>
     */
    public static final String KARENISCH_CODE = "kar";

    /**
     * EN: Code for Karibische Sprachen.<br>
     */
    public static final String KARIBISCHE_SPRACHEN_CODE = "car";

    /**
     * EN: Code for Kasachisch.<br>
     */
    public static final String KASACHISCH_CODE = "kk";

    /**
     * EN: Code for Kaschmiri.<br>
     */
    public static final String KASCHMIRI_CODE = "ks";

    /**
     * EN: Code for Kaschubisch.<br>
     */
    public static final String KASCHUBISCH_CODE = "csb";

    /**
     * EN: Code for Katalanisch.<br>
     */
    public static final String KATALANISCH_CODE = "ca";

    /**
     * EN: Code for Kaukasische Sprachen (Andere).<br>
     */
    public static final String KAUKASISCHE_SPRACHEN_ANDERE_CODE = "cau";

    /**
     * EN: Code for Kawi.<br>
     */
    public static final String KAWI_CODE = "kaw";

    /**
     * EN: Code for Kein linguistischer Inhalt.<br>
     */
    public static final String KEIN_LINGUISTISCHER_INHALT_CODE = "zxx";

    /**
     * EN: Code for Keltische Sprachen (Andere).<br>
     */
    public static final String KELTISCHE_SPRACHEN_ANDERE_CODE = "cel";

    /**
     * EN: Code for Khasi-Sprache.<br>
     */
    public static final String KHASI_SPRACHE_CODE = "kha";

    /**
     * EN: Code for Khoisan-Sprachen (Andere).<br>
     */
    public static final String KHOISAN_SPRACHEN_ANDERE_CODE = "khi";

    /**
     * EN: Code for Khotta.<br>
     */
    public static final String KHOTTA_CODE = "mag";

    /**
     * EN: Code for Kikuyu-Sprache.<br>
     */
    public static final String KIKUYU_SPRACHE_CODE = "ki";

    /**
     * EN: Code for Kimbundu-Sprache.<br>
     */
    public static final String KIMBUNDU_SPRACHE_CODE = "kmb";

    /**
     * EN: Code for Kirchenslawisch.<br>
     */
    public static final String KIRCHENSLAWISCH_CODE = "cu";

    /**
     * EN: Code for Kirgisisch.<br>
     */
    public static final String KIRGISISCH_CODE = "ky";

    /**
     * EN: Code for Klingonisch.<br>
     */
    public static final String KLINGONISCH_CODE = "tlh";

    /**
     * EN: Code for Komi-Sprache.<br>
     */
    public static final String KOMI_SPRACHE_CODE = "kv";

    /**
     * EN: Code for Kongo-Sprache.<br>
     */
    public static final String KONGO_SPRACHE_CODE = "kg";

    /**
     * EN: Code for Konkani.<br>
     */
    public static final String KONKANI_CODE = "kok";

    /**
     * EN: Code for Koptisch.<br>
     */
    public static final String KOPTISCH_CODE = "cop";

    /**
     * EN: Code for Koreanisch.<br>
     */
    public static final String KOREANISCH_CODE = "ko";

    /**
     * EN: Code for Kornisch.<br>
     */
    public static final String KORNISCH_CODE = "kw";

    /**
     * EN: Code for Korsisch.<br>
     */
    public static final String KORSISCH_CODE = "co";

    /**
     * EN: Code for Kosraeanisch.<br>
     */
    public static final String KOSRAEANISCH_CODE = "kos";

    /**
     * EN: Code for Kpelle-Sprache.<br>
     */
    public static final String KPELLE_SPRACHE_CODE = "kpe";

    /**
     * EN: Code for Kreolische Sprachen; Pidginsprachen (Andere).<br>
     */
    public static final String KREOLISCHE_SPRACHEN_PIDGINSPRACHEN_ANDERE_CODE = "crp";

    /**
     * EN: Code for Kreolisch-Englisch (Andere).<br>
     */
    public static final String KREOLISCH_ENGLISCH_ANDERE_CODE = "cpe";

    /**
     * EN: Code for Kreolisch-Französisch (Andere).<br>
     */
    public static final String KREOLISCH_FRANZ_SISCH_ANDERE_CODE = "cpf";

    /**
     * EN: Code for Kreolisch-Portugiesisch (Andere).<br>
     */
    public static final String KREOLISCH_PORTUGIESISCH_ANDERE_CODE = "cpp";

    /**
     * EN: Code for Krimtatarisch.<br>
     */
    public static final String KRIMTATARISCH_CODE = "crh";

    /**
     * EN: Code for Kroatisch.<br>
     */
    public static final String KROATISCH_CODE = "hr";

    /**
     * EN: Code for Kru-Sprachen (Andere).<br>
     */
    public static final String KRU_SPRACHEN_ANDERE_CODE = "kro";

    /**
     * EN: Code for Kumükisch.<br>
     */
    public static final String KUM_KISCH_CODE = "kum";

    /**
     * EN: Code for Kunstsprachen (Andere).<br>
     */
    public static final String KUNSTSPRACHEN_ANDERE_CODE = "art";

    /**
     * EN: Code for Kurdisch.<br>
     */
    public static final String KURDISCH_CODE = "ku";

    /**
     * EN: Code for Kuschitische Sprachen (Andere).<br>
     */
    public static final String KUSCHITISCHE_SPRACHEN_ANDERE_CODE = "cus";

    /**
     * EN: Code for Kutchin-Sprache.<br>
     */
    public static final String KUTCHIN_SPRACHE_CODE = "gwi";

    /**
     * EN: Code for Kutenai-Sprache.<br>
     */
    public static final String KUTENAI_SPRACHE_CODE = "kut";

    /**
     * EN: Code for Kwanyama-Sprache.<br>
     */
    public static final String KWANYAMA_SPRACHE_CODE = "kj";

    /**
     * EN: Code for Kymrisch.<br>
     */
    public static final String KYMRISCH_CODE = "cy";

    /**
     * EN: Code for Lahnda.<br>
     */
    public static final String LAHNDA_CODE = "lah";

    /**
     * EN: Code for Lalo-Sprache.<br>
     */
    public static final String LALO_SPRACHE_CODE = "ii";

    /**
     * EN: Code for Lamba-Sprache (Bantusprache).<br>
     */
    public static final String LAMBA_SPRACHE_BANTUSPRACHE_CODE = "lam";

    /**
     * EN: Code for Laotisch.<br>
     */
    public static final String LAOTISCH_CODE = "lo";

    /**
     * EN: Code for Latein.<br>
     */
    public static final String LATEIN_CODE = "la";

    /**
     * EN: Code for Lesgisch.<br>
     */
    public static final String LESGISCH_CODE = "lez";

    /**
     * EN: Code for Lettisch.<br>
     */
    public static final String LETTISCH_CODE = "lv";

    /**
     * EN: Code for Limburgisch.<br>
     */
    public static final String LIMBURGISCH_CODE = "li";

    /**
     * EN: Code for Lingala.<br>
     */
    public static final String LINGALA_CODE = "ln";

    /**
     * EN: Code for Litauisch.<br>
     */
    public static final String LITAUISCH_CODE = "lt";

    /**
     * EN: Code for Lojban.<br>
     */
    public static final String LOJBAN_CODE = "jbo";

    /**
     * EN: Code for Luba-Katanga-Sprache.<br>
     */
    public static final String LUBA_KATANGA_SPRACHE_CODE = "lu";

    /**
     * EN: Code for Luiseño-Sprache.<br>
     */
    public static final String LUISE_O_SPRACHE_CODE = "lui";

    /**
     * EN: Code for Lulesaamisch.<br>
     */
    public static final String LULESAAMISCH_CODE = "smj";

    /**
     * EN: Code for Lulua-Sprache.<br>
     */
    public static final String LULUA_SPRACHE_CODE = "lua";

    /**
     * EN: Code for Lunda-Sprache.<br>
     */
    public static final String LUNDA_SPRACHE_CODE = "lun";

    /**
     * EN: Code for Luo-Sprache.<br>
     */
    public static final String LUO_SPRACHE_CODE = "luo";

    /**
     * EN: Code for Lushai-Sprache.<br>
     */
    public static final String LUSHAI_SPRACHE_CODE = "lus";

    /**
     * EN: Code for Luxemburgisch.<br>
     */
    public static final String LUXEMBURGISCH_CODE = "lb";

    /**
     * EN: Code for Maduresisch.<br>
     */
    public static final String MADURESISCH_CODE = "mad";

    /**
     * EN: Code for Maithili.<br>
     */
    public static final String MAITHILI_CODE = "mai";

    /**
     * EN: Code for Makassarisch.<br>
     */
    public static final String MAKASSARISCH_CODE = "mak";

    /**
     * EN: Code for Makedonisch.<br>
     */
    public static final String MAKEDONISCH_CODE = "mk";

    /**
     * EN: Code for Malagassi-Sprache.<br>
     */
    public static final String MALAGASSI_SPRACHE_CODE = "mg";

    /**
     * EN: Code for Malaiisch.<br>
     */
    public static final String MALAIISCH_CODE = "ms";

    /**
     * EN: Code for Malayalam.<br>
     */
    public static final String MALAYALAM_CODE = "ml";

    /**
     * EN: Code for Maledivisch.<br>
     */
    public static final String MALEDIVISCH_CODE = "dv";

    /**
     * EN: Code for Malinke-Sprache.<br>
     */
    public static final String MALINKE_SPRACHE_CODE = "man";

    /**
     * EN: Code for Maltesisch.<br>
     */
    public static final String MALTESISCH_CODE = "mt";

    /**
     * EN: Code for Mandaresisch.<br>
     */
    public static final String MANDARESISCH_CODE = "mdr";

    /**
     * EN: Code for Mandschurisch.<br>
     */
    public static final String MANDSCHURISCH_CODE = "mnc";

    /**
     * EN: Code for Manobo-Sprachen.<br>
     */
    public static final String MANOBO_SPRACHEN_CODE = "mno";

    /**
     * EN: Code for Manx.<br>
     */
    public static final String MANX_CODE = "gv";

    /**
     * EN: Code for Maori-Sprache.<br>
     */
    public static final String MAORI_SPRACHE_CODE = "mi";

    /**
     * EN: Code for Marathi.<br>
     */
    public static final String MARATHI_CODE = "mr";

    /**
     * EN: Code for Marschallesisch.<br>
     */
    public static final String MARSCHALLESISCH_CODE = "mh";

    /**
     * EN: Code for Marwari.<br>
     */
    public static final String MARWARI_CODE = "mwr";

    /**
     * EN: Code for Massai-Sprache.<br>
     */
    public static final String MASSAI_SPRACHE_CODE = "mas";

    /**
     * EN: Code for Maya-Sprachen.<br>
     */
    public static final String MAYA_SPRACHEN_CODE = "myn";

    /**
     * EN: Code for Mbundu-Sprache.<br>
     */
    public static final String MBUNDU_SPRACHE_CODE = "umb";

    /**
     * EN: Code for Mehrere Sprachen.<br>
     */
    public static final String MEHRERE_SPRACHEN_CODE = "mul";

    /**
     * EN: Code for Meithei-Sprache.<br>
     */
    public static final String MEITHEI_SPRACHE_CODE = "mni";

    /**
     * EN: Code for Mende-Sprache.<br>
     */
    public static final String MENDE_SPRACHE_CODE = "men";

    /**
     * EN: Code for Miao-Sprachen.<br>
     */
    public static final String MIAO_SPRACHEN_CODE = "hmn";

    /**
     * EN: Code for Micmac-Sprache.<br>
     */
    public static final String MICMAC_SPRACHE_CODE = "mic";

    /**
     * EN: Code for Minangkabau-Sprache.<br>
     */
    public static final String MINANGKABAU_SPRACHE_CODE = "min";

    /**
     * EN: Code for Mirandesisch.<br>
     */
    public static final String MIRANDESISCH_CODE = "mwl";

    /**
     * EN: Code for Mittelenglisch.<br>
     */
    public static final String MITTELENGLISCH_CODE = "enm";

    /**
     * EN: Code for Mittelfranzösisch.<br>
     */
    public static final String MITTELFRANZ_SISCH_CODE = "frm";

    /**
     * EN: Code for Mittelhochdeutsch.<br>
     */
    public static final String MITTELHOCHDEUTSCH_CODE = "gmh";

    /**
     * EN: Code for Mittelirisch.<br>
     */
    public static final String MITTELIRISCH_CODE = "mga";

    /**
     * EN: Code for Mittelniederländisch.<br>
     */
    public static final String MITTELNIEDERL_NDISCH_CODE = "dum";

    /**
     * EN: Code for Mittelpersisch.<br>
     */
    public static final String MITTELPERSISCH_CODE = "pal";

    /**
     * EN: Code for Mohawk-Sprache.<br>
     */
    public static final String MOHAWK_SPRACHE_CODE = "moh";

    /**
     * EN: Code for Mokscha-Sprache.<br>
     */
    public static final String MOKSCHA_SPRACHE_CODE = "mdf";

    /**
     * EN: Code for Mongolisch.<br>
     */
    public static final String MONGOLISCH_CODE = "mn";

    /**
     * EN: Code for Mongo-Sprache.<br>
     */
    public static final String MONGO_SPRACHE_CODE = "lol";

    /**
     * EN: Code for Mon-Khmer-Sprachen (Andere).<br>
     */
    public static final String MON_KHMER_SPRACHEN_ANDERE_CODE = "mkh";

    /**
     * EN: Code for Mossi-Sprache.<br>
     */
    public static final String MOSSI_SPRACHE_CODE = "mos";

    /**
     * EN: Code for Mundasprachen (Andere).<br>
     */
    public static final String MUNDASPRACHEN_ANDERE_CODE = "mun";

    /**
     * EN: Code for Muskogisch.<br>
     */
    public static final String MUSKOGISCH_CODE = "mus";

    /**
     * EN: Code for Nahuatl.<br>
     */
    public static final String NAHUATL_CODE = "nah";

    /**
     * EN: Code for Nauruanisch.<br>
     */
    public static final String NAURUANISCH_CODE = "na";

    /**
     * EN: Code for Navajo-Sprache.<br>
     */
    public static final String NAVAJO_SPRACHE_CODE = "nv";

    /**
     * EN: Code for Ndebele-Sprache (Simbabwe).<br>
     */
    public static final String NDEBELE_SPRACHE_SIMBABWE_CODE = "nd";

    /**
     * EN: Code for Ndebele-Sprache (Transvaal).<br>
     */
    public static final String NDEBELE_SPRACHE_TRANSVAAL_CODE = "nr";

    /**
     * EN: Code for Ndonga.<br>
     */
    public static final String NDONGA_CODE = "ng";

    /**
     * EN: Code for Neapel / Mundart.<br>
     */
    public static final String NEAPEL_MUNDART_CODE = "nap";

    /**
     * EN: Code for Nepali.<br>
     */
    public static final String NEPALI_CODE = "ne";

    /**
     * EN: Code for Neugriechisch.<br>
     */
    public static final String NEUGRIECHISCH_CODE = "el";

    /**
     * EN: Code for Neumelanesisch.<br>
     */
    public static final String NEUMELANESISCH_CODE = "tpi";

    /**
     * EN: Code for Neuostaramäisch.<br>
     */
    public static final String NEUOSTARAM_ISCH_CODE = "syr";

    /**
     * EN: Code for Newari.<br>
     */
    public static final String NEWARI_CODE = "new";

    /**
     * EN: Code for Nias-Sprache.<br>
     */
    public static final String NIAS_SPRACHE_CODE = "nia";

    /**
     * EN: Code for Nicht zu entscheiden.<br>
     */
    public static final String NICHT_ZU_ENTSCHEIDEN_CODE = "und";

    /**
     * EN: Code for Niederdeutsch.<br>
     */
    public static final String NIEDERDEUTSCH_CODE = "nds";

    /**
     * EN: Code for Niederländisch.<br>
     */
    public static final String NIEDERL_NDISCH_CODE = "nl";

    /**
     * EN: Code for Niedersorbisch.<br>
     */
    public static final String NIEDERSORBISCH_CODE = "dsb";

    /**
     * EN: Code for Nigerkordofanische Sprachen (Andere).<br>
     */
    public static final String NIGERKORDOFANISCHE_SPRACHEN_ANDERE_CODE = "nic";

    /**
     * EN: Code for Nilosaharanische Sprachen (Andere).<br>
     */
    public static final String NILOSAHARANISCHE_SPRACHEN_ANDERE_CODE = "ssa";

    /**
     * EN: Code for Niue-Sprache.<br>
     */
    public static final String NIUE_SPRACHE_CODE = "niu";

    /**
     * EN: Code for Nkole-Sprache.<br>
     */
    public static final String NKOLE_SPRACHE_CODE = "nyn";

    /**
     * EN: Code for Nogaisch.<br>
     */
    public static final String NOGAISCH_CODE = "nog";

    /**
     * EN: Code for Nordfriesisch.<br>
     */
    public static final String NORDFRIESISCH_CODE = "frr";

    /**
     * EN: Code for Nordsaamisch.<br>
     */
    public static final String NORDSAAMISCH_CODE = "se";

    /**
     * EN: Code for Norwegisch.<br>
     */
    public static final String NORWEGISCH_CODE = "no";

    /**
     * EN: Code for Nubische Sprachen.<br>
     */
    public static final String NUBISCHE_SPRACHEN_CODE = "nub";

    /**
     * EN: Code for Nyamwezi-Sprache.<br>
     */
    public static final String NYAMWEZI_SPRACHE_CODE = "nym";

    /**
     * EN: Code for Nyanja-Sprache.<br>
     */
    public static final String NYANJA_SPRACHE_CODE = "ny";

    /**
     * EN: Code for Nynorsk.<br>
     */
    public static final String NYNORSK_CODE = "nn";

    /**
     * EN: Code for Nyoro-Sprache.<br>
     */
    public static final String NYORO_SPRACHE_CODE = "nyo";

    /**
     * EN: Code for Nzima-Sprache.<br>
     */
    public static final String NZIMA_SPRACHE_CODE = "nzi";

    /**
     * EN: Code for N'Ko.<br>
     */
    public static final String N_KO_CODE = "nqo";

    /**
     * EN: Code for Obersorbisch.<br>
     */
    public static final String OBERSORBISCH_CODE = "hsb";

    /**
     * EN: Code for Ojibwa-Sprache.<br>
     */
    public static final String OJIBWA_SPRACHE_CODE = "oj";

    /**
     * EN: Code for Okzitanisch.<br>
     */
    public static final String OKZITANISCH_CODE = "oc";

    /**
     * EN: Code for Oraon-Sprache.<br>
     */
    public static final String ORAON_SPRACHE_CODE = "kru";

    /**
     * EN: Code for Oriya-Sprache.<br>
     */
    public static final String ORIYA_SPRACHE_CODE = "or";

    /**
     * EN: Code for Osage-Sprache.<br>
     */
    public static final String OSAGE_SPRACHE_CODE = "osa";

    /**
     * EN: Code for Osmanisch.<br>
     */
    public static final String OSMANISCH_CODE = "ota";

    /**
     * EN: Code for Ossetisch.<br>
     */
    public static final String OSSETISCH_CODE = "os";

    /**
     * EN: Code for Osterinsel-Sprache.<br>
     */
    public static final String OSTERINSEL_SPRACHE_CODE = "rap";

    /**
     * EN: Code for Ostfriesisch.<br>
     */
    public static final String OSTFRIESISCH_CODE = "frs";

    /**
     * EN: Code for Otomangue-Sprachen.<br>
     */
    public static final String OTOMANGUE_SPRACHEN_CODE = "oto";

    /**
     * EN: Code for Palau-Sprache.<br>
     */
    public static final String PALAU_SPRACHE_CODE = "pau";

    /**
     * EN: Code for Pali.<br>
     */
    public static final String PALI_CODE = "pi";

    /**
     * EN: Code for Pampanggan-Sprache.<br>
     */
    public static final String PAMPANGGAN_SPRACHE_CODE = "pam";

    /**
     * EN: Code for Pandschabi-Sprache.<br>
     */
    public static final String PANDSCHABI_SPRACHE_CODE = "pa";

    /**
     * EN: Code for Pangasinan-Sprache.<br>
     */
    public static final String PANGASINAN_SPRACHE_CODE = "pag";

    /**
     * EN: Code for Pangwe-Sprache.<br>
     */
    public static final String PANGWE_SPRACHE_CODE = "fan";

    /**
     * EN: Code for Papiamento.<br>
     */
    public static final String PAPIAMENTO_CODE = "pap";

    /**
     * EN: Code for Papuasprachen (Andere).<br>
     */
    public static final String PAPUASPRACHEN_ANDERE_CODE = "paa";

    /**
     * EN: Code for Paschtu.<br>
     */
    public static final String PASCHTU_CODE = "ps";

    /**
     * EN: Code for Pedi-Sprache.<br>
     */
    public static final String PEDI_SPRACHE_CODE = "nso";

    /**
     * EN: Code for Persisch.<br>
     */
    public static final String PERSISCH_CODE = "fa";

    /**
     * EN: Code for Philippinisch-Austronesisch (Andere).<br>
     */
    public static final String PHILIPPINISCH_AUSTRONESISCH_ANDERE_CODE = "phi";

    /**
     * EN: Code for Phönikisch.<br>
     */
    public static final String PH_NIKISCH_CODE = "phn";

    /**
     * EN: Code for Pilipino.<br>
     */
    public static final String PILIPINO_CODE = "fil";

    /**
     * EN: Code for Polnisch.<br>
     */
    public static final String POLNISCH_CODE = "pl";

    /**
     * EN: Code for Ponapeanisch.<br>
     */
    public static final String PONAPEANISCH_CODE = "pon";

    /**
     * EN: Code for Portugiesisch.<br>
     */
    public static final String PORTUGIESISCH_CODE = "pt";

    /**
     * EN: Code for Prakrit.<br>
     */
    public static final String PRAKRIT_CODE = "pra";

    /**
     * EN: Code for Quechua-Sprache.<br>
     */
    public static final String QUECHUA_SPRACHE_CODE = "qu";

    /**
     * EN: Code for Rajasthani.<br>
     */
    public static final String RAJASTHANI_CODE = "raj";

    /**
     * EN: Code for Rarotonganisch.<br>
     */
    public static final String RAROTONGANISCH_CODE = "rar";

    /**
     * EN: Code for Reserviert für lokale Verwendung.<br>
     */
    public static final String RESERVIERT_F_R_LOKALE_VERWENDUNG_CODE = "qaa";

    /**
     * EN: Code for Romanische Sprachen (Andere).<br>
     */
    public static final String ROMANISCHE_SPRACHEN_ANDERE_CODE = "roa";

    /**
     * EN: Code for Romani (Sprache).<br>
     */
    public static final String ROMANI_SPRACHE_CODE = "rom";

    /**
     * EN: Code for Rotse-Sprache.<br>
     */
    public static final String ROTSE_SPRACHE_CODE = "loz";

    /**
     * EN: Code for Rumänisch.<br>
     */
    public static final String RUM_NISCH_CODE = "ro";

    /**
     * EN: Code for Rundi-Sprache.<br>
     */
    public static final String RUNDI_SPRACHE_CODE = "rn";

    /**
     * EN: Code for Russisch.<br>
     */
    public static final String RUSSISCH_CODE = "ru";

    /**
     * EN: Code for Rwanda-Sprache.<br>
     */
    public static final String RWANDA_SPRACHE_CODE = "rw";

    /**
     * EN: Code for Rätoromanisch.<br>
     */
    public static final String R_TOROMANISCH_CODE = "rm";

    /**
     * EN: Code for Saamisch.<br>
     */
    public static final String SAAMISCH_CODE = "smi";

    /**
     * EN: Code for Sakisch.<br>
     */
    public static final String SAKISCH_CODE = "kho";

    /**
     * EN: Code for Salish-Sprache.<br>
     */
    public static final String SALISH_SPRACHE_CODE = "sal";

    /**
     * EN: Code for Samaritanisch.<br>
     */
    public static final String SAMARITANISCH_CODE = "sam";

    /**
     * EN: Code for Samoanisch.<br>
     */
    public static final String SAMOANISCH_CODE = "sm";

    /**
     * EN: Code for Sandawe-Sprache.<br>
     */
    public static final String SANDAWE_SPRACHE_CODE = "sad";

    /**
     * EN: Code for Sango-Sprache.<br>
     */
    public static final String SANGO_SPRACHE_CODE = "sg";

    /**
     * EN: Code for Sanskrit.<br>
     */
    public static final String SANSKRIT_CODE = "sa";

    /**
     * EN: Code for Santali.<br>
     */
    public static final String SANTALI_CODE = "sat";

    /**
     * EN: Code for Sardisch.<br>
     */
    public static final String SARDISCH_CODE = "sc";

    /**
     * EN: Code for Sasak.<br>
     */
    public static final String SASAK_CODE = "sas";

    /**
     * EN: Code for Schan-Sprache.<br>
     */
    public static final String SCHAN_SPRACHE_CODE = "shn";

    /**
     * EN: Code for Schona-Sprache.<br>
     */
    public static final String SCHONA_SPRACHE_CODE = "sn";

    /**
     * EN: Code for Schottisch.<br>
     */
    public static final String SCHOTTISCH_CODE = "sco";

    /**
     * EN: Code for Schwedisch.<br>
     */
    public static final String SCHWEDISCH_CODE = "sv";

    /**
     * EN: Code for Schweizerdeutsch.<br>
     */
    public static final String SCHWEIZERDEUTSCH_CODE = "gsw";

    /**
     * EN: Code for Selkupisch.<br>
     */
    public static final String SELKUPISCH_CODE = "sel";

    /**
     * EN: Code for Semitische Sprachen (Andere).<br>
     */
    public static final String SEMITISCHE_SPRACHEN_ANDERE_CODE = "sem";

    /**
     * EN: Code for Serbisch.<br>
     */
    public static final String SERBISCH_CODE = "sr";

    /**
     * EN: Code for Serer-Sprache.<br>
     */
    public static final String SERER_SPRACHE_CODE = "srr";

    /**
     * EN: Code for Sidamo-Sprache.<br>
     */
    public static final String SIDAMO_SPRACHE_CODE = "sid";

    /**
     * EN: Code for Sindhi-Sprache.<br>
     */
    public static final String SINDHI_SPRACHE_CODE = "sd";

    /**
     * EN: Code for Singhalesisch.<br>
     */
    public static final String SINGHALESISCH_CODE = "si";

    /**
     * EN: Code for Sinotibetische Sprachen (Andere).<br>
     */
    public static final String SINOTIBETISCHE_SPRACHEN_ANDERE_CODE = "sit";

    /**
     * EN: Code for Sioux-Sprachen (Andere).<br>
     */
    public static final String SIOUX_SPRACHEN_ANDERE_CODE = "sio";

    /**
     * EN: Code for Sizilianisch.<br>
     */
    public static final String SIZILIANISCH_CODE = "scn";

    /**
     * EN: Code for Skoltsaamisch.<br>
     */
    public static final String SKOLTSAAMISCH_CODE = "sms";

    /**
     * EN: Code for Slave-Sprache.<br>
     */
    public static final String SLAVE_SPRACHE_CODE = "den";

    /**
     * EN: Code for Slawische Sprachen (Andere).<br>
     */
    public static final String SLAWISCHE_SPRACHEN_ANDERE_CODE = "sla";

    /**
     * EN: Code for Slowakisch.<br>
     */
    public static final String SLOWAKISCH_CODE = "sk";

    /**
     * EN: Code for Slowenisch.<br>
     */
    public static final String SLOWENISCH_CODE = "sl";

    /**
     * EN: Code for Sogdisch.<br>
     */
    public static final String SOGDISCH_CODE = "sog";

    /**
     * EN: Code for Somali.<br>
     */
    public static final String SOMALI_CODE = "so";

    /**
     * EN: Code for Songhai-Sprache.<br>
     */
    public static final String SONGHAI_SPRACHE_CODE = "son";

    /**
     * EN: Code for Soninke-Sprache.<br>
     */
    public static final String SONINKE_SPRACHE_CODE = "snk";

    /**
     * EN: Code for Sorbisch (Andere).<br>
     */
    public static final String SORBISCH_ANDERE_CODE = "wen";

    /**
     * EN: Code for Spanisch.<br>
     */
    public static final String SPANISCH_CODE = "es";

    /**
     * EN: Code for Sranantongo.<br>
     */
    public static final String SRANANTONGO_CODE = "srn";

    /**
     * EN: Code for Sukuma-Sprache.<br>
     */
    public static final String SUKUMA_SPRACHE_CODE = "suk";

    /**
     * EN: Code for Sumerisch.<br>
     */
    public static final String SUMERISCH_CODE = "sux";

    /**
     * EN: Code for Sundanesisch.<br>
     */
    public static final String SUNDANESISCH_CODE = "su";

    /**
     * EN: Code for Susu.<br>
     */
    public static final String SUSU_CODE = "sus";

    /**
     * EN: Code for Swahili.<br>
     */
    public static final String SWAHILI_CODE = "sw";

    /**
     * EN: Code for Swasi-Sprache.<br>
     */
    public static final String SWASI_SPRACHE_CODE = "ss";

    /**
     * EN: Code for Syrisch.<br>
     */
    public static final String SYRISCH_CODE = "syc";

    /**
     * EN: Code for Südsaamisch.<br>
     */
    public static final String S_DSAAMISCH_CODE = "sma";

    /**
     * EN: Code for Süd-Sotho-Sprache.<br>
     */
    public static final String S_D_SOTHO_SPRACHE_CODE = "st";

    /**
     * EN: Code for Tadschikisch.<br>
     */
    public static final String TADSCHIKISCH_CODE = "tg";

    /**
     * EN: Code for Tagalog.<br>
     */
    public static final String TAGALOG_CODE = "tl";

    /**
     * EN: Code for Tahitisch.<br>
     */
    public static final String TAHITISCH_CODE = "ty";

    /**
     * EN: Code for Tamazight.<br>
     */
    public static final String TAMAZIGHT_CODE = "zgh";

    /**
     * EN: Code for Tamašeq.<br>
     */
    public static final String TAMA_EQ_CODE = "tmh";

    /**
     * EN: Code for Tamil.<br>
     */
    public static final String TAMIL_CODE = "ta";

    /**
     * EN: Code for Tatarisch.<br>
     */
    public static final String TATARISCH_CODE = "tt";

    /**
     * EN: Code for Telugu-Sprache.<br>
     */
    public static final String TELUGU_SPRACHE_CODE = "te";

    /**
     * EN: Code for Temne-Sprache.<br>
     */
    public static final String TEMNE_SPRACHE_CODE = "tem";

    /**
     * EN: Code for Tereno-Sprache.<br>
     */
    public static final String TERENO_SPRACHE_CODE = "ter";

    /**
     * EN: Code for Tetum-Sprache.<br>
     */
    public static final String TETUM_SPRACHE_CODE = "tet";

    /**
     * EN: Code for Thailändisch.<br>
     */
    public static final String THAIL_NDISCH_CODE = "th";

    /**
     * EN: Code for Thaisprachen (Andere).<br>
     */
    public static final String THAISPRACHEN_ANDERE_CODE = "tai";

    /**
     * EN: Code for Tibetisch.<br>
     */
    public static final String TIBETISCH_CODE = "bo";

    /**
     * EN: Code for Tigre-Sprache.<br>
     */
    public static final String TIGRE_SPRACHE_CODE = "tig";

    /**
     * EN: Code for Tigrinja-Sprache.<br>
     */
    public static final String TIGRINJA_SPRACHE_CODE = "ti";

    /**
     * EN: Code for Tiv-Sprache.<br>
     */
    public static final String TIV_SPRACHE_CODE = "tiv";

    /**
     * EN: Code for Tlingit-Sprache.<br>
     */
    public static final String TLINGIT_SPRACHE_CODE = "tli";

    /**
     * EN: Code for Tokelauanisch.<br>
     */
    public static final String TOKELAUANISCH_CODE = "tkl";

    /**
     * EN: Code for Tongaisch.<br>
     */
    public static final String TONGAISCH_CODE = "to";

    /**
     * EN: Code for Tonga (Bantusprache, Sambia).<br>
     */
    public static final String TONGA_BANTUSPRACHE_SAMBIA_CODE = "tog";

    /**
     * EN: Code for Trukesisch.<br>
     */
    public static final String TRUKESISCH_CODE = "chk";

    /**
     * EN: Code for Tschagataisch.<br>
     */
    public static final String TSCHAGATAISCH_CODE = "chg";

    /**
     * EN: Code for Tschechisch.<br>
     */
    public static final String TSCHECHISCH_CODE = "cs";

    /**
     * EN: Code for Tscheremissisch.<br>
     */
    public static final String TSCHEREMISSISCH_CODE = "chm";

    /**
     * EN: Code for Tschetschenisch.<br>
     */
    public static final String TSCHETSCHENISCH_CODE = "ce";

    /**
     * EN: Code for Tschuwaschisch.<br>
     */
    public static final String TSCHUWASCHISCH_CODE = "cv";

    /**
     * EN: Code for Tsimshian-Sprache.<br>
     */
    public static final String TSIMSHIAN_SPRACHE_CODE = "tsi";

    /**
     * EN: Code for Tsonga-Sprache.<br>
     */
    public static final String TSONGA_SPRACHE_CODE = "ts";

    /**
     * EN: Code for Tswana-Sprache.<br>
     */
    public static final String TSWANA_SPRACHE_CODE = "tn";

    /**
     * EN: Code for Tumbuka-Sprache.<br>
     */
    public static final String TUMBUKA_SPRACHE_CODE = "tum";

    /**
     * EN: Code for Tupi-Sprache.<br>
     */
    public static final String TUPI_SPRACHE_CODE = "tup";

    /**
     * EN: Code for Turkmenisch.<br>
     */
    public static final String TURKMENISCH_CODE = "tk";

    /**
     * EN: Code for Tuwinisch.<br>
     */
    public static final String TUWINISCH_CODE = "tyv";

    /**
     * EN: Code for Twi-Sprache.<br>
     */
    public static final String TWI_SPRACHE_CODE = "tw";

    /**
     * EN: Code for Türkisch.<br>
     */
    public static final String T_RKISCH_CODE = "tr";

    /**
     * EN: Code for Udmurtisch.<br>
     */
    public static final String UDMURTISCH_CODE = "udm";

    /**
     * EN: Code for Ugaritisch.<br>
     */
    public static final String UGARITISCH_CODE = "uga";

    /**
     * EN: Code for Uigurisch.<br>
     */
    public static final String UIGURISCH_CODE = "ug";

    /**
     * EN: Code for Ukrainisch.<br>
     */
    public static final String UKRAINISCH_CODE = "uk";

    /**
     * EN: Code for Ungarisch.<br>
     */
    public static final String UNGARISCH_CODE = "hu";

    /**
     * EN: Code for Urdu.<br>
     */
    public static final String URDU_CODE = "ur";

    /**
     * EN: Code for Usbekisch.<br>
     */
    public static final String USBEKISCH_CODE = "uz";

    /**
     * EN: Code for Vai-Sprache.<br>
     */
    public static final String VAI_SPRACHE_CODE = "vai";

    /**
     * EN: Code for Venda-Sprache.<br>
     */
    public static final String VENDA_SPRACHE_CODE = "ve";

    /**
     * EN: Code for Vietnamesisch.<br>
     */
    public static final String VIETNAMESISCH_CODE = "vi";

    /**
     * EN: Code for Volapük.<br>
     */
    public static final String VOLAP_K_CODE = "vo";

    /**
     * EN: Code for Wakash-Sprachen.<br>
     */
    public static final String WAKASH_SPRACHEN_CODE = "wak";

    /**
     * EN: Code for Walamo-Sprache.<br>
     */
    public static final String WALAMO_SPRACHE_CODE = "wal";

    /**
     * EN: Code for Wallonisch.<br>
     */
    public static final String WALLONISCH_CODE = "wa";

    /**
     * EN: Code for Waray.<br>
     */
    public static final String WARAY_CODE = "war";

    /**
     * EN: Code for Washo-Sprache.<br>
     */
    public static final String WASHO_SPRACHE_CODE = "was";

    /**
     * EN: Code for Weißrussisch.<br>
     */
    public static final String WEISSRUSSISCH_CODE = "be";

    /**
     * EN: Code for Wolof-Sprache.<br>
     */
    public static final String WOLOF_SPRACHE_CODE = "wo";

    /**
     * EN: Code for Wotisch.<br>
     */
    public static final String WOTISCH_CODE = "vot";

    /**
     * EN: Code for Xhosa-Sprache.<br>
     */
    public static final String XHOSA_SPRACHE_CODE = "xh";

    /**
     * EN: Code for Yao-Sprache (Bantusprache).<br>
     */
    public static final String YAO_SPRACHE_BANTUSPRACHE_CODE = "yao";

    /**
     * EN: Code for Yapesisch.<br>
     */
    public static final String YAPESISCH_CODE = "yap";

    /**
     * EN: Code for Yoruba-Sprache.<br>
     */
    public static final String YORUBA_SPRACHE_CODE = "yo";

    /**
     * EN: Code for Ypik-Sprachen.<br>
     */
    public static final String YPIK_SPRACHEN_CODE = "ypk";

    /**
     * EN: Code for Zande-Sprachen.<br>
     */
    public static final String ZANDE_SPRACHEN_CODE = "znd";

    /**
     * EN: Code for Zapotekisch.<br>
     */
    public static final String ZAPOTEKISCH_CODE = "zap";

    /**
     * EN: Code for Zazaki.<br>
     */
    public static final String ZAZAKI_CODE = "zza";

    /**
     * EN: Code for Zeichensprachen.<br>
     */
    public static final String ZEICHENSPRACHEN_CODE = "sgn";

    /**
     * EN: Code for Zenaga.<br>
     */
    public static final String ZENAGA_CODE = "zen";

    /**
     * EN: Code for Zhuang.<br>
     */
    public static final String ZHUANG_CODE = "za";

    /**
     * EN: Code for Zulu-Sprache.<br>
     */
    public static final String ZULU_SPRACHE_CODE = "zu";

    /**
     * EN: Code for Zuñi-Sprache.<br>
     */
    public static final String ZU_I_SPRACHE_CODE = "zun";

    /**
     * EN: Code for Ägyptisch.<br>
     */
    public static final String _GYPTISCH_CODE = "egy";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.173";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_HumanLanguage";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.121";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaHumanLanguage getEnum(@Nullable final String code) {
        for (final ElgaHumanLanguage x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaHumanLanguage.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaHumanLanguage x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaHumanLanguage(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
