/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of epims_meldepflichtigeKrankheiten values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.19<br>
 * Effective date: 2020-02-25 16:30<br>
 * Version: 2020<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum EpimsMeldepflichtigeKrankheiten implements ValueSetEnumInterface {

    /**
     * EN: Amöbenruhr.<br>
     */
    AM_BENRUHR("A06",
               "1.2.40.0.34.5.171",
               "Amöbenruhr",
               "Amöbenruhr",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: A/H1N1-Virus (Neue Influenza A).<br>
     */
    A_H1N1_VIRUS_NEUE_INFLUENZA_A("J09a",
                                  "1.2.40.0.34.5.187",
                                  "A/H1N1-Virus (Neue Influenza A)",
                                  "A/H1N1-Virus (Neue Influenza A)",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: A/H5N1-Virus (Vogelgrippe).<br>
     */
    A_H5N1_VIRUS_VOGELGRIPPE("J09b",
                             "1.2.40.0.34.5.187",
                             "A/H5N1-Virus (Vogelgrippe)",
                             "A/H5N1-Virus (Vogelgrippe)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: A/H7N9-Virus.<br>
     */
    A_H7N9_VIRUS("J09c",
                 "1.2.40.0.34.5.187",
                 "A/H7N9-Virus",
                 "A/H7N9-Virus",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Botulismus.<br>
     */
    BOTULISMUS("A05.1",
               "1.2.40.0.34.5.171",
               "Botulismus",
               "Botulismus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Brucellose.<br>
     */
    BRUCELLOSE("A23",
               "1.2.40.0.34.5.171",
               "Brucellose",
               "Brucellose",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Campylobakter spp., darmpathogen.<br>
     */
    CAMPYLOBAKTER_SPP_DARMPATHOGEN("A04.5",
                                   "1.2.40.0.34.5.171",
                                   "Campylobakter spp., darmpathogen",
                                   "Campylobakter spp., darmpathogen",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Chikungunya-Fieber.<br>
     */
    CHIKUNGUNYA_FIEBER("A92.0",
                       "1.2.40.0.34.5.171",
                       "Chikungunya-Fieber",
                       "Chikungunya-Fieber",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Cholera.<br>
     */
    CHOLERA("A00",
            "1.2.40.0.34.5.171",
            "Cholera",
            "Cholera",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Clostridium difficile.<br>
     */
    CLOSTRIDIUM_DIFFICILE("K52.9",
                          "1.2.40.0.34.5.171",
                          "Clostridium difficile",
                          "Clostridium difficile",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Coronavirus-Krankheit-2019.<br>
     */
    CORONAVIRUS_KRANKHEIT_2019("U07.1",
                               "1.2.40.0.34.5.184",
                               "Coronavirus-Krankheit-2019",
                               "Coronavirus-Krankheit-2019",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Creutzfeldt-Jakob-Krankheit (CJD).<br>
     */
    CREUTZFELDT_JAKOB_KRANKHEIT_CJD("A81.0",
                                    "1.2.40.0.34.5.171",
                                    "Creutzfeldt-Jakob-Krankheit (CJD)",
                                    "Creutzfeldt-Jakob-Krankheit (CJD)",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Denguefieber.<br>
     */
    DENGUEFIEBER("A97",
                 "1.2.40.0.34.5.171",
                 "Denguefieber",
                 "Denguefieber",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Diphtherie.<br>
     */
    DIPHTHERIE("A36",
               "1.2.40.0.34.5.171",
               "Diphtherie",
               "Diphtherie",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Ebolafieber.<br>
     */
    EBOLAFIEBER("A98.4",
                "1.2.40.0.34.5.171",
                "Ebolafieber",
                "Ebolafieber",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: E.-coli-Enteritis, sonstige darmpathogene Stämme.<br>
     */
    E_COLI_ENTERITIS_SONSTIGE_DARMPATHOGENE_ST_MME("A04.0",
                                                   "1.2.40.0.34.5.171",
                                                   "E.-coli-Enteritis, sonstige darmpathogene Stämme",
                                                   "E.-coli-Enteritis, sonstige darmpathogene Stämme",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Fleckfieber.<br>
     */
    FLECKFIEBER("A75.0",
                "1.2.40.0.34.5.171",
                "Fleckfieber",
                "Fleckfieber",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: FSME.<br>
     */
    FSME("A84.1",
         "1.2.40.0.34.5.171",
         "FSME",
         "FSME",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Fuchsbandwurm.<br>
     */
    FUCHSBANDWURM("B67.7",
                  "1.2.40.0.34.5.171",
                  "Fuchsbandwurm",
                  "Fuchsbandwurm",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gelbfieber.<br>
     */
    GELBFIEBER("A95",
               "1.2.40.0.34.5.171",
               "Gelbfieber",
               "Gelbfieber",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae.<br>
     */
    HAEMOPHILUS_INFLUENZAE("G00.0",
                           "1.2.40.0.34.5.171",
                           "Haemophilus influenzae",
                           "Haemophilus influenzae",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Hantavirus.<br>
     */
    HANTAVIRUS("A98.5",
               "1.2.40.0.34.5.171",
               "Hantavirus",
               "Hantavirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Hepatitis A.<br>
     */
    HEPATITIS_A("B15",
                "1.2.40.0.34.5.171",
                "Hepatitis A",
                "Hepatitis A",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Hepatitis B.<br>
     */
    HEPATITIS_B("B16",
                "1.2.40.0.34.5.171",
                "Hepatitis B",
                "Hepatitis B",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Hepatitis C.<br>
     */
    HEPATITIS_C("B17.1",
                "1.2.40.0.34.5.171",
                "Hepatitis C",
                "Hepatitis C",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Hepatitis D.<br>
     */
    HEPATITIS_D("B17.0",
                "1.2.40.0.34.5.171",
                "Hepatitis D",
                "Hepatitis D",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Hepatitis E.<br>
     */
    HEPATITIS_E("B17.2",
                "1.2.40.0.34.5.171",
                "Hepatitis E",
                "Hepatitis E",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Hepatitis non A-E.<br>
     */
    HEPATITIS_NON_A_E("B17.8",
                      "1.2.40.0.34.5.171",
                      "Hepatitis non A-E",
                      "Hepatitis non A-E",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Hundebandwurm.<br>
     */
    HUNDEBANDWURM("B67.4",
                  "1.2.40.0.34.5.171",
                  "Hundebandwurm",
                  "Hundebandwurm",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Krim Kongo Fieber.<br>
     */
    KRIM_KONGO_FIEBER("A98.0",
                      "1.2.40.0.34.5.171",
                      "Krim Kongo Fieber",
                      "Krim Kongo Fieber",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Körnerkrankheit.<br>
     */
    K_RNERKRANKHEIT("A71",
                    "1.2.40.0.34.5.171",
                    "Körnerkrankheit",
                    "Körnerkrankheit",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Lassafieber.<br>
     */
    LASSAFIEBER("A96.2",
                "1.2.40.0.34.5.171",
                "Lassafieber",
                "Lassafieber",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Legionellose.<br>
     */
    LEGIONELLOSE("A48.1",
                 "1.2.40.0.34.5.171",
                 "Legionellose",
                 "Legionellose",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Lepra.<br>
     */
    LEPRA("A30",
          "1.2.40.0.34.5.171",
          "Lepra",
          "Lepra",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Leptospirose.<br>
     */
    LEPTOSPIROSE("A27",
                 "1.2.40.0.34.5.171",
                 "Leptospirose",
                 "Leptospirose",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Listeriose.<br>
     */
    LISTERIOSE("A32",
               "1.2.40.0.34.5.171",
               "Listeriose",
               "Listeriose",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Läuserückfallfieber.<br>
     */
    L_USER_CKFALLFIEBER("A68.0",
                        "1.2.40.0.34.5.171",
                        "Läuserückfallfieber",
                        "Läuserückfallfieber",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Malaria.<br>
     */
    MALARIA("B54",
            "1.2.40.0.34.5.171",
            "Malaria",
            "Malaria",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Marburgfieber.<br>
     */
    MARBURGFIEBER("A98.3",
                  "1.2.40.0.34.5.171",
                  "Marburgfieber",
                  "Marburgfieber",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Masern.<br>
     */
    MASERN("B05",
           "1.2.40.0.34.5.171",
           "Masern",
           "Masern",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Meningokokken-Erkrankung, invasiv.<br>
     */
    MENINGOKOKKEN_ERKRANKUNG_INVASIV("A39",
                                     "1.2.40.0.34.5.171",
                                     "Meningokokken-Erkrankung, invasiv",
                                     "Meningokokken-Erkrankung, invasiv",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: MERS-CoV.<br>
     */
    MERS_COV("J09d",
             "1.2.40.0.34.5.187",
             "MERS-CoV",
             "MERS-CoV",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Milzbrand.<br>
     */
    MILZBRAND("A22",
              "1.2.40.0.34.5.171",
              "Milzbrand",
              "Milzbrand",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Neuartige Coronavirus Infektion (2019-nCoV).<br>
     */
    NEUARTIGE_CORONAVIRUS_INFEKTION_2019_NCOV("B34.2",
                                              "1.2.40.0.34.5.171",
                                              "Neuartige Coronavirus Infektion (2019-nCoV)",
                                              "Neuartige Coronavirus Infektion (2019-nCoV)",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Norovirus.<br>
     */
    NOROVIRUS("A08.1",
              "1.2.40.0.34.5.171",
              "Norovirus",
              "Norovirus",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Paratyphus.<br>
     */
    PARATYPHUS("A01.4",
               "1.2.40.0.34.5.171",
               "Paratyphus",
               "Paratyphus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Pertussis.<br>
     */
    PERTUSSIS("A37",
              "1.2.40.0.34.5.171",
              "Pertussis",
              "Pertussis",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Pest.<br>
     */
    PEST("A20",
         "1.2.40.0.34.5.171",
         "Pest",
         "Pest",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Pneumokokken-Erkrankung, invasiv.<br>
     */
    PNEUMOKOKKEN_ERKRANKUNG_INVASIV("A40.3",
                                    "1.2.40.0.34.5.171",
                                    "Pneumokokken-Erkrankung, invasiv",
                                    "Pneumokokken-Erkrankung, invasiv",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Pocken.<br>
     */
    POCKEN("B03",
           "1.2.40.0.34.5.171",
           "Pocken",
           "Pocken",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Poliomyelitis.<br>
     */
    POLIOMYELITIS("A80",
                  "1.2.40.0.34.5.171",
                  "Poliomyelitis",
                  "Poliomyelitis",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Psittakose.<br>
     */
    PSITTAKOSE("A70",
               "1.2.40.0.34.5.171",
               "Psittakose",
               "Psittakose",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Puerperalfieber.<br>
     */
    PUERPERALFIEBER("P36.0",
                    "1.2.40.0.34.5.171",
                    "Puerperalfieber",
                    "Puerperalfieber",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Rotavirus.<br>
     */
    ROTAVIRUS("A08.0",
              "1.2.40.0.34.5.171",
              "Rotavirus",
              "Rotavirus",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Rotz.<br>
     */
    ROTZ("A24.0",
         "1.2.40.0.34.5.171",
         "Rotz",
         "Rotz",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Röteln.<br>
     */
    R_TELN("B06",
           "1.2.40.0.34.5.171",
           "Röteln",
           "Röteln",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Salmonella spp.<br>
     */
    SALMONELLA_SPP("A02",
                   "1.2.40.0.34.5.171",
                   "Salmonella spp.",
                   "Salmonella spp.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: SARS.<br>
     */
    SARS("U04",
         "1.2.40.0.34.5.171",
         "SARS",
         "SARS",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Scharlach.<br>
     */
    SCHARLACH("A38",
              "1.2.40.0.34.5.171",
              "Scharlach",
              "Scharlach",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Shigellose.<br>
     */
    SHIGELLOSE("A03",
               "1.2.40.0.34.5.171",
               "Shigellose",
               "Shigellose",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: sonstige bakterielle Lebensmittelvergiftung.<br>
     */
    SONSTIGE_BAKTERIELLE_LEBENSMITTELVERGIFTUNG("A05.8",
                                                "1.2.40.0.34.5.171",
                                                "sonstige bakterielle Lebensmittelvergiftung",
                                                "sonstige bakterielle Lebensmittelvergiftung",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: sonstige Meningitis (invasive bakt.Erkrankung).<br>
     */
    SONSTIGE_MENINGITIS_INVASIVE_BAKT_ERKRANKUNG("G00.9",
                                                 "1.2.40.0.34.5.171",
                                                 "sonstige Meningitis (invasive bakt.Erkrankung)",
                                                 "sonstige Meningitis (invasive bakt.Erkrankung)",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: sonstige Sepsis (invasive bakt.Erkrankung).<br>
     */
    SONSTIGE_SEPSIS_INVASIVE_BAKT_ERKRANKUNG("A39.4",
                                             "1.2.40.0.34.5.171",
                                             "sonstige Sepsis (invasive bakt.Erkrankung)",
                                             "sonstige Sepsis (invasive bakt.Erkrankung)",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: sonstige transmissible spongiforme Enzephalopathie.<br>
     */
    SONSTIGE_TRANSMISSIBLE_SPONGIFORME_ENZEPHALOPATHIE("A81.9a",
                                                       "1.2.40.0.34.5.187",
                                                       "sonstige transmissible spongiforme Enzephalopathie",
                                                       "sonstige transmissible spongiforme Enzephalopathie",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE"),
    /**
     * EN: sonstige virale Lebensmittelvergiftung.<br>
     */
    SONSTIGE_VIRALE_LEBENSMITTELVERGIFTUNG("A08.5",
                                           "1.2.40.0.34.5.171",
                                           "sonstige virale Lebensmittelvergiftung",
                                           "sonstige virale Lebensmittelvergiftung",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: sonstige virusbedingte Meningoencephalitis.<br>
     */
    SONSTIGE_VIRUSBEDINGTE_MENINGOENCEPHALITIS("A86",
                                               "1.2.40.0.34.5.171",
                                               "sonstige virusbedingte Meningoencephalitis",
                                               "sonstige virusbedingte Meningoencephalitis",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Staphylokokkus aureus.<br>
     */
    STAPHYLOKOKKUS_AUREUS("A05.0",
                          "1.2.40.0.34.5.171",
                          "Staphylokokkus aureus",
                          "Staphylokokkus aureus",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: STEC/VTEC.<br>
     */
    STEC_VTEC("A04.3",
              "1.2.40.0.34.5.171",
              "STEC/VTEC",
              "STEC/VTEC",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tollwut.<br>
     */
    TOLLWUT("A82",
            "1.2.40.0.34.5.171",
            "Tollwut",
            "Tollwut",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Trichinellose.<br>
     */
    TRICHINELLOSE("B75",
                  "1.2.40.0.34.5.171",
                  "Trichinellose",
                  "Trichinellose",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tuberkulose.<br>
     */
    TUBERKULOSE("A15",
                "1.2.40.0.34.5.171",
                "Tuberkulose",
                "Tuberkulose",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Tularämie.<br>
     */
    TULAR_MIE("A21",
              "1.2.40.0.34.5.171",
              "Tularämie",
              "Tularämie",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Typhus abdominalis.<br>
     */
    TYPHUS_ABDOMINALIS("A01.0",
                       "1.2.40.0.34.5.171",
                       "Typhus abdominalis",
                       "Typhus abdominalis",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Variante Creutzfeldt-Jakob-Krankheit (vCJD).<br>
     */
    VARIANTE_CREUTZFELDT_JAKOB_KRANKHEIT_VCJD("A81.9",
                                              "1.2.40.0.34.5.171",
                                              "Variante Creutzfeldt-Jakob-Krankheit (vCJD)",
                                              "Variante Creutzfeldt-Jakob-Krankheit (vCJD)",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: West-Nil Fieber.<br>
     */
    WEST_NIL_FIEBER("A92.3",
                    "1.2.40.0.34.5.171",
                    "West-Nil Fieber",
                    "West-Nil Fieber",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Yersiniose.<br>
     */
    YERSINIOSE("A04.6",
               "1.2.40.0.34.5.171",
               "Yersiniose",
               "Yersiniose",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Zika Virus.<br>
     */
    ZIKA_VIRUS("A92.8",
               "1.2.40.0.34.5.171",
               "Zika Virus",
               "Zika Virus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE");

    /**
     * EN: Code for Amöbenruhr.<br>
     */
    public static final String AM_BENRUHR_CODE = "A06";

    /**
     * EN: Code for A/H1N1-Virus (Neue Influenza A).<br>
     */
    public static final String A_H1N1_VIRUS_NEUE_INFLUENZA_A_CODE = "J09a";

    /**
     * EN: Code for A/H5N1-Virus (Vogelgrippe).<br>
     */
    public static final String A_H5N1_VIRUS_VOGELGRIPPE_CODE = "J09b";

    /**
     * EN: Code for A/H7N9-Virus.<br>
     */
    public static final String A_H7N9_VIRUS_CODE = "J09c";

    /**
     * EN: Code for Botulismus.<br>
     */
    public static final String BOTULISMUS_CODE = "A05.1";

    /**
     * EN: Code for Brucellose.<br>
     */
    public static final String BRUCELLOSE_CODE = "A23";

    /**
     * EN: Code for Campylobakter spp., darmpathogen.<br>
     */
    public static final String CAMPYLOBAKTER_SPP_DARMPATHOGEN_CODE = "A04.5";

    /**
     * EN: Code for Chikungunya-Fieber.<br>
     */
    public static final String CHIKUNGUNYA_FIEBER_CODE = "A92.0";

    /**
     * EN: Code for Cholera.<br>
     */
    public static final String CHOLERA_CODE = "A00";

    /**
     * EN: Code for Clostridium difficile.<br>
     */
    public static final String CLOSTRIDIUM_DIFFICILE_CODE = "K52.9";

    /**
     * EN: Code for Coronavirus-Krankheit-2019.<br>
     */
    public static final String CORONAVIRUS_KRANKHEIT_2019_CODE = "U07.1";

    /**
     * EN: Code for Creutzfeldt-Jakob-Krankheit (CJD).<br>
     */
    public static final String CREUTZFELDT_JAKOB_KRANKHEIT_CJD_CODE = "A81.0";

    /**
     * EN: Code for Denguefieber.<br>
     */
    public static final String DENGUEFIEBER_CODE = "A97";

    /**
     * EN: Code for Diphtherie.<br>
     */
    public static final String DIPHTHERIE_CODE = "A36";

    /**
     * EN: Code for Ebolafieber.<br>
     */
    public static final String EBOLAFIEBER_CODE = "A98.4";

    /**
     * EN: Code for E.-coli-Enteritis, sonstige darmpathogene Stämme.<br>
     */
    public static final String E_COLI_ENTERITIS_SONSTIGE_DARMPATHOGENE_ST_MME_CODE = "A04.0";

    /**
     * EN: Code for Fleckfieber.<br>
     */
    public static final String FLECKFIEBER_CODE = "A75.0";

    /**
     * EN: Code for FSME.<br>
     */
    public static final String FSME_CODE = "A84.1";

    /**
     * EN: Code for Fuchsbandwurm.<br>
     */
    public static final String FUCHSBANDWURM_CODE = "B67.7";

    /**
     * EN: Code for Gelbfieber.<br>
     */
    public static final String GELBFIEBER_CODE = "A95";

    /**
     * EN: Code for Haemophilus influenzae.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_CODE = "G00.0";

    /**
     * EN: Code for Hantavirus.<br>
     */
    public static final String HANTAVIRUS_CODE = "A98.5";

    /**
     * EN: Code for Hepatitis A.<br>
     */
    public static final String HEPATITIS_A_CODE = "B15";

    /**
     * EN: Code for Hepatitis B.<br>
     */
    public static final String HEPATITIS_B_CODE = "B16";

    /**
     * EN: Code for Hepatitis C.<br>
     */
    public static final String HEPATITIS_C_CODE = "B17.1";

    /**
     * EN: Code for Hepatitis D.<br>
     */
    public static final String HEPATITIS_D_CODE = "B17.0";

    /**
     * EN: Code for Hepatitis E.<br>
     */
    public static final String HEPATITIS_E_CODE = "B17.2";

    /**
     * EN: Code for Hepatitis non A-E.<br>
     */
    public static final String HEPATITIS_NON_A_E_CODE = "B17.8";

    /**
     * EN: Code for Hundebandwurm.<br>
     */
    public static final String HUNDEBANDWURM_CODE = "B67.4";

    /**
     * EN: Code for Krim Kongo Fieber.<br>
     */
    public static final String KRIM_KONGO_FIEBER_CODE = "A98.0";

    /**
     * EN: Code for Körnerkrankheit.<br>
     */
    public static final String K_RNERKRANKHEIT_CODE = "A71";

    /**
     * EN: Code for Lassafieber.<br>
     */
    public static final String LASSAFIEBER_CODE = "A96.2";

    /**
     * EN: Code for Legionellose.<br>
     */
    public static final String LEGIONELLOSE_CODE = "A48.1";

    /**
     * EN: Code for Lepra.<br>
     */
    public static final String LEPRA_CODE = "A30";

    /**
     * EN: Code for Leptospirose.<br>
     */
    public static final String LEPTOSPIROSE_CODE = "A27";

    /**
     * EN: Code for Listeriose.<br>
     */
    public static final String LISTERIOSE_CODE = "A32";

    /**
     * EN: Code for Läuserückfallfieber.<br>
     */
    public static final String L_USER_CKFALLFIEBER_CODE = "A68.0";

    /**
     * EN: Code for Malaria.<br>
     */
    public static final String MALARIA_CODE = "B54";

    /**
     * EN: Code for Marburgfieber.<br>
     */
    public static final String MARBURGFIEBER_CODE = "A98.3";

    /**
     * EN: Code for Masern.<br>
     */
    public static final String MASERN_CODE = "B05";

    /**
     * EN: Code for Meningokokken-Erkrankung, invasiv.<br>
     */
    public static final String MENINGOKOKKEN_ERKRANKUNG_INVASIV_CODE = "A39";

    /**
     * EN: Code for MERS-CoV.<br>
     */
    public static final String MERS_COV_CODE = "J09d";

    /**
     * EN: Code for Milzbrand.<br>
     */
    public static final String MILZBRAND_CODE = "A22";

    /**
     * EN: Code for Neuartige Coronavirus Infektion (2019-nCoV).<br>
     */
    public static final String NEUARTIGE_CORONAVIRUS_INFEKTION_2019_NCOV_CODE = "B34.2";

    /**
     * EN: Code for Norovirus.<br>
     */
    public static final String NOROVIRUS_CODE = "A08.1";

    /**
     * EN: Code for Paratyphus.<br>
     */
    public static final String PARATYPHUS_CODE = "A01.4";

    /**
     * EN: Code for Pertussis.<br>
     */
    public static final String PERTUSSIS_CODE = "A37";

    /**
     * EN: Code for Pest.<br>
     */
    public static final String PEST_CODE = "A20";

    /**
     * EN: Code for Pneumokokken-Erkrankung, invasiv.<br>
     */
    public static final String PNEUMOKOKKEN_ERKRANKUNG_INVASIV_CODE = "A40.3";

    /**
     * EN: Code for Pocken.<br>
     */
    public static final String POCKEN_CODE = "B03";

    /**
     * EN: Code for Poliomyelitis.<br>
     */
    public static final String POLIOMYELITIS_CODE = "A80";

    /**
     * EN: Code for Psittakose.<br>
     */
    public static final String PSITTAKOSE_CODE = "A70";

    /**
     * EN: Code for Puerperalfieber.<br>
     */
    public static final String PUERPERALFIEBER_CODE = "P36.0";

    /**
     * EN: Code for Rotavirus.<br>
     */
    public static final String ROTAVIRUS_CODE = "A08.0";

    /**
     * EN: Code for Rotz.<br>
     */
    public static final String ROTZ_CODE = "A24.0";

    /**
     * EN: Code for Röteln.<br>
     */
    public static final String R_TELN_CODE = "B06";

    /**
     * EN: Code for Salmonella spp.<br>
     */
    public static final String SALMONELLA_SPP_CODE = "A02";

    /**
     * EN: Code for SARS.<br>
     */
    public static final String SARS_CODE = "U04";

    /**
     * EN: Code for Scharlach.<br>
     */
    public static final String SCHARLACH_CODE = "A38";

    /**
     * EN: Code for Shigellose.<br>
     */
    public static final String SHIGELLOSE_CODE = "A03";

    /**
     * EN: Code for sonstige bakterielle Lebensmittelvergiftung.<br>
     */
    public static final String SONSTIGE_BAKTERIELLE_LEBENSMITTELVERGIFTUNG_CODE = "A05.8";

    /**
     * EN: Code for sonstige Meningitis (invasive bakt.Erkrankung).<br>
     */
    public static final String SONSTIGE_MENINGITIS_INVASIVE_BAKT_ERKRANKUNG_CODE = "G00.9";

    /**
     * EN: Code for sonstige Sepsis (invasive bakt.Erkrankung).<br>
     */
    public static final String SONSTIGE_SEPSIS_INVASIVE_BAKT_ERKRANKUNG_CODE = "A39.4";

    /**
     * EN: Code for sonstige transmissible spongiforme Enzephalopathie.<br>
     */
    public static final String SONSTIGE_TRANSMISSIBLE_SPONGIFORME_ENZEPHALOPATHIE_CODE = "A81.9a";

    /**
     * EN: Code for sonstige virale Lebensmittelvergiftung.<br>
     */
    public static final String SONSTIGE_VIRALE_LEBENSMITTELVERGIFTUNG_CODE = "A08.5";

    /**
     * EN: Code for sonstige virusbedingte Meningoencephalitis.<br>
     */
    public static final String SONSTIGE_VIRUSBEDINGTE_MENINGOENCEPHALITIS_CODE = "A86";

    /**
     * EN: Code for Staphylokokkus aureus.<br>
     */
    public static final String STAPHYLOKOKKUS_AUREUS_CODE = "A05.0";

    /**
     * EN: Code for STEC/VTEC.<br>
     */
    public static final String STEC_VTEC_CODE = "A04.3";

    /**
     * EN: Code for Tollwut.<br>
     */
    public static final String TOLLWUT_CODE = "A82";

    /**
     * EN: Code for Trichinellose.<br>
     */
    public static final String TRICHINELLOSE_CODE = "B75";

    /**
     * EN: Code for Tuberkulose.<br>
     */
    public static final String TUBERKULOSE_CODE = "A15";

    /**
     * EN: Code for Tularämie.<br>
     */
    public static final String TULAR_MIE_CODE = "A21";

    /**
     * EN: Code for Typhus abdominalis.<br>
     */
    public static final String TYPHUS_ABDOMINALIS_CODE = "A01.0";

    /**
     * EN: Code for Variante Creutzfeldt-Jakob-Krankheit (vCJD).<br>
     */
    public static final String VARIANTE_CREUTZFELDT_JAKOB_KRANKHEIT_VCJD_CODE = "A81.9";

    /**
     * EN: Code for West-Nil Fieber.<br>
     */
    public static final String WEST_NIL_FIEBER_CODE = "A92.3";

    /**
     * EN: Code for Yersiniose.<br>
     */
    public static final String YERSINIOSE_CODE = "A04.6";

    /**
     * EN: Code for Zika Virus.<br>
     */
    public static final String ZIKA_VIRUS_CODE = "A92.8";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.19";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "epims_meldepflichtigeKrankheiten";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EpimsMeldepflichtigeKrankheiten getEnum(@Nullable final String code) {
        for (final EpimsMeldepflichtigeKrankheiten x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EpimsMeldepflichtigeKrankheiten.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EpimsMeldepflichtigeKrankheiten x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EpimsMeldepflichtigeKrankheiten(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
