/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of epims_Reiseland values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.51<br>
 * Effective date: 2020-02-20 16:41<br>
 * Version: 2020<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum EpimsReiseland implements ValueSetEnumInterface {

    /**
     * EN: Afghanistan.<br>
     */
    AFGHANISTAN("AF",
                "1.2.40.0.34.5.96",
                "Afghanistan",
                "Afghanistan",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Aland Islands.<br>
     */
    ALAND_ISLANDS("AX",
                  "1.2.40.0.34.5.96",
                  "Aland Islands",
                  "Aland Islands",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Albanien.<br>
     */
    ALBANIEN("AL",
             "1.2.40.0.34.5.96",
             "Albanien",
             "Albanien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Algerien.<br>
     */
    ALGERIEN("DZ",
             "1.2.40.0.34.5.96",
             "Algerien",
             "Algerien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Andorra.<br>
     */
    ANDORRA("AD",
            "1.2.40.0.34.5.96",
            "Andorra",
            "Andorra",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Angola.<br>
     */
    ANGOLA("AO",
           "1.2.40.0.34.5.96",
           "Angola",
           "Angola",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Anguilla.<br>
     */
    ANGUILLA("AI",
             "1.2.40.0.34.5.96",
             "Anguilla",
             "Anguilla",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Antarktis.<br>
     */
    ANTARKTIS("AQ",
              "1.2.40.0.34.5.96",
              "Antarktis",
              "Antarktis",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Antigua &amp; Barbuda.<br>
     */
    ANTIGUA_BARBUDA("AG",
                    "1.2.40.0.34.5.96",
                    "Antigua & Barbuda",
                    "Antigua & Barbuda",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Argentinien.<br>
     */
    ARGENTINIEN("AR",
                "1.2.40.0.34.5.96",
                "Argentinien",
                "Argentinien",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Armenien.<br>
     */
    ARMENIEN("AM",
             "1.2.40.0.34.5.96",
             "Armenien",
             "Armenien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Aruba.<br>
     */
    ARUBA("AW",
          "1.2.40.0.34.5.96",
          "Aruba",
          "Aruba",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Aserbaidschan.<br>
     */
    ASERBAIDSCHAN("AZ",
                  "1.2.40.0.34.5.96",
                  "Aserbaidschan",
                  "Aserbaidschan",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Australien.<br>
     */
    AUSTRALIEN("AU",
               "1.2.40.0.34.5.96",
               "Australien",
               "Australien",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Bahamas.<br>
     */
    BAHAMAS("BS",
            "1.2.40.0.34.5.96",
            "Bahamas",
            "Bahamas",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Bahrain.<br>
     */
    BAHRAIN("BH",
            "1.2.40.0.34.5.96",
            "Bahrain",
            "Bahrain",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Bangladesch.<br>
     */
    BANGLADESCH("BD",
                "1.2.40.0.34.5.96",
                "Bangladesch",
                "Bangladesch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Barbados.<br>
     */
    BARBADOS("BB",
             "1.2.40.0.34.5.96",
             "Barbados",
             "Barbados",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Belarus.<br>
     */
    BELARUS("BY",
            "1.2.40.0.34.5.96",
            "Belarus",
            "Belarus",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Belgien.<br>
     */
    BELGIEN("BE",
            "1.2.40.0.34.5.96",
            "Belgien",
            "Belgien",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Belize.<br>
     */
    BELIZE("BZ",
           "1.2.40.0.34.5.96",
           "Belize",
           "Belize",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Benin.<br>
     */
    BENIN("BJ",
          "1.2.40.0.34.5.96",
          "Benin",
          "Benin",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Bermuda.<br>
     */
    BERMUDA("BM",
            "1.2.40.0.34.5.96",
            "Bermuda",
            "Bermuda",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Bhutan.<br>
     */
    BHUTAN("BT",
           "1.2.40.0.34.5.96",
           "Bhutan",
           "Bhutan",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Bolivien.<br>
     */
    BOLIVIEN("BO",
             "1.2.40.0.34.5.96",
             "Bolivien",
             "Bolivien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Bonaire, Sint Eustatius und Saba.<br>
     */
    BONAIRE_SINT_EUSTATIUS_UND_SABA("BQ",
                                    "1.2.40.0.34.5.96",
                                    "Bonaire, Sint Eustatius und Saba",
                                    "Bonaire, Sint Eustatius und Saba",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Bosnien &amp; Herzegowina.<br>
     */
    BOSNIEN_HERZEGOWINA("BA",
                        "1.2.40.0.34.5.96",
                        "Bosnien & Herzegowina",
                        "Bosnien & Herzegowina",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Botsuana.<br>
     */
    BOTSUANA("BW",
             "1.2.40.0.34.5.96",
             "Botsuana",
             "Botsuana",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Bouvetinsel.<br>
     */
    BOUVETINSEL("BV",
                "1.2.40.0.34.5.96",
                "Bouvetinsel",
                "Bouvetinsel",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Brasilien.<br>
     */
    BRASILIEN("BR",
              "1.2.40.0.34.5.96",
              "Brasilien",
              "Brasilien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Brit. Territorium im Ind. Ozean.<br>
     */
    BRIT_TERRITORIUM_IM_IND_OZEAN("IO",
                                  "1.2.40.0.34.5.96",
                                  "Brit. Territorium im Ind. Ozean",
                                  "Brit. Territorium im Ind. Ozean",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Brunei Darussalam.<br>
     */
    BRUNEI_DARUSSALAM("BN",
                      "1.2.40.0.34.5.96",
                      "Brunei Darussalam",
                      "Brunei Darussalam",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Bulgarien.<br>
     */
    BULGARIEN("BG",
              "1.2.40.0.34.5.96",
              "Bulgarien",
              "Bulgarien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Burkina Faso.<br>
     */
    BURKINA_FASO("BF",
                 "1.2.40.0.34.5.96",
                 "Burkina Faso",
                 "Burkina Faso",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Burundi.<br>
     */
    BURUNDI("BI",
            "1.2.40.0.34.5.96",
            "Burundi",
            "Burundi",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Canton &amp; Enderburyinseln.<br>
     */
    CANTON_ENDERBURYINSELN("CT",
                           "1.2.40.0.34.5.96",
                           "Canton & Enderburyinseln",
                           "Canton & Enderburyinseln",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Ceuta .<br>
     */
    CEUTA("XC",
          "1.2.40.0.34.5.96",
          "Ceuta ",
          "Ceuta ",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Chile.<br>
     */
    CHILE("CL",
          "1.2.40.0.34.5.96",
          "Chile",
          "Chile",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: China.<br>
     */
    CHINA("CN",
          "1.2.40.0.34.5.96",
          "China",
          "China",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Cook-Inseln.<br>
     */
    COOK_INSELN("CK",
                "1.2.40.0.34.5.96",
                "Cook-Inseln",
                "Cook-Inseln",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Costa Rica.<br>
     */
    COSTA_RICA("CR",
               "1.2.40.0.34.5.96",
               "Costa Rica",
               "Costa Rica",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Curacao.<br>
     */
    CURACAO("CW",
            "1.2.40.0.34.5.96",
            "Curacao",
            "Curacao",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Deutschland.<br>
     */
    DEUTSCHLAND("DE",
                "1.2.40.0.34.5.96",
                "Deutschland",
                "Deutschland",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Dominica.<br>
     */
    DOMINICA("DM",
             "1.2.40.0.34.5.96",
             "Dominica",
             "Dominica",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Dominikanische Republik.<br>
     */
    DOMINIKANISCHE_REPUBLIK("DO",
                            "1.2.40.0.34.5.96",
                            "Dominikanische Republik",
                            "Dominikanische Republik",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Dschibuti.<br>
     */
    DSCHIBUTI("DJ",
              "1.2.40.0.34.5.96",
              "Dschibuti",
              "Dschibuti",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Dänemark.<br>
     */
    D_NEMARK("DK",
             "1.2.40.0.34.5.96",
             "Dänemark",
             "Dänemark",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Ecuador.<br>
     */
    ECUADOR("EC",
            "1.2.40.0.34.5.96",
            "Ecuador",
            "Ecuador",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Elfenbeinküste.<br>
     */
    ELFENBEINK_STE("CI",
                   "1.2.40.0.34.5.96",
                   "Elfenbeinküste",
                   "Elfenbeinküste",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: El Salvador.<br>
     */
    EL_SALVADOR("SV",
                "1.2.40.0.34.5.96",
                "El Salvador",
                "El Salvador",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Eritrea.<br>
     */
    ERITREA("ER",
            "1.2.40.0.34.5.96",
            "Eritrea",
            "Eritrea",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Estland.<br>
     */
    ESTLAND("EE",
            "1.2.40.0.34.5.96",
            "Estland",
            "Estland",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Ex-Jugoslawien.<br>
     */
    EX_JUGOSLAWIEN("YU",
                   "1.2.40.0.34.5.96",
                   "Ex-Jugoslawien",
                   "Ex-Jugoslawien",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Falklandinseln.<br>
     */
    FALKLANDINSELN("FK",
                   "1.2.40.0.34.5.96",
                   "Falklandinseln",
                   "Falklandinseln",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Fidschi.<br>
     */
    FIDSCHI("FJ",
            "1.2.40.0.34.5.96",
            "Fidschi",
            "Fidschi",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Finnland.<br>
     */
    FINNLAND("FI",
             "1.2.40.0.34.5.96",
             "Finnland",
             "Finnland",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Frankreich.<br>
     */
    FRANKREICH("FR",
               "1.2.40.0.34.5.96",
               "Frankreich",
               "Frankreich",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Französische Südgebiete.<br>
     */
    FRANZ_SISCHE_S_DGEBIETE("TF",
                            "1.2.40.0.34.5.96",
                            "Französische Südgebiete",
                            "Französische Südgebiete",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Französische Südpolargebiete.<br>
     */
    FRANZ_SISCHE_S_DPOLARGEBIETE("FQ",
                                 "1.2.40.0.34.5.96",
                                 "Französische Südpolargebiete",
                                 "Französische Südpolargebiete",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Französisch Guayana.<br>
     */
    FRANZ_SISCH_GUAYANA("GF",
                        "1.2.40.0.34.5.96",
                        "Französisch Guayana",
                        "Französisch Guayana",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Französisch Polynesien.<br>
     */
    FRANZ_SISCH_POLYNESIEN("PF",
                           "1.2.40.0.34.5.96",
                           "Französisch Polynesien",
                           "Französisch Polynesien",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Färoeer Inseln.<br>
     */
    F_ROEER_INSELN("FO",
                   "1.2.40.0.34.5.96",
                   "Färoeer Inseln",
                   "Färoeer Inseln",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Gabun.<br>
     */
    GABUN("GA",
          "1.2.40.0.34.5.96",
          "Gabun",
          "Gabun",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Gambia.<br>
     */
    GAMBIA("GM",
           "1.2.40.0.34.5.96",
           "Gambia",
           "Gambia",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Georgien.<br>
     */
    GEORGIEN("GE",
             "1.2.40.0.34.5.96",
             "Georgien",
             "Georgien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Ghana.<br>
     */
    GHANA("GH",
          "1.2.40.0.34.5.96",
          "Ghana",
          "Ghana",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Gibraltar.<br>
     */
    GIBRALTAR("GI",
              "1.2.40.0.34.5.96",
              "Gibraltar",
              "Gibraltar",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Grenada.<br>
     */
    GRENADA("GD",
            "1.2.40.0.34.5.96",
            "Grenada",
            "Grenada",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Griechenland.<br>
     */
    GRIECHENLAND("GR",
                 "1.2.40.0.34.5.96",
                 "Griechenland",
                 "Griechenland",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Großbritannien.<br>
     */
    GROSSBRITANNIEN("UK",
                    "1.2.40.0.34.5.96",
                    "Großbritannien",
                    "Großbritannien",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Grönland.<br>
     */
    GR_NLAND("GL",
             "1.2.40.0.34.5.96",
             "Grönland",
             "Grönland",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Guadeloupe.<br>
     */
    GUADELOUPE("GP",
               "1.2.40.0.34.5.96",
               "Guadeloupe",
               "Guadeloupe",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Guam US-Verwaltung.<br>
     */
    GUAM_US_VERWALTUNG("GU",
                       "1.2.40.0.34.5.96",
                       "Guam US-Verwaltung",
                       "Guam US-Verwaltung",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Guatemala.<br>
     */
    GUATEMALA("GT",
              "1.2.40.0.34.5.96",
              "Guatemala",
              "Guatemala",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Guernsey Insel.<br>
     */
    GUERNSEY_INSEL("GG",
                   "1.2.40.0.34.5.96",
                   "Guernsey Insel",
                   "Guernsey Insel",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Guinea.<br>
     */
    GUINEA("GN",
           "1.2.40.0.34.5.96",
           "Guinea",
           "Guinea",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Guinea-Bissau.<br>
     */
    GUINEA_BISSAU("GW",
                  "1.2.40.0.34.5.96",
                  "Guinea-Bissau",
                  "Guinea-Bissau",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Guyana.<br>
     */
    GUYANA("GY",
           "1.2.40.0.34.5.96",
           "Guyana",
           "Guyana",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Haiti.<br>
     */
    HAITI("HT",
          "1.2.40.0.34.5.96",
          "Haiti",
          "Haiti",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Heard &amp; McDonaldinseln.<br>
     */
    HEARD_MCDONALDINSELN("HM",
                         "1.2.40.0.34.5.96",
                         "Heard & McDonaldinseln",
                         "Heard & McDonaldinseln",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Honduras.<br>
     */
    HONDURAS("HN",
             "1.2.40.0.34.5.96",
             "Honduras",
             "Honduras",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Hongkong.<br>
     */
    HONGKONG("HK",
             "1.2.40.0.34.5.96",
             "Hongkong",
             "Hongkong",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Indien.<br>
     */
    INDIEN("IN",
           "1.2.40.0.34.5.96",
           "Indien",
           "Indien",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Indonesien.<br>
     */
    INDONESIEN("ID",
               "1.2.40.0.34.5.96",
               "Indonesien",
               "Indonesien",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Irak.<br>
     */
    IRAK("IQ",
         "1.2.40.0.34.5.96",
         "Irak",
         "Irak",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Iran.<br>
     */
    IRAN("IR",
         "1.2.40.0.34.5.96",
         "Iran",
         "Iran",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Irland.<br>
     */
    IRLAND("IE",
           "1.2.40.0.34.5.96",
           "Irland",
           "Irland",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Island.<br>
     */
    ISLAND("IS",
           "1.2.40.0.34.5.96",
           "Island",
           "Island",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Isle of Man.<br>
     */
    ISLE_OF_MAN("IM",
                "1.2.40.0.34.5.96",
                "Isle of Man",
                "Isle of Man",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Israel.<br>
     */
    ISRAEL("IL",
           "1.2.40.0.34.5.96",
           "Israel",
           "Israel",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Italien.<br>
     */
    ITALIEN("IT",
            "1.2.40.0.34.5.96",
            "Italien",
            "Italien",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Jamaika.<br>
     */
    JAMAIKA("JM",
            "1.2.40.0.34.5.96",
            "Jamaika",
            "Jamaika",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Japan.<br>
     */
    JAPAN("JP",
          "1.2.40.0.34.5.96",
          "Japan",
          "Japan",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Jemen.<br>
     */
    JEMEN("YE",
          "1.2.40.0.34.5.96",
          "Jemen",
          "Jemen",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Jersey Insel.<br>
     */
    JERSEY_INSEL("JE",
                 "1.2.40.0.34.5.96",
                 "Jersey Insel",
                 "Jersey Insel",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Johnston Insel.<br>
     */
    JOHNSTON_INSEL("JT",
                   "1.2.40.0.34.5.96",
                   "Johnston Insel",
                   "Johnston Insel",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Jordanien.<br>
     */
    JORDANIEN("JO",
              "1.2.40.0.34.5.96",
              "Jordanien",
              "Jordanien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Jungfern-Inseln Britisch .<br>
     */
    JUNGFERN_INSELN_BRITISCH("VG",
                             "1.2.40.0.34.5.96",
                             "Jungfern-Inseln Britisch ",
                             "Jungfern-Inseln Britisch ",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Jungfern-Inseln USA.<br>
     */
    JUNGFERN_INSELN_USA("VI",
                        "1.2.40.0.34.5.96",
                        "Jungfern-Inseln USA",
                        "Jungfern-Inseln USA",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Kaimaninseln.<br>
     */
    KAIMANINSELN("KY",
                 "1.2.40.0.34.5.96",
                 "Kaimaninseln",
                 "Kaimaninseln",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Kambodscha.<br>
     */
    KAMBODSCHA("KH",
               "1.2.40.0.34.5.96",
               "Kambodscha",
               "Kambodscha",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Kamerun.<br>
     */
    KAMERUN("CM",
            "1.2.40.0.34.5.96",
            "Kamerun",
            "Kamerun",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Kanada.<br>
     */
    KANADA("CA",
           "1.2.40.0.34.5.96",
           "Kanada",
           "Kanada",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Kanarische Inseln.<br>
     */
    KANARISCHE_INSELN("IC",
                      "1.2.40.0.34.5.96",
                      "Kanarische Inseln",
                      "Kanarische Inseln",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Kap Verde.<br>
     */
    KAP_VERDE("CV",
              "1.2.40.0.34.5.96",
              "Kap Verde",
              "Kap Verde",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Kasachstan.<br>
     */
    KASACHSTAN("KZ",
               "1.2.40.0.34.5.96",
               "Kasachstan",
               "Kasachstan",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Katar.<br>
     */
    KATAR("QA",
          "1.2.40.0.34.5.96",
          "Katar",
          "Katar",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Kenia.<br>
     */
    KENIA("KE",
          "1.2.40.0.34.5.96",
          "Kenia",
          "Kenia",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Kirgisistan.<br>
     */
    KIRGISISTAN("KG",
                "1.2.40.0.34.5.96",
                "Kirgisistan",
                "Kirgisistan",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Kiribati.<br>
     */
    KIRIBATI("KI",
             "1.2.40.0.34.5.96",
             "Kiribati",
             "Kiribati",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Kokosinseln.<br>
     */
    KOKOSINSELN("CC",
                "1.2.40.0.34.5.96",
                "Kokosinseln",
                "Kokosinseln",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Kolumbien.<br>
     */
    KOLUMBIEN("CO",
              "1.2.40.0.34.5.96",
              "Kolumbien",
              "Kolumbien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Komoren.<br>
     */
    KOMOREN("KM",
            "1.2.40.0.34.5.96",
            "Komoren",
            "Komoren",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Kongo.<br>
     */
    KONGO("CG",
          "1.2.40.0.34.5.96",
          "Kongo",
          "Kongo",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Kongo, Demokr. Republik.<br>
     */
    KONGO_DEMOKR_REPUBLIK("CD",
                          "1.2.40.0.34.5.96",
                          "Kongo, Demokr. Republik",
                          "Kongo, Demokr. Republik",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Korea, Demokr. Volksrepublik.<br>
     */
    KOREA_DEMOKR_VOLKSREPUBLIK("KP",
                               "1.2.40.0.34.5.96",
                               "Korea, Demokr. Volksrepublik",
                               "Korea, Demokr. Volksrepublik",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Korea, Republik von.<br>
     */
    KOREA_REPUBLIK_VON("KR",
                       "1.2.40.0.34.5.96",
                       "Korea, Republik von",
                       "Korea, Republik von",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Kosovo.<br>
     */
    KOSOVO("XK",
           "1.2.40.0.34.5.96",
           "Kosovo",
           "Kosovo",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Kroatien.<br>
     */
    KROATIEN("HR",
             "1.2.40.0.34.5.96",
             "Kroatien",
             "Kroatien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Kuba.<br>
     */
    KUBA("CU",
         "1.2.40.0.34.5.96",
         "Kuba",
         "Kuba",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Kuwait.<br>
     */
    KUWAIT("KW",
           "1.2.40.0.34.5.96",
           "Kuwait",
           "Kuwait",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Laos.<br>
     */
    LAOS("LA",
         "1.2.40.0.34.5.96",
         "Laos",
         "Laos",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Lesotho.<br>
     */
    LESOTHO("LS",
            "1.2.40.0.34.5.96",
            "Lesotho",
            "Lesotho",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Lettland.<br>
     */
    LETTLAND("LV",
             "1.2.40.0.34.5.96",
             "Lettland",
             "Lettland",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Libanon.<br>
     */
    LIBANON("LB",
            "1.2.40.0.34.5.96",
            "Libanon",
            "Libanon",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Liberien.<br>
     */
    LIBERIEN("LR",
             "1.2.40.0.34.5.96",
             "Liberien",
             "Liberien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Libysch-Arab. Dschamahirija.<br>
     */
    LIBYSCH_ARAB_DSCHAMAHIRIJA("LY",
                               "1.2.40.0.34.5.96",
                               "Libysch-Arab. Dschamahirija",
                               "Libysch-Arab. Dschamahirija",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Liechtenstein.<br>
     */
    LIECHTENSTEIN("LI",
                  "1.2.40.0.34.5.96",
                  "Liechtenstein",
                  "Liechtenstein",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Litauen.<br>
     */
    LITAUEN("LT",
            "1.2.40.0.34.5.96",
            "Litauen",
            "Litauen",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Luxemburg.<br>
     */
    LUXEMBURG("LU",
              "1.2.40.0.34.5.96",
              "Luxemburg",
              "Luxemburg",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Macao.<br>
     */
    MACAO("MO",
          "1.2.40.0.34.5.96",
          "Macao",
          "Macao",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Madagaskar.<br>
     */
    MADAGASKAR("MG",
               "1.2.40.0.34.5.96",
               "Madagaskar",
               "Madagaskar",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Malawi.<br>
     */
    MALAWI("MW",
           "1.2.40.0.34.5.96",
           "Malawi",
           "Malawi",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Malaysia.<br>
     */
    MALAYSIA("MY",
             "1.2.40.0.34.5.96",
             "Malaysia",
             "Malaysia",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Malediven.<br>
     */
    MALEDIVEN("MV",
              "1.2.40.0.34.5.96",
              "Malediven",
              "Malediven",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Mali.<br>
     */
    MALI("ML",
         "1.2.40.0.34.5.96",
         "Mali",
         "Mali",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Malta.<br>
     */
    MALTA("MT",
          "1.2.40.0.34.5.96",
          "Malta",
          "Malta",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Marokko.<br>
     */
    MAROKKO("MA",
            "1.2.40.0.34.5.96",
            "Marokko",
            "Marokko",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Marshall Inseln.<br>
     */
    MARSHALL_INSELN("MH",
                    "1.2.40.0.34.5.96",
                    "Marshall Inseln",
                    "Marshall Inseln",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Martinique.<br>
     */
    MARTINIQUE("MQ",
               "1.2.40.0.34.5.96",
               "Martinique",
               "Martinique",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mauretanien.<br>
     */
    MAURETANIEN("MR",
                "1.2.40.0.34.5.96",
                "Mauretanien",
                "Mauretanien",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Mauritius.<br>
     */
    MAURITIUS("MU",
              "1.2.40.0.34.5.96",
              "Mauritius",
              "Mauritius",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Mayotte.<br>
     */
    MAYOTTE("YT",
            "1.2.40.0.34.5.96",
            "Mayotte",
            "Mayotte",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Mazedonien.<br>
     */
    MAZEDONIEN("MK",
               "1.2.40.0.34.5.96",
               "Mazedonien",
               "Mazedonien",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mellila.<br>
     */
    MELLILA("XL",
            "1.2.40.0.34.5.96",
            "Mellila",
            "Mellila",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Mexiko.<br>
     */
    MEXIKO("MX",
           "1.2.40.0.34.5.96",
           "Mexiko",
           "Mexiko",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Midway Inseln.<br>
     */
    MIDWAY_INSELN("MI",
                  "1.2.40.0.34.5.96",
                  "Midway Inseln",
                  "Midway Inseln",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Mikronesien.<br>
     */
    MIKRONESIEN("FM",
                "1.2.40.0.34.5.96",
                "Mikronesien",
                "Mikronesien",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Moldau, Republik.<br>
     */
    MOLDAU_REPUBLIK("MD",
                    "1.2.40.0.34.5.96",
                    "Moldau, Republik",
                    "Moldau, Republik",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Monaco.<br>
     */
    MONACO("MC",
           "1.2.40.0.34.5.96",
           "Monaco",
           "Monaco",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Mongolei.<br>
     */
    MONGOLEI("MN",
             "1.2.40.0.34.5.96",
             "Mongolei",
             "Mongolei",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Montenegro.<br>
     */
    MONTENEGRO("ME",
               "1.2.40.0.34.5.96",
               "Montenegro",
               "Montenegro",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Montserrat.<br>
     */
    MONTSERRAT("MS",
               "1.2.40.0.34.5.96",
               "Montserrat",
               "Montserrat",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mosambik.<br>
     */
    MOSAMBIK("MZ",
             "1.2.40.0.34.5.96",
             "Mosambik",
             "Mosambik",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Myanmar.<br>
     */
    MYANMAR("MM",
            "1.2.40.0.34.5.96",
            "Myanmar",
            "Myanmar",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Namibia.<br>
     */
    NAMIBIA("NA",
            "1.2.40.0.34.5.96",
            "Namibia",
            "Namibia",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Nauru.<br>
     */
    NAURU("NR",
          "1.2.40.0.34.5.96",
          "Nauru",
          "Nauru",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Nepal.<br>
     */
    NEPAL("NP",
          "1.2.40.0.34.5.96",
          "Nepal",
          "Nepal",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Neukaledonien.<br>
     */
    NEUKALEDONIEN("NC",
                  "1.2.40.0.34.5.96",
                  "Neukaledonien",
                  "Neukaledonien",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Neuseeland.<br>
     */
    NEUSEELAND("NZ",
               "1.2.40.0.34.5.96",
               "Neuseeland",
               "Neuseeland",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Nicaragua.<br>
     */
    NICARAGUA("NI",
              "1.2.40.0.34.5.96",
              "Nicaragua",
              "Nicaragua",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Niederlande.<br>
     */
    NIEDERLANDE("NL",
                "1.2.40.0.34.5.96",
                "Niederlande",
                "Niederlande",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Niederländische Antillen.<br>
     */
    NIEDERL_NDISCHE_ANTILLEN("AN",
                             "1.2.40.0.34.5.96",
                             "Niederländische Antillen",
                             "Niederländische Antillen",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Niger.<br>
     */
    NIGER("NE",
          "1.2.40.0.34.5.96",
          "Niger",
          "Niger",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Nigeria.<br>
     */
    NIGERIA("NG",
            "1.2.40.0.34.5.96",
            "Nigeria",
            "Nigeria",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Niue.<br>
     */
    NIUE("NU",
         "1.2.40.0.34.5.96",
         "Niue",
         "Niue",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Norfolkinsel.<br>
     */
    NORFOLKINSEL("NF",
                 "1.2.40.0.34.5.96",
                 "Norfolkinsel",
                 "Norfolkinsel",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Norwegen.<br>
     */
    NORWEGEN("NO",
             "1.2.40.0.34.5.96",
             "Norwegen",
             "Norwegen",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Nördliche Marianen.<br>
     */
    N_RDLICHE_MARIANEN("MP",
                       "1.2.40.0.34.5.96",
                       "Nördliche Marianen",
                       "Nördliche Marianen",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Oman.<br>
     */
    OMAN("OM",
         "1.2.40.0.34.5.96",
         "Oman",
         "Oman",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Pakistan.<br>
     */
    PAKISTAN("PK",
             "1.2.40.0.34.5.96",
             "Pakistan",
             "Pakistan",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Palau.<br>
     */
    PALAU("PW",
          "1.2.40.0.34.5.96",
          "Palau",
          "Palau",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Palästina, Besetzt.<br>
     */
    PAL_STINA_BESETZT("PS",
                      "1.2.40.0.34.5.96",
                      "Palästina, Besetzt",
                      "Palästina, Besetzt",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Panama.<br>
     */
    PANAMA("PA",
           "1.2.40.0.34.5.96",
           "Panama",
           "Panama",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Panama Kanalzone.<br>
     */
    PANAMA_KANALZONE("PZ",
                     "1.2.40.0.34.5.96",
                     "Panama Kanalzone",
                     "Panama Kanalzone",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Papua Neuguinea.<br>
     */
    PAPUA_NEUGUINEA("PG",
                    "1.2.40.0.34.5.96",
                    "Papua Neuguinea",
                    "Papua Neuguinea",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Paraguay.<br>
     */
    PARAGUAY("PY",
             "1.2.40.0.34.5.96",
             "Paraguay",
             "Paraguay",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Pazifische Inseln US.<br>
     */
    PAZIFISCHE_INSELN_US("PU",
                         "1.2.40.0.34.5.96",
                         "Pazifische Inseln US",
                         "Pazifische Inseln US",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Peru.<br>
     */
    PERU("PE",
         "1.2.40.0.34.5.96",
         "Peru",
         "Peru",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Philippinen.<br>
     */
    PHILIPPINEN("PH",
                "1.2.40.0.34.5.96",
                "Philippinen",
                "Philippinen",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Pitcairn Inseln.<br>
     */
    PITCAIRN_INSELN("PN",
                    "1.2.40.0.34.5.96",
                    "Pitcairn Inseln",
                    "Pitcairn Inseln",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Polen.<br>
     */
    POLEN("PL",
          "1.2.40.0.34.5.96",
          "Polen",
          "Polen",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Portugal.<br>
     */
    PORTUGAL("PT",
             "1.2.40.0.34.5.96",
             "Portugal",
             "Portugal",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Puerto Rico.<br>
     */
    PUERTO_RICO("PR",
                "1.2.40.0.34.5.96",
                "Puerto Rico",
                "Puerto Rico",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Ruanda.<br>
     */
    RUANDA("RW",
           "1.2.40.0.34.5.96",
           "Ruanda",
           "Ruanda",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Rumänien.<br>
     */
    RUM_NIEN("RO",
             "1.2.40.0.34.5.96",
             "Rumänien",
             "Rumänien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Russische Föderation.<br>
     */
    RUSSISCHE_F_DERATION("RU",
                         "1.2.40.0.34.5.96",
                         "Russische Föderation",
                         "Russische Föderation",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Réunion.<br>
     */
    R_UNION("RE",
            "1.2.40.0.34.5.96",
            "Réunion",
            "Réunion",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Saint Barthelemy.<br>
     */
    SAINT_BARTHELEMY("BL",
                     "1.2.40.0.34.5.96",
                     "Saint Barthelemy",
                     "Saint Barthelemy",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Saint Martin (französischer Teil).<br>
     */
    SAINT_MARTIN_FRANZ_SISCHER_TEIL("MF",
                                    "1.2.40.0.34.5.96",
                                    "Saint Martin (französischer Teil)",
                                    "Saint Martin (französischer Teil)",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Salomonen.<br>
     */
    SALOMONEN("SB",
              "1.2.40.0.34.5.96",
              "Salomonen",
              "Salomonen",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Sambia.<br>
     */
    SAMBIA("ZM",
           "1.2.40.0.34.5.96",
           "Sambia",
           "Sambia",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Samoa-Amerikanisch.<br>
     */
    SAMOA_AMERIKANISCH("AS",
                       "1.2.40.0.34.5.96",
                       "Samoa-Amerikanisch",
                       "Samoa-Amerikanisch",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Samoa-West.<br>
     */
    SAMOA_WEST("WS",
               "1.2.40.0.34.5.96",
               "Samoa-West",
               "Samoa-West",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: San Marino.<br>
     */
    SAN_MARINO("SM",
               "1.2.40.0.34.5.96",
               "San Marino",
               "San Marino",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Saudi-Arabien.<br>
     */
    SAUDI_ARABIEN("SA",
                  "1.2.40.0.34.5.96",
                  "Saudi-Arabien",
                  "Saudi-Arabien",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Schweden.<br>
     */
    SCHWEDEN("SE",
             "1.2.40.0.34.5.96",
             "Schweden",
             "Schweden",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Schweiz.<br>
     */
    SCHWEIZ("CH",
            "1.2.40.0.34.5.96",
            "Schweiz",
            "Schweiz",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Senegal.<br>
     */
    SENEGAL("SN",
            "1.2.40.0.34.5.96",
            "Senegal",
            "Senegal",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Serbien.<br>
     */
    SERBIEN("RS",
            "1.2.40.0.34.5.96",
            "Serbien",
            "Serbien",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Seychellen.<br>
     */
    SEYCHELLEN("SC",
               "1.2.40.0.34.5.96",
               "Seychellen",
               "Seychellen",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Sierra Leone.<br>
     */
    SIERRA_LEONE("SL",
                 "1.2.40.0.34.5.96",
                 "Sierra Leone",
                 "Sierra Leone",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Simbabwe.<br>
     */
    SIMBABWE("ZW",
             "1.2.40.0.34.5.96",
             "Simbabwe",
             "Simbabwe",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Singapur.<br>
     */
    SINGAPUR("SG",
             "1.2.40.0.34.5.96",
             "Singapur",
             "Singapur",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Sint Maarten (hollländischer Teil).<br>
     */
    SINT_MAARTEN_HOLLL_NDISCHER_TEIL("SX",
                                     "1.2.40.0.34.5.96",
                                     "Sint Maarten (hollländischer Teil)",
                                     "Sint Maarten (hollländischer Teil)",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Slowakei.<br>
     */
    SLOWAKEI("SK",
             "1.2.40.0.34.5.96",
             "Slowakei",
             "Slowakei",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Slowenien.<br>
     */
    SLOWENIEN("SI",
              "1.2.40.0.34.5.96",
              "Slowenien",
              "Slowenien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Somalia.<br>
     */
    SOMALIA("SO",
            "1.2.40.0.34.5.96",
            "Somalia",
            "Somalia",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Spanien.<br>
     */
    SPANIEN("ES",
            "1.2.40.0.34.5.96",
            "Spanien",
            "Spanien",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Spitzbergen &amp; Jan Mayen Inseln.<br>
     */
    SPITZBERGEN_JAN_MAYEN_INSELN("SJ",
                                 "1.2.40.0.34.5.96",
                                 "Spitzbergen & Jan Mayen Inseln",
                                 "Spitzbergen & Jan Mayen Inseln",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Sri Lanka.<br>
     */
    SRI_LANKA("LK",
              "1.2.40.0.34.5.96",
              "Sri Lanka",
              "Sri Lanka",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: St. Helena.<br>
     */
    ST_HELENA("SH",
              "1.2.40.0.34.5.96",
              "St. Helena",
              "St. Helena",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: St. Kitts &amp; Nevis.<br>
     */
    ST_KITTS_NEVIS("KN",
                   "1.2.40.0.34.5.96",
                   "St. Kitts & Nevis",
                   "St. Kitts & Nevis",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: St. Lucia.<br>
     */
    ST_LUCIA("LC",
             "1.2.40.0.34.5.96",
             "St. Lucia",
             "St. Lucia",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: St. Pierre &amp; Miquelon.<br>
     */
    ST_PIERRE_MIQUELON("PM",
                       "1.2.40.0.34.5.96",
                       "St. Pierre & Miquelon",
                       "St. Pierre & Miquelon",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: St. Vincent &amp; Grenadinen.<br>
     */
    ST_VINCENT_GRENADINEN("VC",
                          "1.2.40.0.34.5.96",
                          "St. Vincent & Grenadinen",
                          "St. Vincent & Grenadinen",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Sudan.<br>
     */
    SUDAN("SD",
          "1.2.40.0.34.5.96",
          "Sudan",
          "Sudan",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Suriname.<br>
     */
    SURINAME("SR",
             "1.2.40.0.34.5.96",
             "Suriname",
             "Suriname",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Swasiland.<br>
     */
    SWASILAND("SZ",
              "1.2.40.0.34.5.96",
              "Swasiland",
              "Swasiland",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Syrien.<br>
     */
    SYRIEN("SY",
           "1.2.40.0.34.5.96",
           "Syrien",
           "Syrien",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Südafrika.<br>
     */
    S_DAFRIKA("ZA",
              "1.2.40.0.34.5.96",
              "Südafrika",
              "Südafrika",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Südgeorgien &amp; südl. Sandwich-I.<br>
     */
    S_DGEORGIEN_S_DL_SANDWICH_I("GS",
                                "1.2.40.0.34.5.96",
                                "Südgeorgien & südl. Sandwich-I.",
                                "Südgeorgien & südl. Sandwich-I.",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: São Tomé &amp; Príncipe.<br>
     */
    S_O_TOM_PR_NCIPE("ST",
                     "1.2.40.0.34.5.96",
                     "São Tomé & Príncipe",
                     "São Tomé & Príncipe",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Tadschikistan.<br>
     */
    TADSCHIKISTAN("TJ",
                  "1.2.40.0.34.5.96",
                  "Tadschikistan",
                  "Tadschikistan",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Taiwan.<br>
     */
    TAIWAN("TW",
           "1.2.40.0.34.5.96",
           "Taiwan",
           "Taiwan",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Tansania, Vereinigte Republik.<br>
     */
    TANSANIA_VEREINIGTE_REPUBLIK("TZ",
                                 "1.2.40.0.34.5.96",
                                 "Tansania, Vereinigte Republik",
                                 "Tansania, Vereinigte Republik",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Thailand.<br>
     */
    THAILAND("TH",
             "1.2.40.0.34.5.96",
             "Thailand",
             "Thailand",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Timor-Leste.<br>
     */
    TIMOR_LESTE("TL",
                "1.2.40.0.34.5.96",
                "Timor-Leste",
                "Timor-Leste",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Togo.<br>
     */
    TOGO("TG",
         "1.2.40.0.34.5.96",
         "Togo",
         "Togo",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Tokelau.<br>
     */
    TOKELAU("TK",
            "1.2.40.0.34.5.96",
            "Tokelau",
            "Tokelau",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Tonga.<br>
     */
    TONGA("TO",
          "1.2.40.0.34.5.96",
          "Tonga",
          "Tonga",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Trinidad &amp; Tobago.<br>
     */
    TRINIDAD_TOBAGO("TT",
                    "1.2.40.0.34.5.96",
                    "Trinidad & Tobago",
                    "Trinidad & Tobago",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tschad.<br>
     */
    TSCHAD("TD",
           "1.2.40.0.34.5.96",
           "Tschad",
           "Tschad",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Tschechische Republik.<br>
     */
    TSCHECHISCHE_REPUBLIK("CZ",
                          "1.2.40.0.34.5.96",
                          "Tschechische Republik",
                          "Tschechische Republik",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Tunesien.<br>
     */
    TUNESIEN("TN",
             "1.2.40.0.34.5.96",
             "Tunesien",
             "Tunesien",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Turkmenistan.<br>
     */
    TURKMENISTAN("TM",
                 "1.2.40.0.34.5.96",
                 "Turkmenistan",
                 "Turkmenistan",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Turks- &amp; Caicosinseln.<br>
     */
    TURKS_CAICOSINSELN("TC",
                       "1.2.40.0.34.5.96",
                       "Turks- & Caicosinseln",
                       "Turks- & Caicosinseln",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Tuvalu.<br>
     */
    TUVALU("TV",
           "1.2.40.0.34.5.96",
           "Tuvalu",
           "Tuvalu",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Türkei.<br>
     */
    T_RKEI("TR",
           "1.2.40.0.34.5.96",
           "Türkei",
           "Türkei",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Uganda.<br>
     */
    UGANDA("UG",
           "1.2.40.0.34.5.96",
           "Uganda",
           "Uganda",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Ukraine.<br>
     */
    UKRAINE("UA",
            "1.2.40.0.34.5.96",
            "Ukraine",
            "Ukraine",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Ungarn.<br>
     */
    UNGARN("HU",
           "1.2.40.0.34.5.96",
           "Ungarn",
           "Ungarn",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Uruguay.<br>
     */
    URUGUAY("UY",
            "1.2.40.0.34.5.96",
            "Uruguay",
            "Uruguay",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: USA (sonstige kleine Inseln).<br>
     */
    USA_SONSTIGE_KLEINE_INSELN("UM",
                               "1.2.40.0.34.5.96",
                               "USA (sonstige kleine Inseln)",
                               "USA (sonstige kleine Inseln)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Usbekistan.<br>
     */
    USBEKISTAN("UZ",
               "1.2.40.0.34.5.96",
               "Usbekistan",
               "Usbekistan",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Vanuatu.<br>
     */
    VANUATU("VU",
            "1.2.40.0.34.5.96",
            "Vanuatu",
            "Vanuatu",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Vatikan.<br>
     */
    VATIKAN("VA",
            "1.2.40.0.34.5.96",
            "Vatikan",
            "Vatikan",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Venezuela.<br>
     */
    VENEZUELA("VE",
              "1.2.40.0.34.5.96",
              "Venezuela",
              "Venezuela",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Vereinigte Arabische Emirate.<br>
     */
    VEREINIGTE_ARABISCHE_EMIRATE("AE",
                                 "1.2.40.0.34.5.96",
                                 "Vereinigte Arabische Emirate",
                                 "Vereinigte Arabische Emirate",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Vereinigte Staaten.<br>
     */
    VEREINIGTE_STAATEN("US",
                       "1.2.40.0.34.5.96",
                       "Vereinigte Staaten",
                       "Vereinigte Staaten",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Vietnam.<br>
     */
    VIETNAM("VN",
            "1.2.40.0.34.5.96",
            "Vietnam",
            "Vietnam",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Wake Insel.<br>
     */
    WAKE_INSEL("WK",
               "1.2.40.0.34.5.96",
               "Wake Insel",
               "Wake Insel",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Wallis und Futuna.<br>
     */
    WALLIS_UND_FUTUNA("WF",
                      "1.2.40.0.34.5.96",
                      "Wallis und Futuna",
                      "Wallis und Futuna",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Weihnachtsinsel.<br>
     */
    WEIHNACHTSINSEL("CX",
                    "1.2.40.0.34.5.96",
                    "Weihnachtsinsel",
                    "Weihnachtsinsel",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Westsahara Eigenständiger Staat.<br>
     */
    WESTSAHARA_EIGENST_NDIGER_STAAT("EH",
                                    "1.2.40.0.34.5.96",
                                    "Westsahara Eigenständiger Staat",
                                    "Westsahara Eigenständiger Staat",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Zentralafrikanische Republik.<br>
     */
    ZENTRALAFRIKANISCHE_REPUBLIK("CF",
                                 "1.2.40.0.34.5.96",
                                 "Zentralafrikanische Republik",
                                 "Zentralafrikanische Republik",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Zypern.<br>
     */
    ZYPERN("CY",
           "1.2.40.0.34.5.96",
           "Zypern",
           "Zypern",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Ägypten.<br>
     */
    _GYPTEN("EG",
            "1.2.40.0.34.5.96",
            "Ägypten",
            "Ägypten",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Äquatorial Guinea.<br>
     */
    _QUATORIAL_GUINEA("GQ",
                      "1.2.40.0.34.5.96",
                      "Äquatorial Guinea",
                      "Äquatorial Guinea",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Österreich.<br>
     */
    _STERREICH("AT",
               "1.2.40.0.34.5.96",
               "Österreich",
               "Österreich",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Äthiopien.<br>
     */
    _THIOPIEN("ET",
              "1.2.40.0.34.5.96",
              "Äthiopien",
              "Äthiopien",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE");

    /**
     * EN: Code for Afghanistan.<br>
     */
    public static final String AFGHANISTAN_CODE = "AF";

    /**
     * EN: Code for Aland Islands.<br>
     */
    public static final String ALAND_ISLANDS_CODE = "AX";

    /**
     * EN: Code for Albanien.<br>
     */
    public static final String ALBANIEN_CODE = "AL";

    /**
     * EN: Code for Algerien.<br>
     */
    public static final String ALGERIEN_CODE = "DZ";

    /**
     * EN: Code for Andorra.<br>
     */
    public static final String ANDORRA_CODE = "AD";

    /**
     * EN: Code for Angola.<br>
     */
    public static final String ANGOLA_CODE = "AO";

    /**
     * EN: Code for Anguilla.<br>
     */
    public static final String ANGUILLA_CODE = "AI";

    /**
     * EN: Code for Antarktis.<br>
     */
    public static final String ANTARKTIS_CODE = "AQ";

    /**
     * EN: Code for Antigua &amp; Barbuda.<br>
     */
    public static final String ANTIGUA_BARBUDA_CODE = "AG";

    /**
     * EN: Code for Argentinien.<br>
     */
    public static final String ARGENTINIEN_CODE = "AR";

    /**
     * EN: Code for Armenien.<br>
     */
    public static final String ARMENIEN_CODE = "AM";

    /**
     * EN: Code for Aruba.<br>
     */
    public static final String ARUBA_CODE = "AW";

    /**
     * EN: Code for Aserbaidschan.<br>
     */
    public static final String ASERBAIDSCHAN_CODE = "AZ";

    /**
     * EN: Code for Australien.<br>
     */
    public static final String AUSTRALIEN_CODE = "AU";

    /**
     * EN: Code for Bahamas.<br>
     */
    public static final String BAHAMAS_CODE = "BS";

    /**
     * EN: Code for Bahrain.<br>
     */
    public static final String BAHRAIN_CODE = "BH";

    /**
     * EN: Code for Bangladesch.<br>
     */
    public static final String BANGLADESCH_CODE = "BD";

    /**
     * EN: Code for Barbados.<br>
     */
    public static final String BARBADOS_CODE = "BB";

    /**
     * EN: Code for Belarus.<br>
     */
    public static final String BELARUS_CODE = "BY";

    /**
     * EN: Code for Belgien.<br>
     */
    public static final String BELGIEN_CODE = "BE";

    /**
     * EN: Code for Belize.<br>
     */
    public static final String BELIZE_CODE = "BZ";

    /**
     * EN: Code for Benin.<br>
     */
    public static final String BENIN_CODE = "BJ";

    /**
     * EN: Code for Bermuda.<br>
     */
    public static final String BERMUDA_CODE = "BM";

    /**
     * EN: Code for Bhutan.<br>
     */
    public static final String BHUTAN_CODE = "BT";

    /**
     * EN: Code for Bolivien.<br>
     */
    public static final String BOLIVIEN_CODE = "BO";

    /**
     * EN: Code for Bonaire, Sint Eustatius und Saba.<br>
     */
    public static final String BONAIRE_SINT_EUSTATIUS_UND_SABA_CODE = "BQ";

    /**
     * EN: Code for Bosnien &amp; Herzegowina.<br>
     */
    public static final String BOSNIEN_HERZEGOWINA_CODE = "BA";

    /**
     * EN: Code for Botsuana.<br>
     */
    public static final String BOTSUANA_CODE = "BW";

    /**
     * EN: Code for Bouvetinsel.<br>
     */
    public static final String BOUVETINSEL_CODE = "BV";

    /**
     * EN: Code for Brasilien.<br>
     */
    public static final String BRASILIEN_CODE = "BR";

    /**
     * EN: Code for Brit. Territorium im Ind. Ozean.<br>
     */
    public static final String BRIT_TERRITORIUM_IM_IND_OZEAN_CODE = "IO";

    /**
     * EN: Code for Brunei Darussalam.<br>
     */
    public static final String BRUNEI_DARUSSALAM_CODE = "BN";

    /**
     * EN: Code for Bulgarien.<br>
     */
    public static final String BULGARIEN_CODE = "BG";

    /**
     * EN: Code for Burkina Faso.<br>
     */
    public static final String BURKINA_FASO_CODE = "BF";

    /**
     * EN: Code for Burundi.<br>
     */
    public static final String BURUNDI_CODE = "BI";

    /**
     * EN: Code for Canton &amp; Enderburyinseln.<br>
     */
    public static final String CANTON_ENDERBURYINSELN_CODE = "CT";

    /**
     * EN: Code for Ceuta .<br>
     */
    public static final String CEUTA_CODE = "XC";

    /**
     * EN: Code for Chile.<br>
     */
    public static final String CHILE_CODE = "CL";

    /**
     * EN: Code for China.<br>
     */
    public static final String CHINA_CODE = "CN";

    /**
     * EN: Code for Cook-Inseln.<br>
     */
    public static final String COOK_INSELN_CODE = "CK";

    /**
     * EN: Code for Costa Rica.<br>
     */
    public static final String COSTA_RICA_CODE = "CR";

    /**
     * EN: Code for Curacao.<br>
     */
    public static final String CURACAO_CODE = "CW";

    /**
     * EN: Code for Deutschland.<br>
     */
    public static final String DEUTSCHLAND_CODE = "DE";

    /**
     * EN: Code for Dominica.<br>
     */
    public static final String DOMINICA_CODE = "DM";

    /**
     * EN: Code for Dominikanische Republik.<br>
     */
    public static final String DOMINIKANISCHE_REPUBLIK_CODE = "DO";

    /**
     * EN: Code for Dschibuti.<br>
     */
    public static final String DSCHIBUTI_CODE = "DJ";

    /**
     * EN: Code for Dänemark.<br>
     */
    public static final String D_NEMARK_CODE = "DK";

    /**
     * EN: Code for Ecuador.<br>
     */
    public static final String ECUADOR_CODE = "EC";

    /**
     * EN: Code for Elfenbeinküste.<br>
     */
    public static final String ELFENBEINK_STE_CODE = "CI";

    /**
     * EN: Code for El Salvador.<br>
     */
    public static final String EL_SALVADOR_CODE = "SV";

    /**
     * EN: Code for Eritrea.<br>
     */
    public static final String ERITREA_CODE = "ER";

    /**
     * EN: Code for Estland.<br>
     */
    public static final String ESTLAND_CODE = "EE";

    /**
     * EN: Code for Ex-Jugoslawien.<br>
     */
    public static final String EX_JUGOSLAWIEN_CODE = "YU";

    /**
     * EN: Code for Falklandinseln.<br>
     */
    public static final String FALKLANDINSELN_CODE = "FK";

    /**
     * EN: Code for Fidschi.<br>
     */
    public static final String FIDSCHI_CODE = "FJ";

    /**
     * EN: Code for Finnland.<br>
     */
    public static final String FINNLAND_CODE = "FI";

    /**
     * EN: Code for Frankreich.<br>
     */
    public static final String FRANKREICH_CODE = "FR";

    /**
     * EN: Code for Französische Südgebiete.<br>
     */
    public static final String FRANZ_SISCHE_S_DGEBIETE_CODE = "TF";

    /**
     * EN: Code for Französische Südpolargebiete.<br>
     */
    public static final String FRANZ_SISCHE_S_DPOLARGEBIETE_CODE = "FQ";

    /**
     * EN: Code for Französisch Guayana.<br>
     */
    public static final String FRANZ_SISCH_GUAYANA_CODE = "GF";

    /**
     * EN: Code for Französisch Polynesien.<br>
     */
    public static final String FRANZ_SISCH_POLYNESIEN_CODE = "PF";

    /**
     * EN: Code for Färoeer Inseln.<br>
     */
    public static final String F_ROEER_INSELN_CODE = "FO";

    /**
     * EN: Code for Gabun.<br>
     */
    public static final String GABUN_CODE = "GA";

    /**
     * EN: Code for Gambia.<br>
     */
    public static final String GAMBIA_CODE = "GM";

    /**
     * EN: Code for Georgien.<br>
     */
    public static final String GEORGIEN_CODE = "GE";

    /**
     * EN: Code for Ghana.<br>
     */
    public static final String GHANA_CODE = "GH";

    /**
     * EN: Code for Gibraltar.<br>
     */
    public static final String GIBRALTAR_CODE = "GI";

    /**
     * EN: Code for Grenada.<br>
     */
    public static final String GRENADA_CODE = "GD";

    /**
     * EN: Code for Griechenland.<br>
     */
    public static final String GRIECHENLAND_CODE = "GR";

    /**
     * EN: Code for Großbritannien.<br>
     */
    public static final String GROSSBRITANNIEN_CODE = "UK";

    /**
     * EN: Code for Grönland.<br>
     */
    public static final String GR_NLAND_CODE = "GL";

    /**
     * EN: Code for Guadeloupe.<br>
     */
    public static final String GUADELOUPE_CODE = "GP";

    /**
     * EN: Code for Guam US-Verwaltung.<br>
     */
    public static final String GUAM_US_VERWALTUNG_CODE = "GU";

    /**
     * EN: Code for Guatemala.<br>
     */
    public static final String GUATEMALA_CODE = "GT";

    /**
     * EN: Code for Guernsey Insel.<br>
     */
    public static final String GUERNSEY_INSEL_CODE = "GG";

    /**
     * EN: Code for Guinea.<br>
     */
    public static final String GUINEA_CODE = "GN";

    /**
     * EN: Code for Guinea-Bissau.<br>
     */
    public static final String GUINEA_BISSAU_CODE = "GW";

    /**
     * EN: Code for Guyana.<br>
     */
    public static final String GUYANA_CODE = "GY";

    /**
     * EN: Code for Haiti.<br>
     */
    public static final String HAITI_CODE = "HT";

    /**
     * EN: Code for Heard &amp; McDonaldinseln.<br>
     */
    public static final String HEARD_MCDONALDINSELN_CODE = "HM";

    /**
     * EN: Code for Honduras.<br>
     */
    public static final String HONDURAS_CODE = "HN";

    /**
     * EN: Code for Hongkong.<br>
     */
    public static final String HONGKONG_CODE = "HK";

    /**
     * EN: Code for Indien.<br>
     */
    public static final String INDIEN_CODE = "IN";

    /**
     * EN: Code for Indonesien.<br>
     */
    public static final String INDONESIEN_CODE = "ID";

    /**
     * EN: Code for Irak.<br>
     */
    public static final String IRAK_CODE = "IQ";

    /**
     * EN: Code for Iran.<br>
     */
    public static final String IRAN_CODE = "IR";

    /**
     * EN: Code for Irland.<br>
     */
    public static final String IRLAND_CODE = "IE";

    /**
     * EN: Code for Island.<br>
     */
    public static final String ISLAND_CODE = "IS";

    /**
     * EN: Code for Isle of Man.<br>
     */
    public static final String ISLE_OF_MAN_CODE = "IM";

    /**
     * EN: Code for Israel.<br>
     */
    public static final String ISRAEL_CODE = "IL";

    /**
     * EN: Code for Italien.<br>
     */
    public static final String ITALIEN_CODE = "IT";

    /**
     * EN: Code for Jamaika.<br>
     */
    public static final String JAMAIKA_CODE = "JM";

    /**
     * EN: Code for Japan.<br>
     */
    public static final String JAPAN_CODE = "JP";

    /**
     * EN: Code for Jemen.<br>
     */
    public static final String JEMEN_CODE = "YE";

    /**
     * EN: Code for Jersey Insel.<br>
     */
    public static final String JERSEY_INSEL_CODE = "JE";

    /**
     * EN: Code for Johnston Insel.<br>
     */
    public static final String JOHNSTON_INSEL_CODE = "JT";

    /**
     * EN: Code for Jordanien.<br>
     */
    public static final String JORDANIEN_CODE = "JO";

    /**
     * EN: Code for Jungfern-Inseln Britisch .<br>
     */
    public static final String JUNGFERN_INSELN_BRITISCH_CODE = "VG";

    /**
     * EN: Code for Jungfern-Inseln USA.<br>
     */
    public static final String JUNGFERN_INSELN_USA_CODE = "VI";

    /**
     * EN: Code for Kaimaninseln.<br>
     */
    public static final String KAIMANINSELN_CODE = "KY";

    /**
     * EN: Code for Kambodscha.<br>
     */
    public static final String KAMBODSCHA_CODE = "KH";

    /**
     * EN: Code for Kamerun.<br>
     */
    public static final String KAMERUN_CODE = "CM";

    /**
     * EN: Code for Kanada.<br>
     */
    public static final String KANADA_CODE = "CA";

    /**
     * EN: Code for Kanarische Inseln.<br>
     */
    public static final String KANARISCHE_INSELN_CODE = "IC";

    /**
     * EN: Code for Kap Verde.<br>
     */
    public static final String KAP_VERDE_CODE = "CV";

    /**
     * EN: Code for Kasachstan.<br>
     */
    public static final String KASACHSTAN_CODE = "KZ";

    /**
     * EN: Code for Katar.<br>
     */
    public static final String KATAR_CODE = "QA";

    /**
     * EN: Code for Kenia.<br>
     */
    public static final String KENIA_CODE = "KE";

    /**
     * EN: Code for Kirgisistan.<br>
     */
    public static final String KIRGISISTAN_CODE = "KG";

    /**
     * EN: Code for Kiribati.<br>
     */
    public static final String KIRIBATI_CODE = "KI";

    /**
     * EN: Code for Kokosinseln.<br>
     */
    public static final String KOKOSINSELN_CODE = "CC";

    /**
     * EN: Code for Kolumbien.<br>
     */
    public static final String KOLUMBIEN_CODE = "CO";

    /**
     * EN: Code for Komoren.<br>
     */
    public static final String KOMOREN_CODE = "KM";

    /**
     * EN: Code for Kongo.<br>
     */
    public static final String KONGO_CODE = "CG";

    /**
     * EN: Code for Kongo, Demokr. Republik.<br>
     */
    public static final String KONGO_DEMOKR_REPUBLIK_CODE = "CD";

    /**
     * EN: Code for Korea, Demokr. Volksrepublik.<br>
     */
    public static final String KOREA_DEMOKR_VOLKSREPUBLIK_CODE = "KP";

    /**
     * EN: Code for Korea, Republik von.<br>
     */
    public static final String KOREA_REPUBLIK_VON_CODE = "KR";

    /**
     * EN: Code for Kosovo.<br>
     */
    public static final String KOSOVO_CODE = "XK";

    /**
     * EN: Code for Kroatien.<br>
     */
    public static final String KROATIEN_CODE = "HR";

    /**
     * EN: Code for Kuba.<br>
     */
    public static final String KUBA_CODE = "CU";

    /**
     * EN: Code for Kuwait.<br>
     */
    public static final String KUWAIT_CODE = "KW";

    /**
     * EN: Code for Laos.<br>
     */
    public static final String LAOS_CODE = "LA";

    /**
     * EN: Code for Lesotho.<br>
     */
    public static final String LESOTHO_CODE = "LS";

    /**
     * EN: Code for Lettland.<br>
     */
    public static final String LETTLAND_CODE = "LV";

    /**
     * EN: Code for Libanon.<br>
     */
    public static final String LIBANON_CODE = "LB";

    /**
     * EN: Code for Liberien.<br>
     */
    public static final String LIBERIEN_CODE = "LR";

    /**
     * EN: Code for Libysch-Arab. Dschamahirija.<br>
     */
    public static final String LIBYSCH_ARAB_DSCHAMAHIRIJA_CODE = "LY";

    /**
     * EN: Code for Liechtenstein.<br>
     */
    public static final String LIECHTENSTEIN_CODE = "LI";

    /**
     * EN: Code for Litauen.<br>
     */
    public static final String LITAUEN_CODE = "LT";

    /**
     * EN: Code for Luxemburg.<br>
     */
    public static final String LUXEMBURG_CODE = "LU";

    /**
     * EN: Code for Macao.<br>
     */
    public static final String MACAO_CODE = "MO";

    /**
     * EN: Code for Madagaskar.<br>
     */
    public static final String MADAGASKAR_CODE = "MG";

    /**
     * EN: Code for Malawi.<br>
     */
    public static final String MALAWI_CODE = "MW";

    /**
     * EN: Code for Malaysia.<br>
     */
    public static final String MALAYSIA_CODE = "MY";

    /**
     * EN: Code for Malediven.<br>
     */
    public static final String MALEDIVEN_CODE = "MV";

    /**
     * EN: Code for Mali.<br>
     */
    public static final String MALI_CODE = "ML";

    /**
     * EN: Code for Malta.<br>
     */
    public static final String MALTA_CODE = "MT";

    /**
     * EN: Code for Marokko.<br>
     */
    public static final String MAROKKO_CODE = "MA";

    /**
     * EN: Code for Marshall Inseln.<br>
     */
    public static final String MARSHALL_INSELN_CODE = "MH";

    /**
     * EN: Code for Martinique.<br>
     */
    public static final String MARTINIQUE_CODE = "MQ";

    /**
     * EN: Code for Mauretanien.<br>
     */
    public static final String MAURETANIEN_CODE = "MR";

    /**
     * EN: Code for Mauritius.<br>
     */
    public static final String MAURITIUS_CODE = "MU";

    /**
     * EN: Code for Mayotte.<br>
     */
    public static final String MAYOTTE_CODE = "YT";

    /**
     * EN: Code for Mazedonien.<br>
     */
    public static final String MAZEDONIEN_CODE = "MK";

    /**
     * EN: Code for Mellila.<br>
     */
    public static final String MELLILA_CODE = "XL";

    /**
     * EN: Code for Mexiko.<br>
     */
    public static final String MEXIKO_CODE = "MX";

    /**
     * EN: Code for Midway Inseln.<br>
     */
    public static final String MIDWAY_INSELN_CODE = "MI";

    /**
     * EN: Code for Mikronesien.<br>
     */
    public static final String MIKRONESIEN_CODE = "FM";

    /**
     * EN: Code for Moldau, Republik.<br>
     */
    public static final String MOLDAU_REPUBLIK_CODE = "MD";

    /**
     * EN: Code for Monaco.<br>
     */
    public static final String MONACO_CODE = "MC";

    /**
     * EN: Code for Mongolei.<br>
     */
    public static final String MONGOLEI_CODE = "MN";

    /**
     * EN: Code for Montenegro.<br>
     */
    public static final String MONTENEGRO_CODE = "ME";

    /**
     * EN: Code for Montserrat.<br>
     */
    public static final String MONTSERRAT_CODE = "MS";

    /**
     * EN: Code for Mosambik.<br>
     */
    public static final String MOSAMBIK_CODE = "MZ";

    /**
     * EN: Code for Myanmar.<br>
     */
    public static final String MYANMAR_CODE = "MM";

    /**
     * EN: Code for Namibia.<br>
     */
    public static final String NAMIBIA_CODE = "NA";

    /**
     * EN: Code for Nauru.<br>
     */
    public static final String NAURU_CODE = "NR";

    /**
     * EN: Code for Nepal.<br>
     */
    public static final String NEPAL_CODE = "NP";

    /**
     * EN: Code for Neukaledonien.<br>
     */
    public static final String NEUKALEDONIEN_CODE = "NC";

    /**
     * EN: Code for Neuseeland.<br>
     */
    public static final String NEUSEELAND_CODE = "NZ";

    /**
     * EN: Code for Nicaragua.<br>
     */
    public static final String NICARAGUA_CODE = "NI";

    /**
     * EN: Code for Niederlande.<br>
     */
    public static final String NIEDERLANDE_CODE = "NL";

    /**
     * EN: Code for Niederländische Antillen.<br>
     */
    public static final String NIEDERL_NDISCHE_ANTILLEN_CODE = "AN";

    /**
     * EN: Code for Niger.<br>
     */
    public static final String NIGER_CODE = "NE";

    /**
     * EN: Code for Nigeria.<br>
     */
    public static final String NIGERIA_CODE = "NG";

    /**
     * EN: Code for Niue.<br>
     */
    public static final String NIUE_CODE = "NU";

    /**
     * EN: Code for Norfolkinsel.<br>
     */
    public static final String NORFOLKINSEL_CODE = "NF";

    /**
     * EN: Code for Norwegen.<br>
     */
    public static final String NORWEGEN_CODE = "NO";

    /**
     * EN: Code for Nördliche Marianen.<br>
     */
    public static final String N_RDLICHE_MARIANEN_CODE = "MP";

    /**
     * EN: Code for Oman.<br>
     */
    public static final String OMAN_CODE = "OM";

    /**
     * EN: Code for Pakistan.<br>
     */
    public static final String PAKISTAN_CODE = "PK";

    /**
     * EN: Code for Palau.<br>
     */
    public static final String PALAU_CODE = "PW";

    /**
     * EN: Code for Palästina, Besetzt.<br>
     */
    public static final String PAL_STINA_BESETZT_CODE = "PS";

    /**
     * EN: Code for Panama.<br>
     */
    public static final String PANAMA_CODE = "PA";

    /**
     * EN: Code for Panama Kanalzone.<br>
     */
    public static final String PANAMA_KANALZONE_CODE = "PZ";

    /**
     * EN: Code for Papua Neuguinea.<br>
     */
    public static final String PAPUA_NEUGUINEA_CODE = "PG";

    /**
     * EN: Code for Paraguay.<br>
     */
    public static final String PARAGUAY_CODE = "PY";

    /**
     * EN: Code for Pazifische Inseln US.<br>
     */
    public static final String PAZIFISCHE_INSELN_US_CODE = "PU";

    /**
     * EN: Code for Peru.<br>
     */
    public static final String PERU_CODE = "PE";

    /**
     * EN: Code for Philippinen.<br>
     */
    public static final String PHILIPPINEN_CODE = "PH";

    /**
     * EN: Code for Pitcairn Inseln.<br>
     */
    public static final String PITCAIRN_INSELN_CODE = "PN";

    /**
     * EN: Code for Polen.<br>
     */
    public static final String POLEN_CODE = "PL";

    /**
     * EN: Code for Portugal.<br>
     */
    public static final String PORTUGAL_CODE = "PT";

    /**
     * EN: Code for Puerto Rico.<br>
     */
    public static final String PUERTO_RICO_CODE = "PR";

    /**
     * EN: Code for Ruanda.<br>
     */
    public static final String RUANDA_CODE = "RW";

    /**
     * EN: Code for Rumänien.<br>
     */
    public static final String RUM_NIEN_CODE = "RO";

    /**
     * EN: Code for Russische Föderation.<br>
     */
    public static final String RUSSISCHE_F_DERATION_CODE = "RU";

    /**
     * EN: Code for Réunion.<br>
     */
    public static final String R_UNION_CODE = "RE";

    /**
     * EN: Code for Saint Barthelemy.<br>
     */
    public static final String SAINT_BARTHELEMY_CODE = "BL";

    /**
     * EN: Code for Saint Martin (französischer Teil).<br>
     */
    public static final String SAINT_MARTIN_FRANZ_SISCHER_TEIL_CODE = "MF";

    /**
     * EN: Code for Salomonen.<br>
     */
    public static final String SALOMONEN_CODE = "SB";

    /**
     * EN: Code for Sambia.<br>
     */
    public static final String SAMBIA_CODE = "ZM";

    /**
     * EN: Code for Samoa-Amerikanisch.<br>
     */
    public static final String SAMOA_AMERIKANISCH_CODE = "AS";

    /**
     * EN: Code for Samoa-West.<br>
     */
    public static final String SAMOA_WEST_CODE = "WS";

    /**
     * EN: Code for San Marino.<br>
     */
    public static final String SAN_MARINO_CODE = "SM";

    /**
     * EN: Code for Saudi-Arabien.<br>
     */
    public static final String SAUDI_ARABIEN_CODE = "SA";

    /**
     * EN: Code for Schweden.<br>
     */
    public static final String SCHWEDEN_CODE = "SE";

    /**
     * EN: Code for Schweiz.<br>
     */
    public static final String SCHWEIZ_CODE = "CH";

    /**
     * EN: Code for Senegal.<br>
     */
    public static final String SENEGAL_CODE = "SN";

    /**
     * EN: Code for Serbien.<br>
     */
    public static final String SERBIEN_CODE = "RS";

    /**
     * EN: Code for Seychellen.<br>
     */
    public static final String SEYCHELLEN_CODE = "SC";

    /**
     * EN: Code for Sierra Leone.<br>
     */
    public static final String SIERRA_LEONE_CODE = "SL";

    /**
     * EN: Code for Simbabwe.<br>
     */
    public static final String SIMBABWE_CODE = "ZW";

    /**
     * EN: Code for Singapur.<br>
     */
    public static final String SINGAPUR_CODE = "SG";

    /**
     * EN: Code for Sint Maarten (hollländischer Teil).<br>
     */
    public static final String SINT_MAARTEN_HOLLL_NDISCHER_TEIL_CODE = "SX";

    /**
     * EN: Code for Slowakei.<br>
     */
    public static final String SLOWAKEI_CODE = "SK";

    /**
     * EN: Code for Slowenien.<br>
     */
    public static final String SLOWENIEN_CODE = "SI";

    /**
     * EN: Code for Somalia.<br>
     */
    public static final String SOMALIA_CODE = "SO";

    /**
     * EN: Code for Spanien.<br>
     */
    public static final String SPANIEN_CODE = "ES";

    /**
     * EN: Code for Spitzbergen &amp; Jan Mayen Inseln.<br>
     */
    public static final String SPITZBERGEN_JAN_MAYEN_INSELN_CODE = "SJ";

    /**
     * EN: Code for Sri Lanka.<br>
     */
    public static final String SRI_LANKA_CODE = "LK";

    /**
     * EN: Code for St. Helena.<br>
     */
    public static final String ST_HELENA_CODE = "SH";

    /**
     * EN: Code for St. Kitts &amp; Nevis.<br>
     */
    public static final String ST_KITTS_NEVIS_CODE = "KN";

    /**
     * EN: Code for St. Lucia.<br>
     */
    public static final String ST_LUCIA_CODE = "LC";

    /**
     * EN: Code for St. Pierre &amp; Miquelon.<br>
     */
    public static final String ST_PIERRE_MIQUELON_CODE = "PM";

    /**
     * EN: Code for St. Vincent &amp; Grenadinen.<br>
     */
    public static final String ST_VINCENT_GRENADINEN_CODE = "VC";

    /**
     * EN: Code for Sudan.<br>
     */
    public static final String SUDAN_CODE = "SD";

    /**
     * EN: Code for Suriname.<br>
     */
    public static final String SURINAME_CODE = "SR";

    /**
     * EN: Code for Swasiland.<br>
     */
    public static final String SWASILAND_CODE = "SZ";

    /**
     * EN: Code for Syrien.<br>
     */
    public static final String SYRIEN_CODE = "SY";

    /**
     * EN: Code for Südafrika.<br>
     */
    public static final String S_DAFRIKA_CODE = "ZA";

    /**
     * EN: Code for Südgeorgien &amp; südl. Sandwich-I.<br>
     */
    public static final String S_DGEORGIEN_S_DL_SANDWICH_I_CODE = "GS";

    /**
     * EN: Code for São Tomé &amp; Príncipe.<br>
     */
    public static final String S_O_TOM_PR_NCIPE_CODE = "ST";

    /**
     * EN: Code for Tadschikistan.<br>
     */
    public static final String TADSCHIKISTAN_CODE = "TJ";

    /**
     * EN: Code for Taiwan.<br>
     */
    public static final String TAIWAN_CODE = "TW";

    /**
     * EN: Code for Tansania, Vereinigte Republik.<br>
     */
    public static final String TANSANIA_VEREINIGTE_REPUBLIK_CODE = "TZ";

    /**
     * EN: Code for Thailand.<br>
     */
    public static final String THAILAND_CODE = "TH";

    /**
     * EN: Code for Timor-Leste.<br>
     */
    public static final String TIMOR_LESTE_CODE = "TL";

    /**
     * EN: Code for Togo.<br>
     */
    public static final String TOGO_CODE = "TG";

    /**
     * EN: Code for Tokelau.<br>
     */
    public static final String TOKELAU_CODE = "TK";

    /**
     * EN: Code for Tonga.<br>
     */
    public static final String TONGA_CODE = "TO";

    /**
     * EN: Code for Trinidad &amp; Tobago.<br>
     */
    public static final String TRINIDAD_TOBAGO_CODE = "TT";

    /**
     * EN: Code for Tschad.<br>
     */
    public static final String TSCHAD_CODE = "TD";

    /**
     * EN: Code for Tschechische Republik.<br>
     */
    public static final String TSCHECHISCHE_REPUBLIK_CODE = "CZ";

    /**
     * EN: Code for Tunesien.<br>
     */
    public static final String TUNESIEN_CODE = "TN";

    /**
     * EN: Code for Turkmenistan.<br>
     */
    public static final String TURKMENISTAN_CODE = "TM";

    /**
     * EN: Code for Turks- &amp; Caicosinseln.<br>
     */
    public static final String TURKS_CAICOSINSELN_CODE = "TC";

    /**
     * EN: Code for Tuvalu.<br>
     */
    public static final String TUVALU_CODE = "TV";

    /**
     * EN: Code for Türkei.<br>
     */
    public static final String T_RKEI_CODE = "TR";

    /**
     * EN: Code for Uganda.<br>
     */
    public static final String UGANDA_CODE = "UG";

    /**
     * EN: Code for Ukraine.<br>
     */
    public static final String UKRAINE_CODE = "UA";

    /**
     * EN: Code for Ungarn.<br>
     */
    public static final String UNGARN_CODE = "HU";

    /**
     * EN: Code for Uruguay.<br>
     */
    public static final String URUGUAY_CODE = "UY";

    /**
     * EN: Code for USA (sonstige kleine Inseln).<br>
     */
    public static final String USA_SONSTIGE_KLEINE_INSELN_CODE = "UM";

    /**
     * EN: Code for Usbekistan.<br>
     */
    public static final String USBEKISTAN_CODE = "UZ";

    /**
     * EN: Code for Vanuatu.<br>
     */
    public static final String VANUATU_CODE = "VU";

    /**
     * EN: Code for Vatikan.<br>
     */
    public static final String VATIKAN_CODE = "VA";

    /**
     * EN: Code for Venezuela.<br>
     */
    public static final String VENEZUELA_CODE = "VE";

    /**
     * EN: Code for Vereinigte Arabische Emirate.<br>
     */
    public static final String VEREINIGTE_ARABISCHE_EMIRATE_CODE = "AE";

    /**
     * EN: Code for Vereinigte Staaten.<br>
     */
    public static final String VEREINIGTE_STAATEN_CODE = "US";

    /**
     * EN: Code for Vietnam.<br>
     */
    public static final String VIETNAM_CODE = "VN";

    /**
     * EN: Code for Wake Insel.<br>
     */
    public static final String WAKE_INSEL_CODE = "WK";

    /**
     * EN: Code for Wallis und Futuna.<br>
     */
    public static final String WALLIS_UND_FUTUNA_CODE = "WF";

    /**
     * EN: Code for Weihnachtsinsel.<br>
     */
    public static final String WEIHNACHTSINSEL_CODE = "CX";

    /**
     * EN: Code for Westsahara Eigenständiger Staat.<br>
     */
    public static final String WESTSAHARA_EIGENST_NDIGER_STAAT_CODE = "EH";

    /**
     * EN: Code for Zentralafrikanische Republik.<br>
     */
    public static final String ZENTRALAFRIKANISCHE_REPUBLIK_CODE = "CF";

    /**
     * EN: Code for Zypern.<br>
     */
    public static final String ZYPERN_CODE = "CY";

    /**
     * EN: Code for Ägypten.<br>
     */
    public static final String _GYPTEN_CODE = "EG";

    /**
     * EN: Code for Äquatorial Guinea.<br>
     */
    public static final String _QUATORIAL_GUINEA_CODE = "GQ";

    /**
     * EN: Code for Österreich.<br>
     */
    public static final String _STERREICH_CODE = "AT";

    /**
     * EN: Code for Äthiopien.<br>
     */
    public static final String _THIOPIEN_CODE = "ET";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.51";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "epims_Reiseland";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.96";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EpimsReiseland getEnum(@Nullable final String code) {
        for (final EpimsReiseland x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EpimsReiseland.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EpimsReiseland x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EpimsReiseland(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
