/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of eImpf_Antikoerperbestimmung_VS values
 * <p>
 * EN: Determination of immunity by laboratory medicine ("Impftiter"), structured according to vaccinations.The code of the groups serves the assignment to the vaccinations.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.13<br>
 * Effective date: 2021-11-29 00:00<br>
 * Version: 202111(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-18")
public enum EImpfAntikoerperbestimmungVs implements ValueSetEnumInterface {

    /**
     * EN: aP AK qn.<br>
     */
    AP_AK_QN_L1("11585-7",
                "2.16.840.1.113883.6.1",
                "aP AK qn.",
                "aP AK qn.",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Cholera AK qn.<br>
     */
    CHOLERA_AK_QN_L1("31698-4",
                     "2.16.840.1.113883.6.1",
                     "Cholera AK qn.",
                     "Cholera AK qn.",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Cholera Impfstoff.<br>
     */
    CHOLERA_IMPFSTOFF("836383009",
                      "2.16.840.1.113883.6.96",
                      "Cholera Impfstoff",
                      "Cholera Impfstoff",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Covid-19 Impfstoff.<br>
     */
    COVID_19_IMPFSTOFF("840534001",
                       "2.16.840.1.113883.6.96",
                       "Covid-19 Impfstoff",
                       "Covid-19 Impfstoff",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Diphtherie Impfstoff: Serologie.<br>
     */
    DIPHTHERIE_IMPFSTOFF_SEROLOGIE("836381006",
                                   "2.16.840.1.113883.6.96",
                                   "Diphtherie Impfstoff: Serologie",
                                   "Diphtherie Impfstoff: Serologie",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Di AK qn.<br>
     */
    DI_AK_QN_L1("5115-1",
                "2.16.840.1.113883.6.1",
                "Di AK qn.",
                "Di AK qn.",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Frühsommer-Meningoencephalitis Impfstoff.<br>
     */
    FR_HSOMMER_MENINGOENCEPHALITIS_IMPFSTOFF("836403007",
                                             "2.16.840.1.113883.6.96",
                                             "Frühsommer-Meningoencephalitis Impfstoff",
                                             "Frühsommer-Meningoencephalitis Impfstoff",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: FSME AK qn.<br>
     */
    FSME_AK_QN_L1("31383-3",
                  "2.16.840.1.113883.6.1",
                  "FSME AK qn.",
                  "FSME AK qn.",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gelbfieber Impfstoff.<br>
     */
    GELBFIEBER_IMPFSTOFF("836385002",
                         "2.16.840.1.113883.6.96",
                         "Gelbfieber Impfstoff",
                         "Gelbfieber Impfstoff",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae Typ B Impfstoff.<br>
     */
    HAEMOPHILUS_INFLUENZAE_TYP_B_IMPFSTOFF("836380007",
                                           "2.16.840.1.113883.6.96",
                                           "Haemophilus influenzae Typ B Impfstoff",
                                           "Haemophilus influenzae Typ B Impfstoff",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: HAV AK qn.<br>
     */
    HAV_AK_QN_L1("22312-3",
                 "2.16.840.1.113883.6.1",
                 "HAV AK qn.",
                 "HAV AK qn.",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: HBV s-AK qn.<br>
     */
    HBV_S_AK_QN_L1("16935-9",
                   "2.16.840.1.113883.6.1",
                   "HBV s-AK qn.",
                   "HBV s-AK qn.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Hepatitis A Impfstoff: Serologie.<br>
     */
    HEPATITIS_A_IMPFSTOFF_SEROLOGIE("836375003",
                                    "2.16.840.1.113883.6.96",
                                    "Hepatitis A Impfstoff: Serologie",
                                    "Hepatitis A Impfstoff: Serologie",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Impfstoff: Serologie.<br>
     */
    HEPATITIS_B_IMPFSTOFF_SEROLOGIE("836374004",
                                    "2.16.840.1.113883.6.96",
                                    "Hepatitis B Impfstoff: Serologie",
                                    "Hepatitis B Impfstoff: Serologie",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Herpes Zoster Impfstoff.<br>
     */
    HERPES_ZOSTER_IMPFSTOFF("871919004",
                            "2.16.840.1.113883.6.96",
                            "Herpes Zoster Impfstoff",
                            "Herpes Zoster Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: HiB AK qn.<br>
     */
    HIB_AK_QN_L1("7931-9",
                 "2.16.840.1.113883.6.1",
                 "HiB AK qn.",
                 "HiB AK qn.",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Humane Papillomaviren Impfstoff.<br>
     */
    HUMANE_PAPILLOMAVIREN_IMPFSTOFF("836379009",
                                    "2.16.840.1.113883.6.96",
                                    "Humane Papillomaviren Impfstoff",
                                    "Humane Papillomaviren Impfstoff",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Influenza A AK qn.<br>
     */
    INFLUENZA_A_AK_QN_L1("7920-2",
                         "2.16.840.1.113883.6.1",
                         "Influenza A AK qn.",
                         "Influenza A AK qn.",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Influenza (H1N1) Impfstoff.<br>
     */
    INFLUENZA_H1N1_IMPFSTOFF("871772009",
                             "2.16.840.1.113883.6.96",
                             "Influenza (H1N1) Impfstoff",
                             "Influenza (H1N1) Impfstoff",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Influenza (H5N1) Impfstoff.<br>
     */
    INFLUENZA_H5N1_IMPFSTOFF("427036009",
                             "2.16.840.1.113883.6.96",
                             "Influenza (H5N1) Impfstoff",
                             "Influenza (H5N1) Impfstoff",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Influenza H5 AK Ti.<br>
     */
    INFLUENZA_H5_AK_TI_L1("47454-4",
                          "2.16.840.1.113883.6.1",
                          "Influenza H5 AK Ti.",
                          "Influenza H5 AK Ti.",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Influenza Impfstoff.<br>
     */
    INFLUENZA_IMPFSTOFF("836377006",
                        "2.16.840.1.113883.6.96",
                        "Influenza Impfstoff",
                        "Influenza Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Japanische Encephalitis Impfstoff.<br>
     */
    JAPANISCHE_ENCEPHALITIS_IMPFSTOFF("836378001",
                                      "2.16.840.1.113883.6.96",
                                      "Japanische Encephalitis Impfstoff",
                                      "Japanische Encephalitis Impfstoff",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Masern AK qn.<br>
     */
    MASERN_AK_QN_L1("7961-6",
                    "2.16.840.1.113883.6.1",
                    "Masern AK qn.",
                    "Masern AK qn.",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Masern Impfstoff: Serologie.<br>
     */
    MASERN_IMPFSTOFF_SEROLOGIE("836382004",
                               "2.16.840.1.113883.6.96",
                               "Masern Impfstoff: Serologie",
                               "Masern Impfstoff: Serologie",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Meningokokken Impfstoff.<br>
     */
    MENINGOKOKKEN_IMPFSTOFF("836401009",
                            "2.16.840.1.113883.6.96",
                            "Meningokokken Impfstoff",
                            "Meningokokken Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp B Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_B_IMPFSTOFF("1981000221108",
                                      "2.16.840.1.113883.6.96",
                                      "Meningokokken Serotyp B Impfstoff",
                                      "Meningokokken Serotyp B Impfstoff",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp C Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_C_IMPFSTOFF("871866001",
                                      "2.16.840.1.113883.6.96",
                                      "Meningokokken Serotyp C Impfstoff",
                                      "Meningokokken Serotyp C Impfstoff",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Mumps AK qn.<br>
     */
    MUMPS_AK_QN_L1("7965-7",
                   "2.16.840.1.113883.6.1",
                   "Mumps AK qn.",
                   "Mumps AK qn.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Mumps Impfstoff.<br>
     */
    MUMPS_IMPFSTOFF("871738001",
                    "2.16.840.1.113883.6.96",
                    "Mumps Impfstoff",
                    "Mumps Impfstoff",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Pertussis Impfstoff.<br>
     */
    PERTUSSIS_IMPFSTOFF("601000221108",
                        "2.16.840.1.113883.6.96",
                        "Pertussis Impfstoff",
                        "Pertussis Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Impfstoff.<br>
     */
    PNEUMOKOKKEN_IMPFSTOFF("836398006",
                           "2.16.840.1.113883.6.96",
                           "Pneumokokken Impfstoff",
                           "Pneumokokken Impfstoff",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Pocken Impfstoff.<br>
     */
    POCKEN_IMPFSTOFF("836389008",
                     "2.16.840.1.113883.6.96",
                     "Pocken Impfstoff",
                     "Pocken Impfstoff",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Poliomyelitis Impfstoff: Serologie.<br>
     */
    POLIOMYELITIS_IMPFSTOFF_SEROLOGIE("1031000221108",
                                      "2.16.840.1.113883.6.96",
                                      "Poliomyelitis Impfstoff: Serologie",
                                      "Poliomyelitis Impfstoff: Serologie",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Polio AK qn.<br>
     */
    POLIO_AK_QN_L1("16284-2",
                   "2.16.840.1.113883.6.1",
                   "Polio AK qn.",
                   "Polio AK qn.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Polio virus 1 Ab.<br>
     */
    POLIO_VIRUS_1_AB_L1("5281-1",
                        "2.16.840.1.113883.6.1",
                        "Polio virus 1 Ab",
                        "Polio virus 1 Ab",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Polio virus 2 Ab.<br>
     */
    POLIO_VIRUS_2_AB_L1("5283-7",
                        "2.16.840.1.113883.6.1",
                        "Polio virus 2 Ab",
                        "Polio virus 2 Ab",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Polio virus 3 Ab.<br>
     */
    POLIO_VIRUS_3_AB_L1("5285-2",
                        "2.16.840.1.113883.6.1",
                        "Polio virus 3 Ab",
                        "Polio virus 3 Ab",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Rabies virus Ab.<br>
     */
    RABIES_VIRUS_AB_L1("6524-3",
                       "2.16.840.1.113883.6.1",
                       "Rabies virus Ab",
                       "Rabies virus Ab",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Rotavirus Impfstoff.<br>
     */
    ROTAVIRUS_IMPFSTOFF("836387005",
                        "2.16.840.1.113883.6.96",
                        "Rotavirus Impfstoff",
                        "Rotavirus Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Rota AK qn.<br>
     */
    ROTA_AK_QN_L1("5328-0",
                  "2.16.840.1.113883.6.1",
                  "Rota AK qn.",
                  "Rota AK qn.",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Röteln Ab Tutr Ser HAI.<br>
     */
    R_TELN_AB_TUTR_SER_HAI_L1("50694-9",
                              "2.16.840.1.113883.6.1",
                              "Röteln Ab Tutr Ser HAI",
                              "Röteln Ab Tutr Ser HAI",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Röteln AK qn.<br>
     */
    R_TELN_AK_QN_L1("8013-5",
                    "2.16.840.1.113883.6.1",
                    "Röteln AK qn.",
                    "Röteln AK qn.",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Röteln IgG AK Ti.<br>
     */
    R_TELN_IGG_AK_TI_L1("41763-4",
                        "2.16.840.1.113883.6.1",
                        "Röteln IgG AK Ti.",
                        "Röteln IgG AK Ti.",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Röteln Impfstoff: Serologie.<br>
     */
    R_TELN_IMPFSTOFF_SEROLOGIE("836388000",
                               "2.16.840.1.113883.6.96",
                               "Röteln Impfstoff: Serologie",
                               "Röteln Impfstoff: Serologie",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2-AK IgG.<br>
     */
    SARS_COV_2_AK_IGG_L1("94505-5",
                         "2.16.840.1.113883.6.1",
                         "SARS-CoV-2-AK IgG",
                         "SARS-CoV-2-AK IgG",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2-AK IgG ql.<br>
     */
    SARS_COV_2_AK_IGG_QL_L1("94563-4",
                            "2.16.840.1.113883.6.1",
                            "SARS-CoV-2-AK IgG ql.",
                            "SARS-CoV-2-AK IgG ql.",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2-AK IgG ST.<br>
     */
    SARS_COV_2_AK_IGG_ST_L1("94507-1",
                            "2.16.840.1.113883.6.1",
                            "SARS-CoV-2-AK IgG ST",
                            "SARS-CoV-2-AK IgG ST",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2-AK ql.<br>
     */
    SARS_COV_2_AK_QL_L1("94547-7",
                        "2.16.840.1.113883.6.1",
                        "SARS-CoV-2-AK ql.",
                        "SARS-CoV-2-AK ql.",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Tetanustoxin AK qn.<br>
     */
    TETANUSTOXIN_AK_QN_L1("32775-9",
                          "2.16.840.1.113883.6.1",
                          "Tetanustoxin AK qn.",
                          "Tetanustoxin AK qn.",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Tetanus Impfstoff: Serologie.<br>
     */
    TETANUS_IMPFSTOFF_SEROLOGIE("1101000221104",
                                "2.16.840.1.113883.6.96",
                                "Tetanus Impfstoff: Serologie",
                                "Tetanus Impfstoff: Serologie",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Tollwut AK qn.<br>
     */
    TOLLWUT_AK_QN_L1("5288-6",
                     "2.16.840.1.113883.6.1",
                     "Tollwut AK qn.",
                     "Tollwut AK qn.",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Tollwut Impfstoff: Serologie.<br>
     */
    TOLLWUT_IMPFSTOFF_SEROLOGIE("836393002",
                                "2.16.840.1.113883.6.96",
                                "Tollwut Impfstoff: Serologie",
                                "Tollwut Impfstoff: Serologie",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Tuberkulose Impfstoff.<br>
     */
    TUBERKULOSE_IMPFSTOFF("836402002",
                          "2.16.840.1.113883.6.96",
                          "Tuberkulose Impfstoff",
                          "Tuberkulose Impfstoff",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Typhus Impfstoff.<br>
     */
    TYPHUS_IMPFSTOFF("836390004",
                     "2.16.840.1.113883.6.96",
                     "Typhus Impfstoff",
                     "Typhus Impfstoff",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Varizellen AK qn.<br>
     */
    VARIZELLEN_AK_QN_L1("8046-5",
                        "2.16.840.1.113883.6.1",
                        "Varizellen AK qn.",
                        "Varizellen AK qn.",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Varizellen Impfstoff: Serologie.<br>
     */
    VARIZELLEN_IMPFSTOFF_SEROLOGIE("836495005",
                                   "2.16.840.1.113883.6.96",
                                   "Varizellen Impfstoff: Serologie",
                                   "Varizellen Impfstoff: Serologie",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE");

    /**
     * EN: Code for aP AK qn.<br>
     */
    public static final String AP_AK_QN_L1_CODE = "11585-7";

    /**
     * EN: Code for Cholera AK qn.<br>
     */
    public static final String CHOLERA_AK_QN_L1_CODE = "31698-4";

    /**
     * EN: Code for Cholera Impfstoff.<br>
     */
    public static final String CHOLERA_IMPFSTOFF_CODE = "836383009";

    /**
     * EN: Code for Covid-19 Impfstoff.<br>
     */
    public static final String COVID_19_IMPFSTOFF_CODE = "840534001";

    /**
     * EN: Code for Diphtherie Impfstoff: Serologie.<br>
     */
    public static final String DIPHTHERIE_IMPFSTOFF_SEROLOGIE_CODE = "836381006";

    /**
     * EN: Code for Di AK qn.<br>
     */
    public static final String DI_AK_QN_L1_CODE = "5115-1";

    /**
     * EN: Code for Frühsommer-Meningoencephalitis Impfstoff.<br>
     */
    public static final String FR_HSOMMER_MENINGOENCEPHALITIS_IMPFSTOFF_CODE = "836403007";

    /**
     * EN: Code for FSME AK qn.<br>
     */
    public static final String FSME_AK_QN_L1_CODE = "31383-3";

    /**
     * EN: Code for Gelbfieber Impfstoff.<br>
     */
    public static final String GELBFIEBER_IMPFSTOFF_CODE = "836385002";

    /**
     * EN: Code for Haemophilus influenzae Typ B Impfstoff.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_TYP_B_IMPFSTOFF_CODE = "836380007";

    /**
     * EN: Code for HAV AK qn.<br>
     */
    public static final String HAV_AK_QN_L1_CODE = "22312-3";

    /**
     * EN: Code for HBV s-AK qn.<br>
     */
    public static final String HBV_S_AK_QN_L1_CODE = "16935-9";

    /**
     * EN: Code for Hepatitis A Impfstoff: Serologie.<br>
     */
    public static final String HEPATITIS_A_IMPFSTOFF_SEROLOGIE_CODE = "836375003";

    /**
     * EN: Code for Hepatitis B Impfstoff: Serologie.<br>
     */
    public static final String HEPATITIS_B_IMPFSTOFF_SEROLOGIE_CODE = "836374004";

    /**
     * EN: Code for Herpes Zoster Impfstoff.<br>
     */
    public static final String HERPES_ZOSTER_IMPFSTOFF_CODE = "871919004";

    /**
     * EN: Code for HiB AK qn.<br>
     */
    public static final String HIB_AK_QN_L1_CODE = "7931-9";

    /**
     * EN: Code for Humane Papillomaviren Impfstoff.<br>
     */
    public static final String HUMANE_PAPILLOMAVIREN_IMPFSTOFF_CODE = "836379009";

    /**
     * EN: Code for Influenza A AK qn.<br>
     */
    public static final String INFLUENZA_A_AK_QN_L1_CODE = "7920-2";

    /**
     * EN: Code for Influenza (H1N1) Impfstoff.<br>
     */
    public static final String INFLUENZA_H1N1_IMPFSTOFF_CODE = "871772009";

    /**
     * EN: Code for Influenza (H5N1) Impfstoff.<br>
     */
    public static final String INFLUENZA_H5N1_IMPFSTOFF_CODE = "427036009";

    /**
     * EN: Code for Influenza H5 AK Ti.<br>
     */
    public static final String INFLUENZA_H5_AK_TI_L1_CODE = "47454-4";

    /**
     * EN: Code for Influenza Impfstoff.<br>
     */
    public static final String INFLUENZA_IMPFSTOFF_CODE = "836377006";

    /**
     * EN: Code for Japanische Encephalitis Impfstoff.<br>
     */
    public static final String JAPANISCHE_ENCEPHALITIS_IMPFSTOFF_CODE = "836378001";

    /**
     * EN: Code for Masern AK qn.<br>
     */
    public static final String MASERN_AK_QN_L1_CODE = "7961-6";

    /**
     * EN: Code for Masern Impfstoff: Serologie.<br>
     */
    public static final String MASERN_IMPFSTOFF_SEROLOGIE_CODE = "836382004";

    /**
     * EN: Code for Meningokokken Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_IMPFSTOFF_CODE = "836401009";

    /**
     * EN: Code for Meningokokken Serotyp B Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_B_IMPFSTOFF_CODE = "1981000221108";

    /**
     * EN: Code for Meningokokken Serotyp C Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_C_IMPFSTOFF_CODE = "871866001";

    /**
     * EN: Code for Mumps AK qn.<br>
     */
    public static final String MUMPS_AK_QN_L1_CODE = "7965-7";

    /**
     * EN: Code for Mumps Impfstoff.<br>
     */
    public static final String MUMPS_IMPFSTOFF_CODE = "871738001";

    /**
     * EN: Code for Pertussis Impfstoff.<br>
     */
    public static final String PERTUSSIS_IMPFSTOFF_CODE = "601000221108";

    /**
     * EN: Code for Pneumokokken Impfstoff.<br>
     */
    public static final String PNEUMOKOKKEN_IMPFSTOFF_CODE = "836398006";

    /**
     * EN: Code for Pocken Impfstoff.<br>
     */
    public static final String POCKEN_IMPFSTOFF_CODE = "836389008";

    /**
     * EN: Code for Poliomyelitis Impfstoff: Serologie.<br>
     */
    public static final String POLIOMYELITIS_IMPFSTOFF_SEROLOGIE_CODE = "1031000221108";

    /**
     * EN: Code for Polio AK qn.<br>
     */
    public static final String POLIO_AK_QN_L1_CODE = "16284-2";

    /**
     * EN: Code for Polio virus 1 Ab.<br>
     */
    public static final String POLIO_VIRUS_1_AB_L1_CODE = "5281-1";

    /**
     * EN: Code for Polio virus 2 Ab.<br>
     */
    public static final String POLIO_VIRUS_2_AB_L1_CODE = "5283-7";

    /**
     * EN: Code for Polio virus 3 Ab.<br>
     */
    public static final String POLIO_VIRUS_3_AB_L1_CODE = "5285-2";

    /**
     * EN: Code for Rabies virus Ab.<br>
     */
    public static final String RABIES_VIRUS_AB_L1_CODE = "6524-3";

    /**
     * EN: Code for Rotavirus Impfstoff.<br>
     */
    public static final String ROTAVIRUS_IMPFSTOFF_CODE = "836387005";

    /**
     * EN: Code for Rota AK qn.<br>
     */
    public static final String ROTA_AK_QN_L1_CODE = "5328-0";

    /**
     * EN: Code for Röteln Ab Tutr Ser HAI.<br>
     */
    public static final String R_TELN_AB_TUTR_SER_HAI_L1_CODE = "50694-9";

    /**
     * EN: Code for Röteln AK qn.<br>
     */
    public static final String R_TELN_AK_QN_L1_CODE = "8013-5";

    /**
     * EN: Code for Röteln IgG AK Ti.<br>
     */
    public static final String R_TELN_IGG_AK_TI_L1_CODE = "41763-4";

    /**
     * EN: Code for Röteln Impfstoff: Serologie.<br>
     */
    public static final String R_TELN_IMPFSTOFF_SEROLOGIE_CODE = "836388000";

    /**
     * EN: Code for SARS-CoV-2-AK IgG.<br>
     */
    public static final String SARS_COV_2_AK_IGG_L1_CODE = "94505-5";

    /**
     * EN: Code for SARS-CoV-2-AK IgG ql.<br>
     */
    public static final String SARS_COV_2_AK_IGG_QL_L1_CODE = "94563-4";

    /**
     * EN: Code for SARS-CoV-2-AK IgG ST.<br>
     */
    public static final String SARS_COV_2_AK_IGG_ST_L1_CODE = "94507-1";

    /**
     * EN: Code for SARS-CoV-2-AK ql.<br>
     */
    public static final String SARS_COV_2_AK_QL_L1_CODE = "94547-7";

    /**
     * EN: Code for Tetanustoxin AK qn.<br>
     */
    public static final String TETANUSTOXIN_AK_QN_L1_CODE = "32775-9";

    /**
     * EN: Code for Tetanus Impfstoff: Serologie.<br>
     */
    public static final String TETANUS_IMPFSTOFF_SEROLOGIE_CODE = "1101000221104";

    /**
     * EN: Code for Tollwut AK qn.<br>
     */
    public static final String TOLLWUT_AK_QN_L1_CODE = "5288-6";

    /**
     * EN: Code for Tollwut Impfstoff: Serologie.<br>
     */
    public static final String TOLLWUT_IMPFSTOFF_SEROLOGIE_CODE = "836393002";

    /**
     * EN: Code for Tuberkulose Impfstoff.<br>
     */
    public static final String TUBERKULOSE_IMPFSTOFF_CODE = "836402002";

    /**
     * EN: Code for Typhus Impfstoff.<br>
     */
    public static final String TYPHUS_IMPFSTOFF_CODE = "836390004";

    /**
     * EN: Code for Varizellen AK qn.<br>
     */
    public static final String VARIZELLEN_AK_QN_L1_CODE = "8046-5";

    /**
     * EN: Code for Varizellen Impfstoff: Serologie.<br>
     */
    public static final String VARIZELLEN_IMPFSTOFF_SEROLOGIE_CODE = "836495005";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.13";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "eImpf_Antikoerperbestimmung_VS";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EImpfAntikoerperbestimmungVs getEnum(@Nullable final String code) {
        for (final EImpfAntikoerperbestimmungVs x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EImpfAntikoerperbestimmungVs.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EImpfAntikoerperbestimmungVs x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EImpfAntikoerperbestimmungVs(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
