/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of eImpf_Impfschema_VS values
 * <p>
 * EN: Rules on vaccine doses for obtaining or refreshing (boosting) basic immunisation.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.5<br>
 * Effective date: 2022-02-16 00:00<br>
 * Version: 202202.1(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-03-01")
public enum EImpfImpfschemaVs implements ValueSetEnumInterface {

    /**
     * EN: Cholera Grundschema, Erstimpfung 2-6 Jahre.<br>
     */
    CHOLERA_GRUNDSCHEMA_ERSTIMPFUNG_2_6_JAHRE("SCHEMA076",
                                              "1.2.40.0.34.5.183",
                                              "Cholera Grundschema, Erstimpfung 2-6 Jahre",
                                              "Cholera Grundschema, Erstimpfung 2-6 Jahre",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Cholera Grundschema, Erstimpfung ab 6 Jahren.<br>
     */
    CHOLERA_GRUNDSCHEMA_ERSTIMPFUNG_AB_6_JAHREN("SCHEMA078",
                                                "1.2.40.0.34.5.183",
                                                "Cholera Grundschema, Erstimpfung ab 6 Jahren",
                                                "Cholera Grundschema, Erstimpfung ab 6 Jahren",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: FSME Grundschema, Encepur.<br>
     */
    FSME_GRUNDSCHEMA_ENCEPUR("SCHEMA006",
                             "1.2.40.0.34.5.183",
                             "FSME Grundschema, Encepur",
                             "FSME Grundschema, Encepur",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: FSME Grundschema, FSME-Immun.<br>
     */
    FSME_GRUNDSCHEMA_FSME_IMMUN("SCHEMA005",
                                "1.2.40.0.34.5.183",
                                "FSME Grundschema, FSME-Immun",
                                "FSME Grundschema, FSME-Immun",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: FSME Indikationsschema, Encepur.<br>
     */
    FSME_INDIKATIONSSCHEMA_ENCEPUR("SCHEMA008",
                                   "1.2.40.0.34.5.183",
                                   "FSME Indikationsschema, Encepur",
                                   "FSME Indikationsschema, Encepur",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: FSME Indikationsschema, FSME-Immun.<br>
     */
    FSME_INDIKATIONSSCHEMA_FSME_IMMUN("SCHEMA007",
                                      "1.2.40.0.34.5.183",
                                      "FSME Indikationsschema, FSME-Immun",
                                      "FSME Indikationsschema, FSME-Immun",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: FSME Schnellschema, Encepur.<br>
     */
    FSME_SCHNELLSCHEMA_ENCEPUR("SCHEMA010",
                               "1.2.40.0.34.5.183",
                               "FSME Schnellschema, Encepur",
                               "FSME Schnellschema, Encepur",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: FSME Schnellschema, FSME-Immun.<br>
     */
    FSME_SCHNELLSCHEMA_FSME_IMMUN("SCHEMA009",
                                  "1.2.40.0.34.5.183",
                                  "FSME Schnellschema, FSME-Immun",
                                  "FSME Schnellschema, FSME-Immun",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Gelbfieber Grundschema, ab 1 Jahr.<br>
     */
    GELBFIEBER_GRUNDSCHEMA_AB_1_JAHR("SCHEMA065",
                                     "1.2.40.0.34.5.183",
                                     "Gelbfieber Grundschema, ab 1 Jahr",
                                     "Gelbfieber Grundschema, ab 1 Jahr",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae Typ B Indikationsschema.<br>
     */
    HAEMOPHILUS_INFLUENZAE_TYP_B_INDIKATIONSSCHEMA("SCHEMA011",
                                                   "1.2.40.0.34.5.183",
                                                   "Haemophilus influenzae Typ B Indikationsschema",
                                                   "Haemophilus influenzae Typ B Indikationsschema",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Hepatitis AB Grundschema.<br>
     */
    HEPATITIS_AB_GRUNDSCHEMA("SCHEMA013",
                             "1.2.40.0.34.5.183",
                             "Hepatitis AB Grundschema",
                             "Hepatitis AB Grundschema",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Hepatitis AB Schnellschema.<br>
     */
    HEPATITIS_AB_SCHNELLSCHEMA("SCHEMA015",
                               "1.2.40.0.34.5.183",
                               "Hepatitis AB Schnellschema",
                               "Hepatitis AB Schnellschema",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Hepatitis A Monokomponente Grundschema.<br>
     */
    HEPATITIS_A_MONOKOMPONENTE_GRUNDSCHEMA("SCHEMA014",
                                           "1.2.40.0.34.5.183",
                                           "Hepatitis A Monokomponente Grundschema",
                                           "Hepatitis A Monokomponente Grundschema",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Hepatitis A Monokomponente Indikationsschema.<br>
     */
    HEPATITIS_A_MONOKOMPONENTE_INDIKATIONSSCHEMA("SCHEMA012",
                                                 "1.2.40.0.34.5.183",
                                                 "Hepatitis A Monokomponente Indikationsschema",
                                                 "Hepatitis A Monokomponente Indikationsschema",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Hepatitis A &amp; Typhus Grundschema.<br>
     */
    HEPATITIS_A_TYPHUS_GRUNDSCHEMA("SCHEMA016",
                                   "1.2.40.0.34.5.183",
                                   "Hepatitis A & Typhus Grundschema",
                                   "Hepatitis A & Typhus Grundschema",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Hepatitis B erhoehte Antigenmenge Grundschema.<br>
     */
    HEPATITIS_B_ERHOEHTE_ANTIGENMENGE_GRUNDSCHEMA("SCHEMA019",
                                                  "1.2.40.0.34.5.183",
                                                  "Hepatitis B erhoehte Antigenmenge Grundschema",
                                                  "Hepatitis B erhoehte Antigenmenge Grundschema",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Monokomponente Grundschema.<br>
     */
    HEPATITIS_B_MONOKOMPONENTE_GRUNDSCHEMA("SCHEMA017",
                                           "1.2.40.0.34.5.183",
                                           "Hepatitis B Monokomponente Grundschema",
                                           "Hepatitis B Monokomponente Grundschema",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Monokomponente Indikationsschema.<br>
     */
    HEPATITIS_B_MONOKOMPONENTE_INDIKATIONSSCHEMA("SCHEMA085",
                                                 "1.2.40.0.34.5.183",
                                                 "Hepatitis B Monokomponente Indikationsschema",
                                                 "Hepatitis B Monokomponente Indikationsschema",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Monokomponente Schnellschema durch Indikation.<br>
     */
    HEPATITIS_B_MONOKOMPONENTE_SCHNELLSCHEMA_DURCH_INDIKATION("SCHEMA102",
                                                              "1.2.40.0.34.5.183",
                                                              "Hepatitis B Monokomponente Schnellschema durch Indikation",
                                                              "Hepatitis B Monokomponente Schnellschema durch Indikation",
                                                              "TOTRANSLATE",
                                                              "TOTRANSLATE",
                                                              "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Prophylaxe Neugeborener Indikationsschema.<br>
     */
    HEPATITIS_B_PROPHYLAXE_NEUGEBORENER_INDIKATIONSSCHEMA("SCHEMA103",
                                                          "1.2.40.0.34.5.183",
                                                          "Hepatitis B Prophylaxe Neugeborener Indikationsschema",
                                                          "Hepatitis B Prophylaxe Neugeborener Indikationsschema",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Herpes Zoster Grundschema, ab 50 Jahren.<br>
     */
    HERPES_ZOSTER_GRUNDSCHEMA_AB_50_JAHREN("SCHEMA064",
                                           "1.2.40.0.34.5.183",
                                           "Herpes Zoster Grundschema, ab 50 Jahren",
                                           "Herpes Zoster Grundschema, ab 50 Jahren",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Herpes Zoster Grundschema, nach Zostavax.<br>
     */
    HERPES_ZOSTER_GRUNDSCHEMA_NACH_ZOSTAVAX("SCHEMA091",
                                            "1.2.40.0.34.5.183",
                                            "Herpes Zoster Grundschema, nach Zostavax",
                                            "Herpes Zoster Grundschema, nach Zostavax",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Herpes Zoster Indikationsschema, ab 18 Jahren.<br>
     */
    HERPES_ZOSTER_INDIKATIONSSCHEMA_AB_18_JAHREN("SCHEMA092",
                                                 "1.2.40.0.34.5.183",
                                                 "Herpes Zoster Indikationsschema, ab 18 Jahren",
                                                 "Herpes Zoster Indikationsschema, ab 18 Jahren",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: HPV Grundschema, ab 15 Jahren.<br>
     */
    HPV_GRUNDSCHEMA_AB_15_JAHREN("SCHEMA021",
                                 "1.2.40.0.34.5.183",
                                 "HPV Grundschema, ab 15 Jahren",
                                 "HPV Grundschema, ab 15 Jahren",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: HPV Grundschema, bis 15 Jahre.<br>
     */
    HPV_GRUNDSCHEMA_BIS_15_JAHRE("SCHEMA020",
                                 "1.2.40.0.34.5.183",
                                 "HPV Grundschema, bis 15 Jahre",
                                 "HPV Grundschema, bis 15 Jahre",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: HPV Indikationsschema, bis 15 Jahre.<br>
     */
    HPV_INDIKATIONSSCHEMA_BIS_15_JAHRE("SCHEMA022",
                                       "1.2.40.0.34.5.183",
                                       "HPV Indikationsschema, bis 15 Jahre",
                                       "HPV Indikationsschema, bis 15 Jahre",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Influenza Grundschema, Einmalimpfung.<br>
     */
    INFLUENZA_GRUNDSCHEMA_EINMALIMPFUNG("SCHEMA024",
                                        "1.2.40.0.34.5.183",
                                        "Influenza Grundschema, Einmalimpfung",
                                        "Influenza Grundschema, Einmalimpfung",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Influenza Grundschema, Kinder.<br>
     */
    INFLUENZA_GRUNDSCHEMA_KINDER("SCHEMA023",
                                 "1.2.40.0.34.5.183",
                                 "Influenza Grundschema, Kinder",
                                 "Influenza Grundschema, Kinder",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Japanische Enzephalitis Grundschema, ab 2 Monaten.<br>
     */
    JAPANISCHE_ENZEPHALITIS_GRUNDSCHEMA_AB_2_MONATEN("SCHEMA066",
                                                     "1.2.40.0.34.5.183",
                                                     "Japanische Enzephalitis Grundschema, ab 2 Monaten",
                                                     "Japanische Enzephalitis Grundschema, ab 2 Monaten",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Japanische Enzephalitis Schnellschema, ab 18 Jahren.<br>
     */
    JAPANISCHE_ENZEPHALITIS_SCHNELLSCHEMA_AB_18_JAHREN("SCHEMA067",
                                                       "1.2.40.0.34.5.183",
                                                       "Japanische Enzephalitis Schnellschema, ab 18 Jahren",
                                                       "Japanische Enzephalitis Schnellschema, ab 18 Jahren",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE("SCHEMA082",
                             "1.2.40.0.34.5.183",
                             "Kombinationsschema Di-Te",
                             "Kombinationsschema Di-Te",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT("SCHEMA081",
                                  "1.2.40.0.34.5.183",
                                  "Kombinationsschema Di-Te-Pert",
                                  "Kombinationsschema Di-Te-Pert",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung ab 1 Jahr.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_ERSTIMPFUNG_AB_1_JAHR("SCHEMA002",
                                                                     "1.2.40.0.34.5.183",
                                                                     "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung ab 1 Jahr",
                                                                     "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung ab 1 Jahr",
                                                                     "TOTRANSLATE",
                                                                     "TOTRANSLATE",
                                                                     "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung bis 1 Jahr.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_ERSTIMPFUNG_BIS_1_JAHR("SCHEMA001",
                                                                      "1.2.40.0.34.5.183",
                                                                      "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung bis 1 Jahr",
                                                                      "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung bis 1 Jahr",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Indikation.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_INDIKATION("SCHEMA004",
                                                          "1.2.40.0.34.5.183",
                                                          "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Indikation",
                                                          "Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Indikation",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert-IPV.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT_IPV("SCHEMA080",
                                      "1.2.40.0.34.5.183",
                                      "Kombinationsschema Di-Te-Pert-IPV",
                                      "Kombinationsschema Di-Te-Pert-IPV",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema Di-Te-Pert-IPV-HepB, Erstimpfung ab 6 Jahren.<br>
     */
    KOMBINATIONSSCHEMA_DI_TE_PERT_IPV_HEPB_ERSTIMPFUNG_AB_6_JAHREN("SCHEMA003",
                                                                   "1.2.40.0.34.5.183",
                                                                   "Kombinationsschema Di-Te-Pert-IPV-HepB, Erstimpfung ab 6 Jahren",
                                                                   "Kombinationsschema Di-Te-Pert-IPV-HepB, Erstimpfung ab 6 Jahren",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema MMRV, ab 12 Monaten.<br>
     */
    KOMBINATIONSSCHEMA_MMRV_AB_12_MONATEN("SCHEMA101",
                                          "1.2.40.0.34.5.183",
                                          "Kombinationsschema MMRV, ab 12 Monaten",
                                          "Kombinationsschema MMRV, ab 12 Monaten",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema MMRV, ab 12 Monaten, MMR - MMRV - V.<br>
     */
    KOMBINATIONSSCHEMA_MMRV_AB_12_MONATEN_MMR_MMRV_V("SCHEMA062",
                                                     "1.2.40.0.34.5.183",
                                                     "Kombinationsschema MMRV, ab 12 Monaten, MMR - MMRV - V",
                                                     "Kombinationsschema MMRV, ab 12 Monaten, MMR - MMRV - V",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema MMRV, ab 9 Monaten.<br>
     */
    KOMBINATIONSSCHEMA_MMRV_AB_9_MONATEN("SCHEMA100",
                                         "1.2.40.0.34.5.183",
                                         "Kombinationsschema MMRV, ab 9 Monaten",
                                         "Kombinationsschema MMRV, ab 9 Monaten",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Kombinationsschema MMRV, ab 9 Monaten, MMR - MMRV - V.<br>
     */
    KOMBINATIONSSCHEMA_MMRV_AB_9_MONATEN_MMR_MMRV_V("SCHEMA061",
                                                    "1.2.40.0.34.5.183",
                                                    "Kombinationsschema MMRV, ab 9 Monaten, MMR - MMRV - V",
                                                    "Kombinationsschema MMRV, ab 9 Monaten, MMR - MMRV - V",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Meningokokken ACWY Grundschema, ab 10 Jahren.<br>
     */
    MENINGOKOKKEN_ACWY_GRUNDSCHEMA_AB_10_JAHREN("SCHEMA039",
                                                "1.2.40.0.34.5.183",
                                                "Meningokokken ACWY Grundschema, ab 10 Jahren",
                                                "Meningokokken ACWY Grundschema, ab 10 Jahren",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Meningokokken ACWY Indikationsschema, ab 1 Jahr.<br>
     */
    MENINGOKOKKEN_ACWY_INDIKATIONSSCHEMA_AB_1_JAHR("SCHEMA040",
                                                   "1.2.40.0.34.5.183",
                                                   "Meningokokken ACWY Indikationsschema, ab 1 Jahr",
                                                   "Meningokokken ACWY Indikationsschema, ab 1 Jahr",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Meningokokken ACWY Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    MENINGOKOKKEN_ACWY_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR("SCHEMA041",
                                                                "1.2.40.0.34.5.183",
                                                                "Meningokokken ACWY Indikationsschema, Erstimpfung bis 1 Jahr",
                                                                "Meningokokken ACWY Indikationsschema, Erstimpfung bis 1 Jahr",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 11-18 Jahre, Trumenba.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_11_18_JAHRE_TRUMENBA("SCHEMA079",
                                                                 "1.2.40.0.34.5.183",
                                                                 "Meningokokken B Grundschema, Erstimpfung 11-18 Jahre, Trumenba",
                                                                 "Meningokokken B Grundschema, Erstimpfung 11-18 Jahre, Trumenba",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 12-23 Monate.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_12_23_MONATE("SCHEMA031",
                                                         "1.2.40.0.34.5.183",
                                                         "Meningokokken B Grundschema, Erstimpfung 12-23 Monate",
                                                         "Meningokokken B Grundschema, Erstimpfung 12-23 Monate",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 2-18 Jahre, Bexsero.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_18_JAHRE_BEXSERO("SCHEMA032",
                                                               "1.2.40.0.34.5.183",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-18 Jahre, Bexsero",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-18 Jahre, Bexsero",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 3 Dosen.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_5_MONATE_3_DOSEN("SCHEMA029",
                                                               "1.2.40.0.34.5.183",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 3 Dosen",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 3 Dosen",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 4 Dosen.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_5_MONATE_4_DOSEN("SCHEMA028",
                                                               "1.2.40.0.34.5.183",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 4 Dosen",
                                                               "Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 4 Dosen",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Grundschema, Erstimpfung 6-11 Monate.<br>
     */
    MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_6_11_MONATE("SCHEMA030",
                                                        "1.2.40.0.34.5.183",
                                                        "Meningokokken B Grundschema, Erstimpfung 6-11 Monate",
                                                        "Meningokokken B Grundschema, Erstimpfung 6-11 Monate",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Indikationsschema, ab 18 Jahren, Bexsero.<br>
     */
    MENINGOKOKKEN_B_INDIKATIONSSCHEMA_AB_18_JAHREN_BEXSERO("SCHEMA033",
                                                           "1.2.40.0.34.5.183",
                                                           "Meningokokken B Indikationsschema, ab 18 Jahren, Bexsero",
                                                           "Meningokokken B Indikationsschema, ab 18 Jahren, Bexsero",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: Meningokokken B Indikationsschema, ab 18 Jahren, Trumenba.<br>
     */
    MENINGOKOKKEN_B_INDIKATIONSSCHEMA_AB_18_JAHREN_TRUMENBA("SCHEMA034",
                                                            "1.2.40.0.34.5.183",
                                                            "Meningokokken B Indikationsschema, ab 18 Jahren, Trumenba",
                                                            "Meningokokken B Indikationsschema, ab 18 Jahren, Trumenba",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE"),
    /**
     * EN: Meningokokken C Grundschema, ab 1 Jahr.<br>
     */
    MENINGOKOKKEN_C_GRUNDSCHEMA_AB_1_JAHR("SCHEMA038",
                                          "1.2.40.0.34.5.183",
                                          "Meningokokken C Grundschema, ab 1 Jahr",
                                          "Meningokokken C Grundschema, ab 1 Jahr",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Meningokokken C Indikationsschema, 2-12 Monate, Menjugate.<br>
     */
    MENINGOKOKKEN_C_INDIKATIONSSCHEMA_2_12_MONATE_MENJUGATE("SCHEMA036",
                                                            "1.2.40.0.34.5.183",
                                                            "Meningokokken C Indikationsschema, 2-12 Monate, Menjugate",
                                                            "Meningokokken C Indikationsschema, 2-12 Monate, Menjugate",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE"),
    /**
     * EN: Meningokokken C Indikationsschema, 2-4 Monate, Neisvac C.<br>
     */
    MENINGOKOKKEN_C_INDIKATIONSSCHEMA_2_4_MONATE_NEISVAC_C("SCHEMA035",
                                                           "1.2.40.0.34.5.183",
                                                           "Meningokokken C Indikationsschema, 2-4 Monate, Neisvac C",
                                                           "Meningokokken C Indikationsschema, 2-4 Monate, Neisvac C",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: Meningokokken C Indikationsschema, 4-12 Monate, Neisvac C.<br>
     */
    MENINGOKOKKEN_C_INDIKATIONSSCHEMA_4_12_MONATE_NEISVAC_C("SCHEMA037",
                                                            "1.2.40.0.34.5.183",
                                                            "Meningokokken C Indikationsschema, 4-12 Monate, Neisvac C",
                                                            "Meningokokken C Indikationsschema, 4-12 Monate, Neisvac C",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE"),
    /**
     * EN: MMR Grundschema, ab 1 Jahr.<br>
     */
    MMR_GRUNDSCHEMA_AB_1_JAHR("SCHEMA093",
                              "1.2.40.0.34.5.183",
                              "MMR Grundschema, ab 1 Jahr",
                              "MMR Grundschema, ab 1 Jahr",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: MMR Grundschema ab 9 Monaten.<br>
     */
    MMR_GRUNDSCHEMA_AB_9_MONATEN("SCHEMA025",
                                 "1.2.40.0.34.5.183",
                                 "MMR Grundschema ab 9 Monaten",
                                 "MMR Grundschema ab 9 Monaten",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: MMR Indikationsschema, Erstimpfung 6-8 Monate.<br>
     */
    MMR_INDIKATIONSSCHEMA_ERSTIMPFUNG_6_8_MONATE("SCHEMA027",
                                                 "1.2.40.0.34.5.183",
                                                 "MMR Indikationsschema, Erstimpfung 6-8 Monate",
                                                 "MMR Indikationsschema, Erstimpfung 6-8 Monate",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Grundschema, ab 60 Jahre.<br>
     */
    PNEUMOKOKKEN_GRUNDSCHEMA_AB_60_JAHRE("SCHEMA098",
                                         "1.2.40.0.34.5.183",
                                         "Pneumokokken Grundschema, ab 60 Jahre",
                                         "Pneumokokken Grundschema, ab 60 Jahre",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Grundschema, Erstimpfung 1-2 Jahre.<br>
     */
    PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_1_2_JAHRE("SCHEMA043",
                                                   "1.2.40.0.34.5.183",
                                                   "Pneumokokken Grundschema, Erstimpfung 1-2 Jahre",
                                                   "Pneumokokken Grundschema, Erstimpfung 1-2 Jahre",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Grundschema, Erstimpfung 2-5 Jahre.<br>
     */
    PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_2_5_JAHRE("SCHEMA097",
                                                   "1.2.40.0.34.5.183",
                                                   "Pneumokokken Grundschema, Erstimpfung 2-5 Jahre",
                                                   "Pneumokokken Grundschema, Erstimpfung 2-5 Jahre",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Grundschema, Erstimpfung bis 1 Jahr.<br>
     */
    PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_BIS_1_JAHR("SCHEMA042",
                                                    "1.2.40.0.34.5.183",
                                                    "Pneumokokken Grundschema, Erstimpfung bis 1 Jahr",
                                                    "Pneumokokken Grundschema, Erstimpfung bis 1 Jahr",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Indikationsschema, Erstimpfung 1-5 Jahre.<br>
     */
    PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_1_5_JAHRE("SCHEMA045",
                                                         "1.2.40.0.34.5.183",
                                                         "Pneumokokken Indikationsschema, Erstimpfung 1-5 Jahre",
                                                         "Pneumokokken Indikationsschema, Erstimpfung 1-5 Jahre",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Indikationsschema, Erstimpfung ab 3 Jahren.<br>
     */
    PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_AB_3_JAHREN("SCHEMA046",
                                                           "1.2.40.0.34.5.183",
                                                           "Pneumokokken Indikationsschema, Erstimpfung ab 3 Jahren",
                                                           "Pneumokokken Indikationsschema, Erstimpfung ab 3 Jahren",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR("SCHEMA044",
                                                          "1.2.40.0.34.5.183",
                                                          "Pneumokokken Indikationsschema, Erstimpfung bis 1 Jahr",
                                                          "Pneumokokken Indikationsschema, Erstimpfung bis 1 Jahr",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Poliomyelitis Monokomponente.<br>
     */
    POLIOMYELITIS_MONOKOMPONENTE("SCHEMA084",
                                 "1.2.40.0.34.5.183",
                                 "Poliomyelitis Monokomponente",
                                 "Poliomyelitis Monokomponente",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Rotavirus Grundschema, 1 Dosis, Erstimpfung 19. - 23. Woche, Rotarix.<br>
     */
    ROTAVIRUS_GRUNDSCHEMA_1_DOSIS_ERSTIMPFUNG_19_23_WOCHE_ROTARIX("SCHEMA052",
                                                                  "1.2.40.0.34.5.183",
                                                                  "Rotavirus Grundschema, 1 Dosis, Erstimpfung 19. - 23. Woche, Rotarix",
                                                                  "Rotavirus Grundschema, 1 Dosis, Erstimpfung 19. - 23. Woche, Rotarix",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE"),
    /**
     * EN: Rotavirus Grundschema, 1 Dosis, Erstimpfung 28. - 32. Woche, Rotateq.<br>
     */
    ROTAVIRUS_GRUNDSCHEMA_1_DOSIS_ERSTIMPFUNG_28_32_WOCHE_ROTATEQ("SCHEMA053",
                                                                  "1.2.40.0.34.5.183",
                                                                  "Rotavirus Grundschema, 1 Dosis, Erstimpfung 28. - 32. Woche, Rotateq",
                                                                  "Rotavirus Grundschema, 1 Dosis, Erstimpfung 28. - 32. Woche, Rotateq",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE"),
    /**
     * EN: Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 19. Woche, Rotarix.<br>
     */
    ROTAVIRUS_GRUNDSCHEMA_2_DOSEN_ERSTIMPFUNG_6_19_WOCHE_ROTARIX("SCHEMA050",
                                                                 "1.2.40.0.34.5.183",
                                                                 "Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 19. Woche, Rotarix",
                                                                 "Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 19. Woche, Rotarix",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 27. Woche, Rotateq.<br>
     */
    ROTAVIRUS_GRUNDSCHEMA_2_DOSEN_ERSTIMPFUNG_6_27_WOCHE_ROTATEQ("SCHEMA051",
                                                                 "1.2.40.0.34.5.183",
                                                                 "Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 27. Woche, Rotateq",
                                                                 "Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 27. Woche, Rotateq",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Rotavirus Grundschema, 3 Dosen, Erstimpfung 6. - 23. Woche, Rotateq.<br>
     */
    ROTAVIRUS_GRUNDSCHEMA_3_DOSEN_ERSTIMPFUNG_6_23_WOCHE_ROTATEQ("SCHEMA054",
                                                                 "1.2.40.0.34.5.183",
                                                                 "Rotavirus Grundschema, 3 Dosen, Erstimpfung 6. - 23. Woche, Rotateq",
                                                                 "Rotavirus Grundschema, 3 Dosen, Erstimpfung 6. - 23. Woche, Rotateq",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, AstraZeneca.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_ASTRAZENECA("SCHEMA088",
                                       "1.2.40.0.34.5.183",
                                       "SARS-CoV-2 Grundschema, AstraZeneca",
                                       "SARS-CoV-2 Grundschema, AstraZeneca",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, Auslandsimpfung.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_AUSLANDSIMPFUNG("SCHEMA090",
                                           "1.2.40.0.34.5.183",
                                           "SARS-CoV-2 Grundschema, Auslandsimpfung",
                                           "SARS-CoV-2 Grundschema, Auslandsimpfung",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, Comirnaty.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_COMIRNATY("SCHEMA086",
                                     "1.2.40.0.34.5.183",
                                     "SARS-CoV-2 Grundschema, Comirnaty",
                                     "SARS-CoV-2 Grundschema, Comirnaty",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, Janssen.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_JANSSEN("SCHEMA089",
                                   "1.2.40.0.34.5.183",
                                   "SARS-CoV-2 Grundschema, Janssen",
                                   "SARS-CoV-2 Grundschema, Janssen",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, Moderna.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_MODERNA("SCHEMA087",
                                   "1.2.40.0.34.5.183",
                                   "SARS-CoV-2 Grundschema, Moderna",
                                   "SARS-CoV-2 Grundschema, Moderna",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Grundschema, Nuvaxovid.<br>
     */
    SARS_COV_2_GRUNDSCHEMA_NUVAXOVID("SCHEMA099",
                                     "1.2.40.0.34.5.183",
                                     "SARS-CoV-2 Grundschema, Nuvaxovid",
                                     "SARS-CoV-2 Grundschema, Nuvaxovid",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 heterologes Schema (Impfstoffwechsel).<br>
     */
    SARS_COV_2_HETEROLOGES_SCHEMA_IMPFSTOFFWECHSEL("SCHEMA096",
                                                   "1.2.40.0.34.5.183",
                                                   "SARS-CoV-2 heterologes Schema (Impfstoffwechsel)",
                                                   "SARS-CoV-2 heterologes Schema (Impfstoffwechsel)",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Indikationsschema, Comirnaty.<br>
     */
    SARS_COV_2_INDIKATIONSSCHEMA_COMIRNATY("SCHEMA094",
                                           "1.2.40.0.34.5.183",
                                           "SARS-CoV-2 Indikationsschema, Comirnaty",
                                           "SARS-CoV-2 Indikationsschema, Comirnaty",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Indikationsschema, Moderna.<br>
     */
    SARS_COV_2_INDIKATIONSSCHEMA_MODERNA("SCHEMA095",
                                         "1.2.40.0.34.5.183",
                                         "SARS-CoV-2 Indikationsschema, Moderna",
                                         "SARS-CoV-2 Indikationsschema, Moderna",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Tetanus Monokomponente.<br>
     */
    TETANUS_MONOKOMPONENTE("SCHEMA083",
                           "1.2.40.0.34.5.183",
                           "Tetanus Monokomponente",
                           "Tetanus Monokomponente",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Tollwut Grundschema.<br>
     */
    TOLLWUT_GRUNDSCHEMA("SCHEMA070",
                        "1.2.40.0.34.5.183",
                        "Tollwut Grundschema",
                        "Tollwut Grundschema",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Tollwut postexpositionelles Schema, Essen 4 Dosen.<br>
     */
    TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ESSEN_4_DOSEN("SCHEMA072",
                                                     "1.2.40.0.34.5.183",
                                                     "Tollwut postexpositionelles Schema, Essen 4 Dosen",
                                                     "Tollwut postexpositionelles Schema, Essen 4 Dosen",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Tollwut postexpositionelles Schema, Essen 5 Dosen.<br>
     */
    TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ESSEN_5_DOSEN("SCHEMA073",
                                                     "1.2.40.0.34.5.183",
                                                     "Tollwut postexpositionelles Schema, Essen 5 Dosen",
                                                     "Tollwut postexpositionelles Schema, Essen 5 Dosen",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Tollwut postexpositionelles Schema, mit Tollwut-Vorimpfung.<br>
     */
    TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_MIT_TOLLWUT_VORIMPFUNG("SCHEMA075",
                                                              "1.2.40.0.34.5.183",
                                                              "Tollwut postexpositionelles Schema, mit Tollwut-Vorimpfung",
                                                              "Tollwut postexpositionelles Schema, mit Tollwut-Vorimpfung",
                                                              "TOTRANSLATE",
                                                              "TOTRANSLATE",
                                                              "TOTRANSLATE"),
    /**
     * EN: Tollwut postexpositionelles Schema, Zagreb.<br>
     */
    TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ZAGREB("SCHEMA074",
                                              "1.2.40.0.34.5.183",
                                              "Tollwut postexpositionelles Schema, Zagreb",
                                              "Tollwut postexpositionelles Schema, Zagreb",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Tollwut Schnellschema.<br>
     */
    TOLLWUT_SCHNELLSCHEMA("SCHEMA071",
                          "1.2.40.0.34.5.183",
                          "Tollwut Schnellschema",
                          "Tollwut Schnellschema",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Typhus Grundschema, ab 2 Jahren.<br>
     */
    TYPHUS_GRUNDSCHEMA_AB_2_JAHREN("SCHEMA068",
                                   "1.2.40.0.34.5.183",
                                   "Typhus Grundschema, ab 2 Jahren",
                                   "Typhus Grundschema, ab 2 Jahren",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Typhus Grundschema, ab 6 Jahren, Vivotif-Kapseln.<br>
     */
    TYPHUS_GRUNDSCHEMA_AB_6_JAHREN_VIVOTIF_KAPSELN("SCHEMA069",
                                                   "1.2.40.0.34.5.183",
                                                   "Typhus Grundschema, ab 6 Jahren, Vivotif-Kapseln",
                                                   "Typhus Grundschema, ab 6 Jahren, Vivotif-Kapseln",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Varizellen Grundschema, ab 1 Jahr.<br>
     */
    VARIZELLEN_GRUNDSCHEMA_AB_1_JAHR("SCHEMA060",
                                     "1.2.40.0.34.5.183",
                                     "Varizellen Grundschema, ab 1 Jahr",
                                     "Varizellen Grundschema, ab 1 Jahr",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Varizellen Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    VARIZELLEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR("SCHEMA063",
                                                        "1.2.40.0.34.5.183",
                                                        "Varizellen Indikationsschema, Erstimpfung bis 1 Jahr",
                                                        "Varizellen Indikationsschema, Erstimpfung bis 1 Jahr",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE",
                                                        "TOTRANSLATE");

    /**
     * EN: Code for Cholera Grundschema, Erstimpfung 2-6 Jahre.<br>
     */
    public static final String CHOLERA_GRUNDSCHEMA_ERSTIMPFUNG_2_6_JAHRE_CODE = "SCHEMA076";

    /**
     * EN: Code for Cholera Grundschema, Erstimpfung ab 6 Jahren.<br>
     */
    public static final String CHOLERA_GRUNDSCHEMA_ERSTIMPFUNG_AB_6_JAHREN_CODE = "SCHEMA078";

    /**
     * EN: Code for FSME Grundschema, Encepur.<br>
     */
    public static final String FSME_GRUNDSCHEMA_ENCEPUR_CODE = "SCHEMA006";

    /**
     * EN: Code for FSME Grundschema, FSME-Immun.<br>
     */
    public static final String FSME_GRUNDSCHEMA_FSME_IMMUN_CODE = "SCHEMA005";

    /**
     * EN: Code for FSME Indikationsschema, Encepur.<br>
     */
    public static final String FSME_INDIKATIONSSCHEMA_ENCEPUR_CODE = "SCHEMA008";

    /**
     * EN: Code for FSME Indikationsschema, FSME-Immun.<br>
     */
    public static final String FSME_INDIKATIONSSCHEMA_FSME_IMMUN_CODE = "SCHEMA007";

    /**
     * EN: Code for FSME Schnellschema, Encepur.<br>
     */
    public static final String FSME_SCHNELLSCHEMA_ENCEPUR_CODE = "SCHEMA010";

    /**
     * EN: Code for FSME Schnellschema, FSME-Immun.<br>
     */
    public static final String FSME_SCHNELLSCHEMA_FSME_IMMUN_CODE = "SCHEMA009";

    /**
     * EN: Code for Gelbfieber Grundschema, ab 1 Jahr.<br>
     */
    public static final String GELBFIEBER_GRUNDSCHEMA_AB_1_JAHR_CODE = "SCHEMA065";

    /**
     * EN: Code for Haemophilus influenzae Typ B Indikationsschema.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_TYP_B_INDIKATIONSSCHEMA_CODE = "SCHEMA011";

    /**
     * EN: Code for Hepatitis AB Grundschema.<br>
     */
    public static final String HEPATITIS_AB_GRUNDSCHEMA_CODE = "SCHEMA013";

    /**
     * EN: Code for Hepatitis AB Schnellschema.<br>
     */
    public static final String HEPATITIS_AB_SCHNELLSCHEMA_CODE = "SCHEMA015";

    /**
     * EN: Code for Hepatitis A Monokomponente Grundschema.<br>
     */
    public static final String HEPATITIS_A_MONOKOMPONENTE_GRUNDSCHEMA_CODE = "SCHEMA014";

    /**
     * EN: Code for Hepatitis A Monokomponente Indikationsschema.<br>
     */
    public static final String HEPATITIS_A_MONOKOMPONENTE_INDIKATIONSSCHEMA_CODE = "SCHEMA012";

    /**
     * EN: Code for Hepatitis A &amp; Typhus Grundschema.<br>
     */
    public static final String HEPATITIS_A_TYPHUS_GRUNDSCHEMA_CODE = "SCHEMA016";

    /**
     * EN: Code for Hepatitis B erhoehte Antigenmenge Grundschema.<br>
     */
    public static final String HEPATITIS_B_ERHOEHTE_ANTIGENMENGE_GRUNDSCHEMA_CODE = "SCHEMA019";

    /**
     * EN: Code for Hepatitis B Monokomponente Grundschema.<br>
     */
    public static final String HEPATITIS_B_MONOKOMPONENTE_GRUNDSCHEMA_CODE = "SCHEMA017";

    /**
     * EN: Code for Hepatitis B Monokomponente Indikationsschema.<br>
     */
    public static final String HEPATITIS_B_MONOKOMPONENTE_INDIKATIONSSCHEMA_CODE = "SCHEMA085";

    /**
     * EN: Code for Hepatitis B Monokomponente Schnellschema durch Indikation.<br>
     */
    public static final String HEPATITIS_B_MONOKOMPONENTE_SCHNELLSCHEMA_DURCH_INDIKATION_CODE = "SCHEMA102";

    /**
     * EN: Code for Hepatitis B Prophylaxe Neugeborener Indikationsschema.<br>
     */
    public static final String HEPATITIS_B_PROPHYLAXE_NEUGEBORENER_INDIKATIONSSCHEMA_CODE = "SCHEMA103";

    /**
     * EN: Code for Herpes Zoster Grundschema, ab 50 Jahren.<br>
     */
    public static final String HERPES_ZOSTER_GRUNDSCHEMA_AB_50_JAHREN_CODE = "SCHEMA064";

    /**
     * EN: Code for Herpes Zoster Grundschema, nach Zostavax.<br>
     */
    public static final String HERPES_ZOSTER_GRUNDSCHEMA_NACH_ZOSTAVAX_CODE = "SCHEMA091";

    /**
     * EN: Code for Herpes Zoster Indikationsschema, ab 18 Jahren.<br>
     */
    public static final String HERPES_ZOSTER_INDIKATIONSSCHEMA_AB_18_JAHREN_CODE = "SCHEMA092";

    /**
     * EN: Code for HPV Grundschema, ab 15 Jahren.<br>
     */
    public static final String HPV_GRUNDSCHEMA_AB_15_JAHREN_CODE = "SCHEMA021";

    /**
     * EN: Code for HPV Grundschema, bis 15 Jahre.<br>
     */
    public static final String HPV_GRUNDSCHEMA_BIS_15_JAHRE_CODE = "SCHEMA020";

    /**
     * EN: Code for HPV Indikationsschema, bis 15 Jahre.<br>
     */
    public static final String HPV_INDIKATIONSSCHEMA_BIS_15_JAHRE_CODE = "SCHEMA022";

    /**
     * EN: Code for Influenza Grundschema, Einmalimpfung.<br>
     */
    public static final String INFLUENZA_GRUNDSCHEMA_EINMALIMPFUNG_CODE = "SCHEMA024";

    /**
     * EN: Code for Influenza Grundschema, Kinder.<br>
     */
    public static final String INFLUENZA_GRUNDSCHEMA_KINDER_CODE = "SCHEMA023";

    /**
     * EN: Code for Japanische Enzephalitis Grundschema, ab 2 Monaten.<br>
     */
    public static final String JAPANISCHE_ENZEPHALITIS_GRUNDSCHEMA_AB_2_MONATEN_CODE = "SCHEMA066";

    /**
     * EN: Code for Japanische Enzephalitis Schnellschema, ab 18 Jahren.<br>
     */
    public static final String JAPANISCHE_ENZEPHALITIS_SCHNELLSCHEMA_AB_18_JAHREN_CODE = "SCHEMA067";

    /**
     * EN: Code for Kombinationsschema Di-Te.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_CODE = "SCHEMA082";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_CODE = "SCHEMA081";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung ab 1 Jahr.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_ERSTIMPFUNG_AB_1_JAHR_CODE = "SCHEMA002";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Erstimpfung bis 1 Jahr.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_ERSTIMPFUNG_BIS_1_JAHR_CODE = "SCHEMA001";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert-HiB-IPV-HepB, Indikation.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_HIB_IPV_HEPB_INDIKATION_CODE = "SCHEMA004";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert-IPV.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_IPV_CODE = "SCHEMA080";

    /**
     * EN: Code for Kombinationsschema Di-Te-Pert-IPV-HepB, Erstimpfung ab 6 Jahren.<br>
     */
    public static final String KOMBINATIONSSCHEMA_DI_TE_PERT_IPV_HEPB_ERSTIMPFUNG_AB_6_JAHREN_CODE = "SCHEMA003";

    /**
     * EN: Code for Kombinationsschema MMRV, ab 12 Monaten.<br>
     */
    public static final String KOMBINATIONSSCHEMA_MMRV_AB_12_MONATEN_CODE = "SCHEMA101";

    /**
     * EN: Code for Kombinationsschema MMRV, ab 12 Monaten, MMR - MMRV - V.<br>
     */
    public static final String KOMBINATIONSSCHEMA_MMRV_AB_12_MONATEN_MMR_MMRV_V_CODE = "SCHEMA062";

    /**
     * EN: Code for Kombinationsschema MMRV, ab 9 Monaten.<br>
     */
    public static final String KOMBINATIONSSCHEMA_MMRV_AB_9_MONATEN_CODE = "SCHEMA100";

    /**
     * EN: Code for Kombinationsschema MMRV, ab 9 Monaten, MMR - MMRV - V.<br>
     */
    public static final String KOMBINATIONSSCHEMA_MMRV_AB_9_MONATEN_MMR_MMRV_V_CODE = "SCHEMA061";

    /**
     * EN: Code for Meningokokken ACWY Grundschema, ab 10 Jahren.<br>
     */
    public static final String MENINGOKOKKEN_ACWY_GRUNDSCHEMA_AB_10_JAHREN_CODE = "SCHEMA039";

    /**
     * EN: Code for Meningokokken ACWY Indikationsschema, ab 1 Jahr.<br>
     */
    public static final String MENINGOKOKKEN_ACWY_INDIKATIONSSCHEMA_AB_1_JAHR_CODE = "SCHEMA040";

    /**
     * EN: Code for Meningokokken ACWY Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    public static final String MENINGOKOKKEN_ACWY_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR_CODE = "SCHEMA041";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 11-18 Jahre, Trumenba.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_11_18_JAHRE_TRUMENBA_CODE = "SCHEMA079";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 12-23 Monate.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_12_23_MONATE_CODE = "SCHEMA031";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 2-18 Jahre, Bexsero.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_18_JAHRE_BEXSERO_CODE = "SCHEMA032";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 3 Dosen.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_5_MONATE_3_DOSEN_CODE = "SCHEMA029";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 2-5 Monate, 4 Dosen.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_2_5_MONATE_4_DOSEN_CODE = "SCHEMA028";

    /**
     * EN: Code for Meningokokken B Grundschema, Erstimpfung 6-11 Monate.<br>
     */
    public static final String MENINGOKOKKEN_B_GRUNDSCHEMA_ERSTIMPFUNG_6_11_MONATE_CODE = "SCHEMA030";

    /**
     * EN: Code for Meningokokken B Indikationsschema, ab 18 Jahren, Bexsero.<br>
     */
    public static final String MENINGOKOKKEN_B_INDIKATIONSSCHEMA_AB_18_JAHREN_BEXSERO_CODE = "SCHEMA033";

    /**
     * EN: Code for Meningokokken B Indikationsschema, ab 18 Jahren, Trumenba.<br>
     */
    public static final String MENINGOKOKKEN_B_INDIKATIONSSCHEMA_AB_18_JAHREN_TRUMENBA_CODE = "SCHEMA034";

    /**
     * EN: Code for Meningokokken C Grundschema, ab 1 Jahr.<br>
     */
    public static final String MENINGOKOKKEN_C_GRUNDSCHEMA_AB_1_JAHR_CODE = "SCHEMA038";

    /**
     * EN: Code for Meningokokken C Indikationsschema, 2-12 Monate, Menjugate.<br>
     */
    public static final String MENINGOKOKKEN_C_INDIKATIONSSCHEMA_2_12_MONATE_MENJUGATE_CODE = "SCHEMA036";

    /**
     * EN: Code for Meningokokken C Indikationsschema, 2-4 Monate, Neisvac C.<br>
     */
    public static final String MENINGOKOKKEN_C_INDIKATIONSSCHEMA_2_4_MONATE_NEISVAC_C_CODE = "SCHEMA035";

    /**
     * EN: Code for Meningokokken C Indikationsschema, 4-12 Monate, Neisvac C.<br>
     */
    public static final String MENINGOKOKKEN_C_INDIKATIONSSCHEMA_4_12_MONATE_NEISVAC_C_CODE = "SCHEMA037";

    /**
     * EN: Code for MMR Grundschema, ab 1 Jahr.<br>
     */
    public static final String MMR_GRUNDSCHEMA_AB_1_JAHR_CODE = "SCHEMA093";

    /**
     * EN: Code for MMR Grundschema ab 9 Monaten.<br>
     */
    public static final String MMR_GRUNDSCHEMA_AB_9_MONATEN_CODE = "SCHEMA025";

    /**
     * EN: Code for MMR Indikationsschema, Erstimpfung 6-8 Monate.<br>
     */
    public static final String MMR_INDIKATIONSSCHEMA_ERSTIMPFUNG_6_8_MONATE_CODE = "SCHEMA027";

    /**
     * EN: Code for Pneumokokken Grundschema, ab 60 Jahre.<br>
     */
    public static final String PNEUMOKOKKEN_GRUNDSCHEMA_AB_60_JAHRE_CODE = "SCHEMA098";

    /**
     * EN: Code for Pneumokokken Grundschema, Erstimpfung 1-2 Jahre.<br>
     */
    public static final String PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_1_2_JAHRE_CODE = "SCHEMA043";

    /**
     * EN: Code for Pneumokokken Grundschema, Erstimpfung 2-5 Jahre.<br>
     */
    public static final String PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_2_5_JAHRE_CODE = "SCHEMA097";

    /**
     * EN: Code for Pneumokokken Grundschema, Erstimpfung bis 1 Jahr.<br>
     */
    public static final String PNEUMOKOKKEN_GRUNDSCHEMA_ERSTIMPFUNG_BIS_1_JAHR_CODE = "SCHEMA042";

    /**
     * EN: Code for Pneumokokken Indikationsschema, Erstimpfung 1-5 Jahre.<br>
     */
    public static final String PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_1_5_JAHRE_CODE = "SCHEMA045";

    /**
     * EN: Code for Pneumokokken Indikationsschema, Erstimpfung ab 3 Jahren.<br>
     */
    public static final String PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_AB_3_JAHREN_CODE = "SCHEMA046";

    /**
     * EN: Code for Pneumokokken Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    public static final String PNEUMOKOKKEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR_CODE = "SCHEMA044";

    /**
     * EN: Code for Poliomyelitis Monokomponente.<br>
     */
    public static final String POLIOMYELITIS_MONOKOMPONENTE_CODE = "SCHEMA084";

    /**
     * EN: Code for Rotavirus Grundschema, 1 Dosis, Erstimpfung 19. - 23. Woche, Rotarix.<br>
     */
    public static final String ROTAVIRUS_GRUNDSCHEMA_1_DOSIS_ERSTIMPFUNG_19_23_WOCHE_ROTARIX_CODE = "SCHEMA052";

    /**
     * EN: Code for Rotavirus Grundschema, 1 Dosis, Erstimpfung 28. - 32. Woche, Rotateq.<br>
     */
    public static final String ROTAVIRUS_GRUNDSCHEMA_1_DOSIS_ERSTIMPFUNG_28_32_WOCHE_ROTATEQ_CODE = "SCHEMA053";

    /**
     * EN: Code for Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 19. Woche, Rotarix.<br>
     */
    public static final String ROTAVIRUS_GRUNDSCHEMA_2_DOSEN_ERSTIMPFUNG_6_19_WOCHE_ROTARIX_CODE = "SCHEMA050";

    /**
     * EN: Code for Rotavirus Grundschema, 2 Dosen, Erstimpfung 6.- 27. Woche, Rotateq.<br>
     */
    public static final String ROTAVIRUS_GRUNDSCHEMA_2_DOSEN_ERSTIMPFUNG_6_27_WOCHE_ROTATEQ_CODE = "SCHEMA051";

    /**
     * EN: Code for Rotavirus Grundschema, 3 Dosen, Erstimpfung 6. - 23. Woche, Rotateq.<br>
     */
    public static final String ROTAVIRUS_GRUNDSCHEMA_3_DOSEN_ERSTIMPFUNG_6_23_WOCHE_ROTATEQ_CODE = "SCHEMA054";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, AstraZeneca.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_ASTRAZENECA_CODE = "SCHEMA088";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, Auslandsimpfung.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_AUSLANDSIMPFUNG_CODE = "SCHEMA090";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, Comirnaty.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_COMIRNATY_CODE = "SCHEMA086";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, Janssen.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_JANSSEN_CODE = "SCHEMA089";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, Moderna.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_MODERNA_CODE = "SCHEMA087";

    /**
     * EN: Code for SARS-CoV-2 Grundschema, Nuvaxovid.<br>
     */
    public static final String SARS_COV_2_GRUNDSCHEMA_NUVAXOVID_CODE = "SCHEMA099";

    /**
     * EN: Code for SARS-CoV-2 heterologes Schema (Impfstoffwechsel).<br>
     */
    public static final String SARS_COV_2_HETEROLOGES_SCHEMA_IMPFSTOFFWECHSEL_CODE = "SCHEMA096";

    /**
     * EN: Code for SARS-CoV-2 Indikationsschema, Comirnaty.<br>
     */
    public static final String SARS_COV_2_INDIKATIONSSCHEMA_COMIRNATY_CODE = "SCHEMA094";

    /**
     * EN: Code for SARS-CoV-2 Indikationsschema, Moderna.<br>
     */
    public static final String SARS_COV_2_INDIKATIONSSCHEMA_MODERNA_CODE = "SCHEMA095";

    /**
     * EN: Code for Tetanus Monokomponente.<br>
     */
    public static final String TETANUS_MONOKOMPONENTE_CODE = "SCHEMA083";

    /**
     * EN: Code for Tollwut Grundschema.<br>
     */
    public static final String TOLLWUT_GRUNDSCHEMA_CODE = "SCHEMA070";

    /**
     * EN: Code for Tollwut postexpositionelles Schema, Essen 4 Dosen.<br>
     */
    public static final String TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ESSEN_4_DOSEN_CODE = "SCHEMA072";

    /**
     * EN: Code for Tollwut postexpositionelles Schema, Essen 5 Dosen.<br>
     */
    public static final String TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ESSEN_5_DOSEN_CODE = "SCHEMA073";

    /**
     * EN: Code for Tollwut postexpositionelles Schema, mit Tollwut-Vorimpfung.<br>
     */
    public static final String TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_MIT_TOLLWUT_VORIMPFUNG_CODE = "SCHEMA075";

    /**
     * EN: Code for Tollwut postexpositionelles Schema, Zagreb.<br>
     */
    public static final String TOLLWUT_POSTEXPOSITIONELLES_SCHEMA_ZAGREB_CODE = "SCHEMA074";

    /**
     * EN: Code for Tollwut Schnellschema.<br>
     */
    public static final String TOLLWUT_SCHNELLSCHEMA_CODE = "SCHEMA071";

    /**
     * EN: Code for Typhus Grundschema, ab 2 Jahren.<br>
     */
    public static final String TYPHUS_GRUNDSCHEMA_AB_2_JAHREN_CODE = "SCHEMA068";

    /**
     * EN: Code for Typhus Grundschema, ab 6 Jahren, Vivotif-Kapseln.<br>
     */
    public static final String TYPHUS_GRUNDSCHEMA_AB_6_JAHREN_VIVOTIF_KAPSELN_CODE = "SCHEMA069";

    /**
     * EN: Code for Varizellen Grundschema, ab 1 Jahr.<br>
     */
    public static final String VARIZELLEN_GRUNDSCHEMA_AB_1_JAHR_CODE = "SCHEMA060";

    /**
     * EN: Code for Varizellen Indikationsschema, Erstimpfung bis 1 Jahr.<br>
     */
    public static final String VARIZELLEN_INDIKATIONSSCHEMA_ERSTIMPFUNG_BIS_1_JAHR_CODE = "SCHEMA063";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.5";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "eImpf_Impfschema_VS";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.183";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EImpfImpfschemaVs getEnum(@Nullable final String code) {
        for (final EImpfImpfschemaVs x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EImpfImpfschemaVs.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EImpfImpfschemaVs x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EImpfImpfschemaVs(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
