/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base;

import java.util.List;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Procedure;
import org.projecthusky.common.hl7cdar2.ParticipationPhysicalPerformer;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentProcedureMood;

public class SpecimenCollection
extends POCDMT000040Procedure {
    public SpecimenCollection() {
        super.getClassCode().add("PROC");
        super.setMoodCode(XDocumentProcedureMood.EVN);
        super.getTemplateId().add(SpecimenCollection.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.3.1.2"));
        super.setCode((CD)SpecimenCollection.createHl7CodeFixedValue("33882-2", "2.16.840.1.113883.6.1", null, null));
        super.getParticipant().add(SpecimenCollection.createHl7ParticipantFixedValue("PRD"));
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static POCDMT000040Participant2 createHl7ParticipantFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Participant2 retVal = factory.createPOCDMT000040Participant2();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static POCDMT000040Performer2 createHl7PerformerFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Performer2 retVal = factory.createPOCDMT000040Performer2();
        retVal.setTypeCode(ParticipationPhysicalPerformer.fromValue((String)typeCode));
        return retVal;
    }

    private static CD createHl7TargetSiteCodeFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        CD retVal = factory.createCD();
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040EntryRelationship> getHl7EntryRelationship() {
        return this.entryRelationship;
    }

    public List<POCDMT000040Participant2> getHl7Participant() {
        return this.participant;
    }

    public List<POCDMT000040Performer2> getHl7Performer() {
        return this.performer;
    }

    public List<CD> getHl7TargetSiteCode() {
        return this.targetSiteCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipCompNull() {
        return SpecimenCollection.createHl7EntryRelationshipFixedValue("COMP", null);
    }

    public static POCDMT000040Performer2 getPredefinedPerformerPrf() {
        return SpecimenCollection.createHl7PerformerFixedValue("PRF");
    }

    public static CD getPredefinedTargetSiteCode() {
        return SpecimenCollection.createHl7TargetSiteCodeFixedValue();
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().clear();
        this.getEntryRelationship().add(value);
    }

    public void setHl7Participant(POCDMT000040Participant2 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7Performer(POCDMT000040Performer2 value) {
        this.getPerformer().clear();
        this.getPerformer().add(value);
    }

    public void setHl7TargetSiteCode(CD value) {
        this.getTargetSiteCode().clear();
        this.getTargetSiteCode().add(value);
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

