/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.emed;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.UUID;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Custodian;
import org.projecthusky.common.hl7cdar2.POCDMT000040InfrastructureRootTypeId;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.hl7cdar2.POCDMT000040RelatedDocument;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TS;

@XmlRootElement(name="ClinicalDocument", namespace="urn:hl7-org:v3")
public class Cdamedikationsliste
extends POCDMT000040ClinicalDocument {
    public Cdamedikationsliste() {
        super.getTemplateId().add(Cdamedikationsliste.createHl7TemplateIdFixedValue("1.2.40.0.34.11.8.3"));
        super.getTemplateId().add(Cdamedikationsliste.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.1.5"));
        super.getTemplateId().add(Cdamedikationsliste.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.1.1"));
        super.getTemplateId().add(Cdamedikationsliste.createHl7TemplateIdFixedValue("1.2.40.0.34.11.8.0.3"));
        super.setId(Cdamedikationsliste.createHl7IdFixedValue("1.2.40.0.10.1.4.3.4.2.1", "e-MedAT"));
        super.setCode(Cdamedikationsliste.createHl7CodeFixedValue("56445-0", "2.16.840.1.113883.6.1", null, "Medication summary Document"));
        super.setTypeId(Cdamedikationsliste.createHl7TypeIdFixedValue("2.16.840.1.113883.1.3", "POCD_HD000040"));
        super.getTemplateId().add(Cdamedikationsliste.createHl7TemplateIdFixedValue("1.2.40.0.34.11.1"));
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Component2 createHl7ComponentFixedValue(String typeCode, String contextConductionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Component2 retVal = factory.createPOCDMT000040Component2();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        if (contextConductionInd != null) {
            retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        }
        return retVal;
    }

    private static II createHl7IdFixedValue(String root, String assigningAuthorityName) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        retVal.setAssigningAuthorityName(assigningAuthorityName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    private static POCDMT000040InfrastructureRootTypeId createHl7TypeIdFixedValue(String root, String extension) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040InfrastructureRootTypeId retVal = factory.createPOCDMT000040InfrastructureRootTypeId();
        retVal.setRoot(root);
        retVal.setExtension(extension);
        return retVal;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public CE getHl7Code() {
        return this.code;
    }

    public POCDMT000040Component2 getHl7Component() {
        return this.component;
    }

    public CE getHl7ConfidentialityCode() {
        return this.confidentialityCode;
    }

    public POCDMT000040Custodian getHl7Custodian() {
        return this.custodian;
    }

    public TS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public II getHl7Id() {
        return this.id;
    }

    public CS getHl7LanguageCode() {
        return this.languageCode;
    }

    public POCDMT000040LegalAuthenticator getHl7LegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public List<CS> getHl7RealmCode() {
        return this.realmCode;
    }

    public List<POCDMT000040RecordTarget> getHl7RecordTarget() {
        return this.recordTarget;
    }

    public List<POCDMT000040RelatedDocument> getHl7RelatedDocument() {
        return this.relatedDocument;
    }

    public II getHl7SetId() {
        return this.setId;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public POCDMT000040InfrastructureRootTypeId getHl7TypeId() {
        return this.typeId;
    }

    public INT getHl7VersionNumber() {
        return this.versionNumber;
    }

    public static POCDMT000040Component2 getPredefinedComponentCompTrue() {
        return Cdamedikationsliste.createHl7ComponentFixedValue("COMP", "true");
    }

    public void initFirstVersion(String newDocId) {
        II docId = new II();
        docId.setRoot(newDocId);
        if (newDocId == null) {
            docId.setRoot(UUID.randomUUID().toString());
        }
        this.setId(docId);
        this.setVersion(docId.getRoot(), 1);
    }

    public void initNextVersion(String newDocId) {
        II id = new II();
        id.setRoot(newDocId);
        II setId = this.getSetId();
        if (setId == null) {
            setId = this.getId();
        }
        if (setId == null) {
            setId = id;
        }
        Integer version = this.getVersionNumber().getValue().intValue();
        this.setId(id);
        this.setVersion(setId.getRoot(), version + 1);
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Component(POCDMT000040Component2 value) {
        this.component = value;
    }

    public void setHl7ConfidentialityCode(CE value) {
        this.confidentialityCode = value;
    }

    public void setHl7Custodian(POCDMT000040Custodian value) {
        this.custodian = value;
    }

    public void setHl7EffectiveTime(TS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7LanguageCode(CS value) {
        this.languageCode = value;
    }

    public void setHl7LegalAuthenticator(POCDMT000040LegalAuthenticator value) {
        this.legalAuthenticator = value;
    }

    public void setHl7RealmCode(CS value) {
        this.getRealmCode().clear();
        this.getRealmCode().add(value);
    }

    public void setHl7RecordTarget(POCDMT000040RecordTarget value) {
        this.getRecordTarget().clear();
        this.getRecordTarget().add(value);
    }

    public void setHl7RelatedDocument(POCDMT000040RelatedDocument value) {
        this.getRelatedDocument().clear();
        this.getRelatedDocument().add(value);
    }

    public void setHl7SetId(II value) {
        this.setId = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }

    public void setHl7TypeId(POCDMT000040InfrastructureRootTypeId value) {
        this.typeId = value;
    }

    public void setHl7VersionNumber(INT value) {
        this.versionNumber = value;
    }

    public void setVersion(String idVersion1, int version) {
        II id = new II();
        id.setRoot(idVersion1);
        super.setSetId(id);
        super.setVersionNumber(new INT(version));
    }
}

