/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsHeaderRecordTarget;
import org.projecthusky.common.hl7cdar2.ActClinicalDocument;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Authenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Authorization;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component1;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Custodian;
import org.projecthusky.common.hl7cdar2.POCDMT000040DataEnterer;
import org.projecthusky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040InFulfillmentOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040InformationRecipient;
import org.projecthusky.common.hl7cdar2.POCDMT000040InfrastructureRootTypeId;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant1;
import org.projecthusky.common.hl7cdar2.POCDMT000040RelatedDocument;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TS;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="POCD_MT000040.EpimsDocumentArztmeldung", propOrder={"realmCode", "typeId", "templateId", "id", "code", "title", "effectiveTime", "confidentialityCode", "languageCode", "setId", "versionNumber", "copyTime", "recordTarget", "author", "dataEnterer", "informant", "custodian", "informationRecipient", "legalAuthenticator", "authenticator", "participant", "inFulfillmentOf", "documentationOf", "relatedDocument", "authorization", "componentOf", "component"})
@XmlRootElement(name="ClinicalDocument", namespace="urn:hl7-org:v3")
public class EpimsDocumentArztmeldung {
    protected List<POCDMT000040Authenticator> authenticator;
    @XmlElement(required=true)
    protected List<POCDMT000040Author> author;
    protected List<POCDMT000040Authorization> authorization;
    @XmlAttribute(name="classCode")
    protected ActClinicalDocument classCode;
    @XmlElement(required=true)
    protected CE code;
    @XmlElement(required=true)
    protected POCDMT000040Component2 component;
    protected POCDMT000040Component1 componentOf;
    @XmlElement(required=true)
    protected CE confidentialityCode;
    protected TS copyTime;
    @XmlElement(required=true)
    protected POCDMT000040Custodian custodian;
    protected POCDMT000040DataEnterer dataEnterer;
    protected List<POCDMT000040DocumentationOf> documentationOf;
    @XmlElement(required=true)
    protected TS effectiveTime;
    @XmlElement(required=true)
    protected II id;
    @XmlAttribute(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String idAttr;
    protected List<POCDMT000040Informant12> informant;
    protected List<POCDMT000040InformationRecipient> informationRecipient;
    protected List<POCDMT000040InFulfillmentOf> inFulfillmentOf;
    protected CS languageCode;
    protected POCDMT000040LegalAuthenticator legalAuthenticator;
    @XmlAttribute(name="moodCode")
    protected List<String> moodCode;
    @XmlAttribute(name="nullFlavor")
    protected List<String> nullFlavor;
    protected List<POCDMT000040Participant1> participant;
    protected List<CS> realmCode;
    @XmlElement(required=true, name="recordTarget")
    protected List<EpimsHeaderRecordTarget> recordTarget;
    protected List<POCDMT000040RelatedDocument> relatedDocument;
    protected II setId;
    protected List<II> templateId;
    protected ST title;
    @XmlElement(required=true)
    protected POCDMT000040InfrastructureRootTypeId typeId;
    protected INT versionNumber;

    public EpimsDocumentArztmeldung() {
        this.setClassCode(ActClinicalDocument.DOCCLIN);
        this.getMoodCode().add("EVN");
        this.getTemplateId().add(EpimsDocumentArztmeldung.createHl7TemplateIdFixedValue("1.2.40.0.34.11.1"));
        this.getTemplateId().add(EpimsDocumentArztmeldung.createHl7TemplateIdFixedValue("1.2.40.0.34.11.6"));
        this.getTemplateId().add(EpimsDocumentArztmeldung.createHl7TemplateIdFixedValue("1.2.40.0.34.11.6.0.2"));
        this.setCode(EpimsDocumentArztmeldung.createHl7CodeFixedValue("34782-3", "2.16.840.1.113883.6.1", "LOINC", "Infectious disease Note"));
        this.setComponent(EpimsDocumentArztmeldung.createHl7ComponentFixedValue("COMP", "true"));
    }

    public @NonNull List<POCDMT000040Authenticator> getAuthenticator() {
        if (this.authenticator == null) {
            this.authenticator = new ArrayList<POCDMT000040Authenticator>();
        }
        return this.authenticator;
    }

    public @NonNull List<POCDMT000040Author> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<POCDMT000040Author>();
        }
        return this.author;
    }

    public @NonNull List<POCDMT000040Authorization> getAuthorization() {
        if (this.authorization == null) {
            this.authorization = new ArrayList<POCDMT000040Authorization>();
        }
        return this.authorization;
    }

    public @NonNull ActClinicalDocument getClassCode() {
        if (this.classCode == null) {
            return ActClinicalDocument.DOCCLIN;
        }
        return this.classCode;
    }

    public CE getCode() {
        return this.code;
    }

    public POCDMT000040Component2 getComponent() {
        return this.component;
    }

    public POCDMT000040Component1 getComponentOf() {
        return this.componentOf;
    }

    public CE getConfidentialityCode() {
        return this.confidentialityCode;
    }

    public TS getCopyTime() {
        return this.copyTime;
    }

    public POCDMT000040Custodian getCustodian() {
        return this.custodian;
    }

    public POCDMT000040DataEnterer getDataEnterer() {
        return this.dataEnterer;
    }

    public @NonNull List<POCDMT000040DocumentationOf> getDocumentationOf() {
        if (this.documentationOf == null) {
            this.documentationOf = new ArrayList<POCDMT000040DocumentationOf>();
        }
        return this.documentationOf;
    }

    public TS getEffectiveTime() {
        return this.effectiveTime;
    }

    public II getId() {
        return this.id;
    }

    public String getIDAttr() {
        return this.idAttr;
    }

    public @NonNull List<POCDMT000040Informant12> getInformant() {
        if (this.informant == null) {
            this.informant = new ArrayList<POCDMT000040Informant12>();
        }
        return this.informant;
    }

    public @NonNull List<POCDMT000040InformationRecipient> getInformationRecipient() {
        if (this.informationRecipient == null) {
            this.informationRecipient = new ArrayList<POCDMT000040InformationRecipient>();
        }
        return this.informationRecipient;
    }

    public @NonNull List<POCDMT000040InFulfillmentOf> getInFulfillmentOf() {
        if (this.inFulfillmentOf == null) {
            this.inFulfillmentOf = new ArrayList<POCDMT000040InFulfillmentOf>();
        }
        return this.inFulfillmentOf;
    }

    public CS getLanguageCode() {
        return this.languageCode;
    }

    public POCDMT000040LegalAuthenticator getLegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public @NonNull List<String> getMoodCode() {
        if (this.moodCode == null) {
            this.moodCode = new ArrayList<String>();
        }
        return this.moodCode;
    }

    public @NonNull List<String> getNullFlavor() {
        if (this.nullFlavor == null) {
            this.nullFlavor = new ArrayList<String>();
        }
        return this.nullFlavor;
    }

    public @NonNull List<POCDMT000040Participant1> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<POCDMT000040Participant1>();
        }
        return this.participant;
    }

    public @NonNull List<CS> getRealmCode() {
        if (this.realmCode == null) {
            this.realmCode = new ArrayList<CS>();
        }
        return this.realmCode;
    }

    public @NonNull List<EpimsHeaderRecordTarget> getRecordTarget() {
        if (this.recordTarget == null) {
            this.recordTarget = new ArrayList<EpimsHeaderRecordTarget>();
        }
        return this.recordTarget;
    }

    public @NonNull List<POCDMT000040RelatedDocument> getRelatedDocument() {
        if (this.relatedDocument == null) {
            this.relatedDocument = new ArrayList<POCDMT000040RelatedDocument>();
        }
        return this.relatedDocument;
    }

    public II getSetId() {
        return this.setId;
    }

    public @NonNull List<II> getTemplateId() {
        if (this.templateId == null) {
            this.templateId = new ArrayList<II>();
        }
        return this.templateId;
    }

    public ST getTitle() {
        return this.title;
    }

    public POCDMT000040InfrastructureRootTypeId getTypeId() {
        return this.typeId;
    }

    public INT getVersionNumber() {
        return this.versionNumber;
    }

    public void setClassCode(ActClinicalDocument value) {
        this.classCode = value;
    }

    public void setCode(CE value) {
        this.code = value;
    }

    public void setComponent(POCDMT000040Component2 value) {
        this.component = value;
    }

    public void setComponentOf(POCDMT000040Component1 value) {
        this.componentOf = value;
    }

    public void setConfidentialityCode(CE value) {
        this.confidentialityCode = value;
    }

    public void setCopyTime(TS value) {
        this.copyTime = value;
    }

    public void setCustodian(POCDMT000040Custodian value) {
        this.custodian = value;
    }

    public void setDataEnterer(POCDMT000040DataEnterer value) {
        this.dataEnterer = value;
    }

    public void setEffectiveTime(TS value) {
        this.effectiveTime = value;
    }

    public void setId(II value) {
        this.id = value;
    }

    public void setIDAttr(String value) {
        this.idAttr = value;
    }

    public void setLanguageCode(CS value) {
        this.languageCode = value;
    }

    public void setLegalAuthenticator(POCDMT000040LegalAuthenticator value) {
        this.legalAuthenticator = value;
    }

    public void setSetId(II value) {
        this.setId = value;
    }

    public void setTitle(ST value) {
        this.title = value;
    }

    public void setTypeId(POCDMT000040InfrastructureRootTypeId value) {
        this.typeId = value;
    }

    public void setVersionNumber(INT value) {
        this.versionNumber = value;
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Component2 createHl7ComponentFixedValue(String typeCode, String contextConductionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Component2 retVal = factory.createPOCDMT000040Component2();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        if (contextConductionInd != null) {
            retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<POCDMT000040Authenticator> getHl7Authenticator() {
        return this.authenticator;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public CE getHl7Code() {
        return this.code;
    }

    public POCDMT000040Component2 getHl7Component() {
        return this.component;
    }

    public CE getHl7ConfidentialityCode() {
        return this.confidentialityCode;
    }

    public POCDMT000040Custodian getHl7Custodian() {
        return this.custodian;
    }

    public List<POCDMT000040DocumentationOf> getHl7DocumentationOf() {
        return this.documentationOf;
    }

    public TS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public II getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040InFulfillmentOf> getHl7InFulfillmentOf() {
        return this.inFulfillmentOf;
    }

    public List<POCDMT000040InformationRecipient> getHl7InformationRecipient() {
        return this.informationRecipient;
    }

    public CS getHl7LanguageCode() {
        return this.languageCode;
    }

    public POCDMT000040LegalAuthenticator getHl7LegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public List<POCDMT000040Participant1> getHl7Participant() {
        return this.participant;
    }

    public List<CS> getHl7RealmCode() {
        return this.realmCode;
    }

    public II getHl7SetId() {
        return this.setId;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public POCDMT000040InfrastructureRootTypeId getHl7TypeId() {
        return this.typeId;
    }

    public INT getHl7VersionNumber() {
        return this.versionNumber;
    }

    public void initFirstVersion(String newDocId) {
        II docId = new II();
        docId.setRoot(newDocId);
        if (newDocId == null) {
            docId.setRoot(UUID.randomUUID().toString());
        }
        this.setId(docId);
        this.setVersion(docId.getRoot(), 1);
    }

    public void initNextVersion(String newDocId) {
        II id = new II();
        id.setRoot(newDocId);
        II setId = this.getSetId();
        if (setId == null) {
            setId = this.getId();
        }
        if (setId == null) {
            setId = id;
        }
        Integer version = this.getVersionNumber().getValue().intValue();
        this.setId(id);
        this.setVersion(setId.getRoot(), version + 1);
    }

    public void setHl7Authenticator(POCDMT000040Authenticator value) {
        this.getAuthenticator().clear();
        this.getAuthenticator().add(value);
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Component(POCDMT000040Component2 value) {
        this.component = value;
    }

    public void setHl7ConfidentialityCode(CE value) {
        this.confidentialityCode = value;
    }

    public void setHl7Custodian(POCDMT000040Custodian value) {
        this.custodian = value;
    }

    public void setHl7DocumentationOf(POCDMT000040DocumentationOf value) {
        this.getDocumentationOf().clear();
        this.getDocumentationOf().add(value);
    }

    public void setHl7EffectiveTime(TS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7InFulfillmentOf(POCDMT000040InFulfillmentOf value) {
        this.getInFulfillmentOf().clear();
        this.getInFulfillmentOf().add(value);
    }

    public void setHl7InformationRecipient(POCDMT000040InformationRecipient value) {
        this.getInformationRecipient().clear();
        this.getInformationRecipient().add(value);
    }

    public void setHl7LanguageCode(CS value) {
        this.languageCode = value;
    }

    public void setHl7LegalAuthenticator(POCDMT000040LegalAuthenticator value) {
        this.legalAuthenticator = value;
    }

    public void setHl7Participant(POCDMT000040Participant1 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7RealmCode(CS value) {
        this.getRealmCode().clear();
        this.getRealmCode().add(value);
    }

    public void setHl7SetId(II value) {
        this.setId = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }

    public void setHl7TypeId(POCDMT000040InfrastructureRootTypeId value) {
        this.typeId = value;
    }

    public void setHl7VersionNumber(INT value) {
        this.versionNumber = value;
    }

    public void setVersion(String idVersion1, int version) {
        II id = new II();
        id.setRoot(idVersion1);
        this.setSetId(id);
        this.setVersionNumber(new INT(version));
    }
}

