/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;

public class EpimsEntryProblemConcern
extends POCDMT000040Act {
    public EpimsEntryProblemConcern() {
        super.setClassCode(XActClassDocumentEntryAct.ACT);
        super.setMoodCode(XDocumentActMood.EVN);
        super.getTemplateId().add(EpimsEntryProblemConcern.createHl7TemplateIdFixedValue("1.2.40.0.34.6.0.11.3.98"));
        super.getTemplateId().add(EpimsEntryProblemConcern.createHl7TemplateIdFixedValue("1.2.40.0.34.6.0.11.3.7"));
        super.getTemplateId().add(EpimsEntryProblemConcern.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.27"));
        super.getTemplateId().add(EpimsEntryProblemConcern.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.5.1"));
        super.getTemplateId().add(EpimsEntryProblemConcern.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.5.2"));
        super.setCode((CD)EpimsEntryProblemConcern.createHl7CodeFixedValue("NA"));
        super.setStatusCode(EpimsEntryProblemConcern.createHl7StatusCodeFixedValue("active", null, null, null));
        this.addHl7EntryRelationship(EpimsEntryProblemConcern.createHl7EntryRelationshipFixedValue("SUBJ", true, false));
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        if (this.entryRelationship == null) {
            this.entryRelationship = new LinkedList();
        }
        this.entryRelationship.add(value);
    }

    private static CE createHl7CodeFixedValue(String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.nullFlavor = new ArrayList();
        retVal.nullFlavor.add(nullFlavor);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, boolean contextConductionInd, boolean inversionInd) {
        POCDMT000040EntryRelationship retVal = new POCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        retVal.setContextConductionInd(Boolean.valueOf(contextConductionInd));
        retVal.setInversionInd(Boolean.valueOf(inversionInd));
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        CS retVal = new CS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public II getHl7Id() {
        if (this.id != null && !this.id.isEmpty()) {
            return (II)this.id.get(0);
        }
        return null;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        if (this.id == null) {
            this.id = new LinkedList();
        }
        this.id.clear();
        this.id.add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

