/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum EImpfZusatzklassifikationVs implements ValueSetEnumInterface
{
    ARBEITSPLATZ_BETRIEBE_L1("IS002", "1.2.40.0.34.5.183", "Arbeitsplatz/Betriebe", "Arbeitsplatz/Betriebe", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    BILDUNGSEINRICHTUNG_L1("IS001", "1.2.40.0.34.5.183", "Bildungseinrichtung", "Bildungseinrichtung", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IMPFSTELLE_IMPFSETTING("46224007", "2.16.840.1.113883.6.96", "Impfstelle (Impfsetting)", "Impfstelle (Impfsetting)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    KRANKENHAUS_INKL_KUR_UND_REHAEINRICHTUNGEN_L1("IS003", "1.2.40.0.34.5.183", "Krankenhaus inkl. Kur- und Rehaeinrichtungen", "Krankenhaus inkl. Kur- und Rehaeinrichtungen", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ORDINATION_L1("IS004", "1.2.40.0.34.5.183", "Ordination", "Ordination", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    WOHNBEREICH_UND_BETREUUNGSEINRICHTUNGEN_L1("IS006", "1.2.40.0.34.5.183", "Wohnbereich und Betreuungseinrichtungen", "Wohnbereich und Betreuungseinrichtungen", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _FFENTLICHE_IMPFSTELLE_IMPFSTRASSE_L1("IS005", "1.2.40.0.34.5.183", "\u00d6ffentliche Impfstelle/Impfstra\u00dfe", "\u00d6ffentliche Impfstelle/Impfstra\u00dfe", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ARBEITSPLATZ_BETRIEBE_L1_CODE = "IS002";
    public static final String BILDUNGSEINRICHTUNG_L1_CODE = "IS001";
    public static final String IMPFSTELLE_IMPFSETTING_CODE = "46224007";
    public static final String KRANKENHAUS_INKL_KUR_UND_REHAEINRICHTUNGEN_L1_CODE = "IS003";
    public static final String ORDINATION_L1_CODE = "IS004";
    public static final String WOHNBEREICH_UND_BETREUUNGSEINRICHTUNGEN_L1_CODE = "IS006";
    public static final String _FFENTLICHE_IMPFSTELLE_IMPFSTRASSE_L1_CODE = "IS005";
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.62";
    public static final String VALUE_SET_NAME = "eImpf_Zusatzklassifikation_VS";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable EImpfZusatzklassifikationVs getEnum(@Nullable String code) {
        for (EImpfZusatzklassifikationVs x : EImpfZusatzklassifikationVs.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EImpfZusatzklassifikationVs.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (EImpfZusatzklassifikationVs x : EImpfZusatzklassifikationVs.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private EImpfZusatzklassifikationVs(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

